/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.starfarer.C;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FleetActionTextProvider;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.CampaignClock;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignPlanet;
import com.fs.starfarer.campaign.CircularFleetOrbit;
import com.fs.starfarer.campaign.Hyperspace;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.StarSystem;
import com.fs.starfarer.campaign.ai.PursuitAndEvasionModule;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.ui.trade.CargoItemStack;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.FleetCreationSpec;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignFleetAI
implements AI,
DoNotObfuscate,
CampaignFleetAIAPI {
    private CampaignFleet fleet;
    private List<FleetAssignmentData> assignments = new ArrayList<FleetAssignmentData>();
    private PursuitAndEvasionModule pursuitAndEvasionModule;
    private FleetCreationSpec creationSpec = null;
    private IntervalTracker resupplyTracker = new IntervalTracker(0.5f, 2.0f);
    private IntervalTracker dumpExcessTracker = new IntervalTracker(0.5f, 2.0f);
    private float preferredOffsetDir = Math.signum((float)Math.random() - 0.5f) * (float)Math.random() * 3.0f;
    private JumpPlan currJumpPlan;
    private SectorEntityToken tempDestToken = null;
    private Vector2f tempDest = null;
    private SectorEntityToken resupplyLocation;
    private String actionTextOverride = null;

    public CampaignFleetAI(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
        this.pursuitAndEvasionModule = new PursuitAndEvasionModule(campaignFleet, this);
    }

    protected Object readResolve() {
        this.dumpExcessTracker = new IntervalTracker(0.5f, 2.0f);
        this.resupplyTracker = new IntervalTracker(0.5f, 2.0f);
        if (this.preferredOffsetDir == 0.0f) {
            this.preferredOffsetDir = Math.signum((float)Math.random() - 0.5f) * (float)Math.random() * 3.0f;
        }
        return this;
    }

    public void setCreationSpec(FleetCreationSpec fleetCreationSpec) {
        this.creationSpec = fleetCreationSpec;
    }

    public FleetAssignmentDataAPI getCurrentAssignment() {
        FleetAssignmentData fleetAssignmentData = this.assignments.isEmpty() ? null : this.assignments.get(0);
        return fleetAssignmentData;
    }

    public PursuitAndEvasionModule getPursuitAndEvasionModule() {
        return this.pursuitAndEvasionModule;
    }

    @Override
    public void advance(float f2) {
        float f3;
        float f4;
        float f5 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        this.updatePursueAndFleeRanges();
        this.pursuitAndEvasionModule.advance(f2);
        if (this.pursuitAndEvasionModule.isBusy()) {
            FleetAssignmentData fleetAssignmentData = (FleetAssignmentData)this.getCurrentAssignment();
            if (fleetAssignmentData != null && (fleetAssignmentData.getAssignment() == FleetAssignment.INTERCEPT || fleetAssignmentData.getAssignment() == FleetAssignment.FOLLOW)) {
                fleetAssignmentData.advance(f2);
            }
            return;
        }
        FleetAssignmentData fleetAssignmentData = null;
        while (fleetAssignmentData == null && !this.assignments.isEmpty()) {
            FleetAssignmentData fleetAssignmentData2 = fleetAssignmentData = this.assignments.isEmpty() ? null : this.assignments.get(0);
            if (fleetAssignmentData == null || !fleetAssignmentData.isExpired()) continue;
            this.assignments.remove(0);
            if (fleetAssignmentData.onCompletion != null) {
                fleetAssignmentData.onCompletion.run();
            }
            if (fleetAssignmentData.assignment == FleetAssignment.ORBIT_PASSIVE || fleetAssignmentData.assignment == FleetAssignment.ORBIT_AGGRESSIVE) {
                this.fleet.setOrbit(null);
            }
            this.tempDest = null;
            this.tempDestToken = null;
            fleetAssignmentData = null;
        }
        if (fleetAssignmentData == null) {
            fleetAssignmentData = new FleetAssignmentData(FleetAssignment.PATROL_SYSTEM, null, 1.0f, null, null);
            return;
        }
        if (!this.fleet.isAIMode()) {
            this.resupplyTracker.advance(f5);
            if (this.resupplyTracker.intervalElapsed()) {
                if (this.resupplyLocation != null && (fleetAssignmentData == null || fleetAssignmentData.assignment != FleetAssignment.RESUPPLY && fleetAssignmentData.assignment != FleetAssignment.GO_TO_LOCATION_AND_DESPAWN) && this.needsResupply()) {
                    this.assignments.add(0, fleetAssignmentData);
                    this.addAssignmentAtStart(FleetAssignment.RESUPPLY, this.resupplyLocation, 20.0f, null);
                    if (StarfarerSettings.\u00f6\u00d20000() && this.fleet.isInCurrentLocation()) {
                        CampaignEngine.getInstance().getCampaignUI().addMessage(String.valueOf(this.fleet.getNameWithFaction()) + " (" + this.fleet.hashCode() + "): " + "Heading to resupply at " + this.resupplyLocation.getName(), C.o\u00d20000);
                    }
                    return;
                }
                if (this.resupplyLocation == null && fleetAssignmentData.assignment != FleetAssignment.RESUPPLY && this.needsResupply() && StarfarerSettings.\u00f6\u00d20000() && this.fleet.isInCurrentLocation()) {
                    CampaignEngine.getInstance().getCampaignUI().addMessage(String.valueOf(this.fleet.getNameWithFaction()) + " (" + this.fleet.hashCode() + "): " + "Unable to resupply, no resupply location set", C.o\u00d20000);
                }
            }
        }
        this.dumpExcessTracker.advance(f5);
        if (this.dumpExcessTracker.intervalElapsed()) {
            this.dumpResourcesIfNeeded();
        }
        fleetAssignmentData.advance(f2);
        Vector2f vector2f = new Vector2f();
        float f6 = 0.0f;
        boolean bl = false;
        if (fleetAssignmentData.target != null) {
            vector2f = fleetAssignmentData.target.getLocation();
            this.updateJumpPlanTo(fleetAssignmentData.target.getContainingLocation(), f5);
            if (this.currJumpPlan != null) {
                this.fleet.setInteractionTarget(this.currJumpPlan.point);
                vector2f = this.currJumpPlan.point.getLocation();
            }
            f6 = Utils.void(vector2f, this.fleet.getLocation());
            f6 -= fleetAssignmentData.target.getRadius();
            if ((f6 += 45.0f) > 500.0f && fleetAssignmentData.assignment != FleetAssignment.DELIVER_RESOURCES && fleetAssignmentData.assignment != FleetAssignment.DELIVER_CREW && fleetAssignmentData.assignment != FleetAssignment.DELIVER_FUEL && fleetAssignmentData.assignment != FleetAssignment.DELIVER_MARINES && fleetAssignmentData.assignment != FleetAssignment.DELIVER_PERSONNEL && fleetAssignmentData.assignment != FleetAssignment.DELIVER_SUPPLIES && fleetAssignmentData.assignment != FleetAssignment.RESUPPLY && fleetAssignmentData.assignment != FleetAssignment.GO_TO_LOCATION && fleetAssignmentData.assignment != FleetAssignment.GO_TO_LOCATION_AND_DESPAWN) {
                f4 = Math.min((f6 - 500.0f) / 1000.0f, 1.0f);
                f3 = Utils.\u00d300000(this.fleet.getLocation(), vector2f);
                vector2f = Utils.\u00d300000(f3 += (10.0f + 10.0f * (float)Math.random()) * this.preferredOffsetDir * f4);
                vector2f.scale(f6);
                Vector2f.add((Vector2f)vector2f, (Vector2f)this.fleet.getLocation(), (Vector2f)vector2f);
            }
            if (this.currJumpPlan != null && (f6 < 100.0f || f6 < 500.0f && !this.fleet.isInCurrentLocation() || f6 < 1000.0f && CampaignEngine.getInstance().isInFastAdvance())) {
                CampaignEngine.getInstance().doHyperspaceTransition(this.fleet, this.currJumpPlan.point, this.currJumpPlan.dest);
                this.currJumpPlan = null;
                bl = true;
            } else if (this.currJumpPlan != null) {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                return;
            }
        }
        if (fleetAssignmentData.target != null && this.fleet.getContainingLocation() != fleetAssignmentData.target.getContainingLocation()) {
            return;
        }
        switch (fleetAssignmentData.assignment) {
            case HOLD: {
                if (fleetAssignmentData.target != null) {
                    this.fleet.setMoveDestination(fleetAssignmentData.target.getLocation().x, fleetAssignmentData.target.getLocation().y);
                    break;
                }
                this.fleet.setMoveDestination(this.fleet.getLocation().x, this.fleet.getLocation().y);
                break;
            }
            case DELIVER_CREW: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                if (!this.fleet.isAIMode()) {
                    this.transferResourcesTo(fleetAssignmentData.target.getCargo(), true, false, false, false);
                    this.resupplyAndRestoreFightingStrength();
                }
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DELIVER_MARINES: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                if (!this.fleet.isAIMode()) {
                    this.transferResourcesTo(fleetAssignmentData.target.getCargo(), false, true, false, false);
                    this.resupplyAndRestoreFightingStrength();
                }
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DELIVER_PERSONNEL: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                if (!this.fleet.isAIMode()) {
                    this.transferResourcesTo(fleetAssignmentData.target.getCargo(), true, true, false, false);
                    this.resupplyAndRestoreFightingStrength();
                }
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DELIVER_SUPPLIES: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                if (!this.fleet.isAIMode()) {
                    this.transferResourcesTo(fleetAssignmentData.target.getCargo(), false, false, true, false);
                    this.resupplyAndRestoreFightingStrength();
                }
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DELIVER_FUEL: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                if (!this.fleet.isAIMode()) {
                    this.transferResourcesTo(fleetAssignmentData.target.getCargo(), false, false, false, true);
                    this.resupplyAndRestoreFightingStrength();
                }
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DELIVER_RESOURCES: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                if (!this.fleet.isAIMode()) {
                    this.transferResourcesTo(fleetAssignmentData.target.getCargo(), true, true, true, true);
                    this.resupplyAndRestoreFightingStrength();
                }
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case GO_TO_LOCATION_AND_DESPAWN: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                this.fleet.despawn(CampaignEventListener.FleetDespawnReason.REACHED_DESTINATION, fleetAssignmentData.target);
                fleetAssignmentData.expire();
                if (fleetAssignmentData.onCompletion != null) {
                    fleetAssignmentData.onCompletion.run();
                }
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case DEFEND_LOCATION: 
            case ATTACK_LOCATION: {
                this.defendLocation(vector2f);
                break;
            }
            case ORBIT_PASSIVE: 
            case ORBIT_AGGRESSIVE: {
                if (this.fleet.getOrbit() != null) break;
                f4 = this.fleet.getRadius() + 100.0f + (float)Math.random() * 100.0f + fleetAssignmentData.target.getRadius();
                f3 = f4 / 50.0f * (1.0f + (float)Math.random());
                float f7 = Utils.\u00d500000(fleetAssignmentData.target.getLocation(), this.fleet.getLocation()) + (float)Math.random() * 120.0f - 60.0f;
                this.fleet.setOrbit(new CircularFleetOrbit(this.fleet, fleetAssignmentData.target, f4, f7).setPeriod(f3));
                break;
            }
            case RESUPPLY: {
                if (f6 < 50.0f) {
                    if (!this.fleet.isAIMode()) {
                        this.transferResourcesTo(fleetAssignmentData.target.getCargo(), true, true, true, true);
                        this.resupplyAndRestoreFightingStrength();
                    }
                    fleetAssignmentData.expire();
                    CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                }
            }
            case GO_TO_LOCATION: {
                this.fleet.setMoveDestination(vector2f.x, vector2f.y);
                if (!(f6 < 50.0f)) break;
                fleetAssignmentData.expire();
                CampaignEngine.getInstance().reportFleetReachedEntity(this.fleet, fleetAssignmentData.target);
                break;
            }
            case PATROL_SYSTEM: 
            case RAID_SYSTEM: {
                this.patrolSystem(fleetAssignmentData);
                break;
            }
            case INTERCEPT: {
                this.pursuitAndEvasionModule.pursueTarget(fleetAssignmentData.target, 0.1f);
                break;
            }
            case FOLLOW: {
                this.pursuitAndEvasionModule.pursueTarget(fleetAssignmentData.target, 0.1f, true);
            }
        }
    }

    public boolean isFleeing() {
        return this.pursuitAndEvasionModule.isFleeing();
    }

    public void updateJumpPlanTo(LocationAPI locationAPI, float f2) {
        if (locationAPI == this.fleet.getContainingLocation()) {
            this.currJumpPlan = null;
            return;
        }
        if (this.fleet.getCargo().getFuel() <= 0.0f && !this.fleet.isAIMode()) {
            this.currJumpPlan = null;
            return;
        }
        if (this.fleet.isInHyperspaceTransition()) {
            this.currJumpPlan = null;
            return;
        }
        if (this.currJumpPlan != null) {
            this.currJumpPlan.timeLeft -= f2;
            if (this.currJumpPlan.timeLeft <= 0.0f) {
                this.currJumpPlan = null;
            }
        }
        if (this.currJumpPlan != null) {
            return;
        }
        o o2 = CampaignFleetAI.findNearestSafeJumpPoint(this.fleet, locationAPI);
        if (o2 != null) {
            this.currJumpPlan = new JumpPlan(o2.super, o2.\u00d200000);
        }
    }

    public static o findNearestSafeJumpPoint(CampaignFleetAPI campaignFleetAPI, LocationAPI locationAPI) {
        boolean bl;
        List list = campaignFleetAPI.getContainingLocation().getEntities(JumpPoint.class);
        Hyperspace hyperspace = CampaignEngine.getInstance().getHyperspace();
        boolean bl2 = bl = locationAPI == null;
        if (hyperspace != locationAPI && hyperspace != campaignFleetAPI.getContainingLocation()) {
            bl = true;
        }
        ArrayList<o> arrayList = new ArrayList<o>();
        for (JumpPoint jumpPoint : list) {
            if (jumpPoint.isStarAnchor()) continue;
            for (JumpPointAPI.JumpDestination jumpDestination : jumpPoint.getDestinations()) {
                if (jumpDestination.getDestination() == null || jumpDestination.getDestination().getContainingLocation() != locationAPI && (!bl || hyperspace != jumpDestination.getDestination().getContainingLocation())) continue;
                float f2 = Utils.void(jumpPoint.getLocation(), campaignFleetAPI.getLocation());
                o o2 = new o();
                o2.super = jumpPoint;
                o2.\u00d200000 = jumpDestination;
                o2.String = f2;
                o2.\u00d300000 = CampaignFleetAI.getNumUnsafeFleetsAround(campaignFleetAPI, jumpPoint, 750.0f);
                arrayList.add(o2);
            }
        }
        Collections.sort(arrayList, new Comparator<o>(){

            public int o00000(o o2, o o3) {
                if (o2.\u00d300000 == o3.\u00d300000) {
                    return (int)o2.String - (int)o3.String;
                }
                return o2.\u00d300000 - o3.\u00d300000;
            }
        });
        if (arrayList.isEmpty()) {
            return null;
        }
        return (o)arrayList.get(0);
    }

    public static int getNumUnsafeFleetsAround(final CampaignFleetAPI campaignFleetAPI, SectorEntityToken sectorEntityToken, float f2) {
        List list = Misc.findNearbyFleets((SectorEntityToken)sectorEntityToken, (float)f2, (Misc.FleetFilter)new Misc.FleetFilter(){

            public boolean accept(CampaignFleetAPI campaignFleetAPI2) {
                if (campaignFleetAPI2.getAI() != null && !campaignFleetAPI2.getAI().isHostileTo(campaignFleetAPI)) {
                    return false;
                }
                if (campaignFleetAPI2.getAI() == null && !campaignFleetAPI2.getFaction().isHostileTo(campaignFleetAPI.getFaction())) {
                    return false;
                }
                float f2 = campaignFleetAPI.getFleetPoints();
                float f3 = campaignFleetAPI2.getFleetPoints();
                return f3 * 1.5f >= f2;
            }
        });
        return list.size();
    }

    public void dumpResourcesIfNeeded() {
        CargoData cargoData = this.fleet.getCargo();
        if (cargoData.getFuel() > cargoData.getMaxFuel()) {
            cargoData.removeFuel(cargoData.getFuel() - cargoData.getMaxFuel());
        }
        float f2 = cargoData.getTotalCrew() + cargoData.getMarines();
        float f3 = cargoData.getMaxPersonnel();
        float f4 = f2 - f3;
        boolean bl = false;
        for (CargoItemStack cargoItemStack : cargoData.getStacks()) {
            if (f4 <= 0.0f) break;
            if (!cargoItemStack.isPersonnelStack()) continue;
            float f5 = Math.min(f4, cargoItemStack.getSize());
            cargoItemStack.add(-f5);
            f4 -= f5;
            bl = true;
        }
        float f6 = cargoData.getSpaceUsed();
        float f7 = cargoData.getMaxCapacity();
        f4 = f6 - f7;
        for (CargoItemStack cargoItemStack : cargoData.getStacks()) {
            if (f4 <= 0.0f) break;
            if (cargoItemStack.isPersonnelStack() || cargoItemStack.isFuelStack()) continue;
            float f8 = Math.min(f4, cargoItemStack.getSize());
            cargoItemStack.add(-f8);
            f4 -= f8;
            bl = true;
        }
        if (bl) {
            cargoData.sort();
        }
    }

    private void resupplyAndRestoreFightingStrength() {
        float f2 = this.fleet.getTotalSupplyCostPerDay() * 30.0f;
        float f3 = f2 * 0.33f;
        F f4 = SpecStore.o00000(F.class, "supplies");
        float f5 = this.fleet.getCargo().getSpaceLeft() / f4.getCargoSpace();
        if (f5 < f3) {
            this.fleet.despawn(CampaignEventListener.FleetDespawnReason.NO_REASON_PROVIDED, null);
            return;
        }
        f2 = Math.min(f2, f5);
        this.fleet.getCargo().addSupplies(f2);
        float f6 = this.fleet.getCargo().getSpaceLeft();
        this.fleet.getCargo().addSupplies((float)((int)f6) * 0.5f);
        float f7 = this.fleet.getCargo().getMaxFuel() - this.fleet.getCargo().getFuel();
        this.fleet.getCargo().addFuel(f7);
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            fleetMember.getStatus().repairFully();
            float f8 = fleetMember.getRepairTracker().getMaxCR();
            float f9 = fleetMember.getRepairTracker().getBaseCR();
            if (!(f8 > f9)) continue;
            fleetMember.getRepairTracker().applyCREvent(f8 - f9, "Repaired at station");
        }
    }

    public boolean needsResupply() {
        float f2;
        float f3 = this.fleet.getCargo().getFuel();
        if (f3 < (f2 = this.fleet.getLogistics().getFuelCostPerLightYear())) {
            return true;
        }
        float f4 = this.fleet.getTotalSupplyCostPerDay();
        if (this.fleet.getCargo().getSupplies() < f4 * 5.0f) {
            return true;
        }
        float f5 = 0.0f;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            f5 += fleetMember.getCR();
        }
        float f6 = this.fleet.getMembers().size();
        float f7 = f5 / f6;
        return f7 < 0.1f;
    }

    private void updatePursueAndFleeRanges() {
        FleetAssignmentData fleetAssignmentData;
        FleetAssignmentData fleetAssignmentData2 = fleetAssignmentData = this.assignments.isEmpty() ? null : this.assignments.get(0);
        if (fleetAssignmentData == null) {
            this.pursuitAndEvasionModule.setFleeDetectionRange(500.0f);
            this.pursuitAndEvasionModule.setPursueDetectionRange(500.0f);
            return;
        }
        switch (fleetAssignmentData.assignment) {
            case HOLD: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(0.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(0.0f);
                break;
            }
            case DELIVER_RESOURCES: 
            case DELIVER_SUPPLIES: 
            case DELIVER_FUEL: 
            case DELIVER_PERSONNEL: 
            case DELIVER_CREW: 
            case DELIVER_MARINES: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(500.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(0.0f);
                break;
            }
            case RESUPPLY: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(50.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(0.0f);
                break;
            }
            case ORBIT_PASSIVE: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(150.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(0.0f);
                break;
            }
            case ORBIT_AGGRESSIVE: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(250.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(250.0f);
                break;
            }
            case GO_TO_LOCATION_AND_DESPAWN: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(250.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(150.0f);
                break;
            }
            case DEFEND_LOCATION: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(250.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(600.0f);
                break;
            }
            case ATTACK_LOCATION: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(500.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(500.0f);
                break;
            }
            case GO_TO_LOCATION: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(350.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(350.0f);
                break;
            }
            case INTERCEPT: 
            case FOLLOW: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(350.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(0.0f);
                break;
            }
            case PATROL_SYSTEM: 
            case RAID_SYSTEM: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(500.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(1500.0f);
                break;
            }
            default: {
                this.pursuitAndEvasionModule.setFleeDetectionRange(500.0f);
                this.pursuitAndEvasionModule.setPursueDetectionRange(500.0f);
            }
        }
    }

    private void patrolSystem(FleetAssignmentData fleetAssignmentData) {
        if (this.tempDest != null) {
            this.fleet.setMoveDestination(this.tempDest.x, this.tempDest.y);
            float f2 = Utils.void(this.tempDest, this.fleet.getLocation());
            if (f2 < 50.0f) {
                this.tempDest = null;
            } else {
                return;
            }
        }
        if (fleetAssignmentData != null && fleetAssignmentData.target instanceof JumpPoint && fleetAssignmentData.target.getContainingLocation().isHyperspace()) {
            this.tempDestToken = fleetAssignmentData.target;
            this.tempDest = new Vector2f(this.tempDestToken.getLocation().x + 2500.0f * ((float)Math.random() - 0.5f), this.tempDestToken.getLocation().y + 2500.0f * ((float)Math.random() - 0.5f));
        } else if (this.fleet.getContainingLocation() instanceof StarSystem) {
            StarSystem starSystem = (StarSystem)this.fleet.getContainingLocation();
            ArrayList<CampaignPlanet> arrayList = new ArrayList<CampaignPlanet>();
            List list = starSystem.getObjects().getList(CampaignPlanet.class);
            for (CampaignPlanet campaignPlanet : list) {
                if (campaignPlanet.isStar()) continue;
                arrayList.add(campaignPlanet);
            }
            if (arrayList.isEmpty()) {
                this.tempDestToken = starSystem.getStar();
                this.tempDest = new Vector2f(this.tempDestToken.getLocation().x + 7500.0f * ((float)Math.random() - 0.5f), this.tempDestToken.getLocation().y + 7500.0f * ((float)Math.random() - 0.5f));
            } else {
                Collections.sort(arrayList, new Comparator<CampaignPlanet>(){

                    public int o00000(CampaignPlanet campaignPlanet, CampaignPlanet campaignPlanet2) {
                        float f2 = Utils.void(campaignPlanet.getLocation(), CampaignFleetAI.this.fleet.getLocation());
                        float f3 = Utils.void(campaignPlanet2.getLocation(), CampaignFleetAI.this.fleet.getLocation());
                        return (int)Math.signum(f2 - f3);
                    }
                });
                double d2 = Math.random();
                int n = (int)(d2 * (double)arrayList.size());
                this.tempDestToken = (SectorEntityToken)arrayList.get(n);
                this.tempDest = new Vector2f(this.tempDestToken.getLocation().x + 3000.0f * ((float)Math.random() - 0.5f), this.tempDestToken.getLocation().y + 3000.0f * ((float)Math.random() - 0.5f));
            }
        }
    }

    private void defendLocation(Vector2f vector2f) {
        if (this.tempDest != null) {
            this.fleet.setMoveDestination(this.tempDest.x, this.tempDest.y);
            float f2 = Utils.void(this.tempDest, this.fleet.getLocation());
            if (f2 < 50.0f) {
                this.tempDest = null;
            }
        } else {
            this.tempDest = new Vector2f(vector2f.x + 1000.0f * ((float)Math.random() - 0.5f), vector2f.y + 1000.0f * ((float)Math.random() - 0.5f));
        }
    }

    private void transferResourcesTo(CargoAPI cargoAPI, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f2;
        CargoData cargoData = (CargoData)cargoAPI;
        CargoData cargoData2 = this.fleet.getCargo();
        if (cargoData == null || cargoData2 == null) {
            return;
        }
        float f3 = this.fleet.getFleetData().getFuelPerLightYear() * 10.0f;
        float f4 = this.fleet.getTotalSupplyCostPerDay() * 10.0f;
        float f5 = this.fleet.getFleetData().getMinCrew();
        float f6 = 3000.0f;
        float f7 = 10000.0f;
        float f8 = 2000.0f;
        float f9 = 1000.0f;
        if (bl4 && (f2 = Math.min(f6 - cargoData.getFuel(), cargoData2.getFuel() - f3)) > 0.0f) {
            cargoData2.transfer(CargoAPI.CargoItemType.RESOURCES, "fuel", f2, f3, cargoData);
        }
        if (bl2 && (f2 = Math.min(f9 - (float)cargoData.getMarines(), (float)cargoData2.getMarines() - f5)) > 0.0f) {
            cargoData2.transfer(CargoAPI.CargoItemType.RESOURCES, "marines", f2, 0.0f, cargoData);
        }
        if (bl && (f2 = Math.min(f8 - (float)cargoData.getTotalCrew(), (float)cargoData2.getTotalCrew() - f5)) > 0.0f) {
            cargoData2.transferCrew(f2, f5, cargoData);
        }
        if (bl3) {
            f2 = Math.min(f7 - cargoData.getSupplies(), cargoData2.getSupplies() - f4);
            if (f2 > 0.0f) {
                cargoData2.transfer(CargoAPI.CargoItemType.RESOURCES, "supplies", f2, f4, cargoData);
            }
            for (CargoItemStack object : new ArrayList<CargoItemStack>(cargoData2.getStacks())) {
                if (cargoData.getStacks().size() > 100) {
                    int n = (int)(Math.random() * 50.0);
                    cargoData.removeStackAtIndex(n);
                }
                if (object.isSupplyStack() || object.isFuelStack() || object.isCrewStack() || object.isMarineStack() || object.isNull() || !object.isWeaponStack() && !object.isSpecialStack() && !object.isResourceStack()) continue;
                cargoData2.transfer(object.getType(), object.getData(), object.getSize(), 0.0f, cargoData);
            }
            cargoData.sort();
        }
        if (cargoData2.getMothballedShips() != null) {
            for (FleetMember fleetMember : new ArrayList<FleetMember>(cargoData2.getMothballedShips().getMembers())) {
                if (cargoData.getMothballedShips() == null) {
                    cargoData.initMothballedShips("independent");
                }
                if (cargoData.getMothballedShips().getMembers().size() > 50) {
                    int n = (int)(Math.random() * 50.0);
                    cargoData.getMothballedShips().removeFleetMemberAtIndex(n);
                    cargoData.getMothballedShips().collapseEmptySlots();
                }
                cargoData2.getMothballedShips().removeFleetMemberAndCollapseSlot(fleetMember);
                cargoData.getMothballedShips().addFleetMember(fleetMember);
                fleetMember.getRepairTracker().getRecentEvents().clear();
            }
        }
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getMembersListCopy()) {
            if (cargoData.getMothballedShips() == null) {
                cargoData.initMothballedShips("independent");
            }
            if (!fleetMemberAPI.getRepairTracker().isMothballed()) continue;
            if (cargoData.getMothballedShips().getMembers().size() > 50) {
                int n = (int)(Math.random() * 50.0);
                cargoData.getMothballedShips().removeFleetMemberAtIndex(n);
                cargoData.getMothballedShips().collapseEmptySlots();
            }
            this.fleet.removeFleetMember(fleetMemberAPI);
            cargoData.getMothballedShips().addFleetMember(fleetMemberAPI);
            fleetMemberAPI.getRepairTracker().getRecentEvents().clear();
        }
    }

    @Override
    public void render() {
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        this.assignments.add(new FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, script));
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        this.assignments.add(new FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, script));
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        this.assignments.add(0, new FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, script));
        this.pursuitAndEvasionModule.getTracker().forceIntervalElapsed();
        this.pursuitAndEvasionModule.pursueTarget(null, 0.0f);
        this.fleet.setInteractionTarget(null);
        this.fleet.setOrbit(null);
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        this.assignments.add(0, new FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, script));
        this.pursuitAndEvasionModule.getTracker().forceIntervalElapsed();
        this.pursuitAndEvasionModule.pursueTarget(null, 0.0f);
        this.fleet.setInteractionTarget(null);
        this.fleet.setOrbit(null);
    }

    public boolean isCurrentAssignment(FleetAssignment fleetAssignment) {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        return fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getAssignment() == fleetAssignment;
    }

    public void removeFirstAssignmentIfItIs(FleetAssignment fleetAssignment) {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        if (fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getAssignment() == fleetAssignment) {
            this.removeFirstAssignment();
        }
    }

    public void removeFirstAssignment() {
        if (!this.assignments.isEmpty()) {
            this.assignments.remove(0);
        }
    }

    public void clearAssignments() {
        this.assignments.clear();
    }

    public float computeFleetStrength(CampaignFleet campaignFleet, boolean bl) {
        return campaignFleet.getFleetData().computeTotalStrength(bl);
    }

    public void setPreferredResupplyLocation(SectorEntityToken sectorEntityToken) {
        this.resupplyLocation = sectorEntityToken;
    }

    public boolean isHostileTo(CampaignFleetAPI campaignFleetAPI) {
        if (Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)campaignFleetAPI) && this.fleet.getMemoryWithoutUpdate().contains("$cfai_makeHostile")) {
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
                return true;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostile", false)) {
                return false;
            }
        }
        return this.fleet.getFaction().isAtBest(campaignFleetAPI.getFaction(), RepLevel.HOSTILE);
    }

    /*
     * WARNING - void declaration
     */
    public void performCrashMothballingPriorToEscape(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        void var8_12;
        float f2;
        FleetMember fleetMember2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f6\u00d50000();
        for (FleetMember fleetMember2 : this.fleet.getMembers()) {
            if (!fleetMember2.canBeDeployedForCombat() || fleetMember2.isCivilian()) continue;
            f2 = fleetMember2.getMemberStrength();
            f3 += f2;
            f4 += f2;
        }
        for (FleetMember fleetMember2 : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMember2.canBeDeployedForCombat()) continue;
            f2 = fleetMember2.getMemberStrength();
            f5 += f2;
        }
        fleetMember2 = new WeightedRandomPicker();
        for (FleetMember fleetMember3 : this.fleet.getMembers()) {
            if (!fleetMember3.canBeDeployedForCombat() || fleetMember3.isFighterWing() || !(fleetMember3.getCR() < combatReadinessPlugin.getCriticalMalfunctionThreshold((MutableShipStatsAPI)fleetMember3.getStats()))) continue;
            if (fleetMember3.isCivilian()) {
                fleetMember3.getRepairTracker().setCrashMothballed(true);
                continue;
            }
            fleetMember2.add(fleetMember3, 1.0f);
        }
        boolean bl = false;
        while (var8_12 < 10 && f4 > f3 * 0.33f && !fleetMember2.isEmpty()) {
            ++var8_12;
            FleetMemberAPI fleetMemberAPI = (FleetMemberAPI)fleetMember2.pick();
            if (fleetMemberAPI != null) {
                fleetMemberAPI.getRepairTracker().setCrashMothballed(true);
                float f6 = fleetMemberAPI.getMemberStrength();
                f4 -= f6;
            }
            fleetMember2.remove(fleetMemberAPI);
        }
    }

    public CampaignFleetAIAPI.EncounterOption pickEncounterOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        float f2;
        if (Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)campaignFleetAPI) && this.fleet.getMemoryWithoutUpdate().contains("$cfai_makeAggressive") && this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
            return CampaignFleetAIAPI.EncounterOption.ENGAGE;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f6\u00d50000();
        boolean bl = true;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            float f6;
            if (!fleetMember.canBeDeployedForCombat()) continue;
            if (!fleetMember.isCivilian()) {
                bl = false;
            }
            f2 = fleetMember.getMemberStrength();
            f3 += f2;
            float f7 = fleetMember.getRepairTracker().getCR();
            if (!(f7 < (f6 = fleetMember.getDeployCost()) + combatReadinessPlugin.getCriticalMalfunctionThreshold((MutableShipStatsAPI)fleetMember.getStats()))) continue;
            f5 += f2;
        }
        for (FleetMember fleetMember : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMember.canBeDeployedForCombat()) continue;
            f2 = fleetMember.getMemberStrength();
            f4 += f2;
        }
        if (f3 > f4 * 1.25f) {
            return CampaignFleetAIAPI.EncounterOption.ENGAGE;
        }
        if (f5 > f3 * 0.4f && !bl && this.fleet.getFleetData().getBurnLevel() < campaignFleetAPI.getFleetData().getBurnLevel()) {
            return CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER;
        }
        if (f3 <= f4 * 0.5f || f3 <= 0.0f) {
            return CampaignFleetAIAPI.EncounterOption.DISENGAGE;
        }
        return CampaignFleetAIAPI.EncounterOption.HOLD;
    }

    public CampaignFleetAIAPI.PursuitOption pickPursuitOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        if (!this.isHostileTo(campaignFleetAPI) && !fleetEncounterContextPlugin.isEngagedInHostilities()) {
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        FleetEncounterContextPlugin.PursueAvailability pursueAvailability = fleetEncounterContextPlugin.getPursuitAvailability((CampaignFleetAPI)this.fleet, campaignFleetAPI);
        FleetEncounterContextPlugin.DisengageHarryAvailability disengageHarryAvailability = fleetEncounterContextPlugin.getDisengageHarryAvailability((CampaignFleetAPI)this.fleet, campaignFleetAPI);
        if (pursueAvailability != FleetEncounterContextPlugin.PursueAvailability.AVAILABLE && disengageHarryAvailability != FleetEncounterContextPlugin.DisengageHarryAvailability.AVAILABLE) {
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getMembers()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f2 += (float)fleetMemberAPI.getFleetPointCost();
        }
        for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f3 += (float)fleetMemberAPI.getFleetPointCost();
        }
        if (f2 < 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        float f4 = 0.0f;
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getMembers()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f4 += fleetMemberAPI.getRepairTracker().getCR() * (float)fleetMemberAPI.getFleetPointCost();
        }
        float f5 = 0.0f;
        for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f5 += fleetMemberAPI.getRepairTracker().getCR() * (float)fleetMemberAPI.getFleetPointCost();
        }
        if (pursueAvailability == FleetEncounterContextPlugin.PursueAvailability.AVAILABLE && f2 > f3 * 0.75f && (f4 / f2 > f5 / f3 || f4 > f2 * 0.35f)) {
            return CampaignFleetAIAPI.PursuitOption.PURSUE;
        }
        return CampaignFleetAIAPI.PursuitOption.HARRY;
    }

    public CampaignFleetAIAPI.BoardingActionDecision makeBoardingDecision(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CrewCompositionAPI crewCompositionAPI) {
        return null;
    }

    public CampaignFleetAIAPI.InitialBoardingResponse pickBoardingResponse(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CampaignFleetAPI campaignFleetAPI) {
        if ((float)Math.random() > 0.95f) {
            return CampaignFleetAIAPI.InitialBoardingResponse.LET_IT_GO;
        }
        return CampaignFleetAIAPI.InitialBoardingResponse.ENGAGE;
    }

    public List<FleetMemberAPI> pickBoardingTaskForce(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CampaignFleetAPI campaignFleetAPI) {
        return null;
    }

    public void reportNearbyAction(CampaignFleetAIAPI.ActionType actionType, SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2, String string) {
        if (actionType == CampaignFleetAIAPI.ActionType.HOSTILE) {
            if (this.fleet.getMemoryWithoutUpdate().is("$core_fleetBusy", true)) {
                return;
            }
            if (this.isAlreadyIntercepting()) {
                return;
            }
            boolean bl = this.fleet.getFaction().isAtWorst(sectorEntityToken2.getFaction(), RepLevel.COOPERATIVE);
            if (!(bl &= !this.fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true))) {
                return;
            }
            CampaignFleetAIAPI.EncounterOption encounterOption = this.pickEncounterOption(null, (CampaignFleetAPI)sectorEntityToken);
            if (encounterOption == CampaignFleetAIAPI.EncounterOption.ENGAGE || encounterOption == CampaignFleetAIAPI.EncounterOption.HOLD) {
                this.fleet.getMemoryWithoutUpdate().set(string, (Object)true);
                this.fleet.getMemoryWithoutUpdate().expire(string, 10.0f);
                this.fleet.getMemoryWithoutUpdate().set("$core_fleetBusy", (Object)true, 5.0f);
                this.addAssignmentAtStart(FleetAssignment.INTERCEPT, sectorEntityToken, 10.0f, null);
                Global.getSector().addPing((SectorEntityToken)this.fleet, "danger");
            }
        } else if (actionType == CampaignFleetAIAPI.ActionType.CANCEL && this.fleet.getMemoryWithoutUpdate().is(string, true)) {
            this.fleet.getMemoryWithoutUpdate().unset(string);
            this.fleet.getMemoryWithoutUpdate().unset("$core_fleetBusy");
            this.removeFirstAssignmentIfItIs(FleetAssignment.INTERCEPT);
            this.pursuitAndEvasionModule.getTracker().forceIntervalElapsed();
            this.pursuitAndEvasionModule.pursueTarget(null, 0.0f);
            this.fleet.setInteractionTarget(null);
        }
    }

    private boolean isAlreadyIntercepting() {
        return this.assignments.size() >= 1 && this.assignments.get((int)0).assignment == FleetAssignment.INTERCEPT;
    }

    public void notifyInteractedWith(CampaignFleetAPI campaignFleetAPI) {
        if (this.isAlreadyIntercepting()) {
            this.assignments.remove(0);
        }
    }

    public String getActionTextOverride() {
        if (this.actionTextOverride != null) {
            return this.actionTextOverride;
        }
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        if (fleetAssignmentDataAPI != null) {
            return fleetAssignmentDataAPI.getActionText();
        }
        return null;
    }

    public void setActionTextOverride(String string) {
        this.actionTextOverride = string;
    }

    public FleetAssignment getCurrentAssignmentType() {
        return null;
    }

    public boolean wantsToJoin(BattleAPI battleAPI, boolean bl) {
        return false;
    }

    public void doNotAttack(SectorEntityToken sectorEntityToken, float f2) {
    }

    public CampaignFleetAIAPI.EncounterOption pickEncounterOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI, boolean bl) {
        return null;
    }

    public FleetActionTextProvider getActionTextProvider() {
        return null;
    }

    public void setActionTextProvider(FleetActionTextProvider fleetActionTextProvider) {
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, boolean bl, Script script, Script script2) {
    }

    public List<FleetAssignmentDataAPI> getAssignmentsCopy() {
        return null;
    }

    public void removeAssignment(FleetAssignmentDataAPI fleetAssignmentDataAPI) {
    }

    public boolean isMaintainingContact() {
        return false;
    }

    public static class FleetAssignmentData
    implements DoNotObfuscate,
    FleetAssignmentDataAPI {
        public FleetAssignment assignment;
        public SectorEntityToken target;
        public float maxDurationInDays;
        public float elapsedDays = 0.0f;
        public Script onCompletion;
        public Script onStart;
        public String actionText = null;
        public Boolean addTimeToNext = null;
        public Float timeToAdd = null;
        public Object custom = null;

        public FleetAssignmentData(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, boolean bl, Script script, Script script2) {
            this(fleetAssignment, sectorEntityToken, f2, string, script2);
            this.onStart = script;
            this.addTimeToNext = bl;
        }

        public FleetAssignmentData(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
            this.assignment = fleetAssignment;
            this.target = sectorEntityToken;
            this.maxDurationInDays = f2;
            this.actionText = string;
            this.onCompletion = script;
        }

        public Object getCustom() {
            return this.custom;
        }

        public void setCustom(Object object) {
            this.custom = object;
        }

        public void advance(float f2) {
            CampaignClock campaignClock = CampaignEngine.getInstance().getClock();
            float f3 = campaignClock.convertToDays(f2);
            this.elapsedDays += f3;
        }

        public void advanceDays(float f2) {
            this.elapsedDays += f2;
        }

        public boolean isExpired() {
            return this.elapsedDays >= this.maxDurationInDays;
        }

        public boolean isExipred() {
            return this.isExpired();
        }

        public void expire() {
            if (this.addTimeToNext != null && this.addTimeToNext.booleanValue()) {
                this.timeToAdd = Float.valueOf(this.maxDurationInDays - this.elapsedDays);
            }
            this.elapsedDays = this.maxDurationInDays;
        }

        public String getActionText() {
            return this.actionText;
        }

        public void setActionText(String string) {
            this.actionText = string;
        }

        public Script getOnCompletion() {
            return this.onCompletion;
        }

        public SectorEntityToken getTarget() {
            return this.target;
        }

        public FleetAssignment getAssignment() {
            return this.assignment;
        }

        public float getMaxDurationInDays() {
            return this.maxDurationInDays;
        }

        public float getElapsedDays() {
            return this.elapsedDays;
        }
    }

    public static class JumpPlan
    implements DoNotObfuscate {
        public JumpPoint point;
        public JumpPointAPI.JumpDestination dest;
        public float timeLeft = 0.5f + (float)Math.random() * 0.5f;

        public JumpPlan(JumpPoint jumpPoint, JumpPointAPI.JumpDestination jumpDestination) {
            this.point = jumpPoint;
            this.dest = jumpDestination;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        public JumpPoint super;
        public JumpPointAPI.JumpDestination \u00d200000;
        public int \u00d300000;
        public float String;
    }
}

