/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.C;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.J;
import com.fs.starfarer.campaign.command.L;
import com.fs.starfarer.campaign.command.do;
import com.fs.starfarer.campaign.command.super;
import com.fs.starfarer.campaign.ui.B;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.voidsuper;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.int;
import com.fs.starfarer.util.super.ooOO;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeaponBlueprintBrowser
extends L
implements C,
UITable.Oo {
    public static String ALL_TECHS = "\u6240\u6709\u8bbe\u8ba1";
    public static String ALL_SIZES = "\u6240\u6709\u7ea7\u522b";
    public static String ALL_TYPES = "\u6240\u6709\u7c7b\u578b";
    public static String SMALL = "\u5c0f\u578b";
    public static String MEDIUM = "\u4e2d\u578b";
    public static String LARGE = "\u5927\u578b";
    public static String BALLISTIC = "\u5b9e\u5f39";
    public static String MISSILE = "\u5bfc\u5f39";
    public static String ENERGY = "\u80fd\u91cf";
    private List<BaseWeaponSpec> this.null$super = new ArrayList<BaseWeaponSpec>();
    private CustomProductionPanel o0\u00d2000;
    private TableColumns \u00f8\u00f8o000 = null;

    public WeaponBlueprintBrowser(CustomProductionPanel customProductionPanel, L.o o2) {
        super(o2, customProductionPanel);
        this.o0\u00d2000 = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableWeapons() != null) {
            for (String string : customProductionPanel.getDelegate().getAvailableWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string);
                this.this.null$super.add(baseWeaponSpec);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (String string : faction.getKnownWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string);
                this.this.null$super.add(baseWeaponSpec);
            }
        }
    }

    public List<BaseWeaponSpec> getKnownWeapons() {
        return this.this.null$super;
    }

    @Override
    protected UITable createTable() {
        voidsuper voidsuper2 = new voidsuper(this.faction);
        voidsuper2.addColumn((Object)TableColumns.NAME, "\u6b66\u5668\u84dd\u56fe", 300.0f, true);
        voidsuper2.addColumn((Object)TableColumns.SIZE, "\u89c4\u6a21", 80.0f, true);
        voidsuper2.addColumn((Object)TableColumns.TYPE, "\u7c7b\u578b", 80.0f, true);
        voidsuper2.addColumn((Object)TableColumns.TECH, "\u8bbe\u8ba1\u7c7b\u578b", 200.0f, true);
        voidsuper2.setTooltip(0, "\u6b66\u5668\u7684\u540d\u79f0\u3002\u901a\u8fc7\u5c06\u9f20\u6807\u6ed1\u81f3\u6b66\u5668\u56fe\u6807\u5904\uff0c\u5373\u53ef\u67e5\u770b\u8be5\u6b66\u5668\u7684\u8be6\u7ec6\u4ecb\u7ecd\u4e0e\u80fd\u529b\u6570\u636e\u3002");
        voidsuper2.setTooltip(1, "\u6b66\u5668\u89c4\u6a21\u3002");
        voidsuper2.setTooltip(2, "\u6b66\u5668\u7c7b\u578b - \u5b9e\u5f39\uff0c\u80fd\u91cf\u6216\u5bfc\u5f39\u3002");
        voidsuper2.setTooltip(3, "\u8be5\u9879\u8bbe\u8ba1\u7684\u521b\u59cb\u4eba (\u4f8b\u5982\u516c\u53f8\u3001\u52bf\u529b)\uff0c\u6216\u4ee3\u8868\u4e00\u4e9b\u6bd4\u8f83\u5e38\u89c1\u7684\u8bbe\u8ba1\uff0c\u4e0e\u5176\u4ed6\u4e00\u822c\u5206\u7c7b\u3002");
        if (this.mode == L.o.\u00d300000) {
            voidsuper2.addColumn((Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            voidsuper2.setTooltip(4, "\u8ba9\u8be5\u6b66\u5668\u66f4\u5bb9\u6613\u5728\u4f60\u7684\u9635\u8425\u8230\u961f\u4e2d\u51fa\u73b0\u3002");
        } else {
            voidsuper2.addColumn((Object)TableColumns.COST, "\u751f\u4ea7\u6210\u672c", 120.0f, true);
            voidsuper2.setTooltipAbove(4, new StandardTooltipV2Expandable(300.0f, false){

                public void createImpl(boolean bl) {
                    this.addPara("\u751f\u4ea7\u82b1\u8d39\u3002", 0.0f);
                }
            });
        }
        UITable uITable = new UITable(8000.0f, J.ROW_HEIGHT, voidsuper2, this);
        uITable.setEmptyText("\u6ca1\u6709\u5339\u914d\u7684\u6b66\u5668\u84dd\u56fe");
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(J.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        Set<String> set = this.tags.getSelected();
        for (BaseWeaponSpec baseWeaponSpec : this.this.null$super) {
            if (!this.weaponMatchesTags(baseWeaponSpec, set)) continue;
            super super_ = new super(this.o0\u00d2000, this.table.getHeader(), super.o.\u00d200000, baseWeaponSpec.getWeaponId(), this.mode);
            this.table.addRow(super_);
            if (this.mode != L.o.\u00d200000) continue;
            super_.getButton().getLogic().super(int.o.String);
        }
        this.table.resumeRecompute();
        this.table.sort((Object)TableColumns.SIZE, false);
        super.updateTable();
    }

    protected boolean weaponMatchesTags(BaseWeaponSpec baseWeaponSpec, Set<String> set) {
        WeaponAPI.WeaponSize weaponSize = baseWeaponSpec.getSize();
        String string = null;
        if (weaponSize == WeaponAPI.WeaponSize.SMALL) {
            string = SMALL;
        }
        if (weaponSize == WeaponAPI.WeaponSize.MEDIUM) {
            string = MEDIUM;
        }
        if (weaponSize == WeaponAPI.WeaponSize.LARGE) {
            string = LARGE;
        }
        if (string != null && !set.contains(string)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC && !set.contains(BALLISTIC)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE && !set.contains(MISSILE)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.ENERGY && !set.contains(ENERGY)) {
            return false;
        }
        String string2 = baseWeaponSpec.getManufacturer();
        return string2 == null || set.contains(string2);
    }

    @Override
    protected do createTags() {
        do do_ = new do(this.table.getWidth(), this);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        CountingMap countingMap = new CountingMap();
        for (BaseWeaponSpec baseWeaponSpec : this.this.null$super) {
            countingMap.add((Object)baseWeaponSpec.getManufacturer());
            if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                ++n;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                ++n2;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.LARGE) {
                ++n3;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC) {
                ++n4;
                continue;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE) {
                ++n5;
                continue;
            }
            if (baseWeaponSpec.getType() != WeaponAPI.WeaponType.ENERGY) continue;
            ++n6;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            do_.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                do_.addTag(string, string, countingMap.getCount((Object)string));
            }
            do_.addGroup(0.0f);
        }
        do_.beginGroup(false, ALL_SIZES, 120.0f);
        do_.addTag(SMALL, n);
        do_.addTag(MEDIUM, n2);
        do_.addTag(LARGE, n3);
        do_.addGroup(f2 * 1.0f);
        do_.beginGroup(false, ALL_TYPES, 120.0f);
        do_.addTag(BALLISTIC, n4);
        do_.addTag(MISSILE, n5);
        do_.addTag(ENERGY, n6);
        do_.addGroup(f3);
        return do_;
    }

    @Override
    public void tagsChanged(do do_) {
        TableColumns tableColumns = this.\u00f8\u00f8o000;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((Object)tableColumns, null);
            this.table.sort((Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<B> tableGetComparator(UITable uITable, final Object object) {
        return new Comparator<B>(){

            public int super(B b2, B b3) {
                int n;
                super super_ = (super)b2;
                super super_2 = (super)b3;
                WeaponBlueprintBrowser.this.\u00f8\u00f8o000 = (TableColumns)((Object)object);
                if (object == TableColumns.SIZE && (n = super_.getSizeOrdinal() - super_2.getSizeOrdinal()) != 0) {
                    return n;
                }
                if (object == TableColumns.TECH && (n = super_.getTechString().compareTo(super_2.getTechString())) != 0) {
                    return n;
                }
                if (object == TableColumns.TYPE && (n = super_.getTypeString().compareTo(super_2.getTypeString())) != 0) {
                    return n;
                }
                if (object == TableColumns.ENABLED) {
                    if (super_.isBlueprintEnabled() && !super_2.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (super_2.isBlueprintEnabled() && !super_.isBlueprintEnabled()) {
                        return 1;
                    }
                    n = super_.getSizeOrdinal() - super_2.getSizeOrdinal();
                    if (n != 0) {
                        return n;
                    }
                }
                if (object == TableColumns.COST && (n = super_.getCostValue() - super_2.getCostValue()) != 0) {
                    return n;
                }
                return super_.getNameString().compareTo(super_2.getNameString());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, B b2, Object object) {
        super super_ = (super)b2;
        if (this.mode == L.o.\u00d300000) {
            super_.setBlueprintEnabled(!super_.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n = 1;
            boolean bl = true;
            if (object instanceof ooOO) {
                cloneable = (ooOO)object;
                if (((ooOO)cloneable).isCtrlDown()) {
                    n = 1000;
                } else if (((ooOO)cloneable).isShiftDown()) {
                    n = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((ooOO)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.o0\u00d2000.getProd();
            if (bl) {
                int n2 = this.o0\u00d2000.getDelegate() == null ? 0 : (this.o0\u00d2000.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId(), n, n2);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId(), n);
            }
            this.o0\u00d2000.updatePlanTable(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId());
            super_.getButton().flash(false, 0.1f, 0.9f);
        }
        super_.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, voidsuper.o o2) {
    }

    @Override
    protected void selectAll() {
        for (B b2 : this.table.getRows()) {
            super super_ = (super)b2;
            super_.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (B b2 : this.table.getRows()) {
            super super_ = (super)b2;
            super_.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (String string : faction.getKnownWeapons()) {
            faction.removePriorityWeapon(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityWeapons().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownWeapons(bl);
    }

    @Override
    protected String getAutoEnableSubject() {
        return "\u6b66\u5668\u84dd\u56fe";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownWeapons();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        SIZE,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

