/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.contract;

import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.contract.Bid;
import com.fs.starfarer.campaign.econ.contract.Contract;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistingMarketContracts
implements DoNotObfuscate {
    public Market market;
    public Map<String, List<Bid>> bids = new HashMap<String, List<Bid>>();
    public Map<String, List<Contract>> contracts = new HashMap<String, List<Contract>>();

    public List<Bid> getBids(String string) {
        List<Bid> list = this.bids.get(string);
        if (list == null) {
            list = new ArrayList<Bid>();
            this.bids.put(string, list);
        }
        return list;
    }

    public void addBid(String string, Bid bid) {
        this.getBids(string).add(bid);
    }

    public void removeBid(String string, Bid bid) {
        this.getBids(string).remove(bid);
    }

    public List<Bid> getSortedBids(String string) {
        ArrayList<Bid> arrayList = new ArrayList<Bid>(this.getBids(string));
        Collections.sort(arrayList, new Comparator<Bid>(){

            public int o00000(Bid bid, Bid bid2) {
                return (int)Math.signum(bid2.contract.quantity - bid.contract.quantity);
            }
        });
        return arrayList;
    }

    public List<Contract> getContracts(String string) {
        List<Contract> list = this.contracts.get(string);
        if (list == null) {
            list = new ArrayList<Contract>();
            this.contracts.put(string, list);
        }
        return list;
    }

    public void addContract(String string, Contract contract) {
        this.getContracts(string).add(contract);
    }

    public void removeContract(String string, Contract contract) {
        this.getContracts(string).remove(contract);
    }

    public List<Contract> getSortedContracts(String string) {
        ArrayList<Contract> arrayList = new ArrayList<Contract>(this.getContracts(string));
        Collections.sort(arrayList, new Comparator<Contract>(){

            public int super(Contract contract, Contract contract2) {
                return (int)Math.signum(contract2.quantity - contract.quantity);
            }
        });
        return arrayList;
    }
}

