/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.contract.iter;

import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.contract.Contract;
import com.fs.starfarer.campaign.econ.contract.ContractEconomy;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.util.DoNotObfuscate;
import java.util.List;

public class ContractsAndBidsTask
extends MultiFrameTask
implements DoNotObfuscate {
    public static final int MAX_ITER = 200;
    private ContractEconomy econ;
    private String demandClass;
    private State state = State.INITIAL_PREP;
    private int iter = 0;
    private float fraction;
    private boolean done = false;
    private List<Market> markets = null;
    private int marketIndex = 0;

    public ContractsAndBidsTask(ContractEconomy contractEconomy, String string, float f2) {
        this.econ = contractEconomy;
        this.demandClass = string;
        this.fraction = f2;
    }

    public void doNextBatch() {
        if (this.isDone()) {
            return;
        }
        if (this.state == State.INITIAL_PREP) {
            if (ContractEconomy.DEBUG) {
                System.out.println("");
                System.out.println("-----------------------------------------------------");
                System.out.println("--COMMODITY: " + this.demandClass + "----------------------");
                System.out.println("-----------------------------------------------------");
            }
            this.state = State.EXISTING;
            return;
        }
        if (this.state == State.EXISTING) {
            this.econ.processExistingContracts(this.demandClass, 1.0f);
            this.state = State.GEN_CONTRACTS;
            return;
        }
        if (this.state == State.GEN_CONTRACTS) {
            if (ContractEconomy.DEBUG) {
                System.out.println("");
                System.out.println("-----------------------------------");
                System.out.println("---NEW ROUND OF BIDS & CONTRACTS---");
                System.out.println("-----------------------------------");
            }
            this.econ.generateContracts(this.demandClass);
            this.state = State.MAKE_BIDS;
            return;
        }
        if (this.state == State.MAKE_BIDS) {
            if (this.markets == null) {
                this.marketIndex = 0;
            }
            if (this.marketIndex >= this.markets.size()) {
                this.state = State.PROCESS_BID_RESULTS;
                this.markets = null;
                return;
            }
            this.econ.doRoundOfBids(this.demandClass, this.markets.get(this.marketIndex));
            ++this.marketIndex;
            return;
        }
        if (this.state == State.PROCESS_BID_RESULTS) {
            boolean bl = this.econ.processBidResults(this.econ.getContracts(), false);
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = true;
                float f2 = this.econ.getMinContractSize(this.demandClass);
                for (Contract contract : this.econ.getContracts()) {
                    if (!((float)contract.quantity > f2)) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    if (ContractEconomy.DEBUG) {
                        System.out.println(String.valueOf(this.demandClass) + ": ENDING ON ITERATION " + (this.iter + 1) + " OUT OF " + 200);
                    }
                    bl2 = true;
                }
            }
            ++this.iter;
            if (this.iter >= 200) {
                bl2 = true;
            }
            this.state = bl2 ? State.MOVE_TO_PROJECTED : State.GEN_CONTRACTS;
            return;
        }
        if (this.state == State.MOVE_TO_PROJECTED) {
            this.econ.moveComputedIncomingToCOM(this.demandClass);
            this.state = State.ADD_TO_STOCKPILES;
            return;
        }
        if (this.state == State.ADD_TO_STOCKPILES) {
            this.econ.addToStockpilesFromProjectedIncoming(this.demandClass, this.fraction);
            this.state = State.DONE;
            this.done = true;
            return;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public String getLoggingIdentifier() {
        return "Contracts and bids: " + this.state.name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State implements DoNotObfuscate
    {
        INITIAL_PREP,
        EXISTING,
        GEN_CONTRACTS,
        MAKE_BIDS,
        PROCESS_BID_RESULTS,
        MOVE_TO_PROJECTED,
        ADD_TO_STOCKPILES,
        DONE;

    }
}

