/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;

public class UpdateMarketsAgainTask
extends MultiFrameTask
implements DoNotObfuscate {
    private List<MarketAPI> markets = null;
    private int marketIndex = 0;

    public UpdateMarketsAgainTask(Economy economy) {
        this.markets = new ArrayList<MarketAPI>(economy.getMarkets());
    }

    public void doNextBatch() {
        if (this.isDone()) {
            return;
        }
        if (this.marketIndex < this.markets.size()) {
            Profiler.\u00d200000((String)"Reapplying conditions and industries");
            MarketAPI marketAPI = this.markets.get(this.marketIndex);
            marketAPI.reapplyConditions();
            marketAPI.reapplyIndustries();
            ++this.marketIndex;
            Profiler.o00000();
        }
    }

    public boolean isDone() {
        return this.marketIndex >= this.markets.size();
    }

    public String getLoggingIdentifier() {
        return "UpdateMarketsAgainTask";
    }
}

