/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ui.fleet;

import com.fs.graphics.G;
import com.fs.graphics.Sprite;
import com.fs.starfarer.C;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.fleet.FleetData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.ui.fleet.ooOO;
import com.fs.starfarer.campaign.util.CollectionItemView;
import com.fs.starfarer.coreui.o00o;
import com.fs.starfarer.coreui.refit.auto.D;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.L;
import com.fs.starfarer.ui.Q;
import com.fs.starfarer.ui.b;
import com.fs.starfarer.ui.d;
import com.fs.starfarer.ui.o000;
import com.fs.starfarer.ui.o0O0;
import com.fs.starfarer.ui.ooOo;
import java.awt.Color;

public class FleetMemberView
extends o000
implements ooOo,
CollectionItemView {
    private final FleetMember member;
    private o0O0 button;
    private Sprite flagshipIcon = null;
    private d fpCost;
    private ooOO overlay;
    private D fighters;
    private boolean showRank = true;
    private boolean expired = false;

    public FleetMemberView(FleetMember fleetMember, FleetData fleetData) {
        this.member = fleetMember;
        this.button = Q.o00000(fleetMember, (ooOo)this);
        this.add((b)this.button).inBL(0.0f, 0.0f);
        this.overlay = new ooOO(this, fleetData);
        this.add((b)this.overlay).setSize(1000.0f, 1000.0f).inMid();
        this.overlay.advance(0.0f);
        this.fpCost = new d("" + (int)fleetMember.getDeploymentPointsCost(), "graphics/fonts/insignia21LTaa.fnt", C.return.super, true);
        this.fpCost.autoSize();
        this.add((b)this.fpCost).inTR(4.0f, 0.0f);
        this.button.getHighlightFader().setDuration(0.01f, 0.01f);
        this.updateRankIcon();
    }

    public boolean isShowFighters() {
        return this.fighters != null;
    }

    public void setShowFighters(boolean bl) {
        if (bl) {
            this.fighters = new D(this.getHeight() / 6.0f, true);
        } else {
            this.remove((b)this.fighters);
            this.fighters = null;
        }
    }

    public void hideFpCost() {
        this.remove((b)this.fpCost);
    }

    public void turnOffButtonSounds() {
        this.button.setMouseOverSound(null);
        this.button.setButtonPressedSound(null);
        this.button.setButtonDisabledPressedSound(null);
    }

    public void makeLookDisabled() {
        ((o00o)this.button.getRenderer()).o00000(new Color(120, 120, 120, 255));
        ((o00o)this.button.getRenderer()).\u00d6O0000();
        ((o00o)this.button.getRenderer()).\u00f6O0000().setShowDestroyedFighters(true);
    }

    public void sizeChanged(float f2, float f3) {
        super.sizeChanged(f2, f3);
        this.button.setSize(f2, f3);
        if (this.fighters != null) {
            this.remove((b)this.fighters);
            this.fighters = new D(this.getHeight() / 9.0f, true);
            this.fighters.syncWithVariant(null, this.member.getVariant());
            float f4 = 10.0f;
            this.add((b)this.fighters).setSize(this.getWidth() - f4 * 2.0f, this.getHeight() - f4 * 4.0f).inMid();
        }
    }

    public o0O0 getButton() {
        return this.button;
    }

    public void actionPerformed(Object object, Object object2) {
    }

    protected void advanceImpl(float f2) {
        super.advanceImpl(f2);
        this.updateRankIcon();
    }

    private void updateRankIcon() {
        if (!this.member.isMothballed()) {
            float f2 = StarfarerSettings.\u00f500000("noDeployCrewPercent") * 0.01f;
            boolean bl = this.member.getFleetCommander() != null && this.member.getFleetCommander().isPlayer();
            CharacterStats characterStats = null;
            if (bl) {
                characterStats = this.member.getFleetCommander().getStats();
            }
            if (!this.member.canBeDeployedForCombat() && this.member.getCrewFraction() < f2) {
                this.setStatusText("\u6ca1\u6709\u8db3\u591f\u7684\u8239\u5458", C.\u00d2\u00d30000, false);
            } else if (this.member.getCrewFraction() < 1.0f) {
                this.setStatusText("\u8239\u5458\u6570\u91cf\u4e0d\u8db3", C.\u00d2\u00d30000, false);
            } else if (bl && this.member.getVariant().computeOPCost(characterStats) < this.member.getVariant().getHullSpec().getOrdnancePoints(characterStats)) {
                float f3 = this.member.getVariant().getHullSpec().getOrdnancePoints(characterStats) - this.member.getVariant().computeOPCost(characterStats);
                if (f3 > 1.0f) {
                    this.setStatusText(String.valueOf((int)f3) + " \u88c5\u914d\u70b9 \u5269\u4f59", C.\u00d5O0000, false);
                } else {
                    this.setStatusText(String.valueOf((int)f3) + " \u88c5\u914d\u70b9 \u5269\u4f59", C.\u00d5O0000, false);
                }
            } else {
                this.setStatusText(null, null, false);
            }
        } else {
            this.setStatusText("\u5c01\u5b58", C.\u00d2\u00d30000, false);
        }
        if (this.member.isFlagship() && this.flagshipIcon == null) {
            this.flagshipIcon = new Sprite(G.\u00d200000((String)"graphics/icons/insignia/16x_star_circle.png"));
            this.flagshipIcon.setSize(16.0f, 16.0f);
        } else if (!this.member.isFlagship()) {
            this.flagshipIcon = null;
        }
    }

    public void setStatusText(String string, Color color) {
        this.setStatusText(string, color, true);
    }

    public void setStatusText(String string, Color color, boolean bl) {
        this.overlay.setStatusText(string, color, bl);
    }

    public void setShowRank(boolean bl) {
        this.showRank = bl;
    }

    public void setShowStatus(boolean bl) {
        if (bl) {
            this.remove((b)this.overlay);
            this.add((b)this.overlay).inMid();
        } else {
            this.remove((b)this.overlay);
        }
    }

    protected void renderImpl(float f2) {
        super.renderImpl(f2);
        L l2 = this.getPosition();
        float f3 = l2.getX();
        float f4 = l2.getY();
        float f5 = l2.getWidth();
        float f6 = l2.getHeight();
        if (this.showRank) {
            if (this.flagshipIcon != null) {
                this.flagshipIcon.setNormalBlend();
                this.flagshipIcon.setAlphaMult(f2);
                this.flagshipIcon.render(f3 + 4.0f, f4 + f6 - 50.0f);
            }
            if (this.button.getHighlightFader().getBrightness() > 0.0f && this.flagshipIcon != null) {
                this.flagshipIcon.setAdditiveBlend();
                this.flagshipIcon.setAlphaMult(f2 * this.button.getHighlightFader().getBrightness() * 0.5f);
                this.flagshipIcon.render(f3 + 4.0f, f4 + f6 - 50.0f);
            }
        }
    }

    public int getRenderOrder() {
        return 0;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void notifyOrphaned() {
        this.getParent().remove((b)this);
        this.expired = true;
    }

    public Object getItem() {
        return this.member;
    }

    public FleetMember getMember() {
        return this.member;
    }
}

