/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ui.trade;

import com.fs.graphics.G;
import com.fs.graphics.util.GLListManager;
import com.fs.starfarer.C;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.input.InputEventClass;
import com.fs.starfarer.api.input.InputEventType;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.ui.trade.CargoItemStack;
import com.fs.starfarer.campaign.ui.trade.CargoStackView;
import com.fs.starfarer.campaign.ui.trade.E;
import com.fs.starfarer.campaign.util.CollectionView;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.renderers.OO0O;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.L;
import com.fs.starfarer.ui.b;
import com.fs.starfarer.ui.g;
import com.fs.starfarer.ui.impl.CargoTooltipFactory;
import com.fs.starfarer.ui.impl.StandardTooltipV2;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.ui.o000;
import com.fs.starfarer.util.super.OoOO;
import com.fs.starfarer.util.super.ooOO;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoDataGridView
extends o000
implements CollectionView.CollectionViewDelegate<CargoStackView> {
    public static final float CELL_SIZE = 100.0f;
    private int rows;
    private int cols;
    private com.fs.graphics.Object texture;
    private com.fs.graphics.Object texture2;
    private CargoData cargo = null;
    private CollectionView<CargoStackView> stackView;
    private final g scroller;
    private final o manifest;
    private CharacterStats stats;
    private GLListManager.GLListToken token = null;
    private E transferHandler;
    private Color prevColor = null;
    private Color color = C.\u00d8\u00d20000;

    public CargoDataGridView(int n, o o2) {
        this.cols = n;
        this.scroller = o2.getScroller();
        this.manifest = o2;
        this.texture = G.\u00d200000((String)"graphics/hud/line4x4.png");
        this.texture2 = G.\u00d200000((String)OO0O.Oo.\u00d800000.o00000());
        this.stackView = new CollectionView<CargoStackView>(this);
    }

    public void setStats(CharacterStats characterStats) {
        this.stats = characterStats;
    }

    @Override
    public void advanceImpl(float f2) {
        super.advanceImpl(f2);
        if (this.cargo != null) {
            this.stackView.sync(this.cargo.getStacks());
            this.stackView.finishSync();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    protected void renderImpl(float f2) {
        boolean bl;
        if (this.cargo == null) {
            f2 *= 0.4f;
        }
        L l2 = this.getPosition();
        float f3 = l2.getX();
        float f4 = l2.getY();
        float f5 = l2.getWidth();
        float f6 = l2.getHeight();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f3, (float)f4, (float)0.0f);
        f4 = 0.0f;
        f3 = 0.0f;
        Color color = com.fs.graphics.util.OoOO.String((Color)this.color, (float)f2);
        if (!color.equals(this.prevColor)) {
            this.prevColor = color;
            GLListManager.invalidateList((GLListManager.GLListToken)this.token);
        }
        if (!(bl = GLListManager.callList((GLListManager.GLListToken)this.token))) {
            float f7;
            float f8;
            float f9;
            float f10;
            this.token = GLListManager.beginList();
            float f11 = 1.0f;
            float f12 = 0.0f;
            while (f12 <= (float)this.rows) {
                f10 = f3;
                f9 = f3 + (float)this.cols * 100.0f + 1.0f;
                f7 = f8 = f4 + f6 - f12 * 100.0f;
                com.fs.starfarer.renderers.E.o00000(this.texture, f10, f8, f9, f7, f11, color, 1.0f, 1.0f, 1.0f, false);
                f12 += 1.0f;
            }
            f12 = 0.0f;
            while (f12 <= (float)this.cols) {
                f9 = f10 = f3 + f12 * 100.0f;
                f8 = f4 + f6 - (float)this.rows * 100.0f;
                f7 = f4 + f6;
                com.fs.starfarer.renderers.E.o00000(this.texture, f10, f8, f9, f7, f11, color, 1.0f, 1.0f, 1.0f, false);
                f12 += 1.0f;
            }
            f11 = 7.0f;
            f12 = 0.0f;
            while (f12 <= (float)this.rows) {
                f10 = f3;
                f9 = f3 + (float)this.cols * 100.0f + 1.0f;
                f7 = f8 = f4 + f6 - f12 * 100.0f;
                com.fs.starfarer.renderers.E.o00000(this.texture2, f10, f8, f9, f7, f11, color, 0.5f, 0.5f, 0.5f, true);
                f12 += 1.0f;
            }
            f12 = 0.0f;
            while (f12 <= (float)this.cols) {
                f9 = f10 = f3 + f12 * 100.0f;
                f8 = f4 + f6 - (float)this.rows * 100.0f;
                f7 = f4 + f6;
                com.fs.starfarer.renderers.E.o00000(this.texture2, f10, f8, f9, f7, f11, color, 0.5f, 0.5f, 0.5f, true);
                f12 += 1.0f;
            }
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)7);
            int n = 0;
            while (n < this.cols) {
                int n2 = 0;
                while (n2 < this.rows) {
                    f9 = f3 + (float)n * 100.0f;
                    f8 = f4 + (float)n2 * 100.0f;
                    com.fs.graphics.util.OoOO.\u00d200000((Color)color, (float)0.2f);
                    GL11.glVertex2f((float)f9, (float)f8);
                    GL11.glVertex2f((float)(f9 + 100.0f), (float)f8);
                    com.fs.graphics.util.OoOO.\u00d200000((Color)color, (float)0.0f);
                    GL11.glVertex2f((float)(f9 + 100.0f), (float)(f8 + 100.0f));
                    GL11.glVertex2f((float)f9, (float)(f8 + 100.0f));
                    ++n2;
                }
                ++n;
            }
            GL11.glEnd();
            GLListManager.endList();
        }
        GL11.glPopMatrix();
        super.renderImpl(f2);
    }

    @Override
    protected void processInputImpl(OoOO ooOO2) {
        super.processInputImpl(ooOO2);
        for (ooOO ooOO3 : ooOO2) {
            boolean bl;
            int n;
            int n2;
            float f2;
            if (ooOO3.isConsumed()) continue;
            boolean bl2 = StarfarerSettings.\u00d400000("altMouseMoveToMassTransfer");
            if (ooOO3.isMouseMoveEvent() && ooOO3.isAltDown() && bl2 && this.transferHandler != null && this.scroller.getPosition().containsEvent(ooOO3) && (ooOO3.getDX() != 0 || ooOO3.getDY() != 0)) {
                float f3 = (float)ooOO3.getX() - this.scroller.getContentContainer().getPosition().getX();
                f2 = (float)ooOO3.getY() - this.scroller.getContentContainer().getPosition().getY();
                int n3 = (int)(f3 / 100.0f);
                n2 = (int)(f2 / 100.0f);
                if (n3 < 0 || n3 >= this.cols || n2 < 0 || n2 >= this.rows) continue;
                n = (this.rows - n2 - 1) * this.cols + n3;
                ooOO ooOO4 = new ooOO(InputEventClass.MOUSE_EVENT, InputEventType.MOUSE_DOWN, ooOO3.getX(), ooOO3.getY(), 0, ooOO3.getEventChar());
                ooOO4.setCtrlDown(true);
                this.transferHandler.cargoCellClicked(ooOO4, this.manifest, this.manifest.getCargoStackIndexForCellIndex(n));
                ooOO2.\u00d200000();
                ooOO3.consume();
                break;
            }
            boolean bl3 = bl = ooOO3.isRMBDownEvent() && ooOO3.isShiftDown();
            if ((ooOO3.isLMBDownEvent() || bl) && this.transferHandler != null && this.scroller.getPosition().containsEvent(ooOO3)) {
                f2 = (float)ooOO3.getX() - this.scroller.getContentContainer().getPosition().getX();
                float f4 = (float)ooOO3.getY() - this.scroller.getContentContainer().getPosition().getY();
                n2 = (int)(f2 / 100.0f);
                n = (int)(f4 / 100.0f);
                if (n2 < 0 || n2 >= this.cols || n < 0 || n >= this.rows) continue;
                int n4 = (this.rows - n - 1) * this.cols + n2;
                this.transferHandler.cargoCellClicked(ooOO3, this.manifest, this.manifest.getCargoStackIndexForCellIndex(n4));
                ooOO2.\u00d200000();
                ooOO3.consume();
                break;
            }
            if (!ooOO3.isRMBDownEvent() || this.transferHandler == null || this.transferHandler.getPickedUpStack() != null || !this.scroller.getPosition().containsEvent(ooOO3)) continue;
            f2 = (float)ooOO3.getX() - this.scroller.getContentContainer().getPosition().getX();
            float f5 = (float)ooOO3.getY() - this.scroller.getContentContainer().getPosition().getY();
            n2 = (int)(f2 / 100.0f);
            n = (int)(f5 / 100.0f);
            if (n2 < 0 || n2 >= this.cols || n < 0 || n >= this.rows) continue;
            int n5 = (this.rows - n - 1) * this.cols + n2;
            this.transferHandler.cargoCellRightClicked(ooOO3, this.manifest, this.manifest.getCargoStackIndexForCellIndex(n5));
            ooOO2.\u00d200000();
            ooOO3.consume();
            break;
        }
    }

    public void setCargo(CargoData cargoData) {
        if (this.cargo == cargoData) {
            return;
        }
        this.clearChildren();
        this.cargo = cargoData;
    }

    @Override
    public void sizeChanged(float f2, float f3) {
        super.sizeChanged(f2, f3);
        GLListManager.invalidateList((GLListManager.GLListToken)this.token);
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.stackView.clear();
        GLListManager.invalidateList((GLListManager.GLListToken)this.token);
    }

    @Override
    public CargoStackView createItemView(Object object) {
        CargoItemStack cargoItemStack = (CargoItemStack)object;
        if (cargoItemStack.isNull()) {
            return null;
        }
        CargoStackView cargoStackView = new CargoStackView(cargoItemStack, this.scroller);
        cargoStackView.setShowRedBackground(this.manifest.preventPickup(cargoItemStack));
        CargoDataGridView.assignTooltipToView(cargoStackView, cargoItemStack, this.manifest, this.stats, this.transferHandler);
        int n = this.cargo.getIndexOfStack(cargoItemStack);
        int n2 = n % this.cols;
        int n3 = n / this.cols;
        float f2 = (float)n2 * 100.0f;
        float f3 = (float)(this.rows - n3 - 1) * 100.0f;
        this.add((b)cargoStackView).setSize(100.0f, 100.0f).inBL(f2, f3);
        return cargoStackView;
    }

    public static StandardTooltipV2 createTooltipForStack(CargoItemStack cargoItemStack, final o o2, CharacterStats characterStats, final E e2) {
        BaseWeaponSpec baseWeaponSpec = cargoItemStack.getWeaponIfWeapon();
        F f2 = cargoItemStack.getResourceIfResource();
        StandardTooltipV2 standardTooltipV2 = null;
        if (baseWeaponSpec != null) {
            standardTooltipV2 = CargoTooltipFactory.o00000(baseWeaponSpec, characterStats, cargoItemStack, o2, e2);
        } else if (f2 != null) {
            standardTooltipV2 = CargoTooltipFactory.o00000(f2, cargoItemStack, o2, e2);
        } else if (cargoItemStack.getType() == CargoAPI.CargoItemType.FIGHTER_CHIP) {
            String string = (String)cargoItemStack.getData();
            FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, string);
            standardTooltipV2 = CargoTooltipFactory.o00000(null, fighterWingSpec, -1, 400.0f, CampaignEngine.getInstance().getPlayerStats(), cargoItemStack, o2, e2, false);
        } else if (cargoItemStack.getType() == CargoAPI.CargoItemType.SPECIAL) {
            final SpecialItemPlugin specialItemPlugin = cargoItemStack.getPlugin();
            standardTooltipV2 = new StandardTooltipV2Expandable(specialItemPlugin.getTooltipWidth(), specialItemPlugin.isTooltipExpandable(), true){

                public void createImpl(boolean bl) {
                    specialItemPlugin.createTooltip((TooltipMakerAPI)this, bl, (CargoTransferHandlerAPI)e2, (Object)o2);
                }
            };
        }
        return standardTooltipV2;
    }

    public static void assignTooltipToView(final CargoStackView cargoStackView, CargoItemStack cargoItemStack, o o2, CharacterStats characterStats, E e2) {
        StandardTooltipV2 standardTooltipV2;
        final StandardTooltipV2 standardTooltipV22 = standardTooltipV2 = CargoDataGridView.createTooltipForStack(cargoItemStack, o2, characterStats, e2);
        if (standardTooltipV2 != null) {
            cargoStackView.setTooltip(0.0f, standardTooltipV2);
            standardTooltipV2.setBeforeShowing(new Runnable(){

                public void run() {
                    cargoStackView.setTooltipOffsetFromCenter(-standardTooltipV22.getPosition().getWidth() / 2.0f, -standardTooltipV22.getPosition().getHeight() * 1.0f + 20.0f);
                }
            });
        }
    }

    @Override
    public boolean shouldCreateViewFor(Object object) {
        CargoItemStack cargoItemStack = (CargoItemStack)object;
        return cargoItemStack.getType() != CargoAPI.CargoItemType.NULL;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        if (this.rows != n) {
            GLListManager.invalidateList((GLListManager.GLListToken)this.token);
        }
        this.rows = n;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int n) {
        if (this.cols != n) {
            GLListManager.invalidateList((GLListManager.GLListToken)this.token);
        }
        this.cols = n;
    }

    public void setTransferHandler(E e2) {
        this.transferHandler = e2;
    }

    public static interface o {
        public int getCargoStackIndexForCellIndex(int var1);

        public CargoData getCargo();

        public CargoData getFilteredCargo();

        public g getScroller();

        public CargoDataGridView getCargoDataView();

        public boolean preventPickup(CargoItemStack var1);

        public void updateFilteredCargo();

        public boolean isInvalidDropTarget(CargoItemStack var1);

        public void setInvalidDropTarget(boolean var1);

        public void flashRed();
    }
}

