/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading;

import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.ai.ModularFleetAI;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.loading.new;
import com.fs.starfarer.loading.o0oO;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class FleetCreationSpec
implements DoNotObfuscate {
    private static Logger log = Logger.getLogger(FleetCreationSpec.class);
    private String specId;
    private String displayName;
    private float maxFleetPoints;
    private float minDaysWorthSupplies;
    private float maxDaysWorthSupplies;
    private float minLYWorthOfFuel;
    private float maxLYWorthOfFuel;
    private float minExtraCrewPercent;
    private float maxExtraCrewPercent;
    private float minMarinesPercent;
    private float maxMarinesPercent;
    private List<FleetMemberPick> picks = new ArrayList<FleetMemberPick>();

    public static FleetCreationSpec createFromJSON(String string, JSONObject jSONObject) throws JSONException {
        FleetCreationSpec fleetCreationSpec = new FleetCreationSpec();
        fleetCreationSpec.setSpecId(string);
        fleetCreationSpec.setDisplayName(jSONObject.getString("displayName"));
        fleetCreationSpec.setMaxFleetPoints(jSONObject.getInt("maxFleetPoints"));
        fleetCreationSpec.setMinDaysWorthSupplies(jSONObject.getJSONArray("daysWorthOfSupplies").getInt(0));
        fleetCreationSpec.setMaxDaysWorthSupplies(jSONObject.getJSONArray("daysWorthOfSupplies").getInt(1));
        fleetCreationSpec.setMinLYWorthOfFuel(jSONObject.getJSONArray("lyWorthOfFuel").getInt(0));
        fleetCreationSpec.setMaxLYWorthOfFuel(jSONObject.getJSONArray("lyWorthOfFuel").getInt(1));
        fleetCreationSpec.setMinExtraCrewPercent(jSONObject.getJSONArray("extraCrewPercent").getInt(0));
        fleetCreationSpec.setMaxExtraCrewPercent(jSONObject.getJSONArray("extraCrewPercent").getInt(1));
        fleetCreationSpec.setMinMarinesPercent(jSONObject.getJSONArray("marinesPercent").getInt(0));
        fleetCreationSpec.setMaxMarinesPercent(jSONObject.getJSONArray("marinesPercent").getInt(1));
        JSONObject jSONObject2 = jSONObject.getJSONObject("ships");
        String[] stringArray = JSONObject.getNames((JSONObject)jSONObject2);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = jSONObject2.getJSONArray(string2).getInt(0);
            int n3 = jSONObject2.getJSONArray(string2).getInt(1);
            FleetMemberType fleetMemberType = null;
            if (o0oO.\u00d200000(string2)) {
                fleetMemberType = FleetMemberType.FIGHTER_WING;
            } else if (new.\u00d400000(string2)) {
                fleetMemberType = FleetMemberType.SHIP;
            } else {
                throw new RuntimeException(String.format("Ship hull variant or fighter wing with id: [%s] not found!", string2));
            }
            fleetCreationSpec.addPick(fleetMemberType, string2, n2, n3);
            ++n;
        }
        return fleetCreationSpec;
    }

    public void addPick(FleetMemberType fleetMemberType, String string, int n, int n2) {
        FleetMemberPick fleetMemberPick = new FleetMemberPick(fleetMemberType, string, n, n2);
        this.picks.add(fleetMemberPick);
    }

    public String getSpecId() {
        return this.specId;
    }

    public void setSpecId(String string) {
        this.specId = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public float getMaxFleetPoints() {
        return this.maxFleetPoints;
    }

    public void setMaxFleetPoints(float f2) {
        this.maxFleetPoints = f2;
    }

    public float getMinDaysWorthSupplies() {
        return this.minDaysWorthSupplies;
    }

    public void setMinDaysWorthSupplies(float f2) {
        this.minDaysWorthSupplies = f2;
    }

    public float getMaxDaysWorthSupplies() {
        return this.maxDaysWorthSupplies;
    }

    public void setMaxDaysWorthSupplies(float f2) {
        this.maxDaysWorthSupplies = f2;
    }

    public float getMinLYWorthOfFuel() {
        return this.minLYWorthOfFuel;
    }

    public void setMinLYWorthOfFuel(float f2) {
        this.minLYWorthOfFuel = f2;
    }

    public float getMaxLYWorthOfFuel() {
        return this.maxLYWorthOfFuel;
    }

    public void setMaxLYWorthOfFuel(float f2) {
        this.maxLYWorthOfFuel = f2;
    }

    public float getMinExtraCrewPercent() {
        return this.minExtraCrewPercent;
    }

    public void setMinExtraCrewPercent(float f2) {
        this.minExtraCrewPercent = f2;
    }

    public float getMaxExtraCrewPercent() {
        return this.maxExtraCrewPercent;
    }

    public void setMaxExtraCrewPercent(float f2) {
        this.maxExtraCrewPercent = f2;
    }

    public float getMinMarinesPercent() {
        return this.minMarinesPercent;
    }

    public void setMinMarinesPercent(float f2) {
        this.minMarinesPercent = f2;
    }

    public float getMaxMarinesPercent() {
        return this.maxMarinesPercent;
    }

    public void setMaxMarinesPercent(float f2) {
        this.maxMarinesPercent = f2;
    }

    public static CampaignFleet createFleetFromSpec(FleetCreationSpec fleetCreationSpec, Faction faction) {
        CampaignFleet campaignFleet = new CampaignFleet(faction);
        ModularFleetAI modularFleetAI = new ModularFleetAI(campaignFleet);
        modularFleetAI.setCreationSpec(fleetCreationSpec);
        campaignFleet.setAI(modularFleetAI);
        campaignFleet.setName(fleetCreationSpec.displayName);
        ArrayList<FleetMemberPick> arrayList = new ArrayList<FleetMemberPick>();
        for (FleetMemberPick object2 : fleetCreationSpec.picks) {
            arrayList.add(object2.clone());
        }
        for (FleetMemberPick fleetMemberPick : arrayList) {
            int n = 0;
            while (n < fleetMemberPick.min) {
                campaignFleet.addFleetMember(new FleetMember(0, fleetMemberPick.specId, fleetMemberPick.type));
                ++n;
            }
            fleetMemberPick.max -= fleetMemberPick.min;
            fleetMemberPick.min = 0;
        }
        do {
            FleetMemberPick fleetMemberPick = (FleetMemberPick)arrayList.get((int)((double)arrayList.size() * Math.random()));
            Iterator<FleetMember> iterator = new FleetMember(0, fleetMemberPick.specId, fleetMemberPick.type);
            if (fleetMemberPick.max > 0 && ((float)((FleetMember)((Object)iterator)).getFleetPointCost() + campaignFleet.getFleetData().getFleetPointsUsed() <= fleetCreationSpec.maxFleetPoints + 2.0f || campaignFleet.getMembers().isEmpty())) {
                campaignFleet.addFleetMember((FleetMemberAPI)iterator);
                --fleetMemberPick.max;
                if (fleetMemberPick.max != 0) continue;
                arrayList.remove(fleetMemberPick);
                continue;
            }
            arrayList.remove(fleetMemberPick);
        } while (!arrayList.isEmpty());
        campaignFleet.getFleetData().sort();
        for (FleetMember fleetMember : campaignFleet.getFleetData().getMembers()) {
            fleetMember.getCaptain().setPersonality(faction.getSpec().pickPersonality());
        }
        CargoData cargoData = campaignFleet.getCargo();
        float f2 = campaignFleet.getFleetData().getFuelPerLightYear();
        float f3 = f2 * (fleetCreationSpec.minLYWorthOfFuel + (fleetCreationSpec.maxLYWorthOfFuel - fleetCreationSpec.minLYWorthOfFuel) * (float)Math.random());
        if (f3 > cargoData.getMaxCapacity()) {
            f3 = cargoData.getMaxFuel();
        }
        cargoData.addFuel((int)f3);
        float f4 = campaignFleet.getFleetData().getMinCrew() + (cargoData.getMaxPersonnel() - campaignFleet.getFleetData().getMinCrew()) * 0.01f * (fleetCreationSpec.minExtraCrewPercent + (fleetCreationSpec.maxExtraCrewPercent - fleetCreationSpec.minExtraCrewPercent) * (float)Math.random());
        cargoData.addCrew((int)f4);
        float f5 = (cargoData.getMaxPersonnel() - campaignFleet.getFleetData().getMinCrew()) * 0.01f * (fleetCreationSpec.minMarinesPercent + (fleetCreationSpec.maxMarinesPercent - fleetCreationSpec.minMarinesPercent) * (float)Math.random());
        cargoData.addMarines((int)f5);
        float f6 = campaignFleet.getTotalSupplyCostPerDay();
        float f7 = f6 * (fleetCreationSpec.minDaysWorthSupplies + (fleetCreationSpec.maxDaysWorthSupplies - fleetCreationSpec.minDaysWorthSupplies) * (float)Math.random());
        if (f7 > cargoData.getMaxCapacity() * 0.75f) {
            f7 = cargoData.getMaxCapacity() * 0.75f;
        }
        f7 = Math.max(f7, 5.0f);
        cargoData.addSupplies((int)f7);
        float f8 = cargoData.getSpaceLeft();
        cargoData.addSupplies((float)((int)f8) * 0.5f);
        campaignFleet.getFleetData().setSyncNeeded();
        campaignFleet.getFleetData().syncIfNeeded();
        for (FleetMember fleetMember : campaignFleet.getMembers()) {
            float f9 = fleetMember.getRepairTracker().getMaxCR();
            fleetMember.getRepairTracker().setCR(f9);
        }
        return campaignFleet;
    }

    public static void main(String[] stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        arrayList.add(2);
        arrayList.add(3);
        arrayList.add(4);
        arrayList.add(5);
        arrayList.add(6);
        arrayList.add(7);
        arrayList.add(8);
        int n = 0;
        while (n < 100000000) {
            Integer n2 = (Integer)arrayList.get((int)((double)arrayList.size() * Math.random()));
            ++n;
        }
    }

    public static class FleetMemberPick
    implements DoNotObfuscate,
    Cloneable {
        public FleetMemberType type;
        public String specId;
        int min;
        int max;

        public FleetMemberPick(FleetMemberType fleetMemberType, String string, int n, int n2) {
            this.type = fleetMemberType;
            this.specId = string;
            this.min = n;
            this.max = n2;
        }

        protected FleetMemberPick clone() {
            try {
                return (FleetMemberPick)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

