/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading.specs;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.loading.specs.privatesuper;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactionProduction
implements DoNotObfuscate,
FactionProductionAPI,
Cloneable {
    private List<ItemInProduction> interrupted = new ArrayList<ItemInProduction>();
    private List<ItemInProduction> current = new ArrayList<ItemInProduction>();
    private FactionAPI faction;
    private MarketAPI gatheringPoint;
    private int accruedProduction = 0;
    private float costMult = 1.0f;

    public boolean sameAsCopy(FactionProduction factionProduction) {
        if (factionProduction == null) {
            return false;
        }
        if (this.current.isEmpty() && factionProduction.current.isEmpty()) {
            return true;
        }
        if (this.interrupted.size() != factionProduction.interrupted.size()) {
            return false;
        }
        if (this.current.size() != factionProduction.current.size()) {
            return false;
        }
        int n = 0;
        while (n < this.interrupted.size()) {
            if (!this.interrupted.get(n).equals(factionProduction.interrupted.get(n))) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < this.current.size()) {
            if (!this.current.get(n).equals(factionProduction.current.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void resetFromCopy(FactionProduction factionProduction) {
        this.interrupted.clear();
        this.current.clear();
        for (ItemInProduction itemInProduction : factionProduction.interrupted) {
            this.interrupted.add(itemInProduction.clone());
        }
        for (ItemInProduction itemInProduction : factionProduction.current) {
            this.current.add(itemInProduction.clone());
        }
    }

    public FactionProduction clone() {
        try {
            FactionProduction factionProduction = (FactionProduction)super.clone();
            factionProduction.interrupted = new ArrayList<ItemInProduction>();
            factionProduction.current = new ArrayList<ItemInProduction>();
            for (ItemInProduction itemInProduction : this.interrupted) {
                factionProduction.interrupted.add(itemInProduction.clone());
            }
            for (ItemInProduction itemInProduction : this.current) {
                factionProduction.current.add(itemInProduction.clone());
            }
            return factionProduction;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public FactionProduction(FactionAPI factionAPI) {
        this.faction = factionAPI;
    }

    Object readResolve() {
        return this;
    }

    public void advance(float f2) {
        Object object;
        if (f2 <= 0.0f) {
            return;
        }
        float f3 = Global.getSector().getClock().convertToDays(f2);
        Object object2 = this.current.iterator();
        while (object2.hasNext()) {
            Object object3 = object = object2.next();
            ((ItemInProduction)object3).buildDelay = ((ItemInProduction)object3).buildDelay - f3;
            if (!(((ItemInProduction)object).buildDelay < 0.0f)) continue;
            ((ItemInProduction)object).buildDelay = 0.0f;
        }
        object = this.interrupted.iterator();
        while (object.hasNext()) {
            Object object4 = object2 = (ItemInProduction)object.next();
            ((ItemInProduction)object4).timeInterrupted = ((ItemInProduction)object4).timeInterrupted + f3;
            if (!(((ItemInProduction)object2).timeInterrupted > 30.0f)) continue;
            object.remove();
        }
    }

    public int getMonthlyProductionCapacity() {
        float f2 = 0.0f;
        for (MarketAPI marketAPI : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!marketAPI.isPlayerOwned()) continue;
            f2 += this.getProductionCapacityForMarket(marketAPI);
        }
        f2 = Global.getSector().getPlayerStats().getDynamic().getMod("custom_production_mod").computeEffective(f2);
        f2 = Math.round(f2);
        return (int)f2;
    }

    public float getProductionCapacityForMarket(MarketAPI marketAPI) {
        float f2 = marketAPI.getCommodityData("ships").getMaxSupply();
        if ((f2 = Math.min(f2, (float)marketAPI.getCommodityData("ships").getAvailable())) <= 0.0f) {
            return 0.0f;
        }
        float f3 = f2;
        return (float)Math.round(f3 * 100.0f / 100.0f) * Global.getSettings().getFloat("productionCapacityPerSWUnit");
    }

    public int getTotalCurrentCost() {
        int n = 0;
        for (ItemInProduction itemInProduction : this.current) {
            if ((n += Math.round((float)(itemInProduction.getBaseCost() * itemInProduction.getQuantity()) * this.costMult)) <= 2000000000) continue;
            return n;
        }
        return n;
    }

    public int getUnitCost(FactionProductionAPI.ProductionItemType productionItemType, String string) {
        ItemInProduction itemInProduction = new ItemInProduction(productionItemType, string, 1);
        return Math.round((float)itemInProduction.getBaseCost() * this.costMult);
    }

    public boolean addItem(FactionProductionAPI.ProductionItemType productionItemType, String string) {
        return this.addItem(productionItemType, string, 1);
    }

    public FactionProductionAPI.ItemInProductionAPI createSampleItem(FactionProductionAPI.ProductionItemType productionItemType, String string, int n) {
        return new ItemInProduction(productionItemType, string, n);
    }

    public boolean addItem(FactionProductionAPI.ProductionItemType productionItemType, String string, int n) {
        return this.addItem(productionItemType, string, n, 0);
    }

    public boolean addItem(FactionProductionAPI.ProductionItemType productionItemType, String string, int n, int n2) {
        int n3;
        ItemInProduction itemInProduction = this.getCurrentItem(productionItemType, string);
        if (itemInProduction == null) {
            itemInProduction = this.getInterruptedItem(productionItemType, string);
            if (itemInProduction == null) {
                itemInProduction = new ItemInProduction(productionItemType, string, 0);
            } else {
                this.interrupted.remove(itemInProduction);
                itemInProduction.setQuantity(0);
            }
        }
        boolean bl = true;
        int n4 = itemInProduction.getMaxQuantity();
        if (n2 > 0) {
            n4 = n2;
        }
        if ((n3 = itemInProduction.getQuantity() + n) > n4) {
            n3 = n4;
            bl = false;
        }
        itemInProduction.setQuantity(n3);
        itemInProduction.timeInterrupted = 0.0f;
        if (!this.current.contains(itemInProduction)) {
            this.current.add(itemInProduction);
        }
        return bl;
    }

    protected ItemInProduction getCurrentItem(FactionProductionAPI.ProductionItemType productionItemType, String string) {
        for (ItemInProduction itemInProduction : this.current) {
            if (itemInProduction.type != productionItemType || !itemInProduction.specId.equals(string)) continue;
            return itemInProduction;
        }
        return null;
    }

    protected ItemInProduction getInterruptedItem(FactionProductionAPI.ProductionItemType productionItemType, String string) {
        for (ItemInProduction itemInProduction : this.interrupted) {
            if (itemInProduction.type != productionItemType || !itemInProduction.specId.equals(string)) continue;
            return itemInProduction;
        }
        return null;
    }

    public void clear() {
        for (FactionProductionAPI.ItemInProductionAPI itemInProductionAPI : new ArrayList<ItemInProduction>(this.current)) {
            this.removeItem(itemInProductionAPI.getType(), itemInProductionAPI.getSpecId(), itemInProductionAPI.getQuantity());
        }
    }

    public void removeItem(FactionProductionAPI.ProductionItemType productionItemType, String string, int n) {
        ItemInProduction itemInProduction = this.getCurrentItem(productionItemType, string);
        if (itemInProduction != null) {
            itemInProduction.setQuantity(Math.max(0, itemInProduction.getQuantity() - n));
            if (itemInProduction.getQuantity() <= 0) {
                this.current.remove(itemInProduction);
                if (itemInProduction.getBaseBuildDelay() > 0.0f) {
                    ItemInProduction itemInProduction2 = this.getInterruptedItem(productionItemType, string);
                    if (itemInProduction2 == null) {
                        this.interrupted.add(itemInProduction);
                    } else {
                        itemInProduction2.setBuildDelay(Math.min(itemInProduction2.getBuildDelay(), itemInProduction.getBuildDelay()));
                    }
                }
            }
        }
    }

    public int getCount(FactionProductionAPI.ProductionItemType productionItemType, String string) {
        ItemInProduction itemInProduction = this.getCurrentItem(productionItemType, string);
        if (itemInProduction != null) {
            return itemInProduction.getQuantity();
        }
        return 0;
    }

    public List<FactionProductionAPI.ItemInProductionAPI> getInterrupted() {
        return new ArrayList<FactionProductionAPI.ItemInProductionAPI>(this.interrupted);
    }

    public List<FactionProductionAPI.ItemInProductionAPI> getCurrent() {
        return new ArrayList<FactionProductionAPI.ItemInProductionAPI>(this.current);
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public MarketAPI getGatheringPoint() {
        if (this.gatheringPoint == null || !this.gatheringPoint.isInEconomy()) {
            float f2 = 0.0f;
            MarketAPI marketAPI = null;
            for (MarketAPI marketAPI2 : Global.getSector().getEconomy().getMarketsCopy()) {
                float f3;
                if (!marketAPI2.isPlayerOwned() || !((f3 = marketAPI2.getDaysInExistence()) > f2) && marketAPI != null) continue;
                f2 = f3;
                marketAPI = marketAPI2;
            }
            this.gatheringPoint = marketAPI;
            return marketAPI;
        }
        return this.gatheringPoint;
    }

    public void setGatheringPoint(MarketAPI marketAPI) {
        this.gatheringPoint = marketAPI;
    }

    public int getAccruedProduction() {
        return this.accruedProduction;
    }

    public void setAccruedProduction(int n) {
        this.accruedProduction = n;
    }

    public float getCostMult() {
        return this.costMult;
    }

    public void setCostMult(float f2) {
        this.costMult = f2;
    }

    public static class ItemInProduction
    implements DoNotObfuscate,
    FactionProductionAPI.ItemInProductionAPI,
    Cloneable {
        private FactionProductionAPI.ProductionItemType type;
        private String specId;
        private float buildDelay = 0.0f;
        private float timeInterrupted = 0.0f;
        private int quantity = 0;

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + Float.floatToIntBits(this.buildDelay);
            n2 = 31 * n2 + this.quantity;
            n2 = 31 * n2 + (this.specId == null ? 0 : this.specId.hashCode());
            n2 = 31 * n2 + Float.floatToIntBits(this.timeInterrupted);
            n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ItemInProduction itemInProduction = (ItemInProduction)object;
            if (this.quantity != itemInProduction.quantity) {
                return false;
            }
            if (this.specId == null ? itemInProduction.specId != null : !this.specId.equals(itemInProduction.specId)) {
                return false;
            }
            return !(this.type == null ? itemInProduction.type != null : !this.type.equals((Object)itemInProduction.type));
        }

        public ItemInProduction clone() {
            try {
                return (ItemInProduction)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public ItemInProduction(FactionProductionAPI.ProductionItemType productionItemType, String string, int n) {
            this.type = productionItemType;
            this.specId = string;
            this.buildDelay = this.getBaseBuildDelay();
            this.quantity = n;
        }

        public FighterWingSpecAPI getWingSpec() {
            if (this.type == FactionProductionAPI.ProductionItemType.FIGHTER) {
                return SpecStore.o00000(FighterWingSpec.class, this.specId);
            }
            return null;
        }

        public WeaponSpecAPI getWeaponSpec() {
            if (this.type == FactionProductionAPI.ProductionItemType.WEAPON) {
                return SpecStore.o00000(BaseWeaponSpec.class, this.specId);
            }
            return null;
        }

        public ShipHullSpecAPI getShipSpec() {
            if (this.type == FactionProductionAPI.ProductionItemType.SHIP) {
                return SpecStore.o00000(privatesuper.class, this.specId);
            }
            return null;
        }

        public float getBaseBuildDelay() {
            return 0.0f;
        }

        public int getMaxQuantity() {
            return 100;
        }

        public int getBaseCost() {
            float f2 = Global.getSettings().getFloat("productionCostMult");
            int n = Global.getSettings().getInt("shipProductionCostBase");
            switch (this.type) {
                case FIGHTER: {
                    FighterWingSpecAPI fighterWingSpecAPI = this.getWingSpec();
                    return (int)(fighterWingSpecAPI.getBaseValue() * f2);
                }
                case SHIP: {
                    ShipHullSpecAPI shipHullSpecAPI = this.getShipSpec();
                    float f3 = shipHullSpecAPI.getBaseValue();
                    if (f3 >= 20000.0f) {
                        n = 0;
                    }
                    return (int)(f3 * f2) + n;
                }
                case WEAPON: {
                    WeaponSpecAPI weaponSpecAPI = this.getWeaponSpec();
                    return (int)(weaponSpecAPI.getBaseValue() * f2);
                }
            }
            return 0;
        }

        public FactionProductionAPI.ProductionItemType getType() {
            return this.type;
        }

        public void setType(FactionProductionAPI.ProductionItemType productionItemType) {
            this.type = productionItemType;
        }

        public String getSpecId() {
            return this.specId;
        }

        public void setSpecId(String string) {
            this.specId = string;
        }

        public float getBuildDelay() {
            return this.buildDelay;
        }

        public void setBuildDelay(float f2) {
            this.buildDelay = f2;
        }

        public float getTimeInterrupted() {
            return this.timeInterrupted;
        }

        public void setTimeInterrupted(float f2) {
            this.timeInterrupted = f2;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public void setQuantity(int n) {
            this.quantity = n;
        }
    }
}

