/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading.specs;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.listeners.CombatListenerUtil;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.FormationType;
import com.fs.starfarer.api.loading.WingRole;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FighterWingSpec
implements DoNotObfuscate,
FighterWingSpecAPI {
    private int numFighters;
    private FormationType formation;
    private WingRole role;
    private String roleDesc;
    private String variantId;
    private String id;
    private float refitTime;
    private int fleetPoints;
    private float baseValue;
    private float range;
    private float attackRunRange;
    private float attackPositionOffset;
    private float rarity = 1.0f;
    private float opCost;
    private Set<String> tags = new LinkedHashSet<String>();
    private int tier;
    private String autofitCategory = null;
    private List<String> autofitPriorityCategories = null;

    public float getRarity() {
        return this.rarity;
    }

    public void setRarity(float f2) {
        this.rarity = f2;
    }

    public String getRoleDesc() {
        return this.roleDesc;
    }

    public void setRoleDesc(String string) {
        this.roleDesc = string;
    }

    public float getOpCost(MutableShipStatsAPI mutableShipStatsAPI) {
        float f2 = this.opCost;
        if (mutableShipStatsAPI != null) {
            mutableShipStatsAPI.getDynamic().getValue("all_fighter_cost_mod", f2);
            if (this.isBomber()) {
                f2 = mutableShipStatsAPI.getDynamic().getValue("bomber_cost_mod", f2);
            } else if (this.isRegularFighter()) {
                f2 = mutableShipStatsAPI.getDynamic().getValue("fighter_cost_mod", f2);
            } else if (this.isInterceptor()) {
                f2 = mutableShipStatsAPI.getDynamic().getValue("interceptor_cost_mod", f2);
            } else if (this.isSupport()) {
                f2 = mutableShipStatsAPI.getDynamic().getValue("support_cost_mod", f2);
            }
            f2 = CombatListenerUtil.getFighterOPCost((MutableShipStatsAPI)mutableShipStatsAPI, (FighterWingSpecAPI)this, (int)Math.round(f2));
        }
        if ((f2 = (float)Math.round(f2)) < 0.0f) {
            f2 = 0.0f;
        }
        return f2;
    }

    public void setOpCost(float f2) {
        this.opCost = f2;
    }

    public boolean isBomber() {
        return this.role == WingRole.BOMBER;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float f2) {
        this.range = f2;
    }

    public float getAttackRunRange() {
        return this.attackRunRange;
    }

    public void setAttackRunRange(float f2) {
        this.attackRunRange = f2;
    }

    public float getAttackPositionOffset() {
        return this.attackPositionOffset;
    }

    public void setAttackPositionOffset(float f2) {
        this.attackPositionOffset = f2;
    }

    public boolean isAssault() {
        return this.role == WingRole.ASSAULT;
    }

    public boolean isSupport() {
        return this.role == WingRole.SUPPORT;
    }

    public boolean isInterceptor() {
        return this.role == WingRole.INTERCEPTOR;
    }

    public boolean isAlwaysEscort() {
        return this.range <= 0.0f;
    }

    public boolean isRegularFighter() {
        return this.role == WingRole.FIGHTER;
    }

    public WingRole getRole() {
        return this.role;
    }

    public void setRole(WingRole wingRole) {
        this.role = wingRole;
    }

    public FormationType getFormation() {
        return this.formation;
    }

    public void setFormation(FormationType formationType) {
        this.formation = formationType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public int getNumFighters() {
        return this.numFighters;
    }

    public void setNumFighters(int n) {
        this.numFighters = n;
    }

    public String getVariantId() {
        return this.variantId;
    }

    public HullVariantSpec getVariant() {
        return SpecStore.o00000(HullVariantSpec.class, this.variantId);
    }

    public String getWingName() {
        return String.valueOf(this.getVariant().getHullSpec().getHullName()) + " \u8054\u961f";
    }

    public void setVariantId(String string) {
        this.variantId = string;
    }

    public float getRefitTime() {
        return this.refitTime;
    }

    public void setRefitTime(float f2) {
        this.refitTime = f2;
    }

    public int getFleetPoints() {
        return this.fleetPoints;
    }

    public void setFleetPoints(int n) {
        this.fleetPoints = n;
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(float f2) {
        this.baseValue = f2;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String string) {
        this.autofitPriorityCategories = null;
        this.tags.add(string);
    }

    public boolean hasTag(String string) {
        return this.tags.contains(string);
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int n) {
        this.tier = n;
    }

    public String getAutofitCategory() {
        if (this.autofitCategory == null) {
            int n = -1;
            for (String string : this.getTags()) {
                int n2 = this.getLevel(string);
                if (n2 <= n) continue;
                n = n2;
                this.autofitCategory = this.getCategory(string);
            }
            if (n < 0) {
                this.autofitCategory = "";
            }
        }
        return this.autofitCategory;
    }

    public String getCategory(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (!Character.isDigit(c2)) {
                string2 = String.valueOf(string2) + c2;
            }
            ++n;
        }
        return string2;
    }

    public int getLevel(String string) {
        try {
            String string2 = "";
            int n = string.length() - 1;
            while (n >= 0) {
                char c2 = string.charAt(n);
                if (Character.isDigit(c2)) {
                    string2 = String.valueOf(c2) + string2;
                }
                --n;
            }
            if (!string2.isEmpty()) {
                n = Integer.parseInt(string2);
                return n;
            }
        }
        finally {
            return -1;
        }
    }

    public void resetAutofitPriorityCategories() {
        this.autofitPriorityCategories = null;
    }

    public List<String> getAutofitCategoriesInPriorityOrder() {
        if (this.autofitPriorityCategories != null) {
            return this.autofitPriorityCategories;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.tags) {
            float f2 = this.getLevel(string);
            if (f2 < 0.0f) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList, new Comparator<String>(){

            public int o00000(String string, String string2) {
                return (int)Math.signum(FighterWingSpec.this.getLevel(string2) - FighterWingSpec.this.getLevel(string));
            }
        });
        this.autofitPriorityCategories = arrayList;
        return this.autofitPriorityCategories;
    }
}

