/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics;

import com.fs.graphics.G;
import com.fs.graphics.Object;
import com.fs.graphics.util.OoOO;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class Sprite
implements Cloneable,
DoNotObfuscate {
    protected transient Object texture;
    protected float width;
    protected float height;
    protected float texX = 0.0f;
    protected float texY = 0.0f;
    protected float texWidth;
    protected float texHeight;
    protected float angle;
    protected Color color = new Color(255, 255, 255);
    private float alphaMult = 1.0f;
    private Color colorUL = new Color(255, 255, 255);
    private Color colorUR = new Color(255, 255, 255);
    private Color colorLL = new Color(255, 255, 255);
    private Color colorLR = new Color(255, 255, 255);
    private float centerX = -1.0f;
    private float centerY = -1.0f;
    private int offsetX = 0;
    private int offsetY = 0;
    private int blendSrc = 770;
    private int blendDest = 771;
    private boolean texClamp = false;
    private String textureId;

    public Sprite() {
        this.setTexture(null);
    }

    public Sprite(String string) {
        this.setTexture(G.\u00d200000(string));
    }

    public Sprite(Object object) {
        this.setTexture(object);
    }

    public Sprite(Object object, Color color) {
        this.setTexture(object);
        this.setColor(color);
    }

    public Color getAverageColor() {
        if (this.texture == null) {
            return Color.white;
        }
        return this.texture.float();
    }

    public void setBlendFunc(int n, int n2) {
        this.blendSrc = n;
        this.blendDest = n2;
    }

    public void setNormalBlend() {
        this.setBlendFunc(770, 771);
    }

    public void setAdditiveBlend() {
        this.setBlendFunc(770, 1);
    }

    public void setOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    public void setCenter(float f, float f2) {
        this.centerX = f;
        this.centerY = f2;
    }

    public void setCenterX(float f) {
        this.centerX = f;
    }

    public void setCenterY(float f) {
        this.centerY = f;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
    }

    public int getImageWidth() {
        return this.texture.\u00d300000();
    }

    public int getImageHeight() {
        return this.texture.\u00d400000();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public Object getTexture() {
        return this.texture;
    }

    public Sprite clone() {
        Sprite sprite = null;
        try {
            sprite = (Sprite)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        sprite.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        return sprite;
    }

    public void setTexClamp(boolean bl) {
        this.texClamp = bl;
    }

    public void renderAtCenter(float f, float f2) {
        this.render(f - this.width / 2.0f, f2 - this.height / 2.0f);
    }

    public void render(float f, float f2) {
        if (this.texture != null) {
            this.texture.\u00d800000();
            if (this.texClamp) {
                OoOO.void();
            }
        } else {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * this.alphaMult)));
        GL11.glTranslatef((float)(f + (float)this.offsetX), (float)(f2 + (float)this.offsetY), (float)0.0f);
        if (this.centerX != -1.0f && this.centerY != -1.0f) {
            GL11.glTranslatef((float)(this.width / 2.0f), (float)(this.height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.centerX), (float)(-this.centerY), (float)0.0f);
        } else {
            GL11.glTranslatef((float)(this.width / 2.0f), (float)(this.height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width / 2.0f), (float)(-this.height / 2.0f), (float)0.0f);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)this.blendSrc, (int)this.blendDest);
        float f3 = 0.001f;
        f3 = 0.0f;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)(this.texX + f3), (float)(this.texY + f3));
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)(this.texX + f3), (float)(this.texY + this.texHeight - f3));
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glTexCoord2f((float)(this.texX + this.texWidth - f3), (float)(this.texY + this.texHeight - f3));
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glTexCoord2f((float)(this.texX + this.texWidth - f3), (float)(this.texY + f3));
        GL11.glVertex2f((float)this.width, (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        if (this.texClamp) {
            OoOO.\u00d200000();
        }
    }

    public void renderWithCorners(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.texture == null) {
            return;
        }
        this.texture.\u00d800000();
        GL11.glPushMatrix();
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * this.alphaMult)));
        GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)0.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)this.blendSrc, (int)this.blendDest);
        float f9 = 0.001f;
        f9 = 0.0f;
        GL11.glBegin((int)6);
        float f10 = (f + f3 + f5 + f7) / 4.0f;
        float f11 = (f2 + f4 + f6 + f8) / 4.0f;
        float f12 = this.texX + this.texWidth / 2.0f;
        float f13 = this.texY + this.texHeight / 2.0f;
        GL11.glTexCoord2f((float)f12, (float)f13);
        GL11.glVertex2f((float)f10, (float)f11);
        GL11.glTexCoord2f((float)(this.texX + f9), (float)(this.texY + f9));
        GL11.glVertex2f((float)f, (float)f2);
        GL11.glTexCoord2f((float)(this.texX + f9), (float)(this.texY + this.texHeight - f9));
        GL11.glVertex2f((float)f3, (float)f4);
        GL11.glTexCoord2f((float)(this.texX + this.texWidth - f9), (float)(this.texY + this.texHeight - f9));
        GL11.glVertex2f((float)f5, (float)f6);
        GL11.glTexCoord2f((float)(this.texX + this.texWidth - f9), (float)(this.texY + f9));
        GL11.glVertex2f((float)f7, (float)f8);
        GL11.glTexCoord2f((float)(this.texX + f9), (float)(this.texY + f9));
        GL11.glVertex2f((float)f, (float)f2);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void setTexX(float f) {
        this.texX = f;
    }

    public void setTexY(float f) {
        this.texY = f;
    }

    public float getTexWidth() {
        return this.texWidth;
    }

    public float getTexHeight() {
        return this.texHeight;
    }

    public void setTexWidth(float f) {
        this.texWidth = f;
    }

    public void setTexHeight(float f) {
        this.texHeight = f;
    }

    public void renderNoBlendOrRotate(float f, float f2) {
        this.renderNoBlendOrRotate(f, f2, true);
    }

    public void renderNoBlendOrRotate(float f, float f2, boolean bl) {
        if (this.texture == null) {
            return;
        }
        this.texture.\u00d800000();
        GL11.glPushMatrix();
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * this.alphaMult)));
        GL11.glTranslatef((float)(f + (float)this.offsetX), (float)(f2 + (float)this.offsetY), (float)0.0f);
        GL11.glEnable((int)3553);
        if (bl) {
            GL11.glDisable((int)3042);
        }
        float f3 = 0.001f;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)(0.0f + f3), (float)(0.0f + f3));
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)(0.0f + f3), (float)(this.texHeight - f3));
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glTexCoord2f((float)(this.texWidth - f3), (float)(this.texHeight - f3));
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glTexCoord2f((float)(this.texWidth - f3), (float)(0.0f + f3));
        GL11.glVertex2f((float)this.width, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void renderAtCenterWithCornerColors(float f, float f2) {
        f -= this.width / 2.0f;
        f2 -= this.height / 2.0f;
        if (this.texture == null) {
            return;
        }
        this.texture.\u00d800000();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(f + (float)this.offsetX), (float)(f2 + (float)this.offsetY), (float)0.0f);
        if (this.centerX != -1.0f && this.centerY != -1.0f) {
            GL11.glTranslatef((float)(this.width / 2.0f), (float)(this.height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.centerX), (float)(-this.centerY), (float)0.0f);
        } else {
            GL11.glTranslatef((float)(this.width / 2.0f), (float)(this.height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width / 2.0f), (float)(-this.height / 2.0f), (float)0.0f);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)this.blendSrc, (int)this.blendDest);
        float f3 = 0.001f;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)(0.0f + f3), (float)(0.0f + f3));
        OoOO.\u00d200000(this.colorLL);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)(0.0f + f3), (float)(this.texHeight - f3));
        OoOO.\u00d200000(this.colorUL);
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glTexCoord2f((float)(this.texWidth - f3), (float)(this.texHeight - f3));
        OoOO.\u00d200000(this.colorUR);
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glTexCoord2f((float)(this.texWidth - f3), (float)(0.0f + f3));
        OoOO.\u00d200000(this.colorLR);
        GL11.glVertex2f((float)this.width, (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void renderRegionAtCenter(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        this.renderRegion(f - this.width / 2.0f, f2 - this.height / 2.0f, f3, f4, f5, f6, bl);
    }

    public void renderRegionAtCenter(float f, float f2, float f3, float f4, float f5, float f6) {
        this.renderRegion(f - this.width / 2.0f, f2 - this.height / 2.0f, f3, f4, f5, f6);
    }

    public void renderRegion(float f, float f2, float f3, float f4, float f5, float f6) {
        this.renderRegion(f, f2, f3, f4, f5, f6, true);
    }

    public void renderRegion(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (this.texture != null) {
            if (bl) {
                this.texture.\u00d800000();
            }
        } else {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * this.alphaMult)));
        GL11.glTranslatef((float)(f + (float)this.offsetX), (float)(f2 + (float)this.offsetY), (float)0.0f);
        if (this.centerX != -1.0f && this.centerY != -1.0f) {
            GL11.glTranslatef((float)(this.width / 2.0f), (float)(this.height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.centerX), (float)(-this.centerY), (float)0.0f);
        } else {
            GL11.glTranslatef((float)(this.width / 2.0f), (float)(this.height / 2.0f), (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width / 2.0f), (float)(-this.height / 2.0f), (float)0.0f);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)this.blendSrc, (int)this.blendDest);
        float f7 = 0.001f;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)(f3 * this.texWidth + f7), (float)(f4 * this.texHeight + f7));
        GL11.glVertex2f((float)(f3 * this.width), (float)(f4 * this.height));
        GL11.glTexCoord2f((float)(f3 * this.texWidth + f7), (float)((f4 + f6) * this.texHeight - f7));
        GL11.glVertex2f((float)(f3 * this.width), (float)((f4 + f6) * this.height));
        GL11.glTexCoord2f((float)((f3 + f5) * this.texWidth - f7), (float)((f4 + f6) * this.texHeight - f7));
        GL11.glVertex2f((float)((f3 + f5) * this.width), (float)((f4 + f6) * this.height));
        GL11.glTexCoord2f((float)((f3 + f5) * this.texWidth - f7), (float)(f4 * this.texHeight + f7));
        GL11.glVertex2f((float)((f3 + f5) * this.width), (float)(f4 * this.height));
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public Color getColorLL() {
        return this.colorLL;
    }

    public void setColorLL(Color color) {
        this.colorLL = color;
    }

    public Color getColorLR() {
        return this.colorLR;
    }

    public void setColorLR(Color color) {
        this.colorLR = color;
    }

    public Color getColorUL() {
        return this.colorUL;
    }

    public void setColorUL(Color color) {
        this.colorUL = color;
    }

    public Color getColorUR() {
        return this.colorUR;
    }

    public void setColorUR(Color color) {
        this.colorUR = color;
    }

    public void setTexture(Object object) {
        this.texture = object;
        if (object != null) {
            this.width = object.\u00d300000();
            this.height = object.\u00d400000();
            this.texWidth = object.while();
            this.texHeight = object.o00000();
            this.textureId = object.oO0000();
        } else {
            this.textureId = null;
        }
    }

    java.lang.Object readResolve() {
        if (this.textureId != null) {
            this.texture = G.\u00d200000(this.textureId);
        }
        return this;
    }

    public int getBlendDest() {
        return this.blendDest;
    }

    public int getBlendSrc() {
        return this.blendSrc;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public float getAlphaMult() {
        return this.alphaMult;
    }

    public void setAlphaMult(float f) {
        this.alphaMult = f;
    }
}

