/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.FactionSpecAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.rules.HasMemory;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.RelationshipAPI;
import com.fs.starfarer.api.fleet.ShipFilter;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FactionAPI
extends HasMemory {
    public void adjustRelationship(String var1, float var2);

    public boolean adjustRelationship(String var1, float var2, RepLevel var3);

    public void setRelationship(String var1, float var2);

    public void setRelationship(String var1, RepLevel var2);

    public boolean ensureAtBest(String var1, RepLevel var2);

    public boolean ensureAtWorst(String var1, RepLevel var2);

    public RepLevel getRelationshipLevel(FactionAPI var1);

    public RepLevel getRelationshipLevel(String var1);

    public boolean isAtWorst(String var1, RepLevel var2);

    public boolean isAtWorst(FactionAPI var1, RepLevel var2);

    public boolean isAtBest(String var1, RepLevel var2);

    public boolean isAtBest(FactionAPI var1, RepLevel var2);

    public boolean isHostileTo(FactionAPI var1);

    public boolean isHostileTo(String var1);

    public float getRelationship(String var1);

    public String getId();

    public String getDisplayName();

    public String getDisplayNameWithArticle();

    public Color getColor();

    public Color getBaseUIColor();

    public Color getGridUIColor();

    public Color getDarkUIColor();

    public Color getSecondaryUIColor();

    public Color getBrightUIColor();

    public boolean isNeutralFaction();

    public boolean isPlayerFaction();

    public List<String> getStockFleetIds();

    @Override
    public MemoryAPI getMemory();

    public float pickShipAndAddToFleet(String var1, ShipPickParams var2, CampaignFleetAPI var3);

    public String getFleetTypeName(String var1);

    public String getDisplayNameLong();

    public String getDisplayNameLongWithArticle();

    public String getEntityNamePrefix();

    public Color getRelColor(String var1);

    public Set<String> getIllegalCommodities();

    public boolean isIllegal(String var1);

    public boolean isIllegal(CargoStackAPI var1);

    public List<ShipRolePick> pickShip(String var1, ShipPickParams var2);

    public List<ShipRolePick> pickShip(String var1, ShipPickParams var2, ShipFilter var3, Random var4);

    public void makeCommodityIllegal(String var1);

    public void makeCommodityLegal(String var1);

    public float getTariffFraction();

    public float getTollFraction();

    public float getFineFraction();

    public String getInternalCommsChannel();

    public PersonAPI createRandomPerson();

    public PersonAPI createRandomPerson(FullName.Gender var1);

    public String getLogo();

    public JSONObject getCustom();

    @Override
    public MemoryAPI getMemoryWithoutUpdate();

    public Color getRelColor(RepLevel var1);

    public RelationshipAPI getRelToPlayer();

    public String getRank(String var1);

    public String getPost(String var1);

    public String getDisplayNameIsOrAre();

    public String pickPersonality();

    public boolean getCustomBoolean(String var1);

    public String getCustomString(String var1);

    public boolean isShowInIntelTab();

    public void setShowInIntelTab(boolean var1);

    public String getCrest();

    public String getPersonNamePrefix();

    public String getPersonNamePrefixAOrAn();

    public String pickRandomShipName();

    public float pickShipAndAddToFleet(String var1, ShipPickParams var2, CampaignFleetAPI var3, Random var4);

    public Set<String> getVariantsForRole(String var1);

    public PersonAPI createRandomPerson(FullName.Gender var1, Random var2);

    public PersonAPI createRandomPerson(Random var1);

    public float getCustomFloat(String var1);

    public int getSecondarySegments();

    public String getDisplayNameOverride();

    public void setDisplayNameOverride(String var1);

    public String getDisplayNameWithArticleOverride();

    public void setDisplayNameWithArticleOverride(String var1);

    public String getDisplayIsOrAreOverride();

    public void setDisplayIsOrAreOverride(String var1);

    public String getShipNamePrefixOverride();

    public void setShipNamePrefixOverride(String var1);

    public String getPersonNamePrefixAOrAnOverride();

    public void setPersonNamePrefixAOrAnOverride(String var1);

    public String getFactionLogoOverride();

    public void setFactionLogoOverride(String var1);

    public String getFactionCrestOverride();

    public void setFactionCrestOverride(String var1);

    public WeightedRandomPicker<String> getPortraits(FullName.Gender var1);

    public Set<String> getKnownShips();

    public void addKnownShip(String var1, boolean var2);

    public void removeKnownShip(String var1);

    public Set<String> getKnownWeapons();

    public void addKnownWeapon(String var1, boolean var2);

    public void removeKnownWeapon(String var1);

    public Set<String> getKnownFighters();

    public void addKnownFighter(String var1, boolean var2);

    public void removeKnownFighter(String var1);

    public Set<String> getKnownIndustries();

    public void addKnownIndustry(String var1);

    public void removeKnownIndustry(String var1);

    public boolean knowsShip(String var1);

    public boolean knowsWeapon(String var1);

    public boolean knowsFighter(String var1);

    public boolean knowsIndustry(String var1);

    public Set<String> getPriorityShips();

    public void addPriorityShip(String var1);

    public void removePriorityShip(String var1);

    public boolean isShipPriority(String var1);

    public Set<String> getPriorityWeapons();

    public void addPriorityWeapon(String var1);

    public void removePriorityWeapon(String var1);

    public boolean isWeaponPriority(String var1);

    public Set<String> getPriorityFighters();

    public void addPriorityFighter(String var1);

    public void removePriorityFighter(String var1);

    public boolean isFighterPriority(String var1);

    public boolean isAutoEnableKnownWeapons();

    public void setAutoEnableKnownWeapons(boolean var1);

    public boolean isAutoEnableKnownShips();

    public void setAutoEnableKnownShips(boolean var1);

    public boolean isAutoEnableKnownFighters();

    public void setAutoEnableKnownFighters(boolean var1);

    public boolean isAutoEnableKnownHullmods();

    public void setAutoEnableKnownHullmods(boolean var1);

    public void addKnownHullMod(String var1);

    public void removeKnownHullMod(String var1);

    public boolean knowsHullMod(String var1);

    public Set<String> getKnownHullMods();

    public void addPriorityHullMod(String var1);

    public void removePriorityHullMod(String var1);

    public boolean isHullModPriority(String var1);

    public Set<String> getPriorityHullMods();

    public FactionDoctrineAPI getDoctrine();

    public Map<String, Float> getVariantOverrides();

    public LinkedHashSet<String> getOverriddenHulls();

    public Map<String, Float> getHullFrequency();

    public Set<String> getAlwaysKnownShips();

    public void addUseWhenImportingShip(String var1);

    public void removeUseWhenImportingShip(String var1);

    public boolean useWhenImportingShip(String var1);

    public void clearShipRoleCache();

    public WeightedRandomPicker<String> getPersonalityPicker();

    public FactionProductionAPI getProduction();

    public Map<String, Long> getWeaponTimestamps();

    public Map<String, Long> getFighterTimestamps();

    public Map<String, Long> getShipTimestamps();

    public void setShipTimestampToNow(String var1);

    public void setWeaponTimestampToNow(String var1);

    public void setFighterTimestampToNow(String var1);

    public boolean isShipKnownAt(String var1, Long var2);

    public boolean isWeaponKnownAt(String var1, Long var2);

    public boolean isFighterKnownAt(String var1, Long var2);

    public int getNumAvailableForRole(String var1, ShipPickMode var2);

    public String getDisplayNameHasOrHave();

    public String getDisplayNameWithArticleWithoutArticle();

    public String pickRandomShipName(Random var1);

    public float getApproximateMaxFPPerFleet(ShipPickMode var1);

    public Map<String, String> getMusicMap();

    public String getBarSound();

    public int getRepInt(String var1);

    public String pickVoice(PersonImportance var1, Random var2);

    public String getShipNamePrefix();

    public Map<String, Float> getWeaponSellFrequency();

    public Map<String, Float> getFighterSellFrequency();

    public Map<String, Float> getHullmodSellFrequency();

    public FactionSpecAPI getFactionSpec();

    public void initSpecIfNeeded();

    public JSONObject getCustomJSONObject(String var1);

    public float getVariantWeightForRole(String var1, ShipPickMode var2);

    public Color getSecondaryColorOverride();

    public void setSecondaryColorOverride(Color var1);

    public int getSecondaryColorSegmentsOverride();

    public void setSecondaryColorSegmentsOverride(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShipPickMode {
        IMPORTED,
        ALL,
        PRIORITY_THEN_ALL,
        PRIORITY_ONLY;

    }

    public static class ShipPickParams
    implements Cloneable {
        public ShipPickMode mode;
        public int maxFP = 1000;
        public Long timestamp = null;
        public Boolean blockFallback = null;

        public ShipPickParams(ShipPickMode mode, int maxFP, Long timestamp, Boolean blockFallback) {
            this.mode = mode;
            this.maxFP = maxFP;
            this.timestamp = timestamp;
            this.blockFallback = blockFallback;
        }

        public ShipPickParams(ShipPickMode mode, int maxFP, Long timestamp) {
            this.mode = mode;
            this.maxFP = maxFP;
            this.timestamp = timestamp;
        }

        public ShipPickParams(ShipPickMode mode, int maxFP) {
            this(mode, maxFP, null);
        }

        public ShipPickParams(ShipPickMode mode) {
            this(mode, 1000);
        }

        public ShipPickParams() {
            this(ShipPickMode.PRIORITY_THEN_ALL, 1000);
        }

        public ShipPickParams clone() {
            try {
                return (ShipPickParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public static ShipPickParams all() {
            return new ShipPickParams(ShipPickMode.ALL);
        }

        public static ShipPickParams priority() {
            return new ShipPickParams(ShipPickMode.PRIORITY_THEN_ALL);
        }

        public static ShipPickParams imported() {
            return new ShipPickParams(ShipPickMode.IMPORTED);
        }
    }
}

