/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RepLevel {
    VENGEFUL("\u4ec7\u6068", RepLevel.getT4(), 1.0f),
    HOSTILE("\u654c\u5bf9", RepLevel.getT3(), RepLevel.getT4()),
    INHOSPITABLE("\u51b7\u6de1", RepLevel.getT2(), RepLevel.getT3()),
    SUSPICIOUS("\u6000\u7591", RepLevel.getT1(), RepLevel.getT2()),
    NEUTRAL("\u4e2d\u7acb", 0.0f, RepLevel.getT1()),
    FAVORABLE("\u826f\u597d", RepLevel.getT1(), RepLevel.getT2()),
    WELCOMING("\u6b22\u8fce", RepLevel.getT2(), RepLevel.getT3()),
    FRIENDLY("\u53cb\u597d", RepLevel.getT3(), RepLevel.getT4()),
    COOPERATIVE("\u5408\u4f5c", RepLevel.getT4(), 1.0f);

    private final String displayName;
    private final float max;
    private final float min;
    private static final float T1 = 0.09f;
    private static final float T2 = 0.24f;
    private static final float T3 = 0.49f;
    private static final float T4 = 0.74f;

    private RepLevel(String displayName, float min, float max) {
        this.displayName = displayName;
        this.min = min;
        this.max = max;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public RepLevel getOneBetter() {
        if (this == VENGEFUL) {
            return HOSTILE;
        }
        if (this == HOSTILE) {
            return INHOSPITABLE;
        }
        if (this == INHOSPITABLE) {
            return SUSPICIOUS;
        }
        if (this == SUSPICIOUS) {
            return NEUTRAL;
        }
        if (this == NEUTRAL) {
            return FAVORABLE;
        }
        if (this == FAVORABLE) {
            return WELCOMING;
        }
        if (this == WELCOMING) {
            return FRIENDLY;
        }
        if (this == FRIENDLY) {
            return COOPERATIVE;
        }
        return COOPERATIVE;
    }

    public RepLevel getOneWorse() {
        if (this == HOSTILE) {
            return VENGEFUL;
        }
        if (this == INHOSPITABLE) {
            return HOSTILE;
        }
        if (this == SUSPICIOUS) {
            return INHOSPITABLE;
        }
        if (this == NEUTRAL) {
            return SUSPICIOUS;
        }
        if (this == FAVORABLE) {
            return NEUTRAL;
        }
        if (this == WELCOMING) {
            return FAVORABLE;
        }
        if (this == FRIENDLY) {
            return WELCOMING;
        }
        if (this == COOPERATIVE) {
            return FRIENDLY;
        }
        return VENGEFUL;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public boolean isAtWorst(RepLevel level) {
        return this.ordinal() >= level.ordinal();
    }

    public boolean isAtBest(RepLevel level) {
        return this.ordinal() <= level.ordinal();
    }

    public boolean isNeutral() {
        return this == NEUTRAL;
    }

    public boolean isPositive() {
        return this.isAtWorst(FAVORABLE);
    }

    public boolean isNegative() {
        return this.isAtBest(SUSPICIOUS);
    }

    public static RepLevel getLevelFor(float r) {
        if (r >= 0.0f) {
            int rel = RepLevel.getRepInt(r);
            if (rel <= RepLevel.getRepInt(0.09f)) {
                return NEUTRAL;
            }
            if (rel <= RepLevel.getRepInt(0.24f)) {
                return FAVORABLE;
            }
            if (rel <= RepLevel.getRepInt(0.49f)) {
                return WELCOMING;
            }
            if (rel <= RepLevel.getRepInt(0.74f)) {
                return FRIENDLY;
            }
            return COOPERATIVE;
        }
        int rel = RepLevel.getRepInt(r = -r);
        if (rel <= RepLevel.getRepInt(0.09f)) {
            return NEUTRAL;
        }
        if (rel <= RepLevel.getRepInt(0.24f)) {
            return SUSPICIOUS;
        }
        if (rel <= RepLevel.getRepInt(0.49f)) {
            return INHOSPITABLE;
        }
        if (rel <= RepLevel.getRepInt(0.74f)) {
            return HOSTILE;
        }
        return VENGEFUL;
    }

    public static int getRepInt(float f) {
        return Math.round(f * 100.0f);
    }

    public static float getT1() {
        return 0.09f;
    }

    public static float getT2() {
        return 0.24f;
    }

    public static float getT3() {
        return 0.49f;
    }

    public static float getT4() {
        return 0.74f;
    }
}

