/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FighterBlueprintItemPlugin
extends BaseSpecialItemPlugin
implements BlueprintProviderItem {
    protected FighterWingSpecAPI wing;
    protected ShipVariantAPI fighter;

    @Override
    public void init(CargoStackAPI stack) {
        super.init(stack);
        this.wing = Global.getSettings().getFighterWingSpec(stack.getSpecialDataIfSpecial().getData());
        this.fighter = this.wing.getVariant();
    }

    @Override
    public List<String> getProvidedFighters() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.wing.getId());
        return result;
    }

    @Override
    public List<String> getProvidedShips() {
        return null;
    }

    @Override
    public List<String> getProvidedWeapons() {
        return null;
    }

    @Override
    public List<String> getProvidedIndustries() {
        return null;
    }

    @Override
    public String getDesignType() {
        if (this.fighter != null) {
            return this.fighter.getHullSpec().getManufacturer();
        }
        return null;
    }

    @Override
    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        w = 40.0f;
        h = 40.0f;
        float blX = cx - 24.0f;
        float blY = cy - 17.0f;
        float tlX = cx - 14.0f;
        float tlY = cy + 26.0f;
        float trX = cx + 28.0f;
        float trY = cy + 25.0f;
        float brX = cx + 20.0f;
        float brY = cy - 18.0f;
        String wingId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsFighter(wingId);
        float mult = 1.0f;
        Color bgColor = Global.getSector().getPlayerFaction().getDarkUIColor();
        bgColor = Misc.setAlpha(bgColor, 255);
        renderer.renderBGWithCorners(bgColor, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * mult, glowMult * 0.5f * mult, false);
        renderer.renderShipWithCorners(wingId, null, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * mult, glowMult * 0.5f * mult, !known);
        SpriteAPI overlay = Global.getSettings().getSprite("ui", "bpOverlayFighter");
        overlay.setColor(Color.green);
        overlay.setColor(Global.getSector().getPlayerFaction().getBrightUIColor());
        overlay.setAlphaMult(alphaMult);
        overlay.setNormalBlend();
        renderer.renderScanlinesWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult, false);
        if (known) {
            renderer.renderBGWithCorners(Color.black, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * 0.5f, 0.0f, false);
        }
        overlay.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
    }

    @Override
    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        if (this.wing != null) {
            float base = super.getPrice(market, submarket);
            return (int)(base + this.wing.getBaseValue() * this.getItemPriceMult());
        }
        return super.getPrice(market, submarket);
    }

    @Override
    public String getName() {
        if (this.wing != null) {
            return String.valueOf(this.wing.getWingName()) + " \u84dd\u56fe";
        }
        return super.getName();
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        super.createTooltip(tooltip, expanded, transferHandler, stackSource);
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        String wingId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsFighter(wingId);
        ArrayList<String> wings = new ArrayList<String>();
        wings.add(wingId);
        this.addFighterList(tooltip, "\u6218\u673a\uff1a", wings, 1, opad);
        Description desc = Global.getSettings().getDescription(this.fighter.getHullSpec().getDescriptionId(), Description.Type.SHIP);
        tooltip.addPara(desc.getText1FirstPara(), opad);
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        if (known) {
            tooltip.addPara("\u5df2\u77e5", g, opad);
        } else {
            tooltip.addPara("\u53f3\u952e\u5355\u51fb\u5b66\u4e60", b, opad);
        }
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        String wingId = this.stack.getSpecialDataIfSpecial().getData();
        return !Global.getSector().getPlayerFaction().knowsFighter(wingId);
    }

    @Override
    public void performRightClickAction() {
        String wingId = this.stack.getSpecialDataIfSpecial().getData();
        if (Global.getSector().getPlayerFaction().knowsFighter(wingId)) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.wing.getWingName() + ": \u84dd\u56fe\u5df2\u77e5");
        } else {
            Global.getSoundPlayer().playUISound("ui_acquired_blueprint", 1.0f, 1.0f);
            Global.getSector().getPlayerFaction().addKnownFighter(wingId, true);
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage("\u83b7\u5f97\u7684\u84dd\u56fe\uff1a" + this.wing.getWingName());
        }
    }

    @Override
    public String resolveDropParamsToSpecificItemData(String params, Random random) throws JSONException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (!params.startsWith("{")) {
            return params;
        }
        JSONObject json = new JSONObject(params);
        int tier = json.optInt("tier", -1);
        HashSet<String> tags = new HashSet<String>();
        if (json.has("tags")) {
            JSONArray tagsArray = json.getJSONArray("tags");
            int i = 0;
            while (i < tagsArray.length()) {
                tags.add(tagsArray.getString(i));
                ++i;
            }
        }
        return this.pickFighterWing(tier, tags, random);
    }

    protected String pickFighterWing(int tier, Set<String> tags, Random random) {
        FighterWingSpecAPI curr;
        List<FighterWingSpecAPI> specs = Global.getSettings().getAllFighterWingSpecs();
        Iterator<FighterWingSpecAPI> iter = specs.iterator();
        while (iter.hasNext()) {
            curr = iter.next();
            if (!curr.hasTag("no_drop")) continue;
            iter.remove();
        }
        if (tier >= 0) {
            iter = specs.iterator();
            while (iter.hasNext()) {
                curr = iter.next();
                if (curr.getTier() == tier) continue;
                iter.remove();
            }
        }
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block2: while (iter.hasNext()) {
                curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block2;
                }
            }
        }
        WeightedRandomPicker<FighterWingSpecAPI> picker = new WeightedRandomPicker<FighterWingSpecAPI>(random);
        for (FighterWingSpecAPI spec : specs) {
            picker.add(spec, 1.0f * spec.getRarity());
        }
        FighterWingSpecAPI pick = (FighterWingSpecAPI)picker.pick();
        if (pick == null) {
            return null;
        }
        return pick.getId();
    }
}

