/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class GenericSpecialItemPlugin
extends BaseSpecialItemPlugin {
    protected void addInstalledInSection(TooltipMakerAPI tooltip, float pad) {
        String list = "";
        String[] params = this.spec.getParams().split(",");
        String[] array = new String[params.length];
        int i = 0;
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            curr = curr.trim();
            IndustrySpecAPI ind = Global.getSettings().getIndustrySpec(curr);
            if (ind != null) {
                list = String.valueOf(list) + ind.getName() + ", ";
                array[i] = ind.getName();
                ++i;
            }
            ++n2;
        }
        if (!list.isEmpty()) {
            list = list.substring(0, list.length() - 2);
            tooltip.addPara(list, pad, Misc.getGrayColor(), Misc.getBasePlayerColor(), array);
        }
    }

    public static void addReqsSection(Industry industry, InstallableItemEffect effect, TooltipMakerAPI tooltip, boolean withRequiresText, float pad) {
        List<String> reqs = effect.getRequirements(industry);
        List<String> unmet = effect.getUnmetRequirements(industry);
        if (reqs == null) {
            reqs = new ArrayList<String>();
        }
        if (unmet == null) {
            unmet = new ArrayList<String>();
        }
        Color[] hl = new Color[reqs.size()];
        int i = 0;
        String list = "";
        for (String curr : reqs) {
            list = String.valueOf(list) + curr + ", ";
            hl[i] = unmet.contains(curr) ? Misc.getNegativeHighlightColor() : Misc.getBasePlayerColor();
            ++i;
        }
        if (!list.isEmpty()) {
            list = list.substring(0, list.length() - 2);
            list = Misc.ucFirst(list);
            reqs.set(0, Misc.ucFirst(reqs.get(0)));
            float bulletWidth = 70.0f;
            if (withRequiresText) {
                tooltip.setBulletWidth(Float.valueOf(bulletWidth));
                tooltip.setBulletColor(Misc.getGrayColor());
                tooltip.setBulletedListMode("\u6240\u9700\u73af\u5883\uff1a");
            }
            LabelAPI label = tooltip.addPara(list, Misc.getGrayColor(), pad);
            label.setHighlightColors(hl);
            label.setHighlight(reqs.toArray(new String[0]));
            if (withRequiresText) {
                tooltip.setBulletedListMode(null);
            }
        }
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        InstallableItemEffect effect;
        float pad = 0.0f;
        float opad = 10.0f;
        tooltip.addTitle(this.getName());
        LabelAPI design = Misc.addDesignTypePara(tooltip, this.getDesignType(), opad);
        float bulletWidth = 70.0f;
        if (design != null) {
            bulletWidth = design.computeTextWidth("\u8bbe\u8ba1\u7c7b\u578b\uff1a ");
        }
        if ((effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.getId())) != null) {
            tooltip.setBulletWidth(Float.valueOf(bulletWidth));
            tooltip.setBulletColor(Misc.getGrayColor());
            tooltip.setBulletedListMode("\u6240\u9700\u8bbe\u65bd\uff1a");
            this.addInstalledInSection(tooltip, opad);
            tooltip.setBulletedListMode("\u6240\u9700\u73af\u5883\uff1a");
            GenericSpecialItemPlugin.addReqsSection(null, effect, tooltip, false, pad);
            tooltip.setBulletedListMode(null);
            if (!this.spec.getDesc().isEmpty()) {
                Color c = Misc.getTextColor();
                tooltip.addPara(this.spec.getDesc(), c, opad);
            }
            effect.addItemDescription(null, tooltip, new SpecialItemData(this.getId(), null), InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP);
        } else if (!this.spec.getDesc().isEmpty()) {
            Color c = Misc.getTextColor();
            tooltip.addPara(this.spec.getDesc(), c, opad);
        }
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
    }
}

