/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.listeners;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.listeners.DiscoverEntityPlugin;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.WarningBeaconIntel;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import java.awt.Color;

public class CoreDiscoverEntityPlugin
implements DiscoverEntityPlugin {
    public void discoverEntity(SectorEntityToken entity) {
        SalvageEntityGenDataSpec salvageSpec;
        entity.setDiscoverable(null);
        entity.setSensorProfile(null);
        if (entity.hasTag("warning_beacon")) {
            WarningBeaconIntel intel = new WarningBeaconIntel(entity);
            Global.getSector().getIntelManager().addIntel(intel);
        } else {
            Color c = Global.getSector().getPlayerFaction().getBaseUIColor();
            MessageIntel intel = new MessageIntel("\u53d1\u73b0\uff1a" + entity.getName(), c, new String[]{entity.getName()}, c);
            intel.setSound("ui_discovered_entity");
            intel.setIcon(Global.getSettings().getSpriteName("intel", "discovered_entity"));
            Global.getSector().getCampaignUI().addMessage(intel);
        }
        float xp = 0.0f;
        if (entity.hasDiscoveryXP()) {
            xp = entity.getDiscoveryXP().floatValue();
        } else if (entity.getCustomEntityType() != null && (salvageSpec = (SalvageEntityGenDataSpec)Global.getSettings().getSpec(SalvageEntityGenDataSpec.class, entity.getCustomEntityType(), true)) != null) {
            xp = salvageSpec.getXpDiscover();
        }
        if (xp > 0.0f) {
            Global.getSector().getPlayerPerson().getStats().addXP((long)xp);
        }
        ListenerUtil.reportEntityDiscovered(entity);
    }

    public int getHandlingPriority(Object params) {
        return 0;
    }
}

