/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.characters;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.BaseSkillsChangeEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillsChangeRemoveExcessOPEffect
extends BaseSkillsChangeEffect {
    public void setMap(OPDataMap map, Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        dataMap.put(key, map);
    }

    public OPDataMap getMap(Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        OPDataMap map = (OPDataMap)dataMap.get(key);
        if (map == null) {
            map = new OPDataMap();
            dataMap.put(key, map);
        }
        return map;
    }

    public static int getMaxOP(ShipHullSpecAPI hull, MutableCharacterStatsAPI stats) {
        return hull.getOrdnancePoints(stats);
    }

    public OPDataMap getEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        OPDataMap result = new OPDataMap();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            OPEffectData data = new OPEffectData();
            int maxOPPre = SkillsChangeRemoveExcessOPEffect.getMaxOP(member.getHullSpec(), from);
            int maxOPPost = SkillsChangeRemoveExcessOPEffect.getMaxOP(member.getHullSpec(), to);
            int op = member.getVariant().computeOPCost(to);
            data.member = member;
            data.maxOP = maxOPPost;
            data.currOP = op;
            if (maxOPPost >= maxOPPre || op <= maxOPPost) continue;
            result.map.put(member, data);
        }
        return result;
    }

    @Override
    public boolean hasEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        return !this.getEffects((MutableCharacterStatsAPI)from, (MutableCharacterStatsAPI)to).map.isEmpty();
    }

    @Override
    public void printEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, TooltipMakerAPI info, Map<String, Object> dataMap) {
        super.prepare();
        OPDataMap map = this.getEffects(from, to);
        this.setMap(map, dataMap);
        info.addSectionHeading("\u88c5\u914d\u70b9", this.base, this.dark, Alignment.MID, 15.0f);
        info.addPara("\u6240\u6709 \u88c5\u914d\u70b9 \u8d85\u51fa\u4e0a\u9650\u7684\u8230\u8239\u5c06\u4f1a\u79fb\u9664 \u5e45\u80fd\u5bc4\u5b58\u5668\u3001\u8017\u6563\u901a\u9053\u3001\u8230\u8239\u63d2\u4ef6\u4ee5\u53ca\u6b66\u5668\uff0c\u76f4\u81f3\u5176\u5904\u4e8e\u9650\u5236\u4e4b\u4e0b\u3002", 10.0f, Misc.getNegativeHighlightColor(), "\u5e45\u80fd\u5bc4\u5b58\u5668\u3001\u8017\u6563\u901a\u9053\u3001\u8230\u8239\u63d2\u4ef6\u4ee5\u53ca\u6b66\u5668\uff0c\u76f4\u81f3\u5176\u5904\u4e8e\u9650\u5236\u4e4b\u4e0b");
    }

    @Override
    public void infoButtonPressed(ButtonAPI button, Object param, Map<String, Object> dataMap) {
    }

    @Override
    public void applyEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, Map<String, Object> dataMap) {
        OPDataMap map = this.getMap(dataMap);
        for (OPEffectData data : map.map.values()) {
            SkillsChangeRemoveExcessOPEffect.clampOP(data.member, to);
        }
    }

    public static void clampOP(FleetMemberAPI member, MutableCharacterStatsAPI stats) {
        int maxOP = SkillsChangeRemoveExcessOPEffect.getMaxOP(member.getHullSpec(), stats);
        int op = member.getVariant().computeOPCost(stats);
        int remove = op - maxOP;
        if (remove > 0) {
            ShipVariantAPI variant = member.getVariant();
            variant = variant.clone();
            variant.setSource(VariantSource.REFIT);
            int caps = variant.getNumFluxCapacitors();
            int curr = Math.min(caps, remove);
            variant.setNumFluxCapacitors(caps - curr);
            if ((remove -= curr) > 0) {
                int vents = variant.getNumFluxVents();
                curr = Math.min(vents, remove);
                variant.setNumFluxVents(vents - curr);
                remove -= curr;
            }
            if (remove > 0) {
                for (String modId : variant.getNonBuiltInHullmods()) {
                    HullModSpecAPI mod = Global.getSettings().getHullModSpec(modId);
                    curr = mod.getCostFor(member.getHullSpec().getHullSize());
                    variant.removeMod(modId);
                    if ((remove -= curr) <= 0) break;
                }
            }
            member.setVariant(variant, false, false);
        }
    }

    public static class OPDataMap {
        Map<FleetMemberAPI, OPEffectData> map = new LinkedHashMap<FleetMemberAPI, OPEffectData>();
    }

    public static class OPEffectData {
        FleetMemberAPI member;
        int maxOP;
        int currOP;
    }
}

