/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.characters;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.BaseSkillsChangeEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.plog.SModRecord;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillsChangeRemoveSmodsEffect
extends BaseSkillsChangeEffect {
    public void setMap(SmodDataMap map, Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        dataMap.put(key, map);
    }

    public SmodDataMap getMap(Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        SmodDataMap map = (SmodDataMap)dataMap.get(key);
        if (map == null) {
            map = new SmodDataMap();
            dataMap.put(key, map);
        }
        return map;
    }

    public SmodDataMap getEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        SmodDataMap result = new SmodDataMap();
        for (SModRecord record : PlaythroughLog.getInstance().getSModsInstalled()) {
            FleetMemberAPI member = record.getMember();
            if (member == null || record.getSMods().isEmpty()) continue;
            String modId = record.getSMods().get(0);
            if (!member.getVariant().getSMods().contains(modId) || !member.getVariant().getHullMods().contains(modId)) continue;
            SmodRemovalEffectData data = result.map.get(member);
            if (data == null) {
                data = new SmodRemovalEffectData();
                data.member = member;
                data.numSmods = member.getVariant().getSMods().size();
                data.maxBefore = Misc.getMaxPermanentMods(member, from);
                data.maxAfter = Misc.getMaxPermanentMods(member, to);
                result.map.put(member, data);
            }
            data.records.add(record);
        }
        for (FleetMemberAPI member : new ArrayList<FleetMemberAPI>(result.map.keySet())) {
            SmodRemovalEffectData data = result.map.get(member);
            if (data.maxBefore <= data.maxAfter || data.records.isEmpty() || data.numSmods <= data.maxAfter) {
                result.map.remove(member);
                continue;
            }
            data.remove = Math.min(data.numSmods - data.maxAfter, data.records.size());
            boolean bl = data.offerChoice = data.remove <= 1 && Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy().contains(data.member);
            if (data.offerChoice) continue;
            ArrayList<SModRecord> copy = new ArrayList<SModRecord>(data.records);
            int i = 0;
            while (i < data.remove) {
                int minCost = 10000;
                SModRecord minCostMod = null;
                for (SModRecord record : data.records) {
                    HullModSpecAPI mod = Global.getSettings().getHullModSpec(record.getSMods().get(0));
                    int cost = mod.getCostFor(member.getHullSpec().getHullSize());
                    if (cost >= minCost) continue;
                    minCostMod = record;
                    minCost = cost;
                }
                if (minCostMod != null) {
                    data.removeList.add(minCostMod.getSMods().get(0));
                    copy.remove(minCostMod);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean hasEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        return !this.getEffects((MutableCharacterStatsAPI)from, (MutableCharacterStatsAPI)to).map.isEmpty();
    }

    @Override
    public void printEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, TooltipMakerAPI info, Map<String, Object> dataMap) {
        super.prepare();
        SmodDataMap map = this.getEffects(from, to);
        this.setMap(map, dataMap);
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        float initPad = 15.0f;
        info.addSectionHeading("S-\u63d2\u4ef6", this.base, this.dark, Alignment.MID, initPad);
        initPad = opad;
        info.addPara("\u5982\u679c\u7531\u4f60\u5185\u7f6e\u7684 S-\u63d2\u4ef6 \u7684\u6570\u91cf\u8d85\u51fa\u4e0a\u9650\uff0c\u90a3\u4e48 \u88c5\u914d\u70b9\u6700\u4f4e\u7684 S-\u63d2\u4ef6 \u5c06\u4f1a\u88ab\u79fb\u9664\u3002", initPad, Misc.getNegativeHighlightColor(), "\u88c5\u914d\u70b9\u6700\u4f4e\u7684 S-\u63d2\u4ef6 \u5c06\u4f1a\u88ab\u79fb\u9664");
        initPad = 15.0f;
        info.addPara("\u5982\u679c\u56e0\u6570\u91cf\u8d85\u9650\u800c\u88ab\u4ece\u8230\u8239\u4e0a\u88ab\u79fb\u9664\u7684 S-\u63d2\u4ef6 \u53ea\u6709\u4e00\u4e2a\uff0c\u4e14\u8be5\u8230\u8239\u5904\u5728\u4f60\u7684\u8230\u961f\u4e2d\uff0c\u5219\u4f60\u53ef\u4ee5\u81ea\u884c\u9009\u62e9\u88ab\u79fb\u9664\u7684 S-\u63d2\u4ef6\u3002\u4e0d\u7531\u4f60\u5185\u7f6e\u7684 S-\u63d2\u4ef6 \u5373\u4f7f\u6570\u91cf\u8d85\u9650\u4e5f\u4e0d\u4f1a\u88ab\u79fb\u9664\u3002", opad);
        for (SmodRemovalEffectData data : map.map.values()) {
            FleetMemberAPI member = data.member;
            if (!data.offerChoice) continue;
            String str = "\u9009\u62e9 " + member.getShipName() + " (" + member.getHullSpec().getHullNameWithDashClass() + ") \u7684\u4e00\u4e2a S-\u63d2\u4ef6 \u5e76\u5c06\u5176\u79fb\u9664...";
            info.addPara(str, initPad);
            float bw = 470.0f;
            float bh = 25.0f;
            float indent = 40.0f;
            ButtonAPI prev = null;
            int minCost = 10000;
            ButtonAPI minCostButton = null;
            for (SModRecord record : data.records) {
                HullModSpecAPI mod = Global.getSettings().getHullModSpec(record.getSMods().get(0));
                float p = opad;
                if (prev != null) {
                    p = pad;
                }
                int cost = mod.getCostFor(member.getHullSpec().getHullSize());
                ButtonAPI b = info.addAreaCheckbox(String.valueOf(mod.getDisplayName()) + " (" + cost + " \u88c5\u914d\u70b9) ", new Object(), this.base, this.dark, this.bright, bw, bh, p, true);
                data.buttons.add(b);
                if (prev == null) {
                    b.getPosition().setXAlignOffset(indent);
                }
                prev = b;
                if (cost >= minCost) continue;
                minCostButton = b;
                minCost = cost;
            }
            if (minCostButton != null) {
                minCostButton.setChecked(true);
            }
            info.addSpacer(0.0f).getPosition().setXAlignOffset(-indent);
        }
    }

    @Override
    public void infoButtonPressed(ButtonAPI button, Object param, Map<String, Object> dataMap) {
        SmodDataMap map = this.getMap(dataMap);
        for (SmodRemovalEffectData data : map.map.values()) {
            boolean found = false;
            for (ButtonAPI b : data.buttons) {
                if (b != button) continue;
                found = true;
                break;
            }
            if (!found) continue;
            for (ButtonAPI b : data.buttons) {
                if (b == button) {
                    b.setChecked(true);
                    continue;
                }
                b.setChecked(false);
            }
        }
    }

    @Override
    public void applyEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, Map<String, Object> dataMap) {
        SmodDataMap map = this.getMap(dataMap);
        for (SmodRemovalEffectData data : map.map.values()) {
            ShipVariantAPI variant = data.member.getVariant();
            variant = variant.clone();
            variant.setSource(VariantSource.REFIT);
            if (data.offerChoice) {
                int index = 0;
                for (ButtonAPI b : data.buttons) {
                    if (b.isChecked()) {
                        SModRecord record = data.records.get(index);
                        data.removeList.add(record.getSMods().get(0));
                    }
                    ++index;
                }
            }
            for (String modId : data.removeList) {
                variant.removePermaMod(modId);
            }
            data.member.setVariant(variant, false, false);
        }
    }

    public static class SmodDataMap {
        Map<FleetMemberAPI, SmodRemovalEffectData> map = new LinkedHashMap<FleetMemberAPI, SmodRemovalEffectData>();
    }

    public static class SmodRemovalEffectData {
        FleetMemberAPI member;
        List<SModRecord> records = new ArrayList<SModRecord>();
        int maxBefore;
        int maxAfter;
        int numSmods;
        int remove;
        boolean offerChoice = false;
        List<String> removeList = new ArrayList<String>();
        List<ButtonAPI> buttons = new ArrayList<ButtonAPI>();
    }
}

