/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.HullModEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BaseHullMod
implements HullModEffect {
    protected HullModSpecAPI spec;

    public void init(HullModSpecAPI spec) {
        this.spec = spec;
    }

    public boolean isSMod(MutableShipStatsAPI stats) {
        if (stats == null || stats.getVariant() == null || this.spec == null) {
            return false;
        }
        return stats.getVariant().getSMods().contains(this.spec.getId()) || stats.getVariant().getSModdedBuiltIns().contains(this.spec.getId());
    }

    public boolean isSMod(ShipAPI ship) {
        if (ship == null || ship.getVariant() == null || this.spec == null) {
            return false;
        }
        return ship.getVariant().getSMods().contains(this.spec.getId()) || ship.getVariant().getSModdedBuiltIns().contains(this.spec.getId());
    }

    public boolean isBuiltIn(ShipAPI ship) {
        if (ship == null || ship.getVariant() == null || this.spec == null) {
            return false;
        }
        return ship.getHullSpec().getBuiltInMods().contains(this.spec.getId());
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getDescriptionParam(index, hullSize);
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getSModDescriptionParam(index, hullSize);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return true;
    }

    public void advanceInCampaign(FleetMemberAPI member, float amount) {
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
    }

    public String getUnapplicableReason(ShipAPI ship) {
        return null;
    }

    public boolean affectsOPCosts() {
        return false;
    }

    public boolean canBeAddedOrRemovedNow(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (this.spec == null) {
            return true;
        }
        boolean reqSpaceport = this.spec.hasTag("req_spaceport");
        if (!reqSpaceport) {
            return true;
        }
        if (marketOrNull == null) {
            return false;
        }
        if (mode == CampaignUIAPI.CoreUITradeMode.NONE || mode == null) {
            return false;
        }
        for (Industry ind : marketOrNull.getIndustries()) {
            if (ind.getSpec().hasTag("station")) {
                return true;
            }
            if (!ind.getSpec().hasTag("spaceport")) continue;
            return true;
        }
        return false;
    }

    public String getCanNotBeInstalledNowReason(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (this.spec == null) {
            return null;
        }
        boolean reqSpaceport = this.spec.hasTag("req_spaceport");
        if (!reqSpaceport) {
            return null;
        }
        boolean has = ship.getVariant().hasHullMod(this.spec.getId());
        String verb = "\u5b89\u88c5";
        if (has) {
            verb = "\u79fb\u9664";
        }
        return "\u5982\u9700" + verb + "\u5c31\u5fc5\u987b\u5230\u8239\u575e\u5185\u624d\u53ef\u6267\u884c";
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
    }

    public boolean hasSModEffectSection(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        if (!this.hasSModEffect()) {
            return false;
        }
        GameState state = Global.getCurrentState();
        if (state == GameState.TITLE && !Global.getSettings().isDevMode()) {
            return false;
        }
        if (Misc.CAN_SMOD_BUILT_IN) {
            return !this.isBuiltIn(ship) || !this.isSModEffectAPenalty();
        }
        return !this.isBuiltIn(ship);
    }

    public boolean isSModEffectAPenalty() {
        return false;
    }

    public boolean hasSModEffect() {
        return this.spec != null && this.spec.getSModEffectFormat() != null && !this.spec.getSModEffectFormat().trim().isEmpty() && !this.spec.getSModEffectFormat().startsWith("#");
    }

    public void addSModEffectSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        String[] params = new String[]{this.getSModDescriptionParam(0, hullSize, null), this.getSModDescriptionParam(1, hullSize, null), this.getSModDescriptionParam(2, hullSize, null), this.getSModDescriptionParam(3, hullSize, null), this.getSModDescriptionParam(4, hullSize, null), this.getSModDescriptionParam(5, hullSize, null), this.getSModDescriptionParam(6, hullSize, null), this.getSModDescriptionParam(7, hullSize, null), this.getSModDescriptionParam(8, hullSize, null), this.getSModDescriptionParam(9, hullSize, null)};
        tooltip.addPara(this.spec.getSModDescription(hullSize).replaceAll("\\%", "%%"), opad, h, params);
    }

    public void addSModSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
        float opad = 10.0f;
        boolean sMod = this.isSMod(ship);
        Color s = Misc.getStoryOptionColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color darkBad = Misc.setAlpha(Misc.scaleColorOnly(bad, 0.4f), 175);
        if (!sMod || this.hasSModEffect()) {
            if (!this.isSModEffectAPenalty()) {
                if (isForBuildInList) {
                    tooltip.addSectionHeading(String.valueOf(this.spec.getDisplayName()) + "\u589e\u76ca", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
                } else {
                    tooltip.addSectionHeading("S-\u63d2\u4ef6\u589e\u76ca", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
                }
            } else if (isForBuildInList) {
                tooltip.addSectionHeading(String.valueOf(this.spec.getDisplayName()) + "\u60e9\u7f5a", bad, darkBad, Alignment.MID, opad);
            } else {
                tooltip.addSectionHeading("S-\u63d2\u4ef6 \u60e9\u7f5a", bad, darkBad, Alignment.MID, opad);
            }
        }
        if (this.hasSModEffect()) {
            if (isForBuildInList) {
                tooltip.addSpacer(-5.0f);
            }
            this.addSModEffectSection(tooltip, hullSize, ship, width, isForModSpec, false);
            if (!sMod && !isForBuildInList) {
                boolean builtIn = this.isBuiltIn(ship);
                if (builtIn) {
                    tooltip.addPara("\u8be5\u6548\u679c\u53ea\u6709\u5728\u7528\u4e00\u4e2a %s \u5c06\u8be5\u5185\u7f6e\u63d2\u4ef6\u5f3a\u5316\u540e\u751f\u6548\u3002\u5f3a\u5316\u5185\u7f6e\u63d2\u4ef6\u4e0d\u8ba1\u5165\u8230\u8239\u7684 S-\u63d2\u4ef6 \u4e0a\u9650\u8ba1\u6570\u5185\u3002", opad, s, "\u6545\u4e8b\u70b9");
                } else {
                    tooltip.addPara("\u4ec5\u5f53\u8be5\u63d2\u4ef6\u4f7f\u7528 \u6545\u4e8b\u70b9 \u5185\u7f6e\u5230\u8239\u4f53\u4e2d\u65f6\u6b64\u6548\u679c\u624d\u751f\u6548\u3002\u4f7f\u7528\u88c5\u914d\u70b9\u8f83\u5c11\u7684\u63d2\u4ef6\u5185\u7f6e\u5956\u52b1\u66f4\u5f3a\u3002", opad, s, "\u6545\u4e8b\u70b9");
                }
            }
        } else if (!sMod) {
            tooltip.addPara("\u9664\u4e86\u6d88\u9664\u5176\u88c5\u914d\u70b9\u6210\u672c\u4ee5\u5916\uff0c\u8be5\u63d2\u4ef6\u4e0d\u4f1a\u56e0\u4f7f\u7528 \u6545\u4e8b\u70b9 \u5185\u7f6e\u5230\u8239\u4f53\u4e2d\u800c\u83b7\u5f97\u989d\u5916\u7684\u6548\u679c\u3002", opad, s, "\u6545\u4e8b\u70b9");
        }
        if ((!sMod || this.hasSModEffect()) && isForModSpec) {
            tooltip.addSpacer(opad);
        }
    }

    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
    }

    public boolean shipHasOtherModInCategory(ShipAPI ship, String currMod, String category) {
        for (String id : ship.getVariant().getHullMods()) {
            HullModSpecAPI mod = Global.getSettings().getHullModSpec(id);
            if (!mod.hasTag(category) || id.equals(currMod)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPlayerFleet(MutableShipStatsAPI stats) {
        if (stats == null) {
            return false;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        PersonAPI fc = member.getFleetCommanderForStats();
        if (fc == null) {
            fc = member.getFleetCommander();
        }
        if (fc == null) {
            return false;
        }
        return fc.isPlayer();
    }

    public boolean isInPlayerFleet(ShipAPI ship) {
        if (ship == null) {
            return false;
        }
        FleetMemberAPI member = ship.getFleetMember();
        if (member == null) {
            return false;
        }
        PersonAPI fc = member.getFleetCommanderForStats();
        if (fc == null) {
            fc = member.getFleetCommander();
        }
        if (fc == null) {
            return false;
        }
        return fc.isPlayer();
    }

    public Color getBorderColor() {
        return null;
    }

    public Color getNameColor() {
        return null;
    }

    public int getDisplaySortOrder() {
        return 100;
    }

    public int getDisplayCategoryIndex() {
        return -1;
    }

    public float getTooltipWidth() {
        return 369.0f;
    }

    public boolean showInRefitScreenModPickerFor(ShipAPI ship) {
        return true;
    }
}

