/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ShipwideAIFlags {
    public static final float FLAG_DURATION = 0.5f;
    private Map<AIFlags, FlagData> flags = new HashMap<AIFlags, FlagData>();

    public void unsetFlag(AIFlags flag) {
        this.flags.remove((Object)flag);
    }

    public void setFlag(AIFlags flag) {
        FlagData data = this.flags.get((Object)flag);
        if (data != null) {
            data.elapsed = 0.0f;
        } else {
            this.flags.put(flag, new FlagData(flag));
        }
    }

    public void setFlag(AIFlags flag, float duration) {
        this.setFlag(flag, duration, null);
    }

    public void setFlag(AIFlags flag, float duration, Object custom) {
        FlagData data = this.flags.get((Object)flag);
        if (data != null) {
            data.elapsed = 0.0f;
            data.custom = custom;
        } else {
            data = new FlagData(flag);
            data.durationOverride = duration;
            data.custom = custom;
            this.flags.put(flag, data);
        }
    }

    public Object getCustom(AIFlags flag) {
        FlagData data = this.flags.get((Object)flag);
        if (data != null) {
            return data.custom;
        }
        return null;
    }

    public void removeFlag(AIFlags flag) {
        this.flags.remove((Object)flag);
    }

    public void advance(float amount) {
        ArrayList<AIFlags> remove = new ArrayList<AIFlags>();
        for (AIFlags flag : this.flags.keySet()) {
            FlagData data = this.flags.get((Object)flag);
            data.elapsed += amount;
            if (!(data.durationOverride <= 0.0f && data.elapsed > 0.5f) && (!(data.durationOverride > 0.0f) || !(data.elapsed > data.durationOverride))) continue;
            remove.add(flag);
        }
        for (AIFlags flag : remove) {
            this.flags.remove((Object)flag);
        }
    }

    public boolean hasFlag(AIFlags flag) {
        return this.flags.containsKey((Object)flag);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AIFlags {
        HARASS_MOVE_IN,
        HARASS_MOVE_IN_COOLDOWN,
        AVOIDING_BORDER,
        DO_NOT_AVOID_BORDER,
        CAMP_LOCATION,
        FACING_OVERRIDE_FOR_MOVE_AND_ESCORT_MANEUVERS,
        ESCORT_OTHER_SHIP,
        MANEUVER_TARGET,
        MOVEMENT_DEST_WHILE_SIDETRACKED,
        CARRIER_FIGHTER_TARGET,
        MAINTAINING_STRIKE_RANGE,
        DRONE_MOTHERSHIP,
        DO_NOT_USE_SHIELDS,
        DO_NOT_USE_FLUX,
        DO_NOT_VENT,
        DO_NOT_AUTOFIRE_NON_ESSENTIAL_GROUPS,
        RUN_QUICKLY,
        TURN_QUICKLY,
        PURSUING,
        HAS_INCOMING_DAMAGE,
        KEEP_SHIELDS_ON,
        STAY_PHASED,
        PHASE_BRAWLER_DUMPING_FLUX,
        DO_NOT_BACK_OFF,
        DO_NOT_BACK_OFF_EVEN_WHILE_VENTING,
        BACK_OFF,
        BACK_OFF_MIN_RANGE,
        STANDING_OFF_VS_SHIP_ON_MAP_BORDER,
        BACKING_OFF,
        SAFE_VENT,
        OK_TO_CANCEL_SYSTEM_USE_TO_VENT,
        MANEUVER_RANGE_FROM_TARGET,
        SAFE_FROM_DANGER_TIME,
        PREFER_LEFT_BROADSIDE,
        PREFER_RIGHT_BROADSIDE,
        AUTO_FIRING_AT_PHASE_SHIP,
        AUTO_BEAM_FIRING_AT_PHASE_SHIP,
        DELAY_STRIKE_FIRE,
        PHASE_ATTACK_RUN,
        PHASE_ATTACK_RUN_FROM_BEHIND_DIST_CRITICAL,
        PHASE_ATTACK_RUN_IN_GOOD_SPOT,
        PHASE_ATTACK_RUN_TIMEOUT,
        DO_NOT_PURSUE,
        IN_CRITICAL_DPS_DANGER,
        IN_ATTACK_RUN,
        POST_ATTACK_RUN,
        WANTED_TO_SLOW_DOWN,
        FINISHED_SPREADING,
        WING_NEAR_ENEMY,
        WING_WAS_NEAR_ENEMY,
        WING_SHOULD_GET_SOME_DISTANCE,
        REACHED_WAYPOINT,
        NEEDS_HELP,
        SYSTEM_TARGET_COORDS,
        BIGGEST_THREAT,
        MOVEMENT_DEST,
        HAS_POTENTIAL_MINE_TRIGGER_NEARBY,
        TARGET_FOR_SHIP_SYSTEM;

    }

    private class FlagData {
        AIFlags flag;
        float elapsed;
        float durationOverride = 0.0f;
        Object custom;

        private FlagData(AIFlags flag) {
            this.flag = flag;
        }
    }
}

