/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.BaseAICoreOfficerPluginImpl;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import java.util.Random;

public class AICoreOfficerPluginImpl
extends BaseAICoreOfficerPluginImpl
implements AICoreOfficerPlugin {
    public static int OMEGA_POINTS = 0;
    public static int ALPHA_POINTS = 0;
    public static int BETA_POINTS = 0;
    public static int GAMMA_POINTS = 0;
    public static float OMEGA_MULT = 5.0f;
    public static float ALPHA_MULT = 4.0f;
    public static float BETA_MULT = 3.0f;
    public static float GAMMA_MULT = 2.0f;

    public PersonAPI createPerson(String aiCoreId, String factionId, Random random) {
        if (random == null) {
            random = new Random();
        }
        PersonAPI person = Global.getFactory().createPerson();
        person.setFaction(factionId);
        person.setAICoreId(aiCoreId);
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(aiCoreId);
        boolean alpha = "alpha_core".equals(aiCoreId);
        boolean beta = "beta_core".equals(aiCoreId);
        boolean gamma = "gamma_core".equals(aiCoreId);
        boolean omega = "omega_core".equals(aiCoreId);
        person.getStats().setSkipRefresh(true);
        person.setName(new FullName(spec.getName(), "", FullName.Gender.ANY));
        int points = 0;
        float mult = 1.0f;
        if (omega) {
            person.setPortraitSprite("graphics/portraits/characters/omega.png");
            person.getStats().setLevel(9);
            person.getStats().setSkillLevel("helmsmanship", 2.0f);
            person.getStats().setSkillLevel("target_analysis", 2.0f);
            person.getStats().setSkillLevel("impact_mitigation", 2.0f);
            person.getStats().setSkillLevel("field_modulation", 2.0f);
            person.getStats().setSkillLevel("gunnery_implants", 2.0f);
            person.getStats().setSkillLevel("combat_endurance", 2.0f);
            person.getStats().setSkillLevel("damage_control", 2.0f);
            person.getStats().setSkillLevel("point_defense", 2.0f);
            person.getStats().setSkillLevel("energy_weapon_mastery", 2.0f);
            person.getStats().setSkillLevel("omega_ecm", 2.0f);
            points = OMEGA_POINTS;
            mult = OMEGA_MULT;
        } else if (alpha) {
            person.setPortraitSprite("graphics/portraits/portrait_ai2b.png");
            person.getStats().setLevel(7);
            person.getStats().setSkillLevel("helmsmanship", 2.0f);
            person.getStats().setSkillLevel("target_analysis", 2.0f);
            person.getStats().setSkillLevel("impact_mitigation", 2.0f);
            person.getStats().setSkillLevel("field_modulation", 2.0f);
            person.getStats().setSkillLevel("gunnery_implants", 2.0f);
            person.getStats().setSkillLevel("combat_endurance", 2.0f);
            person.getStats().setSkillLevel("damage_control", 2.0f);
            points = ALPHA_POINTS;
            mult = ALPHA_MULT;
        } else if (beta) {
            person.setPortraitSprite("graphics/portraits/portrait_ai3b.png");
            person.getStats().setLevel(5);
            person.getStats().setSkillLevel("helmsmanship", 2.0f);
            person.getStats().setSkillLevel("target_analysis", 2.0f);
            person.getStats().setSkillLevel("impact_mitigation", 2.0f);
            person.getStats().setSkillLevel("gunnery_implants", 2.0f);
            person.getStats().setSkillLevel("combat_endurance", 2.0f);
            points = BETA_POINTS;
            mult = BETA_MULT;
        } else if (gamma) {
            person.setPortraitSprite("graphics/portraits/portrait_ai1b.png");
            person.getStats().setLevel(3);
            person.getStats().setSkillLevel("helmsmanship", 2.0f);
            person.getStats().setSkillLevel("impact_mitigation", 2.0f);
            person.getStats().setSkillLevel("combat_endurance", 2.0f);
            points = GAMMA_POINTS;
            mult = GAMMA_MULT;
        }
        if (points != 0) {
            person.getMemoryWithoutUpdate().set("$autoPointsValue", points);
        }
        person.getMemoryWithoutUpdate().set("$autoPointsMult", Float.valueOf(mult));
        person.setPersonality("reckless");
        person.setRankId(Ranks.SPACE_CAPTAIN);
        person.setPostId(null);
        person.getStats().setSkipRefresh(false);
        return person;
    }
}

