/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.econ.AbandonMarketPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.impl.campaign.BaseGenericPlugin;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivTracker;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class AbandonMarketPluginImpl
extends BaseGenericPlugin
implements AbandonMarketPlugin {
    public static int MAX_SIZE = 4;
    public static int COST_PER_SIZE_MINUS_2 = 50000;

    public boolean canAbandon(MarketAPI market) {
        return market.getSize() <= MAX_SIZE;
    }

    public int getAbandonCost(MarketAPI market) {
        return Math.max(1, market.getSize() - 2) * COST_PER_SIZE_MINUS_2;
    }

    public void createAbandonButtonTooltip(TooltipMakerAPI info, float width, boolean expanded, MarketAPI market) {
        info.addPara("\u89c4\u6a21\u9ad8\u4e8e %s \u7684\u6b96\u6c11\u5730\u65e0\u6cd5\u9057\u5f03\u3002", 0.0f, Misc.getNegativeHighlightColor(), Misc.getHighlightColor(), "" + MAX_SIZE);
    }

    public boolean isAbandonButtonTooltipExpandable(MarketAPI market) {
        return false;
    }

    public boolean abandonButtonHasTooltip(MarketAPI market) {
        return !this.canAbandon(market);
    }

    public void createConfirmationPrompt(MarketAPI market, TooltipMakerAPI prompt) {
        Color h;
        float opad = 10.0f;
        int \u82b1\u8d39 = this.getAbandonCost(market);
        int refund = Misc.computeTotalShutdownRefund(market);
        int credits = (int)Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        Color cc = h = Misc.getHighlightColor();
        String costStr = "\u82b1\u8d39";
        if (refund > \u82b1\u8d39) {
            costStr = "\u83b7\u5f97";
        }
        if (\u82b1\u8d39 - refund > credits) {
            cc = Misc.getNegativeHighlightColor();
        }
        FactionAPI faction = market.getFaction();
        LabelAPI label = prompt.addPara("\u9057\u5f03 %s \u8fd9\u5904 %s \u89c4\u6a21\u7684\u6b96\u6c11\u5730\uff0c\u9700\u8981 %s \u7684\u758f\u6563\u8d39\u3002\u800c\u9762\u4e34\u5173\u95ed\u7684\u8bbe\u65bd\u5c06\u4e3a\u4f60\u5e26\u6765 %s \u7684\u6536\u5165\uff0c\u56e0\u6b64\u6700\u7ec8 " + costStr + "\u4e3a %s}\u3002", 0.0f, h, market.getName(), "" + market.getSize(), Misc.getDGSCredits(\u82b1\u8d39), Misc.getDGSCredits(refund), Misc.getDGSCredits(Math.abs(\u82b1\u8d39 - refund)));
        label.setHighlightColors(faction.getBaseUIColor(), h, h, h, cc);
        prompt.addPara("\u4f60\u76ee\u524d\u6709 %s \u53ef\u7528\u3002", opad, h, Misc.getDGSCredits(credits));
        prompt.addPara("\u8be5\u884c\u52a8\u65e0\u6cd5\u64a4\u6d88\u3002\u4e14\u6240\u6709\u50a8\u5b58\u4e2d\u7684\u7269\u54c1\u4e0e\u5de5\u4e1a\u8bbe\u65bd\u6240\u4f7f\u7528\u7684\u7269\u8d44\u90fd\u5c06\u4e22\u5931\u3002", opad);
    }

    public boolean isConfirmEnabled(MarketAPI market) {
        int \u82b1\u8d39 = this.getAbandonCost(market);
        int refund = Misc.computeTotalShutdownRefund(market);
        return Global.getSector().getPlayerFleet().getCargo().getCredits().get() >= (float)(\u82b1\u8d39 - refund);
    }

    public float getConfirmationPromptWidth(MarketAPI market) {
        return 550.0f;
    }

    public void abandonConfirmed(MarketAPI market) {
        int \u82b1\u8d39 = this.getAbandonCost(market);
        int refund = Misc.computeTotalShutdownRefund(market);
        int diff = \u82b1\u8d39 - refund;
        Global.getSector().getPlayerFleet().getCargo().getCredits().subtract(diff);
        if (diff > 0) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.format("Spent %s", Misc.getDGSCredits(diff)), Misc.getTooltipTitleAndLightHighlightColor(), Misc.getDGSCredits(diff), Misc.getHighlightColor());
        } else if (diff < 0) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.format("Received %s", Misc.getDGSCredits(-diff)), Misc.getTooltipTitleAndLightHighlightColor(), Misc.getDGSCredits(-diff), Misc.getHighlightColor());
        }
        DecivTracker.removeColony(market, false);
        ListenerUtil.reportPlayerAbandonedColony(market);
        InteractionDialogAPI dialog = Global.getSector().getCampaignUI().getCurrentInteractionDialog();
        if (dialog != null && dialog.getPlugin() instanceof RuleBasedDialog) {
            RuleBasedDialog rbd = (RuleBasedDialog)((Object)dialog.getPlugin());
            rbd.updateMemory();
            market.getMemoryWithoutUpdate().unset("$tradeMode");
            if (market.getPrimaryEntity() != null) {
                market.getPrimaryEntity().getMemoryWithoutUpdate().unset("$tradeMode");
            }
            new ShowDefaultVisual().execute(null, dialog, Misc.tokenize(""), rbd.getMemoryMap());
            dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$menuState", "main", 0.0f);
            dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "NONE", 0.0f);
            dialog.getInteractionTarget().getMemoryWithoutUpdate().unset("$hasMarket");
            dialog.getVisualPanel().closeCoreUI();
            rbd.updateMemory();
            FireAll.fire(null, dialog, rbd.getMemoryMap(), "OpenInteractionDialog");
        } else {
            Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.OUTPOSTS);
        }
    }
}

