/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.SoundAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.AbyssalLightBonus;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.InterdictionPulseAbility;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.FlickerUtilV2;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class AbyssalLightEntityPlugin
extends BaseCustomEntityPlugin {
    public static float MIN_DURATION = 20.0f;
    public static float MAX_DURATION = 30.0f;
    public static float MIN_SIZE = 600.0f;
    public static float MAX_SIZE = 1200.0f;
    public static float DESPAWN_POOF_THRESHOLD = 0.7f;
    public static float GLOW_FREQUENCY = 0.2f;
    public static float PLAYER_PROXIMITY_MIN_BRIGHTNESS_AT = 2000.0f;
    public static float PLAYER_PROXIMITY_MAX_BRIGHTNESS_AT = 300.0f;
    public static float PLAYER_PROXIMITY_MIN_BRIGHTNESS = 0.25f;
    private transient SpriteAPI glow;
    protected float phase = 0.0f;
    protected float frequencyMult = 1.0f;
    protected FlickerUtilV2 flicker = new FlickerUtilV2();
    protected FaderUtil fader = new FaderUtil(0.0f, 0.5f, 0.5f);
    protected AbyssalLightParams params;
    protected float untilFrequencyChange = 0.0f;
    protected float untilSoundPlayed = 0.0f;
    protected float flickerDur = 0.0f;
    protected DespawnType despawnType = null;
    protected boolean playedDespawnSound = false;

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.params = (AbyssalLightParams)pluginParams;
        float radiusMult = this.params.bonusMult;
        if (radiusMult > 1.0f) {
            radiusMult = 1.0f + (radiusMult - 1.0f) * 0.33f;
        } else if (radiusMult < 1.0f) {
            radiusMult = 1.0f - (1.0f - radiusMult) * 0.33f;
        }
        ((CustomCampaignEntityAPI)entity).setRadius(entity.getRadius() * radiusMult);
        entity.setSensorProfile(Float.valueOf(1.0f));
        entity.setDiscoverable(false);
        entity.getDetectedRangeMod().modifyFlat("gen", this.params.detectedRange);
        entity.setExtendedDetectedAtRange(Float.valueOf(2000.0f));
        entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(0.5f));
        entity.getMemoryWithoutUpdate().set("$extraSensorIndicators", 3);
        this.updateFrequency(0.0f);
        this.updateSoundDelayAndPlaySound(0.0f);
        this.readResolve();
    }

    public boolean isDespawning() {
        return this.despawnType != null || this.entity.hasTag("fading_out_and_expiring");
    }

    public void despawn(DespawnType type) {
        SectorEntityToken.VisibilityLevel level;
        if (this.isDespawning()) {
            return;
        }
        float dur = 1.0f;
        if (type == DespawnType.EXPAND) {
            dur = 2.0f;
        }
        Misc.fadeAndExpire(this.entity, dur);
        this.despawnType = type;
        if (type == DespawnType.EXPAND && this.entity.isInCurrentLocation() && ((level = this.entity.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS)) {
            Global.getSoundPlayer().playSound("abyssal_light_expand_despawn_windup", 1.0f, 1.0f, this.entity.getLocation(), Misc.ZERO);
        }
    }

    public void updateSoundDelayAndPlaySound(float amount) {
        this.untilSoundPlayed -= amount;
        if (this.untilSoundPlayed <= 0.0f) {
            SectorEntityToken.VisibilityLevel level;
            this.untilSoundPlayed = 5.0f + (float)Math.random() * 30.0f;
            if (amount > 0.0f && this.entity.isInCurrentLocation() && ((level = this.entity.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS)) {
                float volume = 1.0f;
                if (this.params.bonusMult < 1.0f) {
                    volume = 1.0f - (1.0f - this.params.bonusMult) * 0.6f;
                }
                if (volume > 1.0f) {
                    volume = 1.0f;
                }
                if (volume < 0.0f) {
                    volume = 0.0f;
                }
                SoundAPI sound = Global.getSoundPlayer().playSound("abyssal_light_random_sound", 1.0f, volume, this.entity.getLocation(), Misc.ZERO);
                Global.getSector().addScript(new AbyssalLightSoundStopper(sound));
                this.flickerDur = 0.5f + 0.5f * (float)Math.random();
            }
        }
    }

    public void updateFrequency(float amount) {
        this.untilFrequencyChange -= amount * this.params.frequencyChangeMult;
        if (this.untilFrequencyChange <= 0.0f) {
            this.untilFrequencyChange = 1.0f + (float)Math.random() * 3.0f;
            this.frequencyMult = this.params.frequencyMultMin * (float)Math.random() * (this.params.frequencyMultMax - this.params.frequencyMultMin);
        }
    }

    Object readResolve() {
        this.glow = Global.getSettings().getSprite("campaignEntities", "abyssal_light_glow");
        return this;
    }

    public AbyssalLightParams getParams() {
        return this.params;
    }

    public void advance(float amount) {
        float brightness;
        AbyssalLightBonus bonus;
        float dist;
        float range;
        if (this.isDespawning()) {
            if (!this.playedDespawnSound && (this.getDespawnProgress() > DESPAWN_POOF_THRESHOLD || this.despawnType == DespawnType.FADE_OUT)) {
                SectorEntityToken.VisibilityLevel level;
                this.playedDespawnSound = true;
                if (this.entity.isInCurrentLocation() && ((level = this.entity.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS)) {
                    String soundId = "abyssal_light_despawn_disrupted";
                    if (this.despawnType == DespawnType.FADE_OUT) {
                        soundId = "abyssal_light_despawn_expired";
                    }
                    Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, this.entity.getLocation(), Misc.ZERO);
                }
            }
            return;
        }
        float days = Misc.getDays(amount);
        this.params.durationDays -= days;
        if (this.params.durationDays <= 0.0f || Misc.getAbyssalDepth(this.entity) < 1.0f) {
            this.despawn(DespawnType.FADE_OUT);
            return;
        }
        this.updateFrequency(amount);
        this.updateSoundDelayAndPlaySound(amount);
        this.phase += amount * GLOW_FREQUENCY * this.frequencyMult;
        while (this.phase > 1.0f) {
            this.phase -= 1.0f;
        }
        if (this.flickerDur > 0.0f) {
            this.flickerDur -= amount;
            if (this.flickerDur < 0.0f) {
                this.flickerDur = 0.0f;
            }
        }
        this.flicker.advance(amount * 10.0f);
        this.fader.advance(amount);
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean("$interdictionPulseJustUsed")) {
            if (this.entity.getContainingLocation() != null) {
                for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                    range = InterdictionPulseAbility.getRange(fleet);
                    dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation());
                    if (dist > range || !fleet.getMemoryWithoutUpdate().getBoolean("$justDidInterdictionPulse")) continue;
                    bonus = AbyssalLightBonus.get(fleet);
                    brightness = AbyssalLightEntityPlugin.getProximityBasedBrightnessFactor(fleet, this.entity.getLocation());
                    bonus.addBurnBonus(this.params.bonusMult * brightness);
                    if (fleet.isPlayerFleet()) {
                        bonus.addTopographyPoints(this.params.getTopographyPoints());
                    }
                    this.despawn(DespawnType.EXPAND);
                }
            }
            if (this.isDespawning()) {
                return;
            }
        }
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean("$sensorBurstJustUsed")) {
            if (this.entity.getContainingLocation() != null) {
                for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                    range = 500.0f + fleet.getRadius() + this.entity.getRadius();
                    dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation());
                    if (dist > range || !fleet.getMemoryWithoutUpdate().getBoolean("$justDidSensorBurst")) continue;
                    bonus = AbyssalLightBonus.get(fleet);
                    brightness = AbyssalLightEntityPlugin.getProximityBasedBrightnessFactor(fleet, this.entity.getLocation());
                    bonus.addSensorBonus(this.params.bonusMult * brightness);
                    if (fleet.isPlayerFleet()) {
                        bonus.addTopographyPoints(this.params.getTopographyPoints());
                    }
                    this.despawn(DespawnType.EXPAND);
                }
            }
            if (this.isDespawning()) {
                return;
            }
        }
    }

    public float getFlickerBasedMult() {
        if (this.flickerDur <= 0.0f) {
            return 1.0f;
        }
        float mult = 1.0f;
        if (this.flickerDur < 1.0f) {
            mult = this.flickerDur;
        }
        float f = 1.0f - this.flicker.getBrightness() * (mult *= 0.25f);
        return f;
    }

    public float getGlowAlpha() {
        float glowAlpha = 0.0f;
        if (this.phase < 0.5f) {
            glowAlpha = this.phase * 2.0f;
        }
        if (this.phase >= 0.5f) {
            glowAlpha = 1.0f - (this.phase - 0.5f) * 2.0f;
        }
        if ((glowAlpha = 0.75f + glowAlpha * 0.25f) < 0.0f) {
            glowAlpha = 0.0f;
        }
        if (glowAlpha > 1.0f) {
            glowAlpha = 1.0f;
        }
        return glowAlpha;
    }

    public float getRenderRange() {
        return this.entity.getRadius() + this.params.size * 0.75f;
    }

    public float getDespawnProgress() {
        if (!this.isDespawning()) {
            return 0.0f;
        }
        float f = this.entity.getSensorFaderBrightness();
        return 1.0f - f;
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        SectorEntityToken.VisibilityLevel level;
        float alphaMult = viewport.getAlphaMult();
        if (!this.isDespawning() || this.despawnType == DespawnType.FADE_OUT) {
            alphaMult *= this.entity.getSensorFaderBrightness();
        }
        if (alphaMult <= 0.0f) {
            return;
        }
        float f = this.getDespawnProgress();
        if (this.despawnType == DespawnType.FADE_OUT) {
            f = 0.0f;
        }
        if (f > DESPAWN_POOF_THRESHOLD) {
            float fadeOut = (1.0f - f) / (1.0f - DESPAWN_POOF_THRESHOLD);
            alphaMult *= fadeOut;
        }
        if ((level = this.entity.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS) {
            this.fader.fadeIn();
        } else {
            this.fader.fadeOut();
        }
        alphaMult *= this.fader.getBrightness();
        float b = AbyssalLightEntityPlugin.getPlayerProximityBasedBrightnessFactor(this.entity);
        alphaMult *= b;
        CustomEntitySpecAPI spec = this.entity.getCustomEntitySpec();
        if (spec == null) {
            return;
        }
        float w = spec.getSpriteWidth();
        float h = spec.getSpriteHeight();
        Vector2f loc = this.entity.getLocation();
        float glowAlpha = this.getGlowAlpha();
        this.glow.setColor(this.params.color);
        w = this.params.size;
        h = this.params.size;
        float scale = 0.25f + alphaMult * 0.75f;
        if (f > DESPAWN_POOF_THRESHOLD) {
            scale *= 1.5f;
        }
        float fringeScale = 1.0f;
        this.glow.setAdditiveBlend();
        if (layer == CampaignEngineLayers.TERRAIN_8) {
            this.glow.setAlphaMult(alphaMult * glowAlpha * 0.5f);
            this.glow.setSize(w * scale * fringeScale, h * scale * fringeScale);
            this.glow.renderAtCenter(loc.x, loc.y);
        }
        if (layer == CampaignEngineLayers.STATIONS) {
            if (f > 0.0f) {
                float extra = 1.0f + f * 1.33f;
                if (f > DESPAWN_POOF_THRESHOLD) {
                    extra = 0.0f;
                }
                scale *= extra;
            }
            float flicker = this.getFlickerBasedMult();
            int i = 0;
            while (i < 5) {
                if (i != 0) {
                    flicker = 1.0f;
                }
                this.glow.setSize((w *= 0.3f) * scale, (h *= 0.3f) * scale);
                this.glow.setAlphaMult(alphaMult * glowAlpha * 0.67f * flicker);
                this.glow.renderAtCenter(loc.x, loc.y);
                ++i;
            }
        }
    }

    public static float getPlayerProximityBasedBrightnessFactor(SectorEntityToken entity) {
        return AbyssalLightEntityPlugin.getPlayerProximityBasedBrightnessFactor(entity.getLocation());
    }

    public static float getPlayerProximityBasedBrightnessFactor(Vector2f loc) {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return PLAYER_PROXIMITY_MIN_BRIGHTNESS;
        }
        return AbyssalLightEntityPlugin.getProximityBasedBrightnessFactor(player, loc);
    }

    public static float getProximityBasedBrightnessFactor(CampaignFleetAPI from, Vector2f loc) {
        float dist = Misc.getDistance(from.getLocation(), loc) - from.getRadius();
        if (dist <= PLAYER_PROXIMITY_MAX_BRIGHTNESS_AT) {
            return 1.0f;
        }
        float f = 1.0f - (dist -= PLAYER_PROXIMITY_MAX_BRIGHTNESS_AT) / (PLAYER_PROXIMITY_MIN_BRIGHTNESS_AT - PLAYER_PROXIMITY_MAX_BRIGHTNESS_AT);
        if (f < 0.0f) {
            f = 0.0f;
        }
        float b = PLAYER_PROXIMITY_MIN_BRIGHTNESS + f * (1.0f - PLAYER_PROXIMITY_MIN_BRIGHTNESS);
        return b;
    }

    public static class AbyssalLightParams {
        public Color color = new Color(200, 200, 255, 255);
        public float frequencyMultMin = 0.5f;
        public float frequencyMultMax = 1.5f;
        public float frequencyChangeMult = 1.0f;
        public float size;
        public float detectedRange;
        public float bonusMult;
        public float durationDays;
        public int pointsOverride = 0;

        public AbyssalLightParams() {
            this(MIN_SIZE, MAX_SIZE);
        }

        public AbyssalLightParams(float minSize, float maxSize) {
            float sizeRange = maxSize - minSize;
            float avgSize = MIN_SIZE + (MAX_SIZE - MIN_SIZE) * 0.5f;
            this.size = minSize + (float)Math.random() * sizeRange;
            this.detectedRange = this.size * 3.0f / HyperspaceTerrainPlugin.ABYSS_SENSOR_RANGE_MULT;
            this.bonusMult = this.size / avgSize;
            this.durationDays = MIN_DURATION + (MAX_DURATION - MIN_DURATION) * (float)Math.random();
        }

        public int getTopographyPoints() {
            if (this.pointsOverride > 0) {
                return this.pointsOverride;
            }
            return Math.round((float)HTPoints.ABYSSAL_LIGHT_MIN + (float)(HTPoints.ABYSSAL_LIGHT_AVG - HTPoints.ABYSSAL_LIGHT_MIN) * this.bonusMult);
        }
    }

    public static class AbyssalLightSoundStopper
    implements EveryFrameScript {
        protected transient SoundAPI sound = null;
        protected float elapsed = 0.0f;

        public AbyssalLightSoundStopper(SoundAPI sound) {
            this.sound = sound;
        }

        public boolean isDone() {
            return this.sound == null;
        }

        public boolean runWhilePaused() {
            return true;
        }

        public void advance(float amount) {
            this.elapsed += amount;
            if (this.sound == null) {
                return;
            }
            if (!this.sound.isPlaying() && this.elapsed > 1.0f) {
                this.sound = null;
                return;
            }
            if (Global.getSector().isPaused() && this.sound != null) {
                this.sound.stop();
                this.sound = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DespawnType {
        FADE_OUT,
        EXPAND;

    }
}

