/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BattleAutoresolverPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CombatDamageData;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleAutoresolverPluginImpl
implements BattleAutoresolverPlugin {
    protected CampaignFleetAPI one;
    protected CampaignFleetAPI two;
    protected final BattleAPI battle;
    protected boolean playerPursuitAutoresolveMode = false;
    protected List<FleetMemberAPI> playerShipsToDeploy;
    protected static boolean report = false;
    protected EngagementResultAPI result;
    protected FleetEncounterContext context;

    public BattleAutoresolverPluginImpl(BattleAPI battle) {
        this.battle = battle;
        this.one = battle.getCombinedOne();
        this.two = battle.getCombinedTwo();
        if (battle.isPlayerInvolved()) {
            this.one = battle.getPlayerCombined();
            this.two = battle.getNonPlayerCombined();
        }
        this.setReport(Global.getSettings().isDevMode());
        this.setReport(false);
    }

    @Override
    public void resolve() {
        BattleAutoresolverPluginImpl.report("***");
        BattleAutoresolverPluginImpl.report("***");
        BattleAutoresolverPluginImpl.report(String.format("Autoresolving %s vs %s", this.one.getNameWithFaction(), this.two.getNameWithFaction()));
        this.context = new FleetEncounterContext();
        this.context.setAutoresolve(true);
        this.context.setBattle(this.battle);
        CampaignFleetAIAPI.EncounterOption optionOne = this.one.getAI().pickEncounterOption(this.context, this.two);
        CampaignFleetAIAPI.EncounterOption optionTwo = this.two.getAI().pickEncounterOption(this.context, this.one);
        if (optionOne == CampaignFleetAIAPI.EncounterOption.DISENGAGE && optionTwo == CampaignFleetAIAPI.EncounterOption.DISENGAGE) {
            BattleAutoresolverPluginImpl.report("Both fleets want to disengage");
            BattleAutoresolverPluginImpl.report("Finished autoresolving engagement");
            BattleAutoresolverPluginImpl.report("***");
            BattleAutoresolverPluginImpl.report("***");
            return;
        }
        boolean oneEscaping = false;
        boolean twoEscaping = false;
        boolean freeDisengageIfCanOutrun = false;
        if (optionOne == CampaignFleetAIAPI.EncounterOption.DISENGAGE && optionTwo == CampaignFleetAIAPI.EncounterOption.ENGAGE) {
            BattleAutoresolverPluginImpl.report(String.format("%s \u60f3\u8981\u9003\u8131", this.one.getNameWithFaction()));
            oneEscaping = true;
            if (freeDisengageIfCanOutrun && this.context.canOutrunOtherFleet(this.one, this.two)) {
                BattleAutoresolverPluginImpl.report(String.format("%s \u80fd\u8d85\u8fc7\u5176\u4ed6\u8230\u961f", this.one.getNameWithFaction()));
                BattleAutoresolverPluginImpl.report("Finished autoresolving engagement");
                BattleAutoresolverPluginImpl.report("***");
                BattleAutoresolverPluginImpl.report("***");
                return;
            }
        }
        if (optionOne == CampaignFleetAIAPI.EncounterOption.ENGAGE && optionTwo == CampaignFleetAIAPI.EncounterOption.DISENGAGE) {
            BattleAutoresolverPluginImpl.report(String.format("%s \u60f3\u8981\u9003\u8131", this.two.getNameWithFaction()));
            twoEscaping = true;
            if (freeDisengageIfCanOutrun && this.context.canOutrunOtherFleet(this.two, this.one)) {
                BattleAutoresolverPluginImpl.report(String.format("%s \u80fd\u8d85\u8fc7\u5176\u4ed6\u8230\u961f", this.two.getNameWithFaction()));
                BattleAutoresolverPluginImpl.report("Finished autoresolving engagement");
                BattleAutoresolverPluginImpl.report("***");
                BattleAutoresolverPluginImpl.report("***");
                return;
            }
        }
        this.resolveEngagement(this.context, oneEscaping, twoEscaping);
        BattleAutoresolverPluginImpl.report("");
        BattleAutoresolverPluginImpl.report("Finished autoresolving engagement");
        BattleAutoresolverPluginImpl.report("***");
        BattleAutoresolverPluginImpl.report("***");
    }

    public void resolvePlayerPursuit(FleetEncounterContext context, List<FleetMemberAPI> playerShipsToDeploy) {
        this.context = context;
        this.playerPursuitAutoresolveMode = true;
        this.playerShipsToDeploy = playerShipsToDeploy;
        this.resolveEngagement(context, false, true);
    }

    protected void resolveEngagement(FleetEncounterContext context, boolean oneEscaping, boolean twoEscaping) {
        float winnerAdvantage;
        FleetAutoresolveData loser;
        FleetAutoresolveData winner;
        FleetAutoresolveData dataOne = this.computeDataForFleet(this.one);
        FleetAutoresolveData dataTwo = this.computeDataForFleet(this.two);
        if (dataOne.fightingStrength <= 0.0f && dataTwo.fightingStrength <= 0.0f) {
            return;
        }
        if (dataOne.fightingStrength <= 0.1f) {
            dataOne.fightingStrength = 0.1f;
        }
        if (dataTwo.fightingStrength <= 0.1f) {
            dataTwo.fightingStrength = 0.1f;
        }
        BattleAutoresolverPluginImpl.report("");
        BattleAutoresolverPluginImpl.report("--------------------------------------------");
        dataOne.report();
        BattleAutoresolverPluginImpl.report("");
        BattleAutoresolverPluginImpl.report("--------------------------------------------");
        dataTwo.report();
        BattleAutoresolverPluginImpl.report("");
        BattleAutoresolverPluginImpl.report("");
        boolean loserEscaping = false;
        if ((dataOne.fightingStrength > dataTwo.fightingStrength || twoEscaping) && !oneEscaping) {
            BattleAutoresolverPluginImpl.report(String.format("%s \u8d62\u5f97\u4ea4\u6218", this.one.getNameWithFaction()));
            winner = dataOne;
            loser = dataTwo;
            if (twoEscaping) {
                loserEscaping = true;
            }
        } else {
            BattleAutoresolverPluginImpl.report(String.format("%s \u8d62\u5f97\u4ea4\u6218", this.two.getNameWithFaction()));
            winner = dataTwo;
            loser = dataOne;
            if (oneEscaping) {
                loserEscaping = true;
            }
        }
        if ((winnerAdvantage = winner.fightingStrength / loser.fightingStrength) > 10.0f) {
            winnerAdvantage = 10.0f;
        }
        if (winnerAdvantage < 0.1f) {
            winnerAdvantage = 0.1f;
        }
        float damageDealtToWinner = loser.fightingStrength / winnerAdvantage;
        float damageDealtToLoser = winner.fightingStrength * winnerAdvantage;
        if (this.playerPursuitAutoresolveMode) {
            damageDealtToWinner = 0.0f;
        }
        float damMult = Global.getSettings().getFloat("autoresolveDamageMult");
        damageDealtToWinner *= damMult;
        damageDealtToLoser *= damMult;
        this.result = new EngagementResultImpl(context.getBattle(), context.getBattle().getCombinedFor(winner.fleet), context.getBattle().getCombinedFor(loser.fleet));
        BattleAutoresolverPluginImpl.report("");
        BattleAutoresolverPluginImpl.report("Applying damage to loser's ships");
        BattleAutoresolverPluginImpl.report("--------------------------------------------");
        Collections.shuffle(loser.members);
        for (FleetMemberAutoresolveData data : loser.members) {
            BattleAutoresolverPluginImpl.report(String.format("Remaining damage to loser: %02.2f", Float.valueOf(damageDealtToLoser)));
            FleetMemberBattleOutcome outcome = this.computeOutcomeForFleetMember(data, 1.0f / winnerAdvantage, damageDealtToLoser, loserEscaping, false);
            damageDealtToLoser -= data.strength;
            if (!(damageDealtToLoser < 0.0f)) continue;
            damageDealtToLoser = 0.0f;
        }
        for (FleetMemberAutoresolveData data : loser.members) {
            if (data.member.getStatus().getHullFraction() > 0.0f) {
                this.result.getLoserResult().getRetreated().add(data.member);
                continue;
            }
            this.result.getLoserResult().getDisabled().add(data.member);
        }
        BattleAutoresolverPluginImpl.report("");
        BattleAutoresolverPluginImpl.report("Applying damage to winner's ships");
        BattleAutoresolverPluginImpl.report("--------------------------------------------");
        Collections.shuffle(winner.members);
        boolean winnerCarrierLeft = false;
        for (FleetMemberAutoresolveData data : winner.members) {
            if (!data.combatReady) continue;
            BattleAutoresolverPluginImpl.report(String.format("Remaining damage to winner: %02.2f", Float.valueOf(damageDealtToWinner)));
            FleetMemberBattleOutcome outcome = this.computeOutcomeForFleetMember(data, winnerAdvantage, damageDealtToWinner, false, loserEscaping);
            damageDealtToWinner -= data.strength;
            if (damageDealtToWinner < 0.0f) {
                damageDealtToWinner = 0.0f;
            }
            if (data.member.isMothballed() || !(data.member.getStatus().getHullFraction() > 0.0f) || data.member.getNumFlightDecks() <= 0) continue;
            winnerCarrierLeft = true;
        }
        float deployedStrength = 0.0f;
        float maxDeployedStrength = loser.fightingStrength * 2.0f;
        for (FleetMemberAutoresolveData data : winner.members) {
            if (data.member.getStatus().getHullFraction() > 0.0f || data.member.isFighterWing() && winnerCarrierLeft) continue;
            deployedStrength += data.strength;
        }
        for (FleetMemberAutoresolveData data : winner.members) {
            if (this.playerPursuitAutoresolveMode) {
                if (this.playerShipsToDeploy.contains(data.member) || data.member.isAlly()) {
                    this.result.getWinnerResult().getDeployed().add(data.member);
                    continue;
                }
                this.result.getWinnerResult().getReserves().add(data.member);
                continue;
            }
            if (data.member.getStatus().getHullFraction() > 0.0f) {
                if (deployedStrength < maxDeployedStrength) {
                    this.result.getWinnerResult().getDeployed().add(data.member);
                    deployedStrength += data.strength;
                    continue;
                }
                this.result.getWinnerResult().getReserves().add(data.member);
                continue;
            }
            this.result.getWinnerResult().getDisabled().add(data.member);
        }
        ((EngagementResultForFleetImpl)this.result.getWinnerResult()).setGoal(FleetGoal.ATTACK);
        ((EngagementResultForFleetImpl)this.result.getWinnerResult()).setWinner(true);
        if (loserEscaping) {
            ((EngagementResultForFleetImpl)this.result.getLoserResult()).setGoal(FleetGoal.ESCAPE);
        } else {
            ((EngagementResultForFleetImpl)this.result.getLoserResult()).setGoal(FleetGoal.ATTACK);
        }
        ((EngagementResultForFleetImpl)this.result.getLoserResult()).setWinner(false);
        if (!this.playerPursuitAutoresolveMode) {
            context.processEngagementResults(this.result);
            context.performPostVictoryRecovery(this.result);
            context.getDataFor(winner.fleet).setDisengaged(false);
            context.getDataFor(winner.fleet).setWonLastEngagement(true);
            context.getDataFor(winner.fleet).setLastGoal(FleetGoal.ATTACK);
            context.getDataFor(loser.fleet).setDisengaged(true);
            context.getDataFor(loser.fleet).setWonLastEngagement(false);
            context.getDataFor(loser.fleet).setLastGoal(FleetGoal.ESCAPE);
            if (!winner.fleet.isAIMode()) {
                context.generateLoot(null, true);
                context.autoLoot();
                context.recoverCrew(winner.fleet);
            }
            context.applyAfterBattleEffectsIfThereWasABattle();
        } else {
            for (FleetMemberAutoresolveData data : loser.members) {
                data.member.setOwner(1);
            }
        }
    }

    public static void applyDamageToFleetMember(FleetMemberAPI member, float hullFraction) {
        if (member.isFighterWing()) {
            return;
        }
        if (hullFraction <= 0.0f) {
            return;
        }
        float num = member.getStatus().getNumStatuses();
        boolean someActiveRemaining = false;
        int i = 0;
        while ((float)i < num) {
            ShipVariantAPI variant = member.getVariant();
            if (i > 0) {
                String slotId = member.getVariant().getModuleSlots().get(i - 1);
                variant = variant.getModuleVariant(slotId);
            }
            if (variant.hasHullMod("vastbulk")) {
                float dam = Math.min(hullFraction, 0.9f);
                float hits = Math.min(5.0f, dam / 0.1f);
                if (hits < 1.0f) {
                    hits = 1.0f;
                }
                int j = 0;
                while ((float)j < hits) {
                    member.getStatus().applyHullFractionDamage(dam / hits, i);
                    member.getStatus().setHullFraction(i, 1.0f);
                    ++j;
                }
            } else if (i <= 0 || Misc.isActiveModule(variant)) {
                float damage;
                float damageMult = 1.0f;
                if (i > 0) {
                    damageMult = (float)Math.random();
                    damageMult *= 2.0f;
                }
                if (!((damage = hullFraction * damageMult) <= 0.0f)) {
                    member.getStatus().applyHullFractionDamage(damage, i);
                    float hits = Math.min(5.0f, damage / 0.1f);
                    if (hits < 1.0f) {
                        hits = 1.0f;
                    }
                    int j = 0;
                    while ((float)j < hits) {
                        member.getStatus().applyHullFractionDamage(damage / hits + 0.001f, i);
                        ++j;
                    }
                    if (i > 0 && member.getStatus().getHullFraction(i) <= 0.0f) {
                        member.getStatus().setDetached(i, true);
                    }
                    if (Misc.isActiveModule(variant) && (!member.getStatus().isDetached(i) || member.getStatus().getHullFraction(i) > 0.0f)) {
                        someActiveRemaining = true;
                    }
                }
            }
            ++i;
        }
        if (num > 1.0f) {
            float dist;
            float farthestDetached = 0.0f;
            int i2 = 1;
            while ((float)i2 < num) {
                ShipVariantAPI variant = member.getVariant();
                if (member.getStatus().isDetached(i2)) {
                    WeaponSlotAPI slot;
                    String slotId = variant.getModuleSlots().get(i2 - 1);
                    ShipVariantAPI mv = member.getVariant().getModuleVariant(slotId);
                    if (Misc.isActiveModule(mv) && (dist = (slot = variant.getHullSpec().getWeaponSlotAPI(slotId)).getLocation().length()) > farthestDetached) {
                        farthestDetached = dist;
                    }
                }
                ++i2;
            }
            i2 = 1;
            while ((float)i2 < num) {
                ShipVariantAPI variant = member.getVariant();
                if (!member.getStatus().isDetached(i2)) {
                    WeaponSlotAPI slot;
                    String slotId = variant.getModuleSlots().get(i2 - 1);
                    ShipVariantAPI mv = member.getVariant().getModuleVariant(slotId);
                    if (!mv.hasHullMod("vastbulk") && !Misc.isActiveModule(mv) && (dist = (slot = variant.getHullSpec().getWeaponSlotAPI(slotId)).getLocation().length()) <= farthestDetached + 200.0f) {
                        member.getStatus().setHullFraction(i2, 0.0f);
                        member.getStatus().setDetached(i2, true);
                    }
                }
                ++i2;
            }
        }
        if (!someActiveRemaining || hullFraction >= 1.0f) {
            i = 0;
            while ((float)i < num) {
                member.getStatus().setHullFraction(i, 0.0f);
                if (i > 0) {
                    member.getStatus().setDetached(i, true);
                }
                ++i;
            }
        }
    }

    protected FleetMemberBattleOutcome computeOutcomeForFleetMember(FleetMemberAutoresolveData data, float advantageInBattle, float maxDamage, boolean escaping, boolean enemyEscaping) {
        ShipHullSpecAPI hullSpec = data.member.getHullSpec();
        float unscathed = 1.0f;
        float lightDamage = 0.0f;
        float mediumDamage = 0.0f;
        float heavyDamage = 0.0f;
        float disabled = 0.0f;
        switch (hullSpec.getHullSize()) {
            case CAPITAL_SHIP: {
                unscathed = 5.0f;
                break;
            }
            case CRUISER: {
                unscathed = 10.0f;
                break;
            }
            case DESTROYER: {
                unscathed = 15.0f;
                break;
            }
            case FIGHTER: 
            case FRIGATE: {
                unscathed = 30.0f;
            }
        }
        float maxDamageRatio = maxDamage / data.strength;
        if (maxDamageRatio > 1.0f) {
            maxDamageRatio = 1.0f;
        }
        if (maxDamageRatio <= 0.0f) {
            maxDamageRatio = 0.0f;
        }
        if (maxDamageRatio >= 0.8f) {
            disabled = 20.0f;
            heavyDamage = 10.0f;
            mediumDamage = 10.0f;
            lightDamage = 5.0f;
        } else if (maxDamageRatio >= 0.6f) {
            disabled = 5.0f;
            heavyDamage = 20.0f;
            mediumDamage = 10.0f;
            lightDamage = 5.0f;
        } else if (maxDamageRatio >= 0.4f) {
            disabled = 0.0f;
            heavyDamage = 10.0f;
            mediumDamage = 20.0f;
            lightDamage = 10.0f;
        } else if (maxDamageRatio >= 0.2f) {
            disabled = 0.0f;
            heavyDamage = 0.0f;
            mediumDamage = 10.0f;
            lightDamage = 20.0f;
        } else if (maxDamageRatio > 0.0f) {
            disabled = 0.0f;
            heavyDamage = 0.0f;
            mediumDamage = 5.0f;
            lightDamage = 10.0f;
        }
        if (escaping) {
            unscathed *= 2.0f;
            lightDamage *= 1.5f;
        }
        if (enemyEscaping) {
            disabled *= 0.5f;
            heavyDamage *= 0.6f;
            mediumDamage *= 0.7f;
            lightDamage *= 0.8f;
            unscathed *= 1.0f;
        }
        unscathed *= advantageInBattle;
        lightDamage *= advantageInBattle;
        float shieldRatio = data.shieldRatio;
        disabled *= 1.5f - shieldRatio * 1.0f;
        heavyDamage *= 1.4f - shieldRatio * 0.8f;
        mediumDamage *= 1.3f - shieldRatio * 0.6f;
        lightDamage *= 1.2f - shieldRatio * 0.4f;
        unscathed *= 0.9f + shieldRatio * 0.2f;
        if (data.member.isStation()) {
            heavyDamage += disabled;
            disabled = 0.0f;
        }
        WeightedRandomPicker<FleetMemberBattleOutcome> picker = new WeightedRandomPicker<FleetMemberBattleOutcome>();
        picker.add(FleetMemberBattleOutcome.DISABLED, disabled);
        picker.add(FleetMemberBattleOutcome.HEAVY_DAMAGE, heavyDamage);
        picker.add(FleetMemberBattleOutcome.MEDIUM_DAMAGE, mediumDamage);
        picker.add(FleetMemberBattleOutcome.LIGHT_DAMAGE, lightDamage);
        picker.add(FleetMemberBattleOutcome.UNSCATHED, unscathed);
        BattleAutoresolverPluginImpl.report(String.format("Disabled: %d, Heavy: %d, Medium: %d, Light: %d, Unscathed: %d (Shield ratio: %3.2f)", (int)disabled, (int)heavyDamage, (int)mediumDamage, (int)lightDamage, (int)unscathed, Float.valueOf(shieldRatio)));
        FleetMemberBattleOutcome outcome = (FleetMemberBattleOutcome)((Object)picker.pick());
        float damage = 0.0f;
        data.member.getStatus().resetDamageTaken();
        switch (outcome) {
            case DISABLED: {
                BattleAutoresolverPluginImpl.report(String.format("%40s: \u505c\u7528", data.member.getVariant().getFullDesignationWithHullName()));
                damage = 1.0f;
                break;
            }
            case HEAVY_DAMAGE: {
                BattleAutoresolverPluginImpl.report(String.format("%40s: \u4e25\u91cd\u635f\u574f", data.member.getVariant().getFullDesignationWithHullName()));
                damage = 0.7f + (float)Math.random() * 0.1f;
                break;
            }
            case MEDIUM_DAMAGE: {
                BattleAutoresolverPluginImpl.report(String.format("%40s: \u4e2d\u7b49\u635f\u574f", data.member.getVariant().getFullDesignationWithHullName()));
                damage = 0.45f + (float)Math.random() * 0.1f;
                break;
            }
            case LIGHT_DAMAGE: {
                BattleAutoresolverPluginImpl.report(String.format("%40s: \u8f7b\u5fae\u635f\u574f", data.member.getVariant().getFullDesignationWithHullName()));
                damage = 0.2f + (float)Math.random() * 0.1f;
                break;
            }
            case UNSCATHED: {
                BattleAutoresolverPluginImpl.report(String.format("%40s: \u6beb\u53d1\u65e0\u635f", data.member.getVariant().getFullDesignationWithHullName()));
                damage = 0.0f;
            }
        }
        BattleAutoresolverPluginImpl.applyDamageToFleetMember(data.member, damage);
        return outcome;
    }

    protected FleetAutoresolveData computeDataForFleet(CampaignFleetAPI fleet) {
        FleetAutoresolveData fleetData = new FleetAutoresolveData();
        fleetData.fleet = fleet;
        fleetData.fightingStrength = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            boolean okToDeployIfInPlayerPursuit;
            FleetMemberAutoresolveData data = this.computeDataForMember(member);
            fleetData.members.add(data);
            boolean bl = okToDeployIfInPlayerPursuit = this.playerPursuitAutoresolveMode && this.playerShipsToDeploy != null && fleet == this.one && (this.playerShipsToDeploy.contains(member) || member.isAlly());
            if (!data.combatReady || this.playerPursuitAutoresolveMode && fleet == this.one && !okToDeployIfInPlayerPursuit) continue;
            float mult = 1.0f;
            if (this.playerShipsToDeploy != null && this.playerShipsToDeploy.contains(member)) {
                mult = 8.0f;
            }
            fleetData.fightingStrength += data.strength * mult;
        }
        return fleetData;
    }

    protected FleetMemberAutoresolveData computeDataForMember(FleetMemberAPI member) {
        FleetMemberAutoresolveData data = new FleetMemberAutoresolveData();
        data.member = member;
        ShipHullSpecAPI hullSpec = data.member.getHullSpec();
        if (member.isCivilian() && !this.playerPursuitAutoresolveMode || !member.canBeDeployedForCombat()) {
            data.strength = 0.25f;
            if (hullSpec.getShieldType() != ShieldAPI.ShieldType.NONE) {
                data.shieldRatio = 0.5f;
            }
            data.combatReady = false;
            return data;
        }
        data.combatReady = true;
        MutableShipStatsAPI stats = data.member.getStats();
        float normalizedHullStr = stats.getHullBonus().computeEffective(hullSpec.getHitpoints()) + stats.getArmorBonus().computeEffective(hullSpec.getArmorRating()) * 10.0f;
        float normalizedShieldStr = stats.getFluxCapacity().getModifiedValue() + stats.getFluxDissipation().getModifiedValue() * 10.0f;
        if (hullSpec.getShieldType() == ShieldAPI.ShieldType.NONE) {
            normalizedShieldStr = 0.0f;
        } else {
            float shieldFluxPerDamage = hullSpec.getBaseShieldFluxPerDamageAbsorbed();
            if ((shieldFluxPerDamage *= stats.getShieldAbsorptionMult().getModifiedValue() * stats.getShieldDamageTakenMult().getModifiedValue()) < 0.1f) {
                shieldFluxPerDamage = 0.1f;
            }
            float shieldMult = 1.0f / shieldFluxPerDamage;
            normalizedShieldStr *= shieldMult;
        }
        if (normalizedHullStr < 1.0f) {
            normalizedHullStr = 1.0f;
        }
        if (normalizedShieldStr < 1.0f) {
            normalizedShieldStr = 1.0f;
        }
        data.shieldRatio = normalizedShieldStr / (normalizedShieldStr + normalizedHullStr);
        if (member.isStation()) {
            data.shieldRatio = 0.5f;
        }
        float strength = Misc.getMemberStrength(member, true, true, true);
        data.strength = Math.max(strength *= 0.85f + 0.3f * (float)Math.random(), 0.25f);
        return data;
    }

    protected static void report(String str) {
        if (report) {
            System.out.println(str);
        }
    }

    public void setReport(boolean report) {
        BattleAutoresolverPluginImpl.report = report;
    }

    public EngagementResultAPI getResult() {
        return this.result;
    }

    @Override
    public FleetEncounterContextPlugin getContext() {
        return this.context;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EngagementResultForFleetImpl
    implements EngagementResultForFleetAPI {
        public CampaignFleetAPI fleet;
        public FleetGoal goal;
        public boolean winner = false;
        public List<FleetMemberAPI> deployed = new ArrayList<FleetMemberAPI>();
        public List<FleetMemberAPI> reserves = new ArrayList<FleetMemberAPI>();
        public List<FleetMemberAPI> destroyed = new ArrayList<FleetMemberAPI>();
        public List<FleetMemberAPI> disabled = new ArrayList<FleetMemberAPI>();
        public List<FleetMemberAPI> retreated = new ArrayList<FleetMemberAPI>();

        public EngagementResultForFleetImpl(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }

        @Override
        public List<FleetMemberAPI> getDeployed() {
            return this.deployed;
        }

        @Override
        public List<FleetMemberAPI> getDestroyed() {
            return this.destroyed;
        }

        @Override
        public List<FleetMemberAPI> getDisabled() {
            return this.disabled;
        }

        @Override
        public CampaignFleetAPI getFleet() {
            return this.fleet;
        }

        @Override
        public FleetGoal getGoal() {
            return this.goal;
        }

        @Override
        public List<FleetMemberAPI> getReserves() {
            return this.reserves;
        }

        @Override
        public List<FleetMemberAPI> getRetreated() {
            return this.retreated;
        }

        @Override
        public List<DeployedFleetMemberAPI> getAllEverDeployedCopy() {
            return null;
        }

        @Override
        public boolean isWinner() {
            return this.winner;
        }

        public void setWinner(boolean winner) {
            this.winner = winner;
        }

        @Override
        public void resetAllEverDeployed() {
        }

        @Override
        public void setGoal(FleetGoal goal) {
            this.goal = goal;
        }

        @Override
        public boolean isPlayer() {
            return false;
        }

        @Override
        public boolean enemyCanCleanDisengage() {
            return false;
        }
    }

    public static class EngagementResultImpl
    implements EngagementResultAPI {
        public BattleAPI battle;
        public EngagementResultForFleetImpl winnerResult;
        public EngagementResultForFleetImpl loserResult;

        public EngagementResultImpl(BattleAPI battle, CampaignFleetAPI winner, CampaignFleetAPI loser) {
            this.battle = battle;
            this.winnerResult = new EngagementResultForFleetImpl(winner);
            this.loserResult = new EngagementResultForFleetImpl(loser);
        }

        public BattleAPI getBattle() {
            return this.battle;
        }

        public boolean didPlayerWin() {
            return this.winnerResult.getFleet() != null && Misc.isPlayerOrCombinedContainingPlayer(this.winnerResult.getFleet());
        }

        public EngagementResultForFleetAPI getLoserResult() {
            return this.loserResult;
        }

        public EngagementResultForFleetAPI getWinnerResult() {
            return this.winnerResult;
        }

        public boolean isPlayerOutBeforeEnd() {
            return false;
        }

        public void setPlayerOutBeforeEnd(boolean playerOutBeforeEnd) {
        }

        public void setBattle(BattleAPI battle) {
            this.battle = battle;
        }

        public CombatDamageData getLastCombatDamageData() {
            return null;
        }

        public void setLastCombatDamageData(CombatDamageData lastCombatData) {
        }
    }

    public static class FleetAutoresolveData {
        public CampaignFleetAPI fleet;
        public float fightingStrength;
        public List<FleetMemberAutoresolveData> members = new ArrayList<FleetMemberAutoresolveData>();

        public void report() {
            if (!report) {
                return;
            }
            BattleAutoresolverPluginImpl.report(String.format("\u6218\u6597\u5f3a\u5ea6 %s: %f", this.fleet.getNameWithFaction(), Float.valueOf(this.fightingStrength)));
            for (FleetMemberAutoresolveData data : this.members) {
                String str = String.format("%40s: CR % 3d%%    FP % 4d     STR % 3f   Shield %3.2f", data.member.getVariant().getFullDesignationWithHullName(), (int)(data.member.getRepairTracker().getCR() * 100.0f), data.member.getFleetPointCost(), Float.valueOf(data.strength), Float.valueOf(data.shieldRatio));
                BattleAutoresolverPluginImpl.report("  " + str);
            }
        }
    }

    public static class FleetMemberAutoresolveData {
        public FleetMemberAPI member;
        public float strength;
        public float shieldRatio;
        public boolean combatReady;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FleetMemberBattleOutcome {
        UNSCATHED,
        LIGHT_DAMAGE,
        MEDIUM_DAMAGE,
        HEAVY_DAMAGE,
        DISABLED;

    }
}

