/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class CargoPodsResponse
implements EveryFrameScript {
    public static String PODS_BUSY_REASON = "pods";
    protected IntervalUtil tracker = new IntervalUtil(0.05f, 0.15f);
    protected float elapsed;
    protected CustomCampaignEntityAPI pods;

    public CargoPodsResponse(CustomCampaignEntityAPI pods) {
        this.pods = pods;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        this.elapsed += days;
        if (this.tracker.intervalElapsed()) {
            this.checkResponse();
        }
    }

    public boolean isDone() {
        return this.elapsed >= 3.0f || !this.pods.isAlive() || this.pods.hasTag("non_clickable");
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void checkResponse() {
        List<CampaignFleetAPI> fleets = this.pods.getContainingLocation().getFleets();
        CampaignFleetAPI closest = null;
        float minDist = Float.MAX_VALUE;
        for (CampaignFleetAPI fleet : fleets) {
            float dist;
            if (!this.couldInvestigatePods(fleet) || !((dist = Misc.getDistance(this.pods, fleet)) < minDist)) continue;
            minDist = dist;
            closest = fleet;
        }
        if (closest != null && minDist < 500.0f) {
            this.respond(closest);
            this.elapsed = 10.0f;
        }
    }

    protected float getBaseDur(CampaignFleetAPI fleet) {
        float dur = this.pods.getCargo().getFuel() + this.pods.getCargo().getSpaceUsed() + (float)this.pods.getCargo().getTotalPersonnel();
        return dur /= fleet.getCargo().getMaxCapacity();
    }

    protected void respond(final CampaignFleetAPI fleet) {
        this.unrespond(fleet);
        float dur = this.getBaseDur(fleet);
        dur *= 5.0f;
        if (dur > 1.0f) {
            dur = 1.0f;
        }
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", PODS_BUSY_REASON, true, dur);
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(this.pods.getLocation(), fleet.getLocation()));
        loc.scale(fleet.getRadius() + this.pods.getRadius());
        Vector2f.add((Vector2f)loc, (Vector2f)this.pods.getLocation(), (Vector2f)loc);
        final SectorEntityToken holdLoc = this.pods.getContainingLocation().createToken(loc);
        fleet.addAssignmentAtStart(FleetAssignment.HOLD, holdLoc, dur, "investigating " + this.pods.getName().toLowerCase(), new Script(){

            public void run() {
                Misc.fadeAndExpire(CargoPodsResponse.this.pods);
                fleet.getCargo().addAll(CargoPodsResponse.this.pods.getCargo());
                CargoPodsResponse.this.pods.getCargo().clear();
            }
        });
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(MilitaryResponseScript.RESPONSE_ASSIGNMENT);
        }
        fleet.addScript(new EveryFrameScript(){
            private boolean done = false;

            public boolean runWhilePaused() {
                return false;
            }

            public boolean isDone() {
                return this.done || !Misc.isBusy(fleet) || CargoPodsResponse.this.pods.hasTag("non_clickable") || !CargoPodsResponse.this.pods.isAlive();
            }

            public void advance(float amount) {
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(CargoPodsResponse.this.pods.getLocation(), fleet.getLocation()));
                loc.scale(fleet.getRadius() + CargoPodsResponse.this.pods.getRadius());
                Vector2f.add((Vector2f)loc, (Vector2f)CargoPodsResponse.this.pods.getLocation(), (Vector2f)loc);
                holdLoc.setLocation(loc.x, loc.y);
                if (!CargoPodsResponse.this.pods.isAlive()) {
                    if (Misc.isBusy(fleet)) {
                        CargoPodsResponse.this.unrespond(fleet);
                    }
                    this.done = true;
                }
            }
        });
    }

    protected void unrespond(CampaignFleetAPI fleet) {
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", PODS_BUSY_REASON, false, 0.0f);
        for (FleetAssignmentDataAPI curr : fleet.getAI().getAssignmentsCopy()) {
            if (!MilitaryResponseScript.RESPONSE_ASSIGNMENT.equals(curr.getCustom())) continue;
            fleet.getAI().removeAssignment(curr);
        }
    }

    protected boolean couldInvestigatePods(CampaignFleetAPI fleet) {
        SectorEntityToken.VisibilityLevel level;
        if (fleet.getAI() == null) {
            return false;
        }
        if (fleet.isPlayerFleet()) {
            return false;
        }
        if (!fleet.getMemoryWithoutUpdate().getBoolean("$isPirate")) {
            return false;
        }
        if (fleet.getBattle() != null) {
            return false;
        }
        if (fleet.getMemoryWithoutUpdate().getBoolean("$core_fleetBusy")) {
            return false;
        }
        if (fleet.getAI() instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI ai = (ModularFleetAIAPI)fleet.getAI();
            if (ai.getAssignmentModule().areAssignmentsFrozen()) {
                return false;
            }
            if (ai.isFleeing() || ai.isMaintainingContact()) {
                return false;
            }
            if (ai.isCurrentAssignment(FleetAssignment.INTERCEPT)) {
                return false;
            }
        }
        if ((level = this.pods.getVisibilityLevelTo(fleet)) == SectorEntityToken.VisibilityLevel.NONE) {
            return false;
        }
        if (fleet.getCurrentAssignment() != null && fleet.getCurrentAssignment().getAssignment() == FleetAssignment.GO_TO_LOCATION_AND_DESPAWN) {
            return false;
        }
        float dur = this.getBaseDur(fleet);
        return !(dur < 0.05f);
    }
}

