/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.BaseCampaignObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.econ.CommRelayCondition;
import com.fs.starfarer.api.impl.campaign.intel.misc.CommSnifferIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class CommRelayEntityPlugin
extends BaseCampaignObjectivePlugin {
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        if (this.entity.getContainingLocation() == null || this.entity.isInHyperspace()) {
            return;
        }
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            return;
        }
        for (MarketAPI market : Misc.getMarketsInLocation(this.entity.getContainingLocation())) {
            CommRelayCondition mc = CommRelayCondition.get(market);
            if (mc == null) {
                market.addCondition("comm_relay");
                mc = CommRelayCondition.get(market);
            }
            if (mc == null) continue;
            mc.getRelays().add(this.entity);
        }
        this.checkIntelFromCommSniffer();
    }

    protected boolean isMakeshift() {
        return this.entity.hasTag("makeshift");
    }

    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            text.addPara("\u4e0d\u8fc7\u8be5\u88c5\u7f6e\u5e76\u6ca1\u6709\u8fde\u63a5\u5230\u661f\u57df\u7f51\u7edc\uff0c\u4e5f\u6ca1\u6709\u53d1\u5c04\u51fa\u4e2d\u7eed\u5668\u5de5\u4f5c\u65f6\u7279\u6709\u7684\u8d85\u6ce2\u8f90\u5c04\u3002\u5bfc\u81f4\u5176\u65e0\u6cd5\u5de5\u4f5c\u7684\u539f\u56e0\u5c1a\u4e0d\u6e05\u695a\u3002");
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("\u4f60\u5df2\u7ecf\u6709\u4e00\u4e2a\u901a\u8baf\u55c5\u63a2\u5668\u5728\u8be5\u4e2d\u7ee7\u5668\u4e0a\u8fd0\u884c\u3002");
        }
    }

    public void printEffect(TooltipMakerAPI text, float pad) {
        int bonus = Math.abs(Math.round(CommRelayCondition.COMM_RELAY_BONUS));
        if (this.isMakeshift()) {
            bonus = Math.abs(Math.round(CommRelayCondition.MAKESHIFT_COMM_RELAY_BONUS));
        }
        text.addPara("      %s \u661f\u7cfb\u5185\u6240\u6709\u8005\u52bf\u529b\u6b96\u6c11\u5730\u7684\u7a33\u5b9a\u6027", pad, Misc.getHighlightColor(), "+" + bonus);
    }

    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        int bonus = Math.abs(Math.round(CommRelayCondition.COMM_RELAY_BONUS));
        if (this.isMakeshift()) {
            bonus = Math.abs(Math.round(CommRelayCondition.MAKESHIFT_COMM_RELAY_BONUS));
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("%s \u661f\u7cfb\u5185\u6b96\u6c11\u5730\u7684\u7a33\u5b9a\u6027", pad, Misc.getHighlightColor(), "+" + bonus);
            text.addPara("\u901a\u8baf\u55c5\u63a2\u5668\u5df2\u5b89\u88c5", Misc.getTextColor(), pad);
        } else {
            text.addPara("%s \u661f\u7cfb\u5185\u8be5\u8bbe\u5907\u63a7\u5236\u65b9\u6b96\u6c11\u5730\u7684\u7a33\u5b9a\u6027", pad, Misc.getHighlightColor(), "+" + bonus);
        }
    }

    public void setHacked(boolean hacked) {
        if (hacked) {
            boolean found;
            this.setHacked(hacked, -1.0f);
            boolean bl = found = CommSnifferIntel.getExistingSnifferIntelForRelay(this.entity) != null;
            if (!found) {
                CommSnifferIntel intel = new CommSnifferIntel(this.entity);
                InteractionDialogAPI dialog = Global.getSector().getCampaignUI().getCurrentInteractionDialog();
                if (dialog != null) {
                    Global.getSector().getIntelManager().addIntelToTextPanel(intel, dialog.getTextPanel());
                }
            }
        } else {
            this.setHacked(hacked, -1.0f);
        }
    }

    private void checkIntelFromCommSniffer() {
        if (!this.isHacked().booleanValue()) {
            return;
        }
        boolean playerInRelayRange = Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getCommQueue()) {
            CommSnifferReadableIntel csi;
            if (!(intel instanceof CommSnifferReadableIntel) || !(csi = (CommSnifferReadableIntel)((Object)intel)).canMakeVisibleToCommSniffer(playerInRelayRange, this.entity)) continue;
            intel.setForceAddNextFrame(true);
        }
    }

    public static interface CommSnifferReadableIntel {
        public boolean canMakeVisibleToCommSniffer(boolean var1, SectorEntityToken var2);
    }
}

