/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessageParaAPI;
import com.fs.starfarer.api.campaign.comm.MessageSectionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.RelationshipAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CoreReputationPlugin
implements ReputationActionResponsePlugin {
    public ReputationActionResponsePlugin.ReputationAdjustmentResult handlePlayerReputationAction(Object action, String factionId) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        if (faction == null) {
            return new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        }
        return this.handlePlayerReputationActionInner(action, factionId, null, faction.getRelToPlayer());
    }

    public ReputationActionResponsePlugin.ReputationAdjustmentResult handlePlayerReputationAction(Object action, PersonAPI person) {
        return this.handlePlayerReputationActionInner(action, person.getFaction().getId(), person, person.getRelToPlayer());
    }

    public ReputationActionResponsePlugin.ReputationAdjustmentResult handlePlayerReputationActionInner(Object actionObject, String factionId, PersonAPI person, RelationshipAPI delegate) {
        if (!(actionObject instanceof RepActionEnvelope) && !(actionObject instanceof RepActions)) {
            return new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        }
        if ("neutral".equals(factionId)) {
            return new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        }
        FactionAPI faction = Global.getSector().getFaction(factionId);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        RepActions action = null;
        String reason = null;
        Object param = null;
        CommMessageAPI message = null;
        TextPanelAPI panel = null;
        boolean withMessage = true;
        boolean addMessageOnNoChange = true;
        if (actionObject instanceof RepActions) {
            action = (RepActions)((Object)actionObject);
            param = null;
        } else if (actionObject instanceof RepActionEnvelope) {
            RepActionEnvelope envelope = (RepActionEnvelope)actionObject;
            action = envelope.action;
            param = envelope.param;
            message = envelope.message;
            panel = envelope.textPanel;
            addMessageOnNoChange = envelope.addMessageOnNoChange;
            withMessage = envelope.withMessage;
            reason = envelope.reason;
        }
        float delta = 0.0f;
        RepLevel limit = null;
        RepLevel ensureAtBest = null;
        RepLevel ensureAtWorst = null;
        RepLevel requireAtBest = null;
        RepLevel requireAtWorst = null;
        RepLevel curr = delegate.getLevel();
        if (action == RepActions.CUSTOM) {
            if (!(param instanceof CustomRepImpact)) {
                throw new RuntimeException("For RepActions.CUSTOM, use CustomRepImpact as a param in a RepActionEnvelope");
            }
            CustomRepImpact impact = (CustomRepImpact)param;
            delta = impact.delta;
            limit = impact.limit;
            ensureAtBest = impact.ensureAtBest;
            ensureAtWorst = impact.ensureAtWorst;
            requireAtBest = impact.requireAtBest;
            requireAtWorst = impact.requireAtWorst;
        }
        switch (action) {
            case COMBAT_HELP_MINOR: {
                delta = 0.01f;
                limit = RepLevel.WELCOMING;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case COMBAT_HELP_MAJOR: {
                delta = 0.03f;
                limit = RepLevel.FRIENDLY;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case COMBAT_HELP_CRITICAL: {
                delta = 0.05f;
                limit = RepLevel.COOPERATIVE;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case COMBAT_FRIENDLY_FIRE: {
                float fpHull = (float)Math.ceil(((Float)param).floatValue());
                if (fpHull >= 20.0f) {
                    fpHull = 0.0f;
                    ensureAtBest = RepLevel.HOSTILE;
                }
                delta = -1.0f * fpHull * 0.01f;
                break;
            }
            case COMBAT_NORMAL: {
                delta = -0.03f;
                limit = RepLevel.VENGEFUL;
                ensureAtBest = RepLevel.HOSTILE;
                break;
            }
            case COMBAT_AGGRESSIVE: {
                delta = -0.05f;
                limit = RepLevel.VENGEFUL;
                ensureAtBest = RepLevel.HOSTILE;
                break;
            }
            case COMBAT_NORMAL_TOFF: {
                delta = -0.03f;
                limit = RepLevel.VENGEFUL;
                break;
            }
            case COMBAT_AGGRESSIVE_TOFF: {
                delta = -0.05f;
                limit = RepLevel.VENGEFUL;
                break;
            }
            case FOOD_SHORTAGE_PLAYER_ENDED_FAST: {
                delta = this.getRepRewardForFoodShortage(action, (MarketAPI)param);
                limit = RepLevel.FRIENDLY;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case FOOD_SHORTAGE_PLAYER_ENDED_NORMAL: {
                delta = this.getRepRewardForFoodShortage(action, (MarketAPI)param);
                limit = RepLevel.WELCOMING;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case SYSTEM_BOUNTY_REWARD: {
                float fp = ((Float)param).floatValue();
                if (fp < 10.0f) {
                    delta = 0.02f;
                    limit = RepLevel.WELCOMING;
                } else if (fp < 30.0f) {
                    delta = 0.03f;
                    limit = RepLevel.FRIENDLY;
                } else {
                    delta = 0.05f;
                    limit = RepLevel.COOPERATIVE;
                }
                requireAtWorst = RepLevel.VENGEFUL;
                break;
            }
            case PERSON_BOUNTY_REWARD: {
                delta = 0.03f;
                limit = RepLevel.COOPERATIVE;
                requireAtWorst = RepLevel.VENGEFUL;
                break;
            }
            case COMBAT_WITH_ENEMY: {
                float fp = ((Float)param).floatValue();
                if (fp < 10.0f) {
                    delta = 0.01f;
                    limit = RepLevel.WELCOMING;
                } else if (fp < 30.0f) {
                    delta = 0.02f;
                    limit = RepLevel.FRIENDLY;
                } else {
                    delta = 0.03f;
                    limit = RepLevel.COOPERATIVE;
                }
                requireAtWorst = RepLevel.VENGEFUL;
                break;
            }
            case TRADE_EFFECT: {
                delta = ((Float)param).floatValue() * 0.01f;
                limit = RepLevel.WELCOMING;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case SMUGGLING_EFFECT: {
                delta = -((Float)param).floatValue() * 0.01f;
                limit = RepLevel.INHOSPITABLE;
                break;
            }
            case TRADE_WITH_ENEMY: {
                delta = -((Float)param).floatValue() * 0.01f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case SMUGGLING_INVESTIGATION_GUILTY: {
                delta = -0.05f;
                limit = RepLevel.HOSTILE;
                ensureAtBest = RepLevel.INHOSPITABLE;
                break;
            }
            case OTHER_FACTION_GOOD_REP_INVESTIGATION_MINOR: {
                delta = -0.05f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case OTHER_FACTION_GOOD_REP_INVESTIGATION_MAJOR: {
                delta = -0.05f;
                limit = RepLevel.HOSTILE;
                ensureAtBest = RepLevel.INHOSPITABLE;
                break;
            }
            case OTHER_FACTION_GOOD_REP_INVESTIGATION_CRITICAL: {
                delta = -0.05f;
                limit = RepLevel.HOSTILE;
                ensureAtBest = RepLevel.HOSTILE;
                break;
            }
            case CAUGHT_INSTALLING_SNIFFER: {
                delta = -0.01f;
                limit = RepLevel.INHOSPITABLE;
                break;
            }
            case COMM_SNIFFER_INVESTIGATION_GUILTY: {
                delta = -0.02f;
                limit = RepLevel.INHOSPITABLE;
                break;
            }
            case FOOD_INVESTIGATION_GUILTY: {
                delta = -0.05f;
                limit = RepLevel.INHOSPITABLE;
                break;
            }
            case FOOD_INVESTIGATION_GUILTY_MAJOR: {
                delta = -0.05f;
                limit = RepLevel.HOSTILE;
                ensureAtBest = RepLevel.SUSPICIOUS;
                break;
            }
            case CUSTOMS_NOTICED_EVADING: {
                delta = -0.03f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case CUSTOMS_CAUGHT_SMUGGLING: {
                delta = -((Float)param).floatValue() * 0.01f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case CUSTOMS_REFUSED_TOLL: {
                delta = -0.03f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case CUSTOMS_REFUSED_FINE: {
                delta = -0.07f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case CUSTOMS_COULD_NOT_AFFORD: {
                delta = -0.02f;
                limit = RepLevel.INHOSPITABLE;
                break;
            }
            case CUSTOMS_PAID: {
                delta = 0.01f;
                limit = RepLevel.WELCOMING;
                break;
            }
            case REP_DECAY_POSITIVE: {
                delta = 0.15f;
                limit = RepLevel.NEUTRAL;
                requireAtWorst = RepLevel.INHOSPITABLE;
                break;
            }
            case MISSION_SUCCESS: {
                MissionCompletionRep rep = (MissionCompletionRep)param;
                delta = rep.successDelta;
                limit = rep.successLimit;
                break;
            }
            case MISSION_FAILURE: {
                MissionCompletionRep rep = (MissionCompletionRep)param;
                delta = rep.failureDelta;
                limit = rep.failureLimit;
                break;
            }
            case TRANSPONDER_OFF: {
                delta = person != null ? -0.03f : -0.02f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case TRANSPONDER_OFF_REFUSE: 
            case CARGO_SCAN_REFUSE: {
                delta = person != null ? -0.05f : -0.03f;
                limit = RepLevel.HOSTILE;
                break;
            }
            case COMMISSION_ACCEPT: {
                delta = 0.05f;
                break;
            }
            case SHRINE_OFFERING: {
                delta = 0.03f;
                limit = RepLevel.FRIENDLY;
                break;
            }
            case INTERDICTED: {
                delta = -0.01f;
                limit = RepLevel.INHOSPITABLE;
                break;
            }
            case MAKE_HOSTILE_AT_BEST: {
                delta = 0.0f;
                ensureAtBest = RepLevel.HOSTILE;
                break;
            }
            case MAKE_SUSPICOUS_AT_WORST: {
                delta = 0.0f;
                ensureAtWorst = RepLevel.SUSPICIOUS;
                break;
            }
            case COMMISSION_BOUNTY_REWARD: {
                float fp = ((Float)param).floatValue();
                if (fp < 20.0f) {
                    delta = 0.01f;
                    limit = RepLevel.FRIENDLY;
                    break;
                }
                if (fp < 50.0f) {
                    delta = 0.02f;
                    limit = RepLevel.COOPERATIVE;
                    break;
                }
                delta = 0.03f;
                limit = RepLevel.COOPERATIVE;
                break;
            }
            case COMMISSION_PENALTY_HOSTILE_TO_NON_ENEMY: {
                float fp = ((Float)param).floatValue();
                delta = fp < 20.0f ? -0.01f : (fp < 50.0f ? -0.02f : -0.03f);
                limit = RepLevel.INHOSPITABLE;
            }
        }
        if (delta < 0.0f && delta > -0.01f) {
            delta = -0.01f;
        }
        if (delta > 0.0f && delta < 0.01f) {
            delta = 0.01f;
        }
        delta = (float)Math.round(delta * 100.0f) / 100.0f;
        if (delegate.getTarget() == Global.getSector().getPlayerFaction()) {
            delta = 0.0f;
        }
        if (delegate.getTarget() == Global.getSector().getPlayerPerson()) {
            delta = 0.0f;
        }
        float deltaSign = Math.signum(delta);
        float before = delegate.getRel();
        if (ensureAtBest != null) {
            delegate.ensureAtBest(ensureAtBest);
        }
        if (ensureAtWorst != null) {
            delegate.ensureAtWorst(ensureAtWorst);
        }
        if ((requireAtBest == null || curr.isAtBest(requireAtBest)) && (requireAtWorst == null || curr.isAtWorst(requireAtWorst))) {
            delegate.adjustRelationship(delta, limit);
        }
        float after = delegate.getRel();
        delta = after - before;
        if (withMessage) {
            if (Math.abs(delta) >= 0.005f) {
                CoreReputationPlugin.addAdjustmentMessage(delta, faction, person, message, panel, null, null, true, 0.0f, reason);
            } else if (deltaSign != 0.0f && addMessageOnNoChange) {
                CoreReputationPlugin.addNoChangeMessage(deltaSign, faction, person, message, panel, null, null, true, 0.0f, reason);
            }
        }
        if (delta != 0.0f) {
            if (person == null) {
                Global.getSector().reportPlayerReputationChange(faction.getId(), delta);
            } else {
                Global.getSector().reportPlayerReputationChange(person, delta);
            }
        }
        return new ReputationActionResponsePlugin.ReputationAdjustmentResult(delta);
    }

    private float getRepRewardForFoodShortage(RepActions action, MarketAPI market) {
        float mult = (float)market.getSize() / 10.0f + 0.5f;
        float delta = 0.0f;
        switch (action) {
            case FOOD_SHORTAGE_PLAYER_ENDED_NORMAL: {
                delta = 0.03f;
                break;
            }
            case FOOD_SHORTAGE_PLAYER_ENDED_FAST: {
                delta = 0.05f;
            }
        }
        return delta * mult;
    }

    public static void addDeltaMessage(float delta, FactionAPI faction, PersonAPI person, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad) {
        if (delta == 0.0f) {
            CoreReputationPlugin.addNoChangeMessage(delta, faction, person, null, panel, info, tc, withCurrent, pad);
        } else {
            CoreReputationPlugin.addAdjustmentMessage(delta, faction, person, null, panel, info, tc, withCurrent, pad);
        }
    }

    public static void addNoChangeMessage(float deltaSign, FactionAPI faction, PersonAPI person, CommMessageAPI message, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad) {
        CoreReputationPlugin.addNoChangeMessage(deltaSign, faction, person, message, panel, info, tc, withCurrent, pad, null);
    }

    public static void addNoChangeMessage(float deltaSign, FactionAPI faction, PersonAPI person, CommMessageAPI message, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad, String reason) {
        SectorEntityToken target;
        FactionAPI player = Global.getSector().getFaction("player");
        RepLevel level = player.getRelationshipLevel(faction.getId());
        int repInt = RepLevel.getRepInt(player.getRelationship(faction.getId()));
        Color textColor = Global.getSettings().getColor("standardTextColor");
        Color factionColor = faction.getBaseUIColor();
        Color relColor = faction.getRelColor(player.getId());
        String targetName = faction.getDisplayNameWithArticle();
        String targetNameHighlight = faction.getDisplayName();
        if ("independent".equals(faction.getId())) {
            targetName = faction.getDisplayNameLongWithArticle();
            targetNameHighlight = faction.getDisplayNameLong();
        }
        if (person != null) {
            targetName = person.getName().getFullName();
            relColor = person.getRelToPlayer().getRelColor();
            repInt = RepLevel.getRepInt(person.getRelToPlayer().getRel());
            level = person.getRelToPlayer().getLevel();
        }
        String standing = repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        String text = "\u4f60\u4e0e " + targetName + "\uff0c\u76ee\u524d\u7684\u5173\u7cfb\u662f " + standing + "\uff0c\u4f60\u6700\u8fd1\u7684\u884c\u52a8\u6ca1\u6709\u5f71\u54cd\u4f60\u4eec\u7684\u5173\u7cfb";
        if (panel == null && info == null) {
            MessageIntel intel = new MessageIntel();
            if (person == null) {
                intel.addLine("\u4f60\u4e0e " + targetName + " \u95f4\u7684\u5173\u7cfb\u672a\u53d7\u5f71\u54cd", null, new String[]{targetNameHighlight}, factionColor);
                intel.addLine("- \u76ee\u524d\u4e3a %s", null, new String[]{standing}, relColor);
                if (reason != null) {
                    intel.addLine("    - " + reason);
                }
                intel.setIcon(faction.getCrest());
            } else {
                intel.addLine("\u4f60\u4e0e " + targetName + " \u95f4\u7684\u5173\u7cfb\u672a\u53d7\u5f71\u54cd");
                intel.addLine("- \u76ee\u524d\u4e3a %s", null, new String[]{standing}, relColor);
                if (reason != null) {
                    intel.addLine("    - " + reason);
                }
                intel.setIcon(person.getPortraitSprite());
            }
            Global.getSector().getCampaignUI().addMessage(intel);
        }
        if (panel != null && panel.getDialog() != null && (target = panel.getDialog().getInteractionTarget()) != null) {
            if (target.getActivePerson() != null) {
                target.getActivePerson().getMemory();
            }
            target.getMemory();
        }
        if (text != null) {
            if (message != null) {
                text = text.replaceAll(" \u4f60\u6700\u8fd1\u7684\u884c\u4e3a", " \u8fd9\u6837\u3002");
                CoreReputationPlugin.appendToSection2(text, message);
                CoreReputationPlugin.appendToSectionHighlights(message.getSection2(), new String[]{standing}, new Color[]{relColor});
                message.addTag("reputation_change");
                if (person == null) {
                    message.getCustomMap().put("CMAPIfactionId", faction.getId());
                } else {
                    message.getCustomMap().put("CMAPIpersonId", person.getId());
                }
            }
            if (panel != null) {
                text = text.replaceAll(" \u4f60\u6700\u8fd1\u7684\u884c\u4e3a", "");
                CoreReputationPlugin.printToTextPanel(panel, text, new String[]{standing}, new Color[]{relColor});
            }
        }
        if (info != null) {
            LabelAPI label;
            if (person == null) {
                label = info.addPara("\u4f60\u4e0e " + targetName + " \u95f4\u7684\u5173\u7cfb\u672a\u53d7\u5f71\u54cd", tc, pad);
                label.setHighlight(targetNameHighlight);
                label.setHighlightColors(factionColor);
                if (withCurrent) {
                    info.addPara("\u76ee\u524d\u4e3a %s", 0.0f, tc, relColor, standing);
                }
            } else {
                label = info.addPara("\u4f60\u4e0e " + targetName + " \u95f4\u7684\u5173\u7cfb\u672a\u53d7\u5f71\u54cd", tc, pad);
                if (withCurrent) {
                    info.addPara("\u76ee\u524d\u4e3a %s", 0.0f, tc, relColor, standing);
                }
            }
        }
    }

    public static void addCurrentStanding(FactionAPI faction, PersonAPI person, TextPanelAPI panel, TooltipMakerAPI info, Color tc, float pad) {
        FactionAPI player = Global.getSector().getFaction("player");
        RepLevel level = player.getRelationshipLevel(faction.getId());
        int repInt = RepLevel.getRepInt(player.getRelationship(faction.getId()));
        Color factionColor = faction.getBaseUIColor();
        Color relColor = faction.getRelColor(player.getId());
        String targetName = faction.getDisplayNameWithArticle();
        String targetNameHighlight = faction.getDisplayName();
        if ("independent".equals(faction.getId())) {
            targetName = faction.getDisplayNameLongWithArticle();
            targetNameHighlight = faction.getDisplayNameLong();
        }
        if (person != null) {
            targetName = person.getName().getFullName();
            relColor = person.getRelToPlayer().getRelColor();
            repInt = RepLevel.getRepInt(person.getRelToPlayer().getRel());
            level = person.getRelToPlayer().getLevel();
        }
        String standing = repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        String text = "\u76ee\u524d\u4f60\u4e0e " + targetName + " \u7684\u5173\u7cfb\u4e3a " + standing;
        if (panel != null) {
            CoreReputationPlugin.printToTextPanel(panel, text, new String[]{targetNameHighlight, standing}, new Color[]{factionColor, relColor});
        }
        if (info != null) {
            String end = "";
            if (pad > 0.0f) {
                end = ".";
            }
            if (person == null) {
                LabelAPI label = info.addPara("\u76ee\u524d\u4f60\u4e0e " + targetName + "\u7684\u5173\u7cfb\u4e3a %s" + end, pad, tc, relColor, standing);
                label.setHighlight(targetNameHighlight, standing);
                label.setHighlightColors(factionColor, relColor);
            } else {
                LabelAPI label = info.addPara("\u76ee\u524d\u4f60\u4e0e " + targetName + "\u7684\u5173\u7cfb\u4e3a %s" + end, pad, tc, relColor, standing);
                label.setHighlight(targetNameHighlight, standing);
                label.setHighlightColors(factionColor, relColor);
            }
        }
    }

    public static void addRequiredStanding(FactionAPI faction, RepLevel req, PersonAPI person, TextPanelAPI panel, TooltipMakerAPI info, Color tc, float pad, boolean orBetter) {
        FactionAPI player = Global.getSector().getFaction("player");
        RepLevel level = req;
        float rel = level.getMin() + 0.01f;
        PersonAPI fake = Global.getFactory().createPerson();
        fake.getRelToPlayer().setRel(rel);
        int repInt = RepLevel.getRepInt(rel);
        Color relColor = fake.getRelToPlayer().getRelColor(level);
        Color factionColor = faction.getBaseUIColor();
        String targetName = faction.getDisplayNameWithArticle();
        String targetNameHighlight = faction.getDisplayName();
        if ("independent".equals(faction.getId())) {
            targetName = faction.getDisplayNameLongWithArticle();
            targetNameHighlight = faction.getDisplayNameLong();
        }
        if (person != null) {
            targetName = person.getName().getFullName();
            relColor = person.getRelToPlayer().getRelColor();
        }
        String standing = repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        String mid = "\u6216\u66f4\u597d";
        if (!orBetter) {
            mid = "\u6216\u66f4\u7cdf";
        }
        String text = "\u81f3\u5c11\u9700\u8981 " + standing + " " + mid + "\u7684\u5173\u7cfb - " + targetName;
        if (panel != null) {
            CoreReputationPlugin.printToTextPanel(panel, text, new String[]{standing, targetNameHighlight}, new Color[]{relColor, factionColor});
        }
        if (info != null) {
            String end = "";
            if (pad > 0.0f) {
                end = ".";
            }
            if (person == null) {
                LabelAPI label = info.addPara("\u9700\u8981 %s " + mid + "\u7684\u5173\u7cfb - " + targetName + end, pad, tc, relColor, standing);
                label.setHighlight(standing, targetNameHighlight);
                label.setHighlightColors(relColor, factionColor);
            } else {
                LabelAPI label = info.addPara("\u9700\u8981 %s " + mid + "\u7684\u5173\u7cfb - " + targetName + end, pad, tc, relColor, standing);
                label.setHighlight(standing, targetNameHighlight);
                label.setHighlightColors(relColor, factionColor);
            }
        }
    }

    public static void addAdjustmentMessage(float delta, FactionAPI faction, PersonAPI person, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad) {
        CoreReputationPlugin.addAdjustmentMessage(delta, faction, person, null, panel, info, tc, withCurrent, pad, null);
    }

    public static void addAdjustmentMessage(float delta, FactionAPI faction, PersonAPI person, CommMessageAPI message, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad) {
        CoreReputationPlugin.addAdjustmentMessage(delta, faction, person, message, panel, info, tc, withCurrent, pad, null);
    }

    public static void addAdjustmentMessage(float delta, FactionAPI faction, PersonAPI person, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad, String reason) {
        CoreReputationPlugin.addAdjustmentMessage(delta, faction, person, null, panel, info, tc, withCurrent, pad, reason);
    }

    public static void addAdjustmentMessage(float delta, FactionAPI faction, PersonAPI person, CommMessageAPI message, TextPanelAPI panel, TooltipMakerAPI info, Color tc, boolean withCurrent, float pad, String reason) {
        FactionAPI player = Global.getSector().getFaction("player");
        RepLevel level = null;
        int deltaInt = Math.round(Math.abs(delta) * 100.0f);
        String targetName = null;
        String targetNameHighlight = null;
        Color relColor = null;
        int repInt = 0;
        if (faction != null) {
            level = player.getRelationshipLevel(faction.getId());
            repInt = RepLevel.getRepInt(player.getRelationship(faction.getId()));
            targetName = faction.getDisplayNameWithArticle();
            targetNameHighlight = faction.getDisplayName();
            if ("independent".equals(faction.getId())) {
                targetName = faction.getDisplayNameLongWithArticle();
                targetNameHighlight = faction.getDisplayNameLong();
            }
            relColor = faction.getRelColor(player.getId());
        }
        if (person != null) {
            targetName = person.getName().getFullName();
            relColor = person.getRelToPlayer().getRelColor();
            repInt = RepLevel.getRepInt(person.getRelToPlayer().getRel());
            level = person.getRelToPlayer().getLevel();
        }
        String standing = repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        String text = null;
        Color textColor = Global.getSettings().getColor("standardTextColor");
        Color factionColor = null;
        if (faction != null) {
            factionColor = faction.getBaseUIColor();
        }
        Color deltaColor = Global.getSettings().getColor("textFriendColor");
        String deltaString = "\u5173\u7cfb\u63d0\u9ad8 " + deltaInt;
        if (Math.abs(delta) <= 0.0049f || deltaInt == 0) {
            deltaString = "\u95f4\u7684\u5173\u7cfb\u672a\u53d7\u5f71\u54cd";
            deltaColor = tc;
        } else if (delta < 0.0f) {
            deltaColor = Misc.getNegativeHighlightColor();
            deltaString = "\u5173\u7cfb\u964d\u4f4e " + deltaInt;
        }
        text = "\u4f60\u4e0e " + targetName + " " + deltaString + "\uff0c\u76ee\u524d\u7684\u5173\u7cfb\u662f " + standing;
        if (panel == null && info == null) {
            MessageIntel intel = new MessageIntel();
            if (person == null) {
                intel.addLine("\u4f60\u4e0e " + targetName + " " + deltaString, null, new String[]{targetNameHighlight, deltaString}, factionColor, deltaColor);
                intel.addLine("- \u76ee\u524d\u4e3a %s", null, new String[]{standing}, relColor);
                if (reason != null) {
                    intel.addLine("    - " + reason);
                }
                if (faction != null) {
                    intel.setIcon(faction.getCrest());
                }
            } else {
                intel.addLine("\u4f60\u4e0e " + targetName + " " + deltaString, null, new String[]{deltaString}, deltaColor);
                intel.addLine("- \u76ee\u524d\u4e3a %s", null, new String[]{standing}, relColor);
                if (reason != null) {
                    intel.addLine("    - " + reason);
                }
                intel.setIcon(person.getPortraitSprite());
            }
            Global.getSector().getCampaignUI().addMessage(intel);
        }
        if (text != null) {
            if (message != null) {
                text = String.valueOf(text) + ".";
                CoreReputationPlugin.appendToSection2(text, message);
                CoreReputationPlugin.appendToSectionHighlights(message.getSection2(), new String[]{deltaString, standing}, new Color[]{deltaColor, relColor});
                message.addTag("reputation_change");
                if (person == null) {
                    message.getCustomMap().put("CMAPIfactionId", faction.getId());
                } else {
                    message.getCustomMap().put("CMAPIpersonId", person.getId());
                }
            }
            if (panel != null) {
                CoreReputationPlugin.printToTextPanel(panel, text, new String[]{deltaString, standing}, new Color[]{deltaColor, relColor});
            }
        }
        if (info != null) {
            LabelAPI label;
            if (person == null) {
                label = info.addPara("\u4f60\u4e0e " + targetName + " " + deltaString, tc, pad);
                label.setHighlight(targetNameHighlight, deltaString);
                label.setHighlightColors(factionColor, deltaColor);
                if (withCurrent) {
                    info.addPara("\u76ee\u524d\u4e3a %s", 0.0f, tc, relColor, standing);
                }
            } else {
                label = info.addPara("\u4f60\u4e0e " + targetName + " " + deltaString, tc, pad);
                label.setHighlight(deltaString);
                label.setHighlightColors(deltaColor);
                if (withCurrent) {
                    info.addPara("\u76ee\u524d\u4e3a %s", 0.0f, tc, relColor, standing);
                }
            }
        }
    }

    private static void printToTextPanel(TextPanelAPI panel, String text, String[] highlights, Color[] colors) {
        Color textColor = Global.getSettings().getColor("textGrayColor");
        panel.setFontSmallInsignia();
        panel.addParagraph(text, textColor);
        panel.highlightInLastPara(highlights);
        panel.setHighlightColorsInLastPara(colors);
        panel.setFontInsignia();
    }

    private static void appendToSectionHighlights(MessageSectionAPI section, String[] strings, Color[] colors) {
        String[] currStrings = section.getHighlights();
        Color[] currColors = section.getHighlightColors();
        if (currStrings == null) {
            section.setHighlights(strings);
            section.setHighlightColors(colors);
        } else {
            String s;
            ArrayList<String> stringList = new ArrayList<String>();
            String[] stringArray = currStrings;
            int n = currStrings.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                stringList.add(s);
                ++n2;
            }
            stringArray = strings;
            n = strings.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                stringList.add(s);
                ++n2;
            }
            ArrayList<Color> colorList = new ArrayList<Color>();
            Color[] colorArray = currColors;
            int n3 = currColors.length;
            n = 0;
            while (n < n3) {
                Color s2 = colorArray[n];
                colorList.add(s2);
                ++n;
            }
            colorArray = colors;
            n3 = colors.length;
            n = 0;
            while (n < n3) {
                Color s3 = colorArray[n];
                colorList.add(s3);
                ++n;
            }
            section.setHighlights(stringList.toArray(new String[0]));
            section.setHighlightColors(colorList.toArray(new Color[0]));
        }
    }

    private static void appendToSection2(String text, CommMessageAPI message) {
        List<MessageParaAPI> body = message.getSection2().getBody();
        if (body.isEmpty()) {
            message.getSection2().addPara(text);
        } else {
            MessageParaAPI lastPara = body.get(body.size() - 1);
            String str = lastPara.getBody();
            str = String.valueOf(str) + "\n\n" + text;
            lastPara.setBody(str);
        }
    }

    public static class CustomRepImpact {
        public float delta = 0.0f;
        public RepLevel limit = null;
        public RepLevel ensureAtBest = null;
        public RepLevel ensureAtWorst = null;
        public RepLevel requireAtBest = null;
        public RepLevel requireAtWorst = null;
    }

    public static class MissionCompletionRep {
        public float successDelta;
        public RepLevel successLimit;
        public float failureDelta;
        public RepLevel failureLimit;

        public MissionCompletionRep(float successDelta, RepLevel successLimit, float failureDelta, RepLevel failureLimit) {
            this.successDelta = successDelta;
            this.successLimit = successLimit;
            this.failureDelta = failureDelta;
            this.failureLimit = failureLimit;
        }
    }

    public static class RepActionEnvelope {
        public RepActions action;
        public Object param = null;
        public CommMessageAPI message = null;
        public TextPanelAPI textPanel = null;
        public boolean addMessageOnNoChange = true;
        public boolean withMessage = true;
        public String reason;

        public RepActionEnvelope(RepActions action, Object param) {
            this.action = action;
            this.param = param;
        }

        public RepActionEnvelope(RepActions action) {
            this.action = action;
        }

        public RepActionEnvelope(RepActions action, Object param, CommMessageAPI message, TextPanelAPI textPanel, boolean addMessageOnNoChange) {
            this(action, param, message, textPanel, addMessageOnNoChange, true);
        }

        public RepActionEnvelope(RepActions action, Object param, TextPanelAPI textPanel, boolean addMessageOnNoChange) {
            this(action, param, null, textPanel, addMessageOnNoChange, true);
        }

        public RepActionEnvelope(RepActions action, Object param, CommMessageAPI message, TextPanelAPI textPanel, boolean addMessageOnNoChange, boolean withMessage) {
            this(action, param, message, textPanel, addMessageOnNoChange, withMessage, null);
        }

        public RepActionEnvelope(RepActions action, Object param, TextPanelAPI textPanel, boolean addMessageOnNoChange, boolean withMessage) {
            this(action, param, null, textPanel, addMessageOnNoChange, withMessage, null);
        }

        public RepActionEnvelope(RepActions action, Object param, TextPanelAPI textPanel, boolean addMessageOnNoChange, boolean withMessage, String reason) {
            this(action, param, null, textPanel, addMessageOnNoChange, withMessage, reason);
        }

        public RepActionEnvelope(RepActions action, Object param, CommMessageAPI message, TextPanelAPI textPanel, boolean addMessageOnNoChange, boolean withMessage, String reason) {
            this.action = action;
            this.param = param;
            this.message = message;
            this.addMessageOnNoChange = addMessageOnNoChange;
            this.textPanel = textPanel;
            this.withMessage = withMessage;
            this.reason = reason;
        }

        public RepActionEnvelope(RepActions action, Object param, TextPanelAPI textPanel) {
            this.action = action;
            this.param = param;
            this.textPanel = textPanel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepActions {
        COMBAT_NO_DAMAGE_ESCAPE,
        COMBAT_NORMAL,
        COMBAT_AGGRESSIVE,
        COMBAT_NORMAL_TOFF,
        COMBAT_AGGRESSIVE_TOFF,
        COMBAT_HELP_MINOR,
        COMBAT_HELP_MAJOR,
        COMBAT_HELP_CRITICAL,
        COMBAT_FRIENDLY_FIRE,
        FOOD_SHORTAGE_PLAYER_ENDED_FAST,
        FOOD_SHORTAGE_PLAYER_ENDED_NORMAL,
        SYSTEM_BOUNTY_REWARD,
        PERSON_BOUNTY_REWARD,
        COMBAT_WITH_ENEMY,
        TRADE_EFFECT,
        SMUGGLING_EFFECT,
        TRADE_WITH_ENEMY,
        OTHER_FACTION_GOOD_REP_INVESTIGATION_MINOR,
        OTHER_FACTION_GOOD_REP_INVESTIGATION_MAJOR,
        OTHER_FACTION_GOOD_REP_INVESTIGATION_CRITICAL,
        SMUGGLING_INVESTIGATION_GUILTY,
        COMM_SNIFFER_INVESTIGATION_GUILTY,
        FOOD_INVESTIGATION_GUILTY,
        FOOD_INVESTIGATION_GUILTY_MAJOR,
        CAUGHT_INSTALLING_SNIFFER,
        CUSTOMS_NOTICED_EVADING,
        CUSTOMS_CAUGHT_SMUGGLING,
        CUSTOMS_REFUSED_TOLL,
        CUSTOMS_REFUSED_FINE,
        CUSTOMS_COULD_NOT_AFFORD,
        CUSTOMS_PAID,
        REP_DECAY_POSITIVE,
        TRANSPONDER_OFF,
        TRANSPONDER_OFF_REFUSE,
        CARGO_SCAN_REFUSE,
        MISSION_SUCCESS,
        MISSION_FAILURE,
        MAKE_SUSPICOUS_AT_WORST,
        MAKE_HOSTILE_AT_BEST,
        COMMISSION_ACCEPT,
        COMMISSION_BOUNTY_REWARD,
        COMMISSION_NEUTRAL_BATTLE_PENALTY,
        COMMISSION_PENALTY_HOSTILE_TO_NON_ENEMY,
        SHRINE_OFFERING,
        INTERDICTED,
        CUSTOM;

    }

    public static class RepRewards {
        public static final float TINY = 0.01f;
        public static final float SMALL = 0.02f;
        public static final float MEDIUM = 0.03f;
        public static final float HIGH = 0.05f;
        public static final float VERY_HIGH = 0.07f;
        public static final float EXTREME = 0.1f;
    }
}

