/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.RuleTokenReplacementGeneratorPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreRuleTokenReplacementGeneratorImpl
implements RuleTokenReplacementGeneratorPlugin {
    @Override
    public Map<String, String> getTokenReplacements(String ruleId, Object entity, Map<String, MemoryAPI> memoryMap) {
        String factionName;
        SectorEntityToken target = null;
        PersonAPI person = null;
        MarketAPI market = null;
        FactionAPI faction = null;
        FactionAPI personFaction = null;
        if (entity instanceof SectorEntityToken) {
            target = (SectorEntityToken)entity;
            market = target.getMarket();
            faction = target.getFaction();
        }
        if (entity instanceof CampaignFleetAPI && market == null) {
            market = Misc.getSourceMarket((CampaignFleetAPI)entity);
        }
        if (entity instanceof SectorEntityToken) {
            person = ((SectorEntityToken)entity).getActivePerson();
        }
        if (person == null) {
            if (entity instanceof CampaignFleetAPI) {
                person = ((CampaignFleetAPI)entity).getCommander();
            } else if (entity instanceof PersonAPI) {
                person = (PersonAPI)entity;
            }
        }
        if (person != null) {
            personFaction = person.getFaction();
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("$Playername", Global.getSector().getCharacterData().getName());
        map.put("$playername", Global.getSector().getCharacterData().getName());
        map.put("$playerName", Global.getSector().getCharacterData().getName());
        map.put("$PlayerName", Global.getSector().getCharacterData().getName());
        map.put("$playerFirstName", Global.getSector().getCharacterData().getPerson().getName().getFirst());
        map.put("$playerFirstname", Global.getSector().getCharacterData().getPerson().getName().getFirst());
        map.put("$playerLastName", Global.getSector().getCharacterData().getPerson().getName().getLast());
        map.put("$playerLastname", Global.getSector().getCharacterData().getPerson().getName().getLast());
        PersonAPI playerPerson = Global.getSector().getPlayerPerson();
        String honorific = Global.getSector().getCharacterData().getHonorific();
        if (playerPerson != null) {
            if (playerPerson.isMale()) {
                map.put("$playerSirOrMadam", "\u5148\u751f");
                map.put("$PlayerSirOrMadam", "\u5148\u751f");
                map.put("$playerBrotherOrSister", "\u5144\u5f1f");
                map.put("$PlayerBrotherOrSister", "\u5144\u5f1f");
                map.put("$playerHisOrHer", "\u4ed6");
                map.put("$PlayerHisOrHer", "\u4ed6");
                map.put("$playerHimOrHer", "\u4ed6");
                map.put("$PlayerHimOrHer", "\u4ed6");
                map.put("$playerHeOrShe", "\u4ed6");
                map.put("$PlayerHeOrShe", "\u4ed6");
            } else {
                map.put("$playerSirOrMadam", "\u5973\u58eb");
                map.put("$PlayerSirOrMadam", "\u5973\u58eb");
                map.put("$playerBrotherOrSister", "\u59d0\u59b9");
                map.put("$PlayerBrotherOrSister", "\u59d0\u59b9");
                map.put("$playerHisOrHer", "\u5979");
                map.put("$PlayerHisOrHer", "\u5979");
                map.put("$playerHimOrHer", "\u5979");
                map.put("$PlayerHimOrHer", "\u5979");
                map.put("$playerHeOrShe", "\u5979");
                map.put("$PlayerHeOrShe", "\u5979");
            }
            if (honorific != null && !honorific.isEmpty()) {
                map.put("$playerSirOrMadam", Misc.lcFirst(honorific));
                map.put("$PlayerSirOrMadam", honorific);
                if (!Misc.SIR.toLowerCase().equals(honorific.toLowerCase()) && !Misc.MAAM.toLowerCase().equals(honorific.toLowerCase())) {
                    map.put("$playerBrotherOrSister", "\u6c42\u9053\u8005");
                    map.put("$PlayerBrotherOrSister", "\u6c42\u9053\u8005");
                }
            }
        }
        if (market != null) {
            map.put("$marketName", market.getName());
            if (target.getLocation() instanceof StarSystemAPI) {
                map.put("$marketSystem", String.valueOf(((StarSystemAPI)target.getLocation()).getBaseName()) + " \u661f\u7cfb");
            } else {
                map.put("$marketSystem", "hyperspace");
            }
            MemoryAPI mem = market.getMemoryWithoutUpdate();
            if (mem.contains("$playerHostileTimeout")) {
                float expire2 = mem.getExpire("$playerHostileTimeout");
                String days = Misc.getAtLeastStringForDays((int)expire2);
                map.put("$playerHostileTimeoutStr", days.toLowerCase());
                mem.set("$playerHostileTimeoutStr", days.toLowerCase(), 0.0f);
            }
        }
        if (target != null) {
            map.put("$entityName", target.getName());
            map.put("$fleetName", target.getName().toLowerCase());
            map.put("$relayName", target.getName());
            if (target.getCustomEntityType() != null && target.getCustomEntitySpec() != null) {
                CustomEntitySpecAPI spec = target.getCustomEntitySpec();
                map.put("$nameInText", spec.getNameInText());
                map.put("$shortName", spec.getShortName());
                map.put("$isOrAre", spec.getIsOrAre());
                map.put("$aOrAn", spec.getAOrAn());
            }
            if (target.getFaction() != null) {
                factionName = target.getFaction().getEntityNamePrefix();
                if (factionName == null || factionName.isEmpty()) {
                    factionName = target.getFaction().getDisplayName();
                }
                map.put("$factionAOrAn", target.getFaction().getPersonNamePrefixAOrAn());
                map.put("$factionIsOrAre", target.getFaction().getDisplayNameIsOrAre());
                map.put("$faction", factionName);
                map.put("$ownerFaction", factionName);
                map.put("$marketFaction", factionName);
                map.put("$Faction", Misc.ucFirst(factionName));
                map.put("$OwnerFaction", Misc.ucFirst(factionName));
                map.put("$MarketFaction", Misc.ucFirst(factionName));
                map.put("$theFaction", target.getFaction().getDisplayNameWithArticle());
                map.put("$theOwnerFaction", target.getFaction().getDisplayNameWithArticle());
                map.put("$theMarketFaction", target.getFaction().getDisplayNameWithArticle());
                map.put("$TheFaction", Misc.ucFirst(target.getFaction().getDisplayNameWithArticle()));
                map.put("$TheOwnerFaction", Misc.ucFirst(target.getFaction().getDisplayNameWithArticle()));
                map.put("$TheMarketFaction", Misc.ucFirst(target.getFaction().getDisplayNameWithArticle()));
                map.put("$factionLong", target.getFaction().getDisplayNameLong());
                map.put("$FactionLong", Misc.ucFirst(target.getFaction().getDisplayNameLong()));
                map.put("$theFactionLong", target.getFaction().getDisplayNameLongWithArticle());
                map.put("$TheFactionLong", Misc.ucFirst(target.getFaction().getDisplayNameLongWithArticle()));
            }
        }
        if (target != null) {
            map.put("$entityName", target.getName());
            map.put("$fleetName", target.getName().toLowerCase());
            map.put("$relayName", target.getName());
            if (target.getFaction() != null) {
                factionName = target.getFaction().getEntityNamePrefix();
                if (factionName == null || factionName.isEmpty()) {
                    factionName = target.getFaction().getDisplayName();
                }
                map.put("$factionIsOrAre", target.getFaction().getDisplayNameIsOrAre());
                map.put("$faction", factionName);
                map.put("$ownerFaction", factionName);
                map.put("$marketFaction", factionName);
                map.put("$Faction", Misc.ucFirst(factionName));
                map.put("$OwnerFaction", Misc.ucFirst(factionName));
                map.put("$MarketFaction", Misc.ucFirst(factionName));
                map.put("$theFaction", target.getFaction().getDisplayNameWithArticle());
                map.put("$theOwnerFaction", target.getFaction().getDisplayNameWithArticle());
                map.put("$theMarketFaction", target.getFaction().getDisplayNameWithArticle());
                map.put("$TheFaction", Misc.ucFirst(target.getFaction().getDisplayNameWithArticle()));
                map.put("$TheOwnerFaction", Misc.ucFirst(target.getFaction().getDisplayNameWithArticle()));
                map.put("$TheMarketFaction", Misc.ucFirst(target.getFaction().getDisplayNameWithArticle()));
                map.put("$factionLong", target.getFaction().getDisplayNameLong());
                map.put("$FactionLong", Misc.ucFirst(target.getFaction().getDisplayNameLong()));
                map.put("$theFactionLong", target.getFaction().getDisplayNameLongWithArticle());
                map.put("$TheFactionLong", Misc.ucFirst(target.getFaction().getDisplayNameLongWithArticle()));
            }
        }
        String shipOrFleet = "\u8230\u961f";
        if (playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            shipOrFleet = "\u8230\u8239";
            if (playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                shipOrFleet = "fighter wing";
            }
        }
        map.put("$shipOrFleet", shipOrFleet);
        map.put("$fleetOrShip", shipOrFleet);
        map.put("$ShipOrFleet", Misc.ucFirst(shipOrFleet));
        map.put("$FleetOrShip", Misc.ucFirst(shipOrFleet));
        if (target instanceof CampaignFleetAPI) {
            CampaignFleetAPI \u8230\u961f = (CampaignFleetAPI)target;
            String otherShipOrFleet = "\u8230\u961f";
            if (\u8230\u961f.getFleetData().getMembersListCopy().size() == 1) {
                shipOrFleet = "\u8230\u8239";
                if (\u8230\u961f.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                    shipOrFleet = "fighter wing";
                }
            }
            map.put("$otherShipOrFleet", otherShipOrFleet);
            map.put("$otherFleetName", \u8230\u961f.getName().toLowerCase());
        }
        if (person != null) {
            if (person.isMale()) {
                map.put("$hisOrHer", "\u4ed6");
                map.put("$HisOrHer", "\u4ed6");
                map.put("$himOrHer", "\u4ed6");
                map.put("$HimOrHer", "\u4ed6");
                map.put("$heOrShe", "\u4ed6");
                map.put("$HeOrShe", "\u4ed6");
                map.put("$himOrHerself", "\u4ed6");
                map.put("$HimOrHerself", "\u4ed6");
                map.put("$manOrWoman", "\u7537\u4eba");
                map.put("$ManOrWoman", "\u5148\u751f");
                map.put("$brotherOrSister", "\u5144\u5f1f");
                map.put("$BrotherOrSister", "\u5144\u5f1f");
                map.put("$sirOrMadam", "\u5148\u751f");
                map.put("$SirOrMadam", "\u5148\u751f");
            } else {
                map.put("$hisOrHer", "\u5979");
                map.put("$HisOrHer", "\u5979");
                map.put("$himOrHer", "\u5979");
                map.put("$HimOrHer", "\u5979");
                map.put("$heOrShe", "\u5979");
                map.put("$HeOrShe", "\u5979");
                map.put("$himOrHerself", "\u5979");
                map.put("$HimOrHerself", "\u5979");
                map.put("$manOrWoman", "\u5973\u4eba");
                map.put("$ManOrWoman", "\u5973\u4eba");
                map.put("$brotherOrSister", "\u59d0\u59b9");
                map.put("$BrotherOrSister", "\u59d0\u59b9");
                map.put("$sirOrMadam", "\u5973\u58eb");
                map.put("$SirOrMadam", "\u5973\u58eb");
            }
            if (person.getRank() != null) {
                map.put("$personRank", person.getRank().toLowerCase());
                map.put("$PersonRank", Misc.ucFirst(person.getRank()));
            }
            if (person.getPost() != null) {
                map.put("$personPost", person.getPost().toLowerCase());
                map.put("$PersonPost", Misc.ucFirst(person.getPost()));
            }
            map.put("$PersonName", person.getName().getFullName());
            map.put("$personName", person.getName().getFullName());
            map.put("$personFirstName", person.getName().getFirst());
            map.put("$personLastName", person.getName().getLast());
        }
        if (faction != null) {
            float rel = faction.getRelationship("player");
            RepLevel level = RepLevel.getLevelFor(rel);
            map.put("$relAdjective", level.getDisplayName().toLowerCase());
        }
        if (personFaction != null) {
            String factionName2 = personFaction.getEntityNamePrefix();
            if (factionName2 == null || factionName2.isEmpty()) {
                factionName2 = personFaction.getDisplayName();
            }
            map.put("$personFactionIsOrAre", personFaction.getDisplayNameIsOrAre());
            map.put("$personFaction", factionName2);
            map.put("$PersonFaction", Misc.ucFirst(factionName2));
            map.put("$thePersonFaction", personFaction.getDisplayNameWithArticle());
            map.put("$ThePersonFaction", Misc.ucFirst(personFaction.getDisplayNameWithArticle()));
            map.put("$personFactionLong", personFaction.getDisplayNameLong());
            map.put("$PersonFactionLong", Misc.ucFirst(personFaction.getDisplayNameLong()));
            map.put("$thePersonFactionLong", personFaction.getDisplayNameLongWithArticle());
            map.put("$ThePersonFactionLong", Misc.ucFirst(personFaction.getDisplayNameLongWithArticle()));
        }
        return map;
    }
}

