/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AdminData;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillsChangeRemoveExcessOPEffect;
import com.fs.starfarer.api.characters.SkillsChangeRemoveVentsCapsEffect;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsResponse;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.TOffAlarm;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.ProductionReportIntel;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreScript
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(CoreScript.class);
    public static final String SHARED_DATA_KEY = "core_CEFSSharedDataKey";
    private SharedData shared;
    private IntervalUtil timer = new IntervalUtil(0.5f, 1.5f);
    private boolean firstFrame = true;
    private float highestDelta = 0.0f;
    private String deltaFaction = null;
    protected Random prodRandom = new Random();

    public CoreScript() {
        super(true);
        this.shared = SharedData.getData();
    }

    @Override
    public void advance(float amount) {
        SectorAPI sector = Global.getSector();
        this.playRepChangeSoundsIfNeeded();
        if (sector.isPaused()) {
            if (Global.getSettings().isDevMode()) {
                RouteManager.getInstance().advance(0.0f);
            }
            return;
        }
        if (this.firstFrame) {
            this.firstFrame = false;
        }
        float days = sector.getClock().convertToDays(amount);
        this.shared.advance(amount);
        this.timer.advance(days);
        this.timer.intervalElapsed();
        RouteManager.getInstance().advance(amount);
        Misc.computeCoreWorldsExtent();
    }

    private void playRepChangeSoundsIfNeeded() {
        if (this.deltaFaction != null) {
            if (this.highestDelta > 0.0f) {
                Global.getSoundPlayer().playUISound("ui_rep_raise", 1.0f, 1.0f);
            } else if (this.highestDelta < 0.0f) {
                Global.getSoundPlayer().playUISound("ui_rep_drop", 1.0f, 1.0f);
            }
        }
        this.highestDelta = 0.0f;
        this.deltaFaction = null;
    }

    @Override
    public void reportPlayerReputationChange(String faction, float delta) {
        super.reportPlayerReputationChange(faction, delta);
        if (Math.abs(delta) > Math.abs(this.highestDelta)) {
            this.highestDelta = delta;
            this.deltaFaction = faction;
        }
    }

    @Override
    public void reportPlayerReputationChange(PersonAPI person, float delta) {
        super.reportPlayerReputationChange(person, delta);
        if (Math.abs(delta) > Math.abs(this.highestDelta)) {
            this.highestDelta = delta;
            this.deltaFaction = person.getFaction().getId();
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return true;
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        super.reportPlayerMarketTransaction(transaction);
        for (PlayerMarketTransaction.ShipSaleInfo info : transaction.getShipsBought()) {
            FleetMemberAPI member = info.getMember();
            if (member.getVariant().hasTag("variant_allow_excess_op_etc")) continue;
            SkillsChangeRemoveExcessOPEffect.clampOP(member, Global.getSector().getPlayerStats());
            SkillsChangeRemoveVentsCapsEffect.clampNumVentsAndCaps(member, Global.getSector().getPlayerStats());
        }
        SubmarketAPI submarket = transaction.getSubmarket();
        MarketAPI market = transaction.getMarket();
        if (!market.isPlayerOwned() && submarket.getPlugin().isParticipatesInEconomy() && !submarket.getPlugin().isBlackMarket() && submarket.getFaction() == market.getFaction()) {
            CargoAPI \u4ed3\u7ba1\u8d39 = transaction.getSubmarket().getCargo();
            boolean didAnything = false;
            block1: for (CargoStackAPI stack : transaction.getSold().getStacksCopy()) {
                SpecialItemPlugin plugin = stack.getPlugin();
                if (plugin == null) continue;
                SpecialItemData data = stack.getSpecialDataIfSpecial();
                InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
                for (Industry ind : market.getIndustries()) {
                    List<String> unmet;
                    if (!ind.wantsToUseSpecialItem(data) || effect != null && (unmet = effect.getUnmetRequirements(ind)) != null && !unmet.isEmpty()) continue;
                    if (ind.getSpecialItem() != null) {
                        \u4ed3\u7ba1\u8d39.addItems(CargoAPI.CargoItemType.SPECIAL, ind.getSpecialItem(), 1.0f);
                    }
                    \u4ed3\u7ba1\u8d39.removeItems(CargoAPI.CargoItemType.SPECIAL, data, 1.0f);
                    ind.setSpecialItem(data);
                    didAnything = true;
                    continue block1;
                }
            }
            if (didAnything) {
                \u4ed3\u7ba1\u8d39.sort();
            }
        }
    }

    @Override
    public void reportPlayerOpenedMarket(MarketAPI market) {
        super.reportPlayerOpenedMarket(market);
        SharedData.getData().getPlayerActivityTracker().updateLastVisit(market);
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        CoreScript.generateOrAddToDebrisFieldFromBattle(primaryWinner, battle);
        if (!battle.isPlayerInvolved()) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerFleet.isValidPlayerFleet()) {
            float fp = 0.0f;
            float crew = 0.0f;
            for (FleetMemberAPI member : Misc.getSnapshotMembersLost(playerFleet)) {
                fp += (float)member.getFleetPointCost();
                crew = member.getMinCrew();
            }
            this.shared.setPlayerPreLosingBattleFP(fp);
            this.shared.setPlayerPreLosingBattleCrew(crew);
            this.shared.setPlayerLosingBattleTimestamp(Global.getSector().getClock().getTimestamp());
        }
        for (final CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            if (otherFleet.hasScriptOfClass(TOffAlarm.class)) continue;
            MemoryAPI memory = otherFleet.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(memory, "$cfai_makeHostileWhileTOff", "battle", true, 7.0f + (float)Math.random() * 7.0f);
            if (!otherFleet.getMemoryWithoutUpdate().getBoolean("$lowRepImpact") || otherFleet.getMemoryWithoutUpdate().getBoolean("$alwaysSpreadTOffHostility")) {
                otherFleet.addScript(new TOffAlarm(otherFleet));
            }
            float fpLost = Misc.getSnapshotFPLost(otherFleet);
            List<MarketAPI> markets = Misc.findNearbyLocalMarkets(otherFleet, Global.getSettings().getFloat("sensorRangeMax") + 500.0f, new BaseEventPlugin.MarketFilter(){

                public boolean acceptMarket(MarketAPI market) {
                    return market.getFaction() != null && market.getFaction() == otherFleet.getFaction();
                }
            });
            for (MarketAPI market : markets) {
                MemoryAPI mem = market.getMemoryWithoutUpdate();
                float expire2 = fpLost;
                if (mem.contains("$playerHostileTimeout")) {
                    expire2 += mem.getExpire("$playerHostileTimeout");
                }
                if (expire2 > 180.0f) {
                    expire2 = 180.0f;
                }
                if (!(expire2 > 0.0f)) continue;
                mem.set("$playerHostileTimeout", true, expire2);
            }
        }
    }

    @Override
    public void reportFleetJumped(CampaignFleetAPI fleet, SectorEntityToken from, JumpPointAPI.JumpDestination to) {
        super.reportFleetJumped(fleet, from, to);
        if (!fleet.isPlayerFleet()) {
            return;
        }
        FactionAPI faction = Global.getSector().getPlayerFaction();
        Color color = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        Color grid = faction.getGridUIColor();
        Color bright = faction.getBrightUIColor();
        if (fleet.getContainingLocation() instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)fleet.getContainingLocation();
            CoreScript.markSystemAsEntered(system, true);
        }
    }

    public static void markSystemAsEntered(StarSystemAPI system, boolean withMessages) {
        system.setEnteredByPlayer(true);
        for (PlanetAPI planet : system.getPlanets()) {
            MarketAPI market;
            if (planet.isStar() || (market = planet.getMarket()) == null || market.getSurveyLevel() != MarketAPI.SurveyLevel.NONE) continue;
            market.setSurveyLevel(MarketAPI.SurveyLevel.SEEN);
            String type = planet.getSpec().getName();
            if (!planet.isGasGiant()) {
                type = String.valueOf(type) + " \u884c\u661f";
            }
            if (!withMessages) continue;
            MessageIntel intel = new MessageIntel("\u65b0\u884c\u661f\u6570\u636e\uff1a" + planet.getName() + ", " + type, Misc.getBasePlayerColor());
            intel.setIcon(Global.getSettings().getSpriteName("intel", "new_planet_info"));
            Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.INTEL_TAB, planet);
        }
    }

    public static void addMiscToDropData(SalvageEntityGenDataSpec.DropData data, FleetMemberAPI member, boolean weapons, boolean mods, boolean fighters) {
        Object spec;
        float p;
        ShipVariantAPI variant = member.getVariant();
        if (weapons) {
            p = Global.getSettings().getFloat("salvageWeaponProb");
            for (String slotId : variant.getNonBuiltInWeaponSlots()) {
                String weaponId = variant.getWeaponId(slotId);
                data.addWeapon(weaponId, 1.0f * p);
            }
        }
        if (mods) {
            p = Global.getSettings().getFloat("salvageHullmodProb");
            for (String id : member.getVariant().getHullMods()) {
                spec = Global.getSettings().getHullModSpec(id);
                if (spec.isHidden() || spec.isHiddenEverywhere() || spec.hasTag("no_drop")) continue;
                data.addHullMod(id, 1.0f * p);
            }
        }
        if (fighters) {
            p = Global.getSettings().getFloat("salvageWingProb");
            for (String id : member.getVariant().getFittedWings()) {
                spec = Global.getSettings().getFighterWingSpec(id);
                if (spec.hasTag("no_drop")) continue;
                data.addFighterChip(id, 1.0f * p);
            }
        }
        data.valueMult = Global.getSettings().getFloat("salvageDebrisFieldFraction");
    }

    public static Set<String> getCargoCommodities(CargoAPI \u4ed3\u7ba1\u8d39) {
        HashSet<String> result = new HashSet<String>();
        for (CargoStackAPI stack : \u4ed3\u7ba1\u8d39.getStacksCopy()) {
            if (!stack.isCommodityStack()) continue;
            result.add(stack.getCommodityId());
        }
        return result;
    }

    public static void generateOrAddToDebrisFieldFromBattle(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        float time;
        float minDays;
        Object params;
        SalvageEntityGenDataSpec.DropData \u4ed3\u7ba1\u8d39;
        float fpForThisFleet;
        if (primaryWinner == null) {
            return;
        }
        LocationAPI location = primaryWinner.getContainingLocation();
        if (location == null) {
            return;
        }
        boolean allowDebris = !location.isHyperspace();
        boolean playerInvolved = battle.isPlayerInvolved();
        SalvageEntityGenDataSpec.DropData misc = new SalvageEntityGenDataSpec.DropData();
        int miscChances = 0;
        ArrayList<SalvageEntityGenDataSpec.DropData> cargoList = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        WeightedRandomPicker<FleetMemberAPI> recoverySpecialChoices = new WeightedRandomPicker<FleetMemberAPI>();
        Vector2f com = new Vector2f();
        float count = 0.0f;
        float fpDestroyed = 0.0f;
        for (CampaignFleetAPI fleet : battle.getSnapshotSideOne()) {
            count += 1.0f;
            com.x += fleet.getLocation().x;
            com.y += fleet.getLocation().y;
            fpForThisFleet = 0.0f;
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(fleet)) {
                if (!(loss.getVariant().hasTag("ship_recoverable") || loss.isStation() || fleet.getMemoryWithoutUpdate().getBoolean("$noShipRecovery"))) {
                    recoverySpecialChoices.add(loss);
                }
                fpDestroyed += (float)loss.getFleetPointCost();
                fpForThisFleet += (float)loss.getFleetPointCost();
                if (!allowDebris || fleet.isPlayerFleet()) continue;
                CoreScript.addMiscToDropData(misc, loss, true, true, true);
                ++miscChances;
            }
            if (!allowDebris || fleet.isPlayerFleet()) continue;
            \u4ed3\u7ba1\u8d39 = new SalvageEntityGenDataSpec.DropData();
            float cargoValue = fpForThisFleet * Global.getSettings().getFloat("salvageValuePerFP");
            if (!((cargoValue *= Global.getSettings().getFloat("salvageDebrisFieldFraction")) >= 1.0f)) continue;
            for (String cid : CoreScript.getCargoCommodities(fleet.getCargo())) {
                \u4ed3\u7ba1\u8d39.addCommodity(cid, 1.0f);
            }
            \u4ed3\u7ba1\u8d39.value = (int)cargoValue;
            \u4ed3\u7ba1\u8d39.chances = 1;
            cargoList.add(\u4ed3\u7ba1\u8d39);
        }
        for (CampaignFleetAPI fleet : battle.getSnapshotSideTwo()) {
            count += 1.0f;
            com.x += fleet.getLocation().x;
            com.y += fleet.getLocation().y;
            fpForThisFleet = 0.0f;
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(fleet)) {
                if (!loss.getVariant().hasTag("ship_recoverable")) {
                    if (!loss.isStation() && !fleet.getMemoryWithoutUpdate().getBoolean("$noShipRecovery")) {
                        recoverySpecialChoices.add(loss);
                    }
                } else {
                    loss.getVariant().removeTag("ship_recoverable");
                }
                fpDestroyed += (float)loss.getFleetPointCost();
                fpForThisFleet += (float)loss.getFleetPointCost();
                if (!allowDebris || fleet.isPlayerFleet()) continue;
                CoreScript.addMiscToDropData(misc, loss, true, true, true);
                ++miscChances;
            }
            if (!allowDebris || fleet.isPlayerFleet()) continue;
            \u4ed3\u7ba1\u8d39 = new SalvageEntityGenDataSpec.DropData();
            float cargoValue = fpForThisFleet * Global.getSettings().getFloat("salvageValuePerFP");
            if (!((cargoValue *= Global.getSettings().getFloat("salvageDebrisFieldFraction")) >= 1.0f)) continue;
            for (String cid : CoreScript.getCargoCommodities(fleet.getCargo())) {
                \u4ed3\u7ba1\u8d39.addCommodity(cid, 1.0f);
            }
            \u4ed3\u7ba1\u8d39.value = (int)cargoValue;
            \u4ed3\u7ba1\u8d39.chances = 1;
            cargoList.add(\u4ed3\u7ba1\u8d39);
        }
        if (count <= 0.0f) {
            return;
        }
        com.scale(1.0f / count);
        float numShips = recoverySpecialChoices.getItems().size();
        float chanceDerelict = 1.0f - 10.0f / (numShips + 10.0f);
        int max = 3;
        if (playerInvolved) {
            max = 2;
            chanceDerelict *= 0.25f;
        }
        int i = 0;
        while (i < max && !recoverySpecialChoices.isEmpty()) {
            boolean spawnShip;
            boolean bl = spawnShip = Math.random() < (double)chanceDerelict;
            if (spawnShip) {
                FleetMemberAPI member = (FleetMemberAPI)recoverySpecialChoices.pickAndRemove();
                String variantId = member.getVariant().getHullVariantId();
                if (!member.getVariant().isStockVariant()) {
                    variantId = member.getVariant().getOriginalVariant();
                }
                if (variantId != null) {
                    params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData(variantId, DerelictShipEntityPlugin.pickBadCondition(null), 0.0f), false);
                    ((DerelictShipEntityPlugin.DerelictShipData)params).durationDays = DerelictShipEntityPlugin.getBaseDuration(member.getHullSpec().getHullSize());
                    CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(primaryWinner.getContainingLocation(), "wreck", "neutral", params);
                    entity.addTag("expires");
                    SalvageSpecialAssigner.assignSpecialForBattleWreck(entity);
                    float angle = (float)Math.random() * 360.0f;
                    float speed = 10.0f + 10.0f * (float)Math.random();
                    Vector2f vel = Misc.getUnitVectorAtDegreeAngle(angle);
                    vel.scale(speed);
                    entity.getVelocity().set((ReadableVector2f)vel);
                    entity.getLocation().x = com.x + vel.x * 3.0f;
                    entity.getLocation().y = com.y + vel.y * 3.0f;
                }
            }
            ++i;
        }
        float salvageValue = fpDestroyed * Global.getSettings().getFloat("salvageValuePerFP");
        if (Misc.isEasy()) {
            salvageValue *= Global.getSettings().getFloat("easySalvageMult");
        }
        float salvageXP = (salvageValue *= Global.getSettings().getFloat("salvageDebrisFieldFraction")) * 0.1f;
        float minForField = Global.getSettings().getFloat("minSalvageValueForDebrisField");
        if (playerInvolved) {
            minForField = 2500.0f + (float)Math.random() * 1000.0f;
        }
        if (salvageValue < minForField || !allowDebris) {
            return;
        }
        CampaignTerrainAPI debris = null;
        for (CampaignTerrainAPI curr : primaryWinner.getContainingLocation().getTerrainCopy()) {
            if (!(curr.getPlugin() instanceof DebrisFieldTerrainPlugin)) continue;
            DebrisFieldTerrainPlugin plugin = (DebrisFieldTerrainPlugin)curr.getPlugin();
            if (plugin.params.source != DebrisFieldTerrainPlugin.DebrisFieldSource.BATTLE || !(plugin.params.density >= 1.0f) || !plugin.containsPoint(com, 100.0f)) continue;
            debris = curr;
            break;
        }
        if (debris == null) {
            params = new DebrisFieldTerrainPlugin.DebrisFieldParams(200.0f, -1.0f, 1.0f, 1.0f);
            ((DebrisFieldTerrainPlugin.DebrisFieldParams)params).source = DebrisFieldTerrainPlugin.DebrisFieldSource.BATTLE;
            ((DebrisFieldTerrainPlugin.DebrisFieldParams)params).baseSalvageXP = (long)salvageXP;
            debris = (CampaignTerrainAPI)Misc.addDebrisField(location, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, null);
            debris.setDiscoverable(null);
            debris.setDiscoveryXP(null);
            debris.getLocation().set((ReadableVector2f)com);
            debris.getDropValue().clear();
            debris.getDropRandom().clear();
        }
        DebrisFieldTerrainPlugin plugin = (DebrisFieldTerrainPlugin)debris.getPlugin();
        SalvageEntityGenDataSpec.DropData basicDrop = null;
        for (SalvageEntityGenDataSpec.DropData data : debris.getDropValue()) {
            if (!"basic".equals(data.group)) continue;
            basicDrop = data;
            break;
        }
        if (basicDrop == null) {
            basicDrop = new SalvageEntityGenDataSpec.DropData();
            basicDrop.group = "basic";
            debris.addDropValue(basicDrop);
        }
        basicDrop.value = (int)((float)basicDrop.value + salvageValue);
        if (misc.getCustom() != null) {
            misc.chances = miscChances;
            float total = misc.getCustom().getTotal();
            if (total > 0.0f) {
                misc.addNothing(Math.max(1.0f, total));
            }
            debris.addDropRandom(misc);
        }
        for (SalvageEntityGenDataSpec.DropData \u4ed3\u7ba1\u8d392 : cargoList) {
            debris.addDropRandom(\u4ed3\u7ba1\u8d392);
        }
        ShipRecoverySpecial.ShipRecoverySpecialData data = ShipRecoverySpecial.getSpecialData(debris, null, true, false);
        if (data != null && data.ships.size() < 3) {
            float items = recoverySpecialChoices.getTotal();
            float total = items + 25.0f;
            int i2 = 0;
            while (i2 < 3) {
                FleetMemberAPI pick;
                if ((float)Math.random() * total < items && (pick = (FleetMemberAPI)recoverySpecialChoices.pick()) != null) {
                    String variantId = pick.getVariant().getHullVariantId();
                    if (!pick.getVariant().isStockVariant()) {
                        variantId = pick.getVariant().getOriginalVariant();
                    }
                    data.addShip(variantId, ShipRecoverySpecial.ShipCondition.WRECKED, 0.0f);
                }
                ++i2;
            }
        }
        float radius = 100.0f + (float)Math.min(900.0, Math.sqrt(basicDrop.value));
        float durationExtra = (float)Math.sqrt(salvageValue) * 0.1f;
        if (durationExtra < (minDays = 4.0f)) {
            durationExtra = minDays;
        }
        if ((time = durationExtra + plugin.params.lastsDays) > 30.0f) {
            time = 30.0f;
        }
        plugin.params.lastsDays = time;
        plugin.params.glowsDays = time;
        plugin.params.bandWidthInEngine = radius;
        plugin.params.middleRadius = plugin.params.bandWidthInEngine / 2.0f;
        float range = DebrisFieldTerrainPlugin.computeDetectionRange(plugin.params.bandWidthInEngine);
        debris.getDetectedRangeMod().modifyFlat("gen", range);
    }

    @Override
    public void reportPlayerDumpedCargo(CargoAPI \u4ed3\u7ba1\u8d39) {
        super.reportPlayerDumpedCargo(\u4ed3\u7ba1\u8d39);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CustomCampaignEntityAPI pods = Misc.addCargoPods(playerFleet.getContainingLocation(), playerFleet.getLocation());
        pods.getCargo().addAll(\u4ed3\u7ba1\u8d39);
        CargoPodsResponse script = new CargoPodsResponse(pods);
        pods.getContainingLocation().addScript(script);
        ListenerUtil.reportPlayerLeftCargoPods(pods);
    }

    @Override
    public void reportPlayerDidNotTakeCargo(CargoAPI \u4ed3\u7ba1\u8d39) {
        super.reportPlayerDumpedCargo(\u4ed3\u7ba1\u8d39);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CustomCampaignEntityAPI pods = Misc.addCargoPods(playerFleet.getContainingLocation(), playerFleet.getLocation());
        pods.getCargo().addAll(\u4ed3\u7ba1\u8d39);
        ListenerUtil.reportPlayerLeftCargoPods(pods);
    }

    public void doCustomProduction() {
        FactionAPI pf = Global.getSector().getPlayerFaction();
        FactionProductionAPI prod = pf.getProduction();
        MarketAPI gatheringPoint = prod.getGatheringPoint();
        if (gatheringPoint == null) {
            return;
        }
        CargoAPI local = Misc.getStorageCargo(gatheringPoint);
        if (local == null) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        MonthlyReport report = SharedData.getData().getCurrentReport();
        report.computeTotals();
        int total = (int)(report.getRoot().totalIncome - report.getRoot().totalUpkeep);
        int credits = (int)playerFleet.getCargo().getCredits().get();
        if ((credits += total) < 0) {
            credits = 0;
        }
        int capacity = prod.getMonthlyProductionCapacity();
        capacity = Math.min(capacity, credits);
        int remainingValue = capacity + prod.getAccruedProduction();
        if (this.prodRandom == null) {
            this.prodRandom = new Random();
        }
        Random random = this.prodRandom;
        WeightedRandomPicker<FactionProductionAPI.ItemInProductionAPI> picker = new WeightedRandomPicker<FactionProductionAPI.ItemInProductionAPI>(random);
        for (FactionProductionAPI.ItemInProductionAPI item : prod.getCurrent()) {
            if (item.getBuildDelay() > 0.0f && !Global.getSettings().isDevMode()) continue;
            picker.add(item, item.getQuantity());
        }
        int accrued = 0;
        boolean wantedToDoProduction = !picker.isEmpty();
        boolean unableToDoProduction = capacity <= 0;
        ProductionReportIntel.ProductionData data = new ProductionReportIntel.ProductionData();
        CargoAPI \u4ed3\u7ba1\u8d39 = data.getCargo("\u91cd\u5de5\u4e1a - \u5b9a\u5236\u751f\u4ea7");
        float quality = -1.0f;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.isPlayerOwned()) continue;
            float currQuality = market.getStats().getDynamic().getMod("production_quality_mod").computeEffective(0.0f);
            quality = Math.max(quality, currQuality += market.getStats().getDynamic().getMod("fleet_quality_mod").computeEffective(0.0f));
        }
        quality -= Global.getSector().getFaction("player").getDoctrine().getShipQualityContribution();
        CampaignFleetAPI ships = Global.getFactory().createEmptyFleet("player", "temp", true);
        ships.setCommander(Global.getSector().getPlayerPerson());
        DefaultFleetInflaterParams p = new DefaultFleetInflaterParams();
        p.quality = quality += 4.0f * Global.getSettings().getFloat("doctrineFleetQualityPerPoint");
        p.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        p.persistent = false;
        p.seed = random.nextLong();
        p.timestamp = null;
        FleetInflater inflater = Misc.getInflater(ships, p);
        ships.setInflater(inflater);
        int totalCost = 0;
        while (remainingValue > 0 && !picker.isEmpty()) {
            FactionProductionAPI.ItemInProductionAPI pick = (FactionProductionAPI.ItemInProductionAPI)picker.pick();
            int baseCost = pick.getBaseCost();
            int count = Math.min(pick.getQuantity(), remainingValue / Math.max(1, baseCost));
            if (count > 0) {
                count = random.nextInt(count) + 1;
            }
            if (count <= 0) {
                accrued = remainingValue;
                remainingValue = 0;
                continue;
            }
            int currCost = count * baseCost;
            totalCost += currCost;
            remainingValue -= currCost;
            if (pick.getType() == FactionProductionAPI.ProductionItemType.SHIP) {
                Object variants = Global.getSettings().getHullIdToVariantListMap().get(pick.getSpecId());
                if (variants.isEmpty()) {
                    variants.add(String.valueOf(pick.getSpecId()) + "_Hull");
                    continue;
                }
                int index = random.nextInt(variants.size());
                int i = 0;
                while (i < count) {
                    ships.getFleetData().addFleetMember((String)variants.get(index));
                    ++i;
                }
            } else if (pick.getType() == FactionProductionAPI.ProductionItemType.FIGHTER) {
                \u4ed3\u7ba1\u8d39.addFighters(pick.getSpecId(), count);
            } else if (pick.getType() == FactionProductionAPI.ProductionItemType.WEAPON) {
                \u4ed3\u7ba1\u8d39.addWeapons(pick.getSpecId(), count);
            }
            prod.removeItem(pick.getType(), pick.getSpecId(), count);
            if (pick.getQuantity() > 0) continue;
            picker.remove(pick);
        }
        int weaponCost = 0;
        ships.inflateIfNeeded();
        for (FleetMemberAPI member : ships.getFleetData().getMembersListCopy()) {
            \u4ed3\u7ba1\u8d39.getMothballedShips().addFleetMember(member);
            for (String wingId : member.getVariant().getNonBuiltInWings()) {
                FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
                weaponCost = (int)((float)weaponCost + spec.getBaseValue());
            }
            for (String slotId : member.getVariant().getNonBuiltInWeaponSlots()) {
                WeaponSpecAPI spec = member.getVariant().getWeaponSpec(slotId);
                weaponCost = (int)((float)weaponCost + spec.getBaseValue());
            }
        }
        if (!DebugFlags.WEAPONS_HAVE_COST) {
            weaponCost = 0;
        }
        int addedValue = (int)((float)totalCost * Global.getSettings().getFloat("productionSuppliesBonusFraction"));
        int sCost = (int)Global.getSettings().getCommoditySpec("supplies").getBasePrice();
        int fCost = (int)Global.getSettings().getCommoditySpec("fuel").getBasePrice();
        int cCost = (int)Global.getSettings().getCommoditySpec("crew").getBasePrice();
        int supplies = (int)((float)addedValue * (0.5f * (0.5f + random.nextFloat() * 0.5f))) / sCost;
        int fuel = (int)((float)addedValue * (0.3f * (0.5f + random.nextFloat() * 0.5f))) / fCost;
        int crew = (addedValue - sCost * supplies - fCost * fuel) / cCost;
        supplies = supplies / 10 * 10;
        fuel = fuel / 10 * 10;
        crew = crew / 10 * 10;
        \u4ed3\u7ba1\u8d39.addSupplies(supplies);
        \u4ed3\u7ba1\u8d39.addFuel(fuel);
        \u4ed3\u7ba1\u8d39.addCrew(crew);
        totalCost -= prod.getAccruedProduction();
        if ((totalCost += accrued) < 0) {
            totalCost = 0;
        }
        prod.setAccruedProduction(accrued);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.isPlayerOwned()) continue;
            for (Industry ind : market.getIndustries()) {
                Random curr;
                CargoAPI added = ind.generateCargoForGatheringPoint(curr = Misc.getRandom(random.nextLong(), 11));
                if (added == null || added.isEmpty() && (added.getMothballedShips() == null || added.getMothballedShips().getMembersListCopy().isEmpty())) continue;
                String title = ind.getCargoTitleForGatheringPoint();
                data.getCargo(title).addAll(added, true);
            }
        }
        if (!data.isEmpty() || totalCost > 0 || wantedToDoProduction && unableToDoProduction) {
            if (totalCost > 0) {
                MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
                if (marketsNode.name == null) {
                    marketsNode.name = "\u6b96\u6c11\u5730";
                    marketsNode.custom = MonthlyReport.OUTPOSTS;
                    marketsNode.tooltipCreator = report.getMonthlyReportTooltip();
                }
                MonthlyReport.FDNode production = report.getNode(marketsNode, MonthlyReport.PRODUCTION);
                production.name = "\u5b9a\u5236\u751f\u4ea7\u8ba2\u5355";
                production.custom = MonthlyReport.PRODUCTION;
                production.custom2 = \u4ed3\u7ba1\u8d39;
                production.tooltipCreator = report.getMonthlyReportTooltip();
                production.upkeep += (float)totalCost;
                if (weaponCost > 0) {
                    MonthlyReport.FDNode productionWeapons = report.getNode(marketsNode, MonthlyReport.PRODUCTION_WEAPONS);
                    productionWeapons.name = "\u7528\u4e8e\u751f\u4ea7\u8230\u8239\u4e0a\u7684\u6b66\u5668\u4e0e\u6218\u673a LPC";
                    productionWeapons.custom = MonthlyReport.PRODUCTION_WEAPONS;
                    productionWeapons.tooltipCreator = report.getMonthlyReportTooltip();
                    productionWeapons.upkeep += (float)weaponCost;
                }
            }
            for (CargoAPI curr : data.data.values()) {
                local.addAll(curr);
                local.initMothballedShips("player");
                for (FleetMemberAPI member : curr.getMothballedShips().getMembersListCopy()) {
                    member.getRepairTracker().setMothballed(false);
                    member.getRepairTracker().setCR(0.5f);
                    local.getMothballedShips().addFleetMember(member);
                }
            }
            local.sort();
            ProductionReportIntel intel = new ProductionReportIntel(gatheringPoint, data, totalCost + weaponCost, prod.getAccruedProduction(), wantedToDoProduction && unableToDoProduction);
            Global.getSector().getIntelManager().addIntel(intel);
        }
    }

    @Override
    public void reportEconomyMonthEnd() {
        MonthlyReport previous;
        float debt;
        super.reportEconomyMonthEnd();
        if (TutorialMissionIntel.isTutorialInProgress()) {
            return;
        }
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        if (marketsNode.custom != null) {
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                float incentive;
                if (!market.isPlayerOwned() || !((incentive = market.getIncentiveCredits()) > 0.0f)) continue;
                MonthlyReport.FDNode mNode = report.getNode(marketsNode, market.getId());
                if (mNode.custom != null) {
                    MonthlyReport.FDNode incNode = report.getNode(mNode, "incentives");
                    incNode.name = "\u5371\u9669\u6d25\u8d34";
                    incNode.custom = MonthlyReport.INCENTIVES;
                    incNode.mapEntity = market.getPrimaryEntity();
                    incNode.tooltipCreator = report.getMonthlyReportTooltip();
                    incNode.upkeep += incentive;
                }
                market.setIncentiveCredits(0.0f);
            }
        }
        if ((debt = (float)(previous = SharedData.getData().getPreviousReport()).getDebt()) > 0.0f) {
            MonthlyReport current = SharedData.getData().getCurrentReport();
            current.getDebtNode().upkeep = debt;
        }
        this.doCustomProduction();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        SharedData.getData().rollOverReport();
        report = SharedData.getData().getPreviousReport();
        report.setPreviousDebt(previous.getDebt());
        report.setTimestamp(Global.getSector().getClock().getTimestamp());
        report.computeTotals();
        int total = (int)(report.getRoot().totalIncome - report.getRoot().totalUpkeep);
        float credits = (int)playerFleet.getCargo().getCredits().get();
        float newCredits = credits + (float)total;
        if (newCredits < 0.0f) {
            report.setDebt((int)Math.abs(newCredits));
            newCredits = 0.0f;
        }
        playerFleet.getCargo().getCredits().set(newCredits);
        String totalStr = Misc.getDGSCredits(Math.abs(total));
        String title = "\u6708\u6536\u76ca\uff1a" + totalStr;
        Color highlight = Misc.getHighlightColor();
        if (total < 0) {
            title = "\u6bcf\u6708\u652f\u51fa\uff1a" + totalStr;
            highlight = Misc.getNegativeHighlightColor();
        }
        MessageIntel intel = new MessageIntel(title, Misc.getBasePlayerColor(), new String[]{totalStr}, highlight);
        intel.setIcon(Global.getSettings().getSpriteName("intel", "monthly_income_report"));
        if (total >= 0) {
            intel.setSound("ui_intel_monthly_income_positive");
        } else {
            intel.setSound("ui_intel_monthly_income_negative");
        }
        Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.INCOME_TAB, "income_report");
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        super.reportEconomyTick(iterIndex);
        if (TutorialMissionIntel.isTutorialInProgress()) {
            return;
        }
        int crewSalary = Global.getSettings().getInt("crewSalary");
        int marineSalary = Global.getSettings().getInt("marineSalary");
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        float f = 1.0f / numIter;
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode fleetNode = report.getNode(MonthlyReport.FLEET);
        fleetNode.name = "\u8230\u961f";
        fleetNode.custom = MonthlyReport.FLEET;
        fleetNode.tooltipCreator = report.getMonthlyReportTooltip();
        int crewCost = playerFleet.getCargo().getCrew() * crewSalary;
        MonthlyReport.FDNode crewNode = report.getNode(fleetNode, MonthlyReport.CREW);
        crewNode.upkeep += (float)crewCost * f;
        crewNode.name = "\u8239\u5458\u5de5\u8d44";
        crewNode.custom = MonthlyReport.CREW;
        crewNode.tooltipCreator = report.getMonthlyReportTooltip();
        int marineCost = playerFleet.getCargo().getMarines() * marineSalary;
        if (marineSalary > 0) {
            MonthlyReport.FDNode marineNode = report.getNode(fleetNode, MonthlyReport.MARINES);
            marineNode.upkeep += (float)marineCost * f;
            marineNode.name = "\u9646\u6218\u961f\u5458\u5de5\u8d44";
            marineNode.custom = MonthlyReport.MARINES;
            marineNode.tooltipCreator = report.getMonthlyReportTooltip();
        }
        MonthlyReport.FDNode officersNode = report.getNode(fleetNode, MonthlyReport.OFFICERS);
        officersNode.name = "\u519b\u5b98\u5de5\u8d44";
        officersNode.custom = MonthlyReport.OFFICERS;
        officersNode.tooltipCreator = report.getMonthlyReportTooltip();
        for (OfficerDataAPI od : playerFleet.getFleetData().getOfficersCopy()) {
            float salary = Misc.getOfficerSalary(od.getPerson());
            MonthlyReport.FDNode oNode = report.getNode(officersNode, od.getPerson().getId());
            oNode.name = od.getPerson().getName().getFullName();
            oNode.upkeep += salary * f;
            oNode.custom = od;
        }
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        marketsNode.name = "\u6b96\u6c11\u5730";
        marketsNode.custom = MonthlyReport.OUTPOSTS;
        marketsNode.tooltipCreator = report.getMonthlyReportTooltip();
        MonthlyReport.FDNode storageNode = null;
        float storageFraction = Global.getSettings().getFloat("storageFreeFraction");
        int index = 0;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.isPlayerOwned() && Misc.playerHasStorageAccess(market)) {
                float vc = Misc.getStorageCargoValue(market);
                float vs = Misc.getStorageShipValue(market);
                float fc = (int)(vc * storageFraction);
                float fs = (int)(vs * storageFraction);
                if (!(fc > 0.0f) && !(fs > 0.0f)) continue;
                if (storageNode == null) {
                    storageNode = report.getNode(MonthlyReport.STORAGE);
                    storageNode.name = "\u4ed3\u5e93";
                    storageNode.custom = MonthlyReport.STORAGE;
                    storageNode.tooltipCreator = report.getMonthlyReportTooltip();
                }
                MonthlyReport.FDNode mNode = report.getNode(storageNode, market.getId());
                String desc = "";
                desc = fc > 0.0f && fs > 0.0f ? "ships & cargo" : (fc > 0.0f ? "\u4ed3\u7ba1\u8d39" : "ships");
                mNode.name = String.valueOf(market.getName()) + " (" + desc + ")";
                mNode.custom = market;
                mNode.custom2 = MonthlyReport.STORAGE;
                mNode.upkeep += (fc + fs) * f;
                continue;
            }
            if (!market.isPlayerOwned()) continue;
            MonthlyReport.FDNode mNode = report.getNode(marketsNode, market.getId());
            mNode.name = String.valueOf(market.getName()) + " (" + market.getSize() + ")";
            mNode.custom = market;
            MonthlyReport.FDNode indNode = report.getNode(mNode, "industries");
            indNode.name = "\u5de5\u4e1a\u8bbe\u65bd & \u5176\u4ed6\u8bbe\u65bd";
            indNode.custom = MonthlyReport.INDUSTRIES;
            indNode.mapEntity = market.getPrimaryEntity();
            indNode.tooltipCreator = report.getMonthlyReportTooltip();
            for (Industry curr : market.getIndustries()) {
                MonthlyReport.FDNode iNode = report.getNode(indNode, curr.getId());
                iNode.name = curr.getCurrentName();
                iNode.income += (float)curr.getIncome().getModifiedInt() * f;
                iNode.upkeep += (float)curr.getUpkeep().getModifiedInt() * f;
                iNode.custom = curr;
                iNode.mapEntity = market.getPrimaryEntity();
            }
            MonthlyReport.FDNode exportNode = report.getNode(mNode, "exports");
            exportNode.name = "Exports";
            exportNode.custom = MonthlyReport.EXPORTS;
            exportNode.mapEntity = market.getPrimaryEntity();
            exportNode.tooltipCreator = report.getMonthlyReportTooltip();
            this.addExportsGroupedByCommodity(report, exportNode, market, f);
            ++index;
        }
        MonthlyReport.FDNode adminNode = report.getNode(marketsNode, MonthlyReport.ADMIN);
        adminNode.name = "\u884c\u653f\u5b98";
        adminNode.custom = MonthlyReport.ADMIN;
        adminNode.tooltipCreator = report.getMonthlyReportTooltip();
        for (AdminData data : Global.getSector().getCharacterData().getAdmins()) {
            float salary = Misc.getAdminSalary(data.getPerson());
            if (salary <= 0.0f) continue;
            MonthlyReport.FDNode aNode = report.getNode(adminNode, data.getPerson().getId());
            aNode.name = data.getPerson().getName().getFullName();
            if (data.getMarket() != null) {
                aNode.name = String.valueOf(aNode.name) + " (" + data.getMarket().getName() + ")";
            } else {
                aNode.name = String.valueOf(aNode.name) + " (\u672a\u4e0a\u4efb) ";
                salary *= Global.getSettings().getFloat("idleAdminSalaryMult");
            }
            aNode.upkeep += salary * f;
            aNode.custom = data;
        }
    }

    protected void addExportsGroupedByCommodity(MonthlyReport report, MonthlyReport.FDNode parent, MarketAPI market, float f) {
        for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
            MonthlyReport.FDNode eNode = report.getNode(parent, com.getId());
            eNode.name = com.getCommodity().getName();
            eNode.income += (float)com.getExportIncome() * f;
            eNode.custom = com;
            eNode.mapEntity = market.getPrimaryEntity();
        }
    }

    public static class ExportCommodityGroupData {
        public CommodityOnMarketAPI com;
        public int quantity;
    }
}

