/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.plugins.DModAdderPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DModManager {
    public static int MAX_DMODS_FROM_COMBAT = Global.getSettings().getInt("maxDModsAddedByCombat");
    public static int reduceNextDmodsBy = 0;
    public static boolean assumeAllShipsAreAutomated = false;

    public static boolean setDHull(ShipVariantAPI variant) {
        variant.setSource(VariantSource.REFIT);
        if (!variant.getHullSpec().isDefaultDHull()) {
            String dHullId = Misc.getDHullId(variant.getHullSpec());
            ShipHullSpecAPI dHull = Global.getSettings().getHullSpec(dHullId);
            variant.setHullSpecAPI(dHull);
            return true;
        }
        return false;
    }

    public static void addDMods(FleetEncounterContextPlugin.FleetMemberData data, boolean own, CampaignFleetAPI recoverer, Random random) {
        DModManager.addDMods(data.getMember(), data.getStatus() == FleetEncounterContextPlugin.Status.DESTROYED, own, recoverer, random);
    }

    public static void addDMods(FleetMemberAPI member, boolean destroyed, boolean own, CampaignFleetAPI recoverer, Random random) {
        ShipVariantAPI variant = member.getVariant();
        DModManager.addDMods(variant, destroyed, own, recoverer, random);
    }

    public static void addDMods(ShipVariantAPI variant, boolean destroyed, boolean own, CampaignFleetAPI recoverer, Random random) {
        boolean hasStructDamage;
        if (random == null) {
            random = new Random();
        }
        DModAdderPlugin.DModAdderParams params = new DModAdderPlugin.DModAdderParams();
        params.variant = variant;
        params.destroyed = destroyed;
        params.own = own;
        params.recoverer = recoverer;
        params.random = random;
        DModAdderPlugin plugin = Global.getSector().getGenericPlugins().pickPlugin(DModAdderPlugin.class, params);
        if (plugin != null) {
            plugin.addDMods(params);
            return;
        }
        if (destroyed) {
            DModManager.addAllPermaModsWithTags(variant, "destroyedDamageAlways");
        }
        List<HullModSpecAPI> potentialMods = DModManager.getModsWithTags("damage");
        DModManager.removeUnsuitedMods(variant, potentialMods);
        boolean bl = hasStructDamage = DModManager.getNumDMods(variant, "damageStruct") > 0;
        if (hasStructDamage) {
            potentialMods = DModManager.getModsWithoutTags(potentialMods, "damageStruct");
        }
        if (variant.getHullSpec().getFighterBays() > 0) {
            potentialMods.addAll(DModManager.getModsWithTags("fighterBayDamage"));
        }
        if (variant.getHullSpec().isPhase()) {
            potentialMods.addAll(DModManager.getModsWithTags("phaseDamage"));
        }
        DModManager.removeModsAlreadyInVariant(variant, potentialMods);
        int num = 2 + random.nextInt(3);
        int reduction = 0;
        reduction += reduceNextDmodsBy;
        reduceNextDmodsBy = 0;
        if (recoverer != null) {
            int extra = (int)recoverer.getStats().getDynamic().getValue("ship_dmod_reduction_mod", 0.0f);
            extra = extra >= 0 ? random.nextInt(extra + 1) : -1 * random.nextInt(-extra + 1);
            reduction += extra;
        }
        if ((num -= reduction) < 1) {
            num = 1;
        }
        int already = DModManager.getNumDMods(variant);
        int add = num - already;
        if (own) {
            add = 1 - reduction;
        }
        if (add + already > MAX_DMODS_FROM_COMBAT) {
            add = MAX_DMODS_FROM_COMBAT - already;
        }
        if (add <= 0) {
            return;
        }
        WeightedRandomPicker<HullModSpecAPI> picker = new WeightedRandomPicker<HullModSpecAPI>(random);
        picker.addAll(potentialMods);
        int i = 0;
        while (i < add && !picker.isEmpty()) {
            HullModSpecAPI pick = (HullModSpecAPI)picker.pickAndRemove();
            if (pick != null) {
                if (pick.hasTag("damageStruct") && DModManager.getNumDMods(variant, "damageStruct") > 0) {
                    --i;
                } else {
                    variant.removeSuppressedMod(pick.getId());
                    variant.addPermaMod(pick.getId(), false);
                }
            }
            ++i;
        }
    }

    public static void addDMods(FleetMemberAPI member, boolean canAddDestroyedMods, int num, Random random) {
        ShipVariantAPI variant = member.getVariant();
        DModManager.addDMods(variant, canAddDestroyedMods, num, random);
    }

    public static void addDMods(ShipVariantAPI variant, boolean canAddDestroyedMods, int num, Random random) {
        boolean hasStructDamage;
        if (random == null) {
            random = new Random();
        }
        DModAdderPlugin.DModAdderParams params = new DModAdderPlugin.DModAdderParams();
        params.variant = variant;
        params.canAddDestroyedMods = canAddDestroyedMods;
        params.num = num;
        params.random = random;
        DModAdderPlugin plugin = Global.getSector().getGenericPlugins().pickPlugin(DModAdderPlugin.class, params);
        if (plugin != null) {
            plugin.addDMods(params);
            return;
        }
        List<HullModSpecAPI> potentialMods = DModManager.getModsWithTags("damage");
        if (canAddDestroyedMods) {
            potentialMods.addAll(DModManager.getModsWithTags("destroyedDamageAlways"));
        }
        DModManager.removeUnsuitedMods(variant, potentialMods);
        boolean bl = hasStructDamage = DModManager.getNumDMods(variant, "damageStruct") > 0;
        if (hasStructDamage) {
            potentialMods = DModManager.getModsWithoutTags(potentialMods, "damageStruct");
        }
        if (variant.getHullSpec().getFighterBays() > 0) {
            potentialMods.addAll(DModManager.getModsWithTags("fighterBayDamage"));
        }
        if (variant.getHullSpec().isPhase()) {
            potentialMods.addAll(DModManager.getModsWithTags("phaseDamage"));
        }
        if (variant.isCarrier()) {
            potentialMods.addAll(DModManager.getModsWithTags("carrierDamageAlways"));
        }
        potentialMods = new ArrayList<HullModSpecAPI>(potentialMods);
        DModManager.removeModsAlreadyInVariant(variant, potentialMods);
        WeightedRandomPicker<HullModSpecAPI> picker = new WeightedRandomPicker<HullModSpecAPI>(random);
        picker.addAll(potentialMods);
        int added = 0;
        int i = 0;
        while (i < num && !picker.isEmpty()) {
            HullModSpecAPI pick = (HullModSpecAPI)picker.pickAndRemove();
            if (pick != null) {
                if (pick.hasTag("damageStruct") && DModManager.getNumDMods(variant, "damageStruct") > 0) {
                    --i;
                } else {
                    variant.removeSuppressedMod(pick.getId());
                    variant.addPermaMod(pick.getId(), false);
                    ++added;
                }
            }
            ++i;
        }
    }

    public static void removeUnsuitedMods(ShipVariantAPI variant, List<HullModSpecAPI> mods) {
        boolean auto = variant.hasHullMod("automated");
        if (assumeAllShipsAreAutomated) {
            auto = true;
        }
        boolean civ = variant.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.CIVILIAN);
        boolean phase = variant.getHullSpec().isPhase();
        boolean peakTime = variant.getHullSpec().getNoCRLossTime() < 10000.0f;
        boolean shields = variant.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.FRONT || variant.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.OMNI;
        Iterator<HullModSpecAPI> iter = mods.iterator();
        while (iter.hasNext()) {
            HullModSpecAPI curr = iter.next();
            if (!peakTime && curr.hasTag("peak_time")) {
                iter.remove();
                continue;
            }
            if (phase && curr.hasTag("notPhase")) {
                iter.remove();
                continue;
            }
            if (auto && curr.hasTag("notAuto")) {
                iter.remove();
                continue;
            }
            if (civ && curr.hasTag("notCiv")) {
                iter.remove();
                continue;
            }
            if (civ && !curr.hasTag("civ") && !curr.hasTag("civOnly")) {
                iter.remove();
                continue;
            }
            if (!civ && curr.hasTag("civOnly")) {
                iter.remove();
                continue;
            }
            if (shields || !curr.hasTag("reqShields")) continue;
            iter.remove();
        }
    }

    public static void removeModsAlreadyInVariant(ShipVariantAPI variant, List<HullModSpecAPI> mods) {
        Iterator<HullModSpecAPI> iter = mods.iterator();
        while (iter.hasNext()) {
            HullModSpecAPI curr = iter.next();
            if (!variant.hasHullMod(curr.getId())) continue;
            iter.remove();
        }
    }

    public static int addAllPermaModsWithTags(ShipVariantAPI variant, String ... tags) {
        int added = 0;
        for (HullModSpecAPI mod : DModManager.getModsWithTags(tags)) {
            if (!variant.hasHullMod(mod.getId())) {
                ++added;
            }
            variant.removeSuppressedMod(mod.getId());
            variant.addPermaMod(mod.getId(), false);
        }
        return added;
    }

    public static List<HullModSpecAPI> getModsWithoutTags(List<HullModSpecAPI> mods, String ... tags) {
        ArrayList<HullModSpecAPI> result = new ArrayList<HullModSpecAPI>();
        block0: for (HullModSpecAPI mod : mods) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (mod.hasTag(tag)) continue block0;
                ++n2;
            }
            result.add(mod);
        }
        return result;
    }

    public static List<HullModSpecAPI> getModsWithTags(String ... tags) {
        ArrayList<HullModSpecAPI> result = new ArrayList<HullModSpecAPI>();
        for (HullModSpecAPI mod : Global.getSettings().getAllHullModSpecs()) {
            if (!mod.getTags().containsAll(Arrays.asList(tags))) continue;
            result.add(mod);
        }
        return result;
    }

    public static int getNumDMods(ShipVariantAPI variant) {
        int count = 0;
        for (String id : variant.getHullMods()) {
            if (!DModManager.getMod(id).hasTag("dmod")) continue;
            ++count;
        }
        return count;
    }

    public static int getNumNonBuiltInDMods(ShipVariantAPI variant) {
        int count = 0;
        for (String id : variant.getHullMods()) {
            if (!DModManager.getMod(id).hasTag("dmod") || variant.getHullSpec().getBuiltInMods().contains(id)) continue;
            ++count;
        }
        return count;
    }

    public static int getNumDMods(ShipVariantAPI variant, String ... tags) {
        int count = 0;
        for (String id : variant.getHullMods()) {
            HullModSpecAPI mod = DModManager.getMod(id);
            if (!mod.getTags().containsAll(Arrays.asList(tags)) || !mod.hasTag("dmod")) continue;
            ++count;
        }
        return count;
    }

    public static HullModSpecAPI getMod(String id) {
        return Global.getSettings().getHullModSpec(id);
    }

    public static void removeDMod(ShipVariantAPI v, String id) {
        ShipHullSpecAPI base = v.getHullSpec().getDParentHull();
        if (!v.getHullSpec().isDefaultDHull() && !v.getHullSpec().isRestoreToBase()) {
            base = v.getHullSpec();
        }
        if (base == null && v.getHullSpec().isRestoreToBase()) {
            base = v.getHullSpec().getBaseHull();
        }
        if (base.isBuiltInMod(id)) {
            v.removePermaMod(id);
            v.addSuppressedMod(id);
        } else {
            v.removePermaMod(id);
            v.removeMod(id);
        }
    }
}

