/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.GateIntel;
import com.fs.starfarer.api.impl.campaign.world.ZigLeashAssignmentAI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.JitterUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WarpingSpriteRendererUtil;
import java.awt.Color;
import java.util.LinkedHashSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GateEntityPlugin
extends BaseCustomEntityPlugin {
    public static float ACCUMULATED_TRANSIT_DIST_DECAY_RATE = 20.0f;
    public static float MOTE_SPAWN_MULT_BASELINE_DIST_LY = 25.0f;
    public static String GATE_DATA = "gateData";
    public static String GATE_SCANNED = "$gateScanned";
    public static String CAN_SCAN_GATES = "$canScanGates";
    public static String GATES_ACTIVE = "$gatesActive";
    public static String PLAYER_CAN_USE_GATES = "$playerCanUseGates";
    public static String NUM_GATES_SCANNED = "$numGatesScanned";
    protected transient SpriteAPI baseSprite;
    protected transient SpriteAPI scannedGlow;
    protected transient SpriteAPI activeGlow;
    protected transient SpriteAPI whirl1;
    protected transient SpriteAPI whirl2;
    protected transient SpriteAPI starfield;
    protected transient SpriteAPI rays;
    protected transient SpriteAPI concentric;
    protected transient WarpingSpriteRendererUtil warp;
    protected FaderUtil beingUsedFader = new FaderUtil(0.0f, 1.0f, 1.0f, false, true);
    protected FaderUtil glowFader = new FaderUtil(0.0f, 1.0f, 1.0f, true, true);
    protected boolean madeActive = false;
    protected boolean addedIntel = false;
    protected float showBeingUsedDur = 0.0f;
    protected float accumulatedTransitDistLY = 0.0f;
    protected Color jitterColor = null;
    protected JitterUtil jitter;
    protected FaderUtil jitterFader = null;
    protected IntervalUtil moteSpawn = null;
    protected float inUseAngle = 0.0f;
    protected transient boolean scaledSprites = false;

    public static int getNumGatesScanned() {
        return Global.getSector().getMemoryWithoutUpdate().getInt(NUM_GATES_SCANNED);
    }

    public static void addGateScanned() {
        int num = GateEntityPlugin.getNumGatesScanned();
        Global.getSector().getMemoryWithoutUpdate().set(NUM_GATES_SCANNED, ++num);
    }

    public static GateData getGateData() {
        Object data = Global.getSector().getPersistentData().get(GATE_DATA);
        if (!(data instanceof GateData)) {
            data = new GateData();
            Global.getSector().getPersistentData().put(GATE_DATA, data);
        }
        return (GateData)data;
    }

    public static boolean isScanned(SectorEntityToken gate) {
        return gate.getMemoryWithoutUpdate().getBoolean(GATE_SCANNED);
    }

    public static boolean isActive(SectorEntityToken gate) {
        return gate.getCustomPlugin() instanceof GateEntityPlugin && ((GateEntityPlugin)gate.getCustomPlugin()).isActive();
    }

    public static boolean areGatesActive() {
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(GATES_ACTIVE)) {
            return true;
        }
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        return cargo.getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("janus", null)) > 0.0f;
    }

    public static boolean canUseGates() {
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(PLAYER_CAN_USE_GATES)) {
            return true;
        }
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        return cargo.getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("janus", null)) > 0.0f;
    }

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        this.scannedGlow = Global.getSettings().getSprite("gates", "glow_scanned");
        this.activeGlow = Global.getSettings().getSprite("gates", "glow_ring_active");
        this.concentric = Global.getSettings().getSprite("gates", "glow_concentric");
        this.rays = Global.getSettings().getSprite("gates", "glow_rays");
        this.whirl1 = Global.getSettings().getSprite("gates", "glow_whirl1");
        this.whirl2 = Global.getSettings().getSprite("gates", "glow_whirl2");
        this.starfield = Global.getSettings().getSprite("gates", "starfield");
        if (this.beingUsedFader == null) {
            this.beingUsedFader = new FaderUtil(0.0f, 1.0f, 1.0f, false, true);
        }
        if (this.glowFader == null) {
            this.glowFader = new FaderUtil(0.0f, 1.0f, 1.0f, true, true);
            this.glowFader.fadeIn();
        }
        this.inUseAngle = 0.0f;
        return this;
    }

    public void jitter() {
        if (this.jitterFader == null) {
            this.jitterFader = new FaderUtil(0.0f, 2.0f, 2.0f);
            this.jitterFader.setBounceDown(true);
        }
        if (this.jitter == null) {
            this.jitter = new JitterUtil();
            this.jitter.updateSeed();
        }
        this.jitterFader.fadeIn();
    }

    public float getJitterLevel() {
        if (this.jitterFader != null) {
            return this.jitterFader.getBrightness();
        }
        return 0.0f;
    }

    public Color getJitterColor() {
        return this.jitterColor;
    }

    public void setJitterColor(Color jitterColor) {
        this.jitterColor = jitterColor;
    }

    public boolean isActive() {
        return this.madeActive;
    }

    public void showBeingUsed(float transitDistLY) {
        this.showBeingUsed(10.0f, transitDistLY);
    }

    public void showBeingUsed(float dur, float transitDistLY) {
        this.beingUsedFader.fadeIn();
        this.showBeingUsedDur = dur;
        this.accumulatedTransitDistLY += transitDistLY;
    }

    public float getProximitySoundFactor() {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float dist = Misc.getDistance(player.getLocation(), this.entity.getLocation());
        float radSum = this.entity.getRadius() + player.getRadius();
        dist -= radSum;
        float f = 1.0f;
        if (dist > 300.0f) {
            f = 1.0f - (dist - 300.0f) / 100.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void playProximityLoop() {
        float prox;
        if (!this.isActive() || !this.entity.isInCurrentLocation()) {
            return;
        }
        float volumeMult = prox = this.getProximitySoundFactor();
        float suppressionMult = prox;
        if (volumeMult <= 0.0f) {
            return;
        }
        volumeMult = (float)Math.sqrt(volumeMult);
        Global.getSector().getCampaignUI().suppressMusic(1.0f * suppressionMult);
        float dirToEntity = Misc.getAngleInDegrees(this.entity.getLocation(), this.entity.getLocation());
        Vector2f playbackLoc = Misc.getUnitVectorAtDegreeAngle(dirToEntity);
        playbackLoc.scale(500.0f);
        Vector2f.add((Vector2f)this.entity.getLocation(), (Vector2f)playbackLoc, (Vector2f)playbackLoc);
        Global.getSoundPlayer().playLoop("active_gate_loop", this.entity, 1.0f, 1.0f * volumeMult, playbackLoc, Misc.ZERO);
        if (!this.beingUsedFader.isIdle()) {
            Global.getSoundPlayer().playLoop("gate_being_used", this.entity, 1.0f, 1.0f * volumeMult, playbackLoc, Misc.ZERO);
        }
    }

    public void advance(float amount) {
        if (this.showBeingUsedDur > 0.0f || !this.beingUsedFader.isIdle()) {
            this.showBeingUsedDur -= amount;
            if (this.showBeingUsedDur > 0.0f) {
                this.beingUsedFader.fadeIn();
            } else {
                this.showBeingUsedDur = 0.0f;
            }
            this.inUseAngle += amount * 60.0f;
            if (this.warp != null) {
                this.warp.advance(amount);
            }
        }
        this.glowFader.advance(amount);
        if (this.jitterFader != null) {
            this.jitterFader.advance(amount);
            if (this.jitterFader.isFadedOut()) {
                this.jitterFader = null;
            }
        }
        if (this.accumulatedTransitDistLY > 0.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.accumulatedTransitDistLY -= days * ACCUMULATED_TRANSIT_DIST_DECAY_RATE;
            if (this.accumulatedTransitDistLY < 0.0f) {
                this.accumulatedTransitDistLY = 0.0f;
            }
        }
        this.beingUsedFader.advance(amount);
        if (!this.madeActive && GateEntityPlugin.canUseGates() && GateEntityPlugin.isScanned(this.entity)) {
            if (this.entity.getName().equals(this.entity.getCustomEntitySpec().getDefaultName())) {
                this.entity.setName("\u6fc0\u6d3b\u7684\u661f\u95e8");
            }
            this.entity.setCustomDescriptionId("active_gate");
            this.entity.setInteractionImage("illustrations", "active_gate");
            this.entity.removeTag("neutrino");
            this.entity.addTag("neutrino_high");
            this.madeActive = true;
        }
        if (this.entity.isInCurrentLocation()) {
            if (amount > 0.0f) {
                this.playProximityLoop();
                if (this.jitter != null) {
                    this.jitter.updateSeed();
                }
                if (!(this.addedIntel || Global.getSector().isInNewGameAdvance() || Global.getSector().isInFastAdvance())) {
                    boolean alreadyHas = false;
                    for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(GateIntel.class)) {
                        if (((GateIntel)intel).getGate() != this.entity) continue;
                        alreadyHas = true;
                        break;
                    }
                    if (!alreadyHas) {
                        Global.getSector().getIntelManager().addIntel(new GateIntel(this.entity));
                    }
                    this.addedIntel = true;
                }
                if (this.beingUsedFader.getBrightness() > 0.0f) {
                    if (this.moteSpawn == null) {
                        this.moteSpawn = new IntervalUtil(0.01f, 20.0f);
                    }
                    float moteSpawnMult = this.accumulatedTransitDistLY / MOTE_SPAWN_MULT_BASELINE_DIST_LY;
                    this.moteSpawn.advance(amount * moteSpawnMult);
                    if (this.moteSpawn.intervalElapsed()) {
                        ZigLeashAssignmentAI.spawnMote(this.entity);
                    }
                } else {
                    this.moteSpawn = null;
                }
            } else {
                this.moteSpawn = null;
            }
        }
    }

    public float getRenderRange() {
        return this.entity.getRadius() + 500.0f;
    }

    public void createMapTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color color = this.entity.getFaction().getBaseUIColor();
        tooltip.addPara(this.entity.getName(), color, 0.0f);
        if (GateEntityPlugin.isScanned(this.entity)) {
            if (GateEntityPlugin.areGatesActive()) {
                tooltip.addPara("\u5df2\u6fc0\u6d3b", Misc.getGrayColor(), 3.0f);
            } else {
                tooltip.addPara("\u5df2\u626b\u63cf", Misc.getGrayColor(), 3.0f);
            }
        }
    }

    public boolean hasCustomMapTooltip() {
        return true;
    }

    public void appendToCampaignTooltip(TooltipMakerAPI tooltip, SectorEntityToken.VisibilityLevel level) {
        if (GateEntityPlugin.isScanned(this.entity)) {
            tooltip.setParaFontDefault();
            if (GateEntityPlugin.areGatesActive()) {
                tooltip.addPara("\u8be5\u661f\u95e8\u76ee\u524d\u5df2\u88ab\u6fc0\u6d3b\u3002", Misc.getGrayColor(), 10.0f);
            } else {
                tooltip.addPara("\u5df2\u7ecf\u626b\u63cf\u4e86\u8fd9\u5904\u661f\u95e8\u3002", Misc.getGrayColor(), 10.0f);
            }
        }
    }

    protected void scaleGlowSprites() {
        if (this.scaledSprites) {
            return;
        }
        CustomEntitySpecAPI spec = this.entity.getCustomEntitySpec();
        if (spec != null) {
            this.baseSprite = Global.getSettings().getSprite(spec.getSpriteName());
            this.baseSprite.setSize(spec.getSpriteWidth(), spec.getSpriteHeight());
            this.scaledSprites = true;
            float scale = spec.getSpriteWidth() / Global.getSettings().getSprite(spec.getSpriteName()).getWidth();
            this.scannedGlow.setSize(this.scannedGlow.getWidth() * scale, this.scannedGlow.getHeight() * scale);
            this.activeGlow.setSize(this.activeGlow.getWidth() * scale, this.activeGlow.getHeight() * scale);
            this.rays.setSize(this.rays.getWidth() * scale, this.rays.getHeight() * scale);
            this.whirl1.setSize(this.whirl1.getWidth() * scale, this.whirl1.getHeight() * scale);
            this.whirl2.setSize(this.whirl2.getWidth() * scale, this.whirl2.getHeight() * scale);
            this.starfield.setSize(this.starfield.getWidth() * scale, this.starfield.getHeight() * scale);
            this.concentric.setSize(this.concentric.getWidth() * scale, this.concentric.getHeight() * scale);
        }
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        if (layer == CampaignEngineLayers.BELOW_STATIONS) {
            boolean beingUsed;
            boolean bl = beingUsed = !this.beingUsedFader.isFadedOut();
            if (beingUsed) {
                float alphaMult = viewport.getAlphaMult();
                alphaMult *= this.entity.getSensorFaderBrightness();
                if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
                    return;
                }
                if (this.warp == null) {
                    int cells = 6;
                    float cs = this.starfield.getWidth() / 10.0f;
                    this.warp = new WarpingSpriteRendererUtil(cells, cells, cs * 0.2f, cs * 0.2f, 2.0f);
                }
                Vector2f loc = this.entity.getLocation();
                float glowAlpha = 1.0f;
                this.scaleGlowSprites();
                this.starfield.setAlphaMult(alphaMult * (glowAlpha *= this.beingUsedFader.getBrightness()));
                this.starfield.setAdditiveBlend();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glBlendFunc((int)770, (int)771);
                this.warp.renderNoBlendOrRotate(this.starfield, loc.x + 1.5f - this.starfield.getWidth() / 2.0f, loc.y - this.starfield.getHeight() / 2.0f, false);
            }
        }
        if (layer == CampaignEngineLayers.STATIONS) {
            float alphaMult = viewport.getAlphaMult();
            alphaMult *= this.entity.getSensorFaderBrightness();
            if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
                return;
            }
            CustomEntitySpecAPI spec = this.entity.getCustomEntitySpec();
            if (spec == null) {
                return;
            }
            float w = spec.getSpriteWidth();
            float h = spec.getSpriteHeight();
            float scale = spec.getSpriteWidth() / Global.getSettings().getSprite(spec.getSpriteName()).getWidth();
            Vector2f loc = this.entity.getLocation();
            Color scannedGlowColor = new Color(255, 200, 0, 255);
            Color activeGlowColor = new Color(200, 50, 255, 255);
            scannedGlowColor = Color.white;
            activeGlowColor = Color.white;
            float glowAlpha = 1.0f;
            float glowMod1 = 0.5f + 0.5f * this.glowFader.getBrightness();
            float glowMod2 = 0.75f + 0.25f * this.glowFader.getBrightness();
            boolean beingUsed = !this.beingUsedFader.isFadedOut();
            boolean scanned = GateEntityPlugin.isScanned(this.entity);
            boolean active = GateEntityPlugin.areGatesActive();
            this.scaleGlowSprites();
            if (this.jitterFader != null && this.jitter != null) {
                Color c = this.jitterColor;
                if (c == null) {
                    c = new Color(255, 255, 255, 255);
                }
                this.baseSprite.setColor(c);
                this.baseSprite.setAlphaMult(alphaMult * this.jitterFader.getBrightness());
                this.baseSprite.setAdditiveBlend();
                this.jitter.render(this.baseSprite, loc.x, loc.y, 30.0f * this.jitterFader.getBrightness(), 10);
                this.baseSprite.renderAtCenter(loc.x, loc.y);
            }
            if (!active && scanned) {
                this.scannedGlow.setColor(scannedGlowColor);
                this.scannedGlow.setAlphaMult(alphaMult * glowAlpha * glowMod1);
                this.scannedGlow.setAdditiveBlend();
                this.scannedGlow.renderAtCenter(loc.x, loc.y);
            }
            if (active && scanned) {
                this.activeGlow.setColor(activeGlowColor);
                this.activeGlow.setAlphaMult(alphaMult * glowAlpha * glowMod2);
                this.activeGlow.setAdditiveBlend();
                this.activeGlow.renderAtCenter(loc.x, loc.y);
            }
            if (beingUsed) {
                if (!active) {
                    this.activeGlow.setColor(activeGlowColor);
                    this.activeGlow.setAlphaMult(alphaMult * glowAlpha * this.beingUsedFader.getBrightness() * glowMod2);
                    this.activeGlow.setAdditiveBlend();
                    this.activeGlow.renderAtCenter(loc.x, loc.y);
                }
                this.rays.setAlphaMult(alphaMult * (glowAlpha *= this.beingUsedFader.getBrightness()));
                this.rays.setAdditiveBlend();
                this.rays.renderAtCenter(loc.x + 1.5f, loc.y);
                this.concentric.setAlphaMult(alphaMult * glowAlpha * 1.0f);
                this.concentric.setAdditiveBlend();
                this.concentric.renderAtCenter(loc.x + 1.5f, loc.y);
                float angle = -this.inUseAngle * 0.25f;
                angle = Misc.normalizeAngle(angle);
                this.whirl1.setAngle(angle);
                this.whirl1.setAlphaMult(alphaMult * glowAlpha);
                this.whirl1.setAdditiveBlend();
                this.whirl1.renderAtCenter(loc.x + 1.5f, loc.y);
                angle = -this.inUseAngle * 0.33f;
                angle = Misc.normalizeAngle(angle);
                this.whirl2.setAngle(angle);
                this.whirl2.setAlphaMult(alphaMult * glowAlpha * 0.5f);
                this.whirl2.setAdditiveBlend();
                this.whirl2.renderAtCenter(loc.x + 1.5f, loc.y);
            }
        }
    }

    public static class GateData {
        public LinkedHashSet<SectorEntityToken> scanned = new LinkedHashSet();
    }
}

