/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class HasslePlayerScript
implements EveryFrameScript {
    public static final String HASSLE_COMPLETE_KEY = "$hassleComplete";
    public static final String HASSLE_TIMEOUT_KEY = "$hassleTimeout";
    private IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    private float currDuration = 0.0f;
    private float currElapsed = 0.0f;
    private CampaignFleetAPI curr = null;
    private Vector2f startHyperLoc;
    private float leashRange = 0.0f;

    public void advance(float amount) {
        boolean hassle;
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.curr != null) {
            this.maintainOngoingHassle(days);
            return;
        }
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        float MAX_RANGE_FROM_PLAYER = 2000.0f;
        final MemoryAPI global = Global.getSector().getMemoryWithoutUpdate();
        final CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null || player.isInHyperspace()) {
            return;
        }
        List<CampaignFleetAPI> fleets = Misc.findNearbyFleets(player, 2000.0f, new Misc.FleetFilter(){

            public boolean accept(CampaignFleetAPI curr) {
                SectorEntityToken.VisibilityLevel vis;
                if (curr.getFaction().isPlayerFaction()) {
                    return false;
                }
                if (curr.isHostileTo(player)) {
                    return false;
                }
                if (curr.isStationMode()) {
                    return false;
                }
                if (!curr.getMemoryWithoutUpdate().getBoolean("$willHasslePlayer")) {
                    return false;
                }
                if (curr.getMemoryWithoutUpdate().getBoolean("$core_fleetSpecialAction")) {
                    return false;
                }
                String type = curr.getMemoryWithoutUpdate().getString("$hassleType");
                if (type == null || type.isEmpty()) {
                    return false;
                }
                String timeoutKey = "$hassleTimeout_" + type;
                if (global.contains(timeoutKey)) {
                    return false;
                }
                if (curr.getAI() instanceof ModularFleetAIAPI) {
                    ModularFleetAIAPI ai = (ModularFleetAIAPI)curr.getAI();
                    if (ai.isFleeing()) {
                        return false;
                    }
                    if (curr.getInteractionTarget() instanceof CampaignFleetAPI) {
                        return false;
                    }
                }
                return (vis = player.getVisibilityLevelTo(curr)) != SectorEntityToken.VisibilityLevel.NONE;
            }
        });
        if (fleets.isEmpty()) {
            return;
        }
        float minDist = Float.MAX_VALUE;
        CampaignFleetAPI closestHassler = null;
        for (CampaignFleetAPI curr : fleets) {
            float dist = Misc.getDistance(player.getLocation(), curr.getLocation());
            if (!(dist < minDist)) continue;
            minDist = dist;
            closestHassler = curr;
        }
        if (closestHassler == null) {
            return;
        }
        this.curr = closestHassler;
        boolean bl = hassle = (float)Math.random() < 0.25f;
        if (hassle) {
            this.currDuration = 10.0f + (float)Math.random() * 5.0f;
            this.currElapsed = 0.0f;
            MemoryAPI mem = this.curr.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$pursuePlayer", "hassle", true, 1.0f);
            mem.set("$core_fleetSpecialAction", true, 1.0f);
            Misc.setFlagWithReason(mem, "$keepPursuingPlayer", "hassle", true, this.currDuration);
            this.startHyperLoc = this.curr.getLocationInHyperspace();
            this.leashRange = Global.getSettings().getFloat("commRelayRangeAroundSystem");
            if (this.curr.isInHyperspace()) {
                this.leashRange *= 2.0f;
            }
            float timeoutDuration = 20.0f + (float)Math.random() * 10.0f;
            String type = this.curr.getMemoryWithoutUpdate().getString("$hassleType");
            if (type != null && !type.isEmpty()) {
                String timeoutKey = "$hassleTimeout_" + type;
                global.set(timeoutKey, true, timeoutDuration);
            }
        } else {
            this.curr = null;
        }
    }

    public void maintainOngoingHassle(float days) {
        float dist;
        if (!this.curr.isAlive()) {
            this.cleanUpCurr();
            return;
        }
        if (this.curr.isHostileTo(Global.getSector().getPlayerFleet())) {
            this.cleanUpCurr();
            return;
        }
        this.currElapsed += days;
        if (this.currElapsed > this.currDuration) {
            this.cleanUpCurr();
            return;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (this.startHyperLoc != null && (dist = Misc.getDistanceLY(player.getLocationInHyperspace(), this.startHyperLoc)) > this.leashRange) {
            this.cleanUpCurr();
            return;
        }
        MemoryAPI mem = this.curr.getMemoryWithoutUpdate();
        if (mem.getBoolean(HASSLE_COMPLETE_KEY)) {
            this.cleanUpCurr();
            return;
        }
        Misc.setFlagWithReason(mem, "$core_fleetBusy", "hassle", true, 1.0f);
        mem.set("$core_fleetSpecialAction", true, 1.0f);
        SectorEntityToken.VisibilityLevel vis = player.getVisibilityLevelTo(this.curr);
        if (vis != SectorEntityToken.VisibilityLevel.NONE) {
            Misc.setFlagWithReason(mem, "$pursuePlayer", "hassle", true, 1.0f);
        }
    }

    protected void cleanUpCurr() {
        if (this.curr != null) {
            ModularFleetAIAPI ai;
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            FleetAssignmentDataAPI a = this.curr.getCurrentAssignment();
            if (a != null && a.getAssignment() == FleetAssignment.INTERCEPT && a.getTarget() == pf) {
                this.curr.removeFirstAssignmentIfItIs(a.getAssignment());
            }
            this.curr.setInteractionTarget(null);
            if (this.curr.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.curr.getAI()).getTacticalModule().getTarget() == pf) {
                ai.getTacticalModule().setTarget(null);
            }
            MemoryAPI mem = this.curr.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$core_fleetBusy", "hassle", false, 0.0f);
            mem.unset("$core_fleetSpecialAction");
            Misc.setFlagWithReason(mem, "$pursuePlayer", "hassle", false, 0.0f);
            Misc.setFlagWithReason(mem, "$keepPursuingPlayer", "hassle", false, 0.0f);
            mem.unset(HASSLE_COMPLETE_KEY);
            this.curr = null;
            this.currElapsed = 0.0f;
            this.currDuration = 0.0f;
            this.startHyperLoc = null;
            this.leashRange = 0.0f;
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

