/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.impl.items.WormholeScannerPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.abilities.TransponderAbility;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumpPointInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static final String UNSTABLE_KEY = "$unstable";
    public static final String CAN_STABILIZE = "$canStabilize";
    public static float WORMHOLE_FUEL_USE_MULT = 5.0f;
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private CampaignFleetAPI playerFleet;
    private JumpPointAPI jumpPoint;
    protected boolean shownConfirm = false;
    protected boolean canAfford;
    protected OptionId beingConfirmed = null;
    private List<OptionId> jumpOptions = Arrays.asList(OptionId.JUMP_1, OptionId.JUMP_2, OptionId.JUMP_3, OptionId.JUMP_4, OptionId.JUMP_5, OptionId.JUMP_6, OptionId.JUMP_7, OptionId.JUMP_8, OptionId.JUMP_9);
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private EngagementResultAPI lastResult = null;
    private Map<OptionId, JumpPointAPI.JumpDestination> destinationMap = new HashMap<OptionId, JumpPointAPI.JumpDestination>();
    protected OptionId lastOptionMousedOver = null;
    protected float fuelCost;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.jumpPoint = (JumpPointAPI)dialog.getInteractionTarget();
        this.fuelCost = this.playerFleet.getLogistics().getFuelCostPerLightYear();
        float rounded = Math.round(this.fuelCost);
        if (this.fuelCost > 0.0f && rounded <= 0.0f) {
            rounded = 1.0f;
        }
        this.fuelCost = rounded;
        if (this.isWormhole()) {
            this.fuelCost *= WORMHOLE_FUEL_USE_MULT;
        } else if (this.jumpPoint.isInHyperspace()) {
            this.fuelCost = 0.0f;
        }
        this.canAfford = this.fuelCost <= this.playerFleet.getCargo().getFuel();
        this.visual.setVisualFade(0.25f, 0.25f);
        if (this.jumpPoint.getCustomInteractionDialogImageVisual() != null) {
            this.visual.showImageVisual(this.jumpPoint.getCustomInteractionDialogImageVisual());
        } else if (this.isWormhole()) {
            this.visual.showImagePortion("illustrations", "jump_point_wormhole", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        } else if (this.playerFleet.getContainingLocation().isHyperspace()) {
            this.visual.showImagePortion("illustrations", "jump_point_hyper", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        } else {
            this.visual.showImagePortion("illustrations", "jump_point_normal", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        }
        dialog.setOptionOnEscape("\u79bb\u5f00", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        JumpPointAPI.JumpDestination dest;
        if (optionData == null) {
            return;
        }
        if ("DumpMemory.option_dump_memory" == optionData) {
            HashMap<String, MemoryAPI> memoryMap = new HashMap<String, MemoryAPI>();
            MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
            memoryMap.put("local", memory);
            if (this.dialog.getInteractionTarget().getFaction() != null) {
                memoryMap.put("faction", this.dialog.getInteractionTarget().getFaction().getMemory());
            } else {
                memoryMap.put("faction", Global.getFactory().createMemory());
            }
            memoryMap.put("global", Global.getSector().getMemory());
            memoryMap.put("player", Global.getSector().getCharacterData().getMemory());
            if (this.dialog.getInteractionTarget().getMarket() != null) {
                memoryMap.put("market", this.dialog.getInteractionTarget().getMarket().getMemory());
            }
            new DumpMemory().execute(null, this.dialog, null, memoryMap);
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        boolean unstable = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(UNSTABLE_KEY);
        boolean stabilizing = this.jumpPoint.getMemoryWithoutUpdate().getExpire(UNSTABLE_KEY) > 0.0f;
        boolean canStabilize = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(CAN_STABILIZE);
        boolean canTransverseJump = Global.getSector().getPlayerFleet().hasAbility("fracture_jump");
        boolean tutorialInProgress = TutorialMissionIntel.isTutorialInProgress();
        switch (option) {
            case INIT: {
                if (this.isWormhole()) {
                    this.addText("\u4f60\u7684\u8230\u961f\u9760\u8fd1\u4e86\u866b\u6d1e\u3002");
                } else {
                    this.addText(this.getString("approach"));
                }
                Description desc = Global.getSettings().getDescription(this.jumpPoint.getCustomDescriptionId(), Description.Type.CUSTOM);
                if (desc != null && desc.hasText3()) {
                    this.addText(desc.getText3());
                }
                String noun = "\u8df3\u8dc3\u70b9";
                if (this.isWormhole()) {
                    noun = "\u866b\u6d1e";
                }
                if (unstable) {
                    if (this.isWormhole() && stabilizing) {
                        float dur = this.jumpPoint.getMemoryWithoutUpdate().getExpire(UNSTABLE_KEY);
                        String durStr = "" + (int)dur;
                        String \u5929 = "\u5929";
                        if ((int)dur == 1) {
                            \u5929 = "\u5929";
                        }
                        if ((int)dur <= 0) {
                            \u5929 = "\u5929";
                            durStr = "1";
                        }
                        this.textPanel.addPara("\u8fd9\u4e2a\u866b\u6d1e\u6b63\u5728\u6267\u884c\u7a33\u5b9a\u5316\uff0c\u5e94\u8be5\u5728\u53ef\u7528\u4e4b\u524d\u9700\u8981\u7ecf\u8fc7 %s" + \u5929 + ".", Misc.getHighlightColor(), durStr);
                    } else {
                        if (stabilizing && !canTransverseJump) {
                            if (tutorialInProgress) {
                                this.addText("\u8fd9\u4e2a\u8df3\u8dc3\u70b9\u6b63\u5728\u6267\u884c\u7a33\u5b9a\u5316\uff0c\u5e94\u8be5\u5728\u4e00\u5929\u4e4b\u5185\u53d8\u5f97\u53ef\u7528\u3002");
                            } else {
                                this.addText("\u8fd9\u4e2a\u8df3\u8dc3\u70b9\u6b63\u5728\u6267\u884c\u7a33\u5b9a\u5316\uff0c\u4f60\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\u3002");
                            }
                        } else {
                            this.addText("\u8fd9\u4e2a\u8df3\u8dc3\u70b9\u662f\u4e0d\u7a33\u5b9a\u7684\uff0c\u65e0\u6cd5\u4f7f\u7528\u3002");
                        }
                        if (canTransverseJump && !tutorialInProgress) {
                            this.addText("\u5728\u5b83\u7a33\u5b9a\u4e4b\u524d\uff0c\u53ea\u80fd\u901a\u8fc7\u6a2a\u8f74\u8df3\u8dc3\u8fdb\u5165\u8d85\u7a7a\u95f4\u3002");
                        }
                    }
                } else {
                    if (!this.jumpPoint.isInHyperspace()) {
                        if (this.canAfford) {
                            if (!this.jumpPoint.getDestinations().isEmpty() && this.isWormhole()) {
                                this.addText("\u5bfc\u822a\u8ba1\u7b97\u673a\u901a\u8fc7\u9a71\u52a8\u573a\u6ce2\u5411\u866b\u6d1e\u8282\u70b9\u53d1\u51fa\u901a\u8baf\u8bf7\u6c42\uff0c\u5e76\u5efa\u7acb\u8d77\u4e86\u6570\u636e\u8fde\u63a5\u3002\u8fde\u63a5\u8fc7\u7a0b\u4ec5\u8017\u65f6\u4e0d\u5230\u4e00\u5206\u949f\uff0c\u800c\u4eba\u5de5\u91cd\u529b\u81ea\u52a8\u6821\u6b63\u7ed9\u4f60\u5e26\u6765\u7684\u8f7b\u5fae\u4e0d\u9002\u4e5f\u53ea\u6301\u7eed\u4e86\u4e00\u77ac\u3002\u4f60\u7684\u4e3b\u754c\u9762\u4e0a\u663e\u793a\u51fa\u4e00\u4efd\u53ef\u4ee5\u524d\u5f80\u7684\u76ee\u7684\u5730\u5217\u8868\u3002");
                            }
                            this.textPanel.addParagraph("\u6fc0\u6d3b\u8be5 " + noun + " \u5e76\u8ba9\u4f60\u7684\u8230\u961f\u7a7f\u8fc7\uff0c\u9700\u8981 " + (int)this.fuelCost + " \u70b9\u71c3\u6599\u3002");
                            this.textPanel.highlightInLastPara(Misc.getHighlightColor(), "" + (int)this.fuelCost);
                        } else {
                            int fuel = (int)this.playerFleet.getCargo().getFuel();
                            if (fuel == 0) {
                                this.textPanel.addParagraph("\u6fc0\u6d3b\u8be5 " + noun + " \u5e76\u8ba9\u4f60\u7684\u8230\u961f\u7a7f\u8fc7\uff0c\u9700\u8981 " + (int)this.fuelCost + " \u71c3\u6599\u3002\u4f60\u5df2\u7ecf\u6ca1\u6709\u71c3\u6599\u3002");
                            } else {
                                this.textPanel.addParagraph("\u6fc0\u6d3b\u8be5 " + noun + " \u5e76\u8ba9\u4f60\u7684\u8230\u961f\u7a7f\u8fc7\uff0c\u9700\u8981 " + (int)this.fuelCost + " \u71c3\u6599\u3002\u4f60\u53ea\u62e5\u6709 " + fuel + " \u70b9\u71c3\u6599\u3002");
                            }
                            this.textPanel.highlightInLastPara(Misc.getNegativeHighlightColor(), "" + (int)this.fuelCost, "" + fuel);
                        }
                    }
                    if (this.canAfford) {
                        this.showWarningIfNeeded();
                    }
                }
                this.createInitialOptions();
                break;
            }
            case STABILIZE: {
                this.jumpPoint.getMemoryWithoutUpdate().unset(CAN_STABILIZE);
                this.jumpPoint.getMemoryWithoutUpdate().expire(UNSTABLE_KEY, 1.0f);
                this.addText("\u4f60\u5c06\u7a33\u5b9a\u7b97\u6cd5\u8f93\u5165\u8df3\u8dc3\u7a0b\u5e8f\uff0c\u968f\u540e\u9a71\u52a8\u529b\u573a\u53d1\u751f\u4e86\u4e00\u7cfb\u5217\u5185\u884c\u4eba\u624d\u4f1a\u6ce8\u610f\u5230\u7684\u6ce2\u52a8\uff0c\u7528\u5171\u632f\u9010\u6e10\u62b5\u6d88\u4e86\u540e\u8005\u7684\u4e0d\u7a33\u5b9a\u6027\u3002");
                this.addText("\u8df3\u8dc3\u70b9\u76ee\u524d\u7684\u7a33\u5b9a\u6027\u8db3\u4ee5\u5728\u4e00\u5929\u5185\u6b63\u5e38\u4f7f\u7528\u3002");
                this.createInitialOptions();
                break;
            }
            case JUMP_CONFIRM_TURN_TRANSPONDER_ON: {
                AbilityPlugin t = Global.getSector().getPlayerFleet().getAbility("transponder");
                if (t != null && !t.isActive()) {
                    t.activate();
                }
                this.optionSelected(null, (Object)this.beingConfirmed);
                break;
            }
            case JUMP_CONFIRM: {
                this.optionSelected(null, (Object)this.beingConfirmed);
                break;
            }
            case RETRIEVE_ANCHOR_CONFIRM: {
                this.dialog.getTextPanel().addPara("\u4f60\u4e0b\u4ee4\u5c06\u6b64\u6267\u884c\u3002\u4e0d\u4e45\u4e4b\u540e\uff0c\u4f60\u7684\u884c\u52a8\u957f\u5b98\u6c47\u62a5\u786e\u8ba4\u866b\u6d1e\u951a\u5b9a\u88c5\u7f6e\u5df2\u88ab\u56de\u6536\u5e76\u59a5\u5584\u5b89\u7f6e\u5728\u4f60\u65d7\u8230\u7684\u4fdd\u9669\u4ed3\u5185\u3002");
                WormholeManager.get().removeWormhole(this.jumpPoint, this.dialog);
                this.options.clearOptions();
                this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                break;
            }
            case RETRIEVE_ANCHOR: {
                this.dialog.getTextPanel().addPara("\u8fd9\u5c06\u6467\u6bc1\u866b\u6d1e\uff0c\u5e76\u5c06\u7a33\u5b9a\u70b9\u7a7a\u51fa\u4ee5\u4f9b\u53e6\u4f5c\u4ed6\u7528\u3002");
                this.options.clearOptions();
                this.options.addOption("\u786e\u8ba4\u6267\u884c", (Object)OptionId.RETRIEVE_ANCHOR_CONFIRM, null);
                this.options.addOption("\u653e\u5f03", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                break;
            }
            case LEAVE: {
                Global.getSector().getCampaignUI().setFollowingDirectCommand(true);
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
        if (this.jumpOptions.contains((Object)option) && (dest = this.destinationMap.get((Object)option)) != null) {
            if (!this.shownConfirm) {
                SectorEntityToken target = dest.getDestination();
                CampaignFleetAPI player = Global.getSector().getPlayerFleet();
                if (target != null && target.getContainingLocation() != null && !target.getContainingLocation().isHyperspace() && !player.isTransponderOn()) {
                    List<FactionAPI> wouldBecomeHostile = TransponderAbility.getFactionsThatWouldBecomeHostile(player);
                    boolean wouldMindTOff = false;
                    boolean isPopulated = false;
                    for (MarketAPI market : Global.getSector().getEconomy().getMarkets(target.getContainingLocation())) {
                        if (market.isHidden() || market.getFaction().isPlayerFaction()) continue;
                        isPopulated = true;
                        if (market.getFaction().isHostileTo("player") || market.isFreePort() || market.getFaction().getCustomBoolean("allowsTransponderOffTrade")) continue;
                        wouldMindTOff = true;
                    }
                    if (isPopulated) {
                        if (wouldMindTOff) {
                            this.textPanel.addPara("\u7531\u4e8e\u4f60\u7684\u5e94\u7b54\u5668\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u5982\u679c\u8d38\u7136\u8fdb\u5165 " + target.getContainingLocation().getNameWithLowercaseType() + " \u4e00\u65e6\u88ab\u9644\u8fd1\u5de1\u903b\u961f\u53d1\u73b0\uff0c\u5c06\u7ed9\u4f60\u5e26\u6765\u4e0d\u5fc5\u8981\u7684\u9ebb\u70e6\u3002");
                        } else {
                            this.textPanel.addPara("\u5c3d\u7ba1\u4f60\u7684\u5e94\u7b54\u5668\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u4f46\u4e0d\u4f1a\u5f15\u8d77 " + target.getContainingLocation().getNameWithLowercaseType() + " \u5185\u5de1\u903b\u961f\u7684\u6ce8\u610f\u3002");
                        }
                        if (!wouldBecomeHostile.isEmpty()) {
                            String str = "\u6253\u5f00\u5e94\u7b54\u5668\u65f6\u4f1a\u66b4\u9732\u4f60\u7684\u654c\u5bf9\u884c\u4e3a";
                            boolean first = true;
                            boolean last = false;
                            for (FactionAPI faction : wouldBecomeHostile) {
                                last = wouldBecomeHostile.indexOf(faction) == wouldBecomeHostile.size() - 1;
                                str = first || !last ? String.valueOf(str) + " " + faction.getDisplayNameWithArticle() + "," : String.valueOf(str) + " \u548c " + faction.getDisplayNameWithArticle() + ",";
                            }
                            str = String.valueOf(str.substring(0, str.length() - 1)) + ".";
                            this.textPanel.addPara(str, Misc.getNegativeHighlightColor());
                        }
                        this.options.clearOptions();
                        this.options.addOption("\u6253\u5f00\u5e94\u7b54\u5668\uff0c\u7136\u540e\u8df3\u8dc3", (Object)OptionId.JUMP_CONFIRM_TURN_TRANSPONDER_ON, null);
                        this.options.addOption("\u4f9d\u65e7\u5173\u95ed\u5e94\u7b54\u5668\u5e76\u76f4\u63a5\u8df3\u8dc3", (Object)OptionId.JUMP_CONFIRM, null);
                        this.beingConfirmed = option;
                        this.options.addOption("\u4e2d\u6b62\u8df3\u8dc3", (Object)OptionId.LEAVE, null);
                        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                        this.shownConfirm = true;
                        return;
                    }
                }
            }
            if (Global.getSector().getUIData().getCourseTarget() == this.dialog.getInteractionTarget()) {
                Global.getSector().getCampaignUI().clearLaidInCourse();
            }
            this.dialog.dismiss();
            Global.getSector().setPaused(false);
            Global.getSector().doHyperspaceTransition(this.playerFleet, this.jumpPoint, dest);
            this.playerFleet.getCargo().removeFuel(this.fuelCost);
            return;
        }
    }

    protected void showWarningIfNeeded() {
        if (this.isWormhole()) {
            return;
        }
        if (this.jumpPoint.getDestinations().isEmpty()) {
            return;
        }
        JumpPointAPI.JumpDestination dest = this.jumpPoint.getDestinations().get(0);
        SectorEntityToken target = dest.getDestination();
        if (target == null || target.getContainingLocation() == null) {
            return;
        }
        ArrayList<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>();
        boolean \u654c\u610f = false;
        float minDist = Float.MAX_VALUE;
        int maxDanger = 0;
        for (CampaignFleetAPI other : target.getContainingLocation().getFleets()) {
            float dist = Misc.getDistance(target, other);
            if (!(dist < 1000.0f)) continue;
            fleets.add(other);
            \u654c\u610f = other.getAI() != null ? (\u654c\u610f |= other.getAI().isHostileTo(Global.getSector().getPlayerFleet())) : (\u654c\u610f |= other.getFaction().isHostileTo("player"));
            if (other.getMemoryWithoutUpdate().getBoolean("$isPirate")) {
                \u654c\u610f = true;
            }
            if (\u654c\u610f) {
                maxDanger = Math.max(maxDanger, Misc.getDangerLevel(other));
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        TextPanelAPI text = this.dialog.getTextPanel();
        if (maxDanger >= 2) {
            String noun = "\u8df3\u8dc3\u70b9";
            if (this.isWormhole()) {
                noun = "\u866b\u6d1e";
            }
            text.addPara("\u8b66\u544a\uff01", Misc.getNegativeHighlightColor());
            Global.getSoundPlayer().playUISound("cr_playership_malfunction", 1.0f, 0.25f);
            String where = "\u79bb\u51fa\u53e3\u4e0d\u8fdc\u7684\u9644\u8fd1\u6709\u5904\u5728\u6d3b\u8dc3\u72b6\u6001\u4e0b\u7684\u9a71\u52a8\u5668";
            String whereHL = "";
            if (minDist < 300.0f) {
                whereHL = where = "\u79bb\u51fa\u53e3\u5f88\u8fd1\u7684\u5730\u65b9\u6709\u5904\u5728\u6d3b\u8dc3\u72b6\u6001\u4e0b\u7684\u9a71\u52a8\u5668";
            }
            text.addPara("\u6839\u636e\u8df3\u8dc3\u70b9\u8868\u73b0\u51fa\u7684\u6ce2\u52a8\u7279\u5f81\uff0c\u53e6\u4e00\u4fa7" + where + ".", Misc.getNegativeHighlightColor(), whereHL);
            text.addPara("\u4f60\u6240\u53d1\u5c04\u7684\u4e00\u6b21\u6027\u63a2\u6d4b\u5668\u5e26\u6765\u4e86\u4e00\u5219\u654c\u6211\u8bc6\u522b\u4fe1\u606f\uff1a\u51fa\u53e3\u9644\u8fd1\u7684\u8230\u961f\u62b1\u6709 \u654c\u610f \u4e14\u53ef\u80fd\u5bf9\u6211\u65b9\u8230\u961f\u6784\u6210 \u5a01\u80c1", Misc.getNegativeHighlightColor(), "\u654c\u610f", "\u5a01\u80c1");
        }
    }

    private void createInitialOptions() {
        this.options.clearOptions();
        boolean dev = Global.getSettings().isDevMode();
        float navigation = Global.getSector().getPlayerFleet().getCommanderStats().getSkillLevel("navigation");
        boolean isStarAnchor = this.jumpPoint.isStarAnchor();
        boolean okToUseIfAnchor = isStarAnchor && navigation >= 7.0f;
        okToUseIfAnchor = true;
        if (isStarAnchor && !okToUseIfAnchor && dev) {
            this.addText(" (\u59cb\u7ec8\u53ef\u4ee5\u5728\u5f00\u53d1\u6a21\u5f0f\u4e0b\u4f7f\u7528) ");
        }
        okToUseIfAnchor |= dev;
        String noun = "\u8df3\u8dc3\u70b9";
        if (this.isWormhole()) {
            noun = "\u866b\u6d1e";
        }
        boolean unstable = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(UNSTABLE_KEY);
        boolean canStabilize = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(CAN_STABILIZE);
        if (unstable) {
            if (canStabilize) {
                this.options.addOption("\u7a33\u5b9a\u8df3\u8dc3\u70b9", (Object)OptionId.STABILIZE, null);
            }
        } else if (this.jumpPoint.getDestinations().isEmpty()) {
            if (this.isWormhole()) {
                this.addText("\u8fd9\u4e2a\u866b\u6d1e\u672a\u8fde\u63a5\u5230\u5176\u4ed6\u866b\u6d1e\u8282\u70b9\uff0c\u65e0\u6cd5\u4f7f\u7528\u3002");
            } else {
                this.addText(this.getString("noExits"));
            }
        } else if (!(this.playerFleet.getCargo().getFuel() <= 0.0f) || this.canAfford) {
            if (isStarAnchor && !okToUseIfAnchor) {
                this.addText(this.getString("starAnchorUnusable"));
            } else if (this.canAfford) {
                int index = 0;
                for (JumpPointAPI.JumpDestination dest : this.jumpPoint.getDestinations()) {
                    if (index >= this.jumpOptions.size()) break;
                    OptionId option = this.jumpOptions.get(index);
                    ++index;
                    if (this.isWormhole()) {
                        this.options.addOption("\u8fdb\u5165\uff0c\u5e76\u8f6c\u79fb\u5230 " + dest.getLabelInInteractionDialog(), (Object)option, null);
                        boolean canUse = WormholeScannerPlugin.canPlayerUseWormholes();
                        if (!canUse) {
                            this.options.setEnabled((Object)option, false);
                            this.options.setTooltip((Object)option, "\u4f60\u5fc5\u987b\u62e5\u6709 \u866b\u6d1e\u626b\u63cf\u4eea \u624d\u80fd\u4f7f\u7528\u866b\u6d1e\u3002");
                        }
                    } else {
                        this.options.addOption("\u8fdb\u5165\uff0c\u5e76\u8df3\u8dc3\u5230 " + dest.getLabelInInteractionDialog(), (Object)option, null);
                    }
                    this.destinationMap.put(option, dest);
                }
            }
        }
        if (this.isWormhole()) {
            this.options.addOption("\u6467\u6bc1\u866b\u6d1e\u5e76\u56de\u6536\u866b\u6d1e\u951a\u5b9a\u88c5\u7f6e", (Object)OptionId.RETRIEVE_ANCHOR, null);
        }
        this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        if (Global.getSettings().getBoolean("oneClickJumpPoints") && this.jumpPoint.getDestinations().size() == 1) {
            this.dialog.setOpacity(0.0f);
            this.dialog.setBackgroundDimAmount(0.0f);
            this.optionSelected(null, (Object)OptionId.JUMP_1);
        }
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    private String getString(String id) {
        String str = Global.getSettings().getString("jumpPointInteractionDialog", id);
        String fleetOrShip = "\u8230\u961f";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        return str;
    }

    @Override
    public Object getContext() {
        return null;
    }

    public boolean isWormhole() {
        return this.jumpPoint.isWormhole();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        JUMP_1,
        JUMP_2,
        JUMP_3,
        JUMP_4,
        JUMP_5,
        JUMP_6,
        JUMP_7,
        JUMP_8,
        JUMP_9,
        JUMP_CONFIRM_TURN_TRANSPONDER_ON,
        JUMP_CONFIRM,
        STABILIZE,
        RETRIEVE_ANCHOR,
        RETRIEVE_ANCHOR_CONFIRM,
        LEAVE;

    }
}

