/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class LeashScript
implements EveryFrameScript {
    private CampaignFleetAPI fleet;
    private float range;
    private Script onBroken;
    private SectorEntityToken anchor;
    private Vector2f offset;
    private boolean broken = false;

    public LeashScript(CampaignFleetAPI fleet, float range, SectorEntityToken anchor, Vector2f offset, Script onBroken) {
        this.fleet = fleet;
        this.range = range;
        this.onBroken = onBroken;
        this.anchor = anchor;
        this.offset = offset;
    }

    public void advance(float amount) {
        float dist;
        if (this.fleet.getContainingLocation() != this.anchor.getContainingLocation()) {
            this.broken = true;
            this.onBroken.run();
        }
        if (this.broken) {
            return;
        }
        Vector2f dest = new Vector2f(this.anchor.getLocation().x + this.offset.x, this.anchor.getLocation().y + this.offset.y);
        float distToDest = Misc.getDistance(dest, this.fleet.getLocation());
        this.fleet.setMoveDestination(dest.x, dest.y);
        if (distToDest < 2.0f) {
            this.fleet.setLocation(dest.x, dest.y);
        }
        if ((dist = Misc.getDistance(this.anchor.getLocation(), this.fleet.getLocation())) > this.range + this.anchor.getRadius() + this.fleet.getRadius()) {
            this.broken = true;
            this.onBroken.run();
        }
    }

    public boolean isDone() {
        return this.broken;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

