/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class MonthlyReportNodeTooltipCreator
implements TooltipMakerAPI.TooltipCreator {
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
        MonthlyReport.FDNode node = (MonthlyReport.FDNode)tooltipParam;
        float pad = 3.0f;
        float opad = 10.0f;
        int crewSalary = Global.getSettings().getInt("crewSalary");
        int marineSalary = Global.getSettings().getInt("marineSalary");
        int officerBase = Global.getSettings().getInt("officerSalaryBase");
        int officerPerLevel = Global.getSettings().getInt("officerSalaryPerLevel");
        float storageFreeFraction = Global.getSettings().getFloat("storageFreeFraction");
        Color h = Misc.getHighlightColor();
        FactionAPI faction = Global.getSector().getPlayerFaction();
        Color color = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        Color grid = faction.getGridUIColor();
        Color bright = faction.getBrightUIColor();
        if (MonthlyReport.FLEET.equals(node.custom)) {
            tooltip.addPara("\u4e0e\u8230\u961f\u76f8\u5173\u7684\u6536\u5165\u548c\u5f00\u9500\u3002", 0.0f);
        } else if (MonthlyReport.OUTPOSTS.equals(node.custom)) {
            tooltip.addPara("\u6b96\u6c11\u5730\u76f8\u5173\u7684\u6536\u5165\u4e0e\u5f00\u652f\u3002", 0.0f);
        } else if (MonthlyReport.PRODUCTION_WEAPONS.equals(node.custom)) {
            tooltip.addPara("Weapons and fighter LPCs installed on produced ships.", 0.0f);
        } else if (MonthlyReport.PRODUCTION.equals(node.custom)) {
            FactionAPI pf;
            FactionProductionAPI prod;
            int accrued;
            float currPad = 0.0f;
            if (node.custom2 instanceof CargoAPI) {
                CargoAPI cargo = (CargoAPI)node.custom2;
                if (!cargo.isEmpty()) {
                    tooltip.addSectionHeading("\u8bbe\u5907", color, dark, Alignment.MID, currPad);
                    tooltip.showCargo(cargo, 10, true, opad);
                    currPad = opad;
                }
                ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
                ships.addAll(cargo.getMothballedShips().getMembersListCopy());
                if (!ships.isEmpty()) {
                    tooltip.addSectionHeading("\u8230\u8239", color, dark, Alignment.MID, currPad);
                    tooltip.showShips(ships, 10, true, opad);
                }
            }
            if ((accrued = (prod = (pf = Global.getSector().getPlayerFaction()).getProduction()).getAccruedProduction()) > 0) {
                tooltip.addPara("\u5171\u6709\u4ef7\u503c %s \u7684\u751f\u4ea7\u80fd\u529b\u88ab\u6295\u5165\u5230\u672a\u5b8c\u6210\u7684\u9879\u76ee\u4e2d\u3002", currPad, Misc.getHighlightColor(), Misc.getDGSCredits(accrued));
            }
        } else if (MonthlyReport.STOCKPILING.equals(node.custom)) {
            if (node.custom2 instanceof CargoAPI) {
                tooltip.addPara("\u56e0\u4f7f\u7528\u5f53\u5730\u5e93\u5b58\u6765\u5e94\u5bf9\u77ed\u7f3a\u800c\u4ea7\u751f\u7684\u8d39\u7528\u3002", 0.0f);
                CargoAPI cargo = (CargoAPI)node.custom2;
                if (!cargo.isEmpty()) {
                    tooltip.addSectionHeading("\u8d44\u6e90", color, dark, Alignment.MID, opad);
                    tooltip.showCargo(cargo, 10, true, opad);
                }
                ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
                ships.addAll(cargo.getMothballedShips().getMembersListCopy());
                if (!ships.isEmpty()) {
                    tooltip.addSectionHeading("\u8230\u8239", color, dark, Alignment.MID, opad);
                    tooltip.showShips(ships, 10, true, opad);
                }
            }
        } else if (MonthlyReport.RESTOCKING.equals(node.custom)) {
            if (node.custom2 instanceof CargoAPI) {
                tooltip.addPara("\u586b\u8865\u5df1\u65b9\u8230\u961f\u6240\u62ff\u53bb\u7684\u8d44\u6e90\uff0c\u800c\u4ea7\u751f\u7684\u8d39\u7528\u3002", 0.0f);
                CargoAPI cargo = (CargoAPI)node.custom2;
                if (!cargo.isEmpty()) {
                    tooltip.addSectionHeading("\u8d44\u6e90", color, dark, Alignment.MID, opad);
                    tooltip.showCargo(cargo, 10, true, opad);
                }
                ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
                ships.addAll(cargo.getMothballedShips().getMembersListCopy());
                if (!ships.isEmpty()) {
                    tooltip.addSectionHeading("\u8230\u8239", color, dark, Alignment.MID, opad);
                    tooltip.showShips(ships, 10, true, opad);
                }
            }
        } else if (MonthlyReport.OFFICERS.equals(node.custom)) {
            tooltip.addPara("\u6bcf\u540d\u519b\u5b98\u6bcf\u6708\u83b7\u5f97 %s \u661f\u5e01\u7684\u57fa\u672c\u5de5\u8d44\uff0c\u4e14\u519b\u8854\u6bcf\u63d0\u9ad8\u4e00\u7ea7\u5c06\u63d0\u9ad8 %s \u661f\u5e01\u3002", 0.0f, h, Misc.getWithDGS(officerBase), Misc.getWithDGS(officerPerLevel));
        } else if (MonthlyReport.ADMIN.equals(node.custom)) {
            float f = Global.getSettings().getFloat("idleAdminSalaryMult");
            tooltip.addPara("\u6bcf\u4e00\u540d\u884c\u653f\u5b98\u7684\u85aa\u6c34\u53d6\u51b3\u4e8e\u4ed6\u4eec\u7684\u6280\u80fd\u3002\u5f53\u884c\u653f\u5b98\u672a\u5206\u914d\u5230\u6b96\u6c11\u5730\u62c5\u4efb\u804c\u52a1\u65f6\uff0c\u4ed6\u4eec\u7684\u85aa\u6c34\u5c06\u4f1a\u964d\u4f4e\u81f3 %s.", 0.0f, Misc.getHighlightColor(), Math.round(f * 100.0f) + "%");
        } else if (MonthlyReport.CREW.equals(node.custom)) {
            tooltip.addPara("\u6bcf\u540d\u8239\u5458\u7684\u6708\u85aa\u4e3a %s \u661f\u5e01\u3002", 0.0f, h, Misc.getWithDGS(crewSalary));
        } else if (MonthlyReport.MARINES.equals(node.custom)) {
            tooltip.addPara("\u6bcf\u540d\u9646\u6218\u961f\u5458\u7684\u6708\u85aa\u4e3a %s \u661f\u5e01\u3002", 0.0f, h, Misc.getWithDGS(marineSalary));
        } else if (MonthlyReport.LAST_MONTH_DEBT.equals(node.custom)) {
            tooltip.addPara("\u4e0a\u4e2a\u6708\u7ed3\u8d26\u540e\u672a\u507f\u8fd8\u7684\u503a\u52a1\u3002", 0.0f);
        } else if (MonthlyReport.INDUSTRIES.equals(node.custom)) {
            tooltip.addPara("\u6765\u81ea\u524d\u54e8\u7ad9\u6216\u6b96\u6c11\u5730\u7684\u5de5\u4e1a\u8bbe\u65bd\u4e0e\u5176\u4ed6\u8bbe\u65bd\u7684\u7ef4\u62a4\u548c\u6536\u76ca\u3002", 0.0f);
        } else if (MonthlyReport.INCENTIVES.equals(node.custom)) {
            tooltip.addPara("\u4e0a\u4e2a\u6708\u6b96\u6c11\u5730\u7684\u5371\u9669\u6d25\u8d34\u4e0e\u79fb\u6c11\u8865\u8d34\u7684\u603b\u652f\u51fa\u3002", 0.0f);
        } else if (MonthlyReport.EXPORTS.equals(node.custom)) {
            tooltip.addPara("\u8be5\u524d\u54e8\u7ad9\u6216\u6b96\u6c11\u5730\u7684\u5bf9\u5916\u51fa\u53e3\u6536\u76ca\u3002\u8d70\u79c1\u4e0e\u52bf\u529b\u5185\u90e8\u51fa\u53e3\u5c06\u4e0d\u80fd\u4ea7\u751f\u6536\u5165\u3002", 0.0f);
        } else if (MonthlyReport.STORAGE.equals(node.custom)) {
            tooltip.addPara("\u5c06\u8239\u5458\u6216\u7269\u8d44\u5b89\u7f6e\u5728\u67d0\u5904\u7684\u8d39\u7528\u4e0e\u5f00\u652f\u3002\u5305\u62ec\u79df\u91d1\uff0c\u5b89\u4fdd\u8d39\u7b49\u3002", 0.0f);
            String percent = (int)(storageFreeFraction * 100.0f) + "%";
            tooltip.addPara("\u6bcf\u6708\u4ea7\u751f\u7684\u8d39\u7528\u901a\u5e38\u662f\u5b58\u50a8\u8d27\u7269\u57fa\u672c\u4ef7\u503c\u7684 %s.", 10.0f, h, percent);
            tooltip.addPara("\u5728\u4f60\u63a7\u5236\u4e0b\u7684\u6b96\u6c11\u5730\u50a8\u5b58\u8d27\u7269\u5c06\u4e0d\u4f1a\u4ea7\u751f\u4efb\u4f55\u8d39\u7528\u3002", 10.0f);
        } else if (node.custom instanceof CommodityOnMarketAPI) {
            float quantity = 0.0f;
            if (node.custom2 instanceof Float && (quantity = ((Float)node.custom2).floatValue()) < 1.0f) {
                quantity = 1.0f;
            }
            String \u5355\u4f4d = "\u5355\u4f4d";
            if (quantity <= 1.0f) {
                \u5355\u4f4d = "\u5355\u4f4d";
            }
            CommodityOnMarketAPI com = (CommodityOnMarketAPI)node.custom;
            tooltip.addPara("\u5927\u7ea6 %s " + \u5355\u4f4d + "\u7684" + com.getCommodity().getName() + ".", 0.0f, h, Misc.getWithDGS(quantity));
        }
    }

    public float getTooltipWidth(Object tooltipParam) {
        return 450.0f;
    }

    public boolean isTooltipExpandable(Object tooltipParam) {
        return false;
    }
}

