/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.HassleNPCScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;

public class NPCHassler
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected HassleNPCScript.HassleParams params;
    protected StarSystemAPI restrictTo;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);

    public NPCHassler(CampaignFleetAPI fleet) {
        this(fleet, new HassleNPCScript.HassleParams(), null);
    }

    public NPCHassler(CampaignFleetAPI fleet, StarSystemAPI restrictTo) {
        this(fleet, new HassleNPCScript.HassleParams(), restrictTo);
    }

    public NPCHassler(CampaignFleetAPI fleet, HassleNPCScript.HassleParams params, StarSystemAPI restrictTo) {
        this.fleet = fleet;
        this.params = params;
        this.restrictTo = restrictTo;
    }

    public HassleNPCScript.HassleParams getParams() {
        return this.params;
    }

    public void advance(float amount) {
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (this.restrictTo != null && this.fleet.getContainingLocation() != this.restrictTo) {
            return;
        }
        if (Global.getSector().getMemoryWithoutUpdate().contains(this.params.timeoutKey)) {
            return;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$core_fleetSpecialAction")) {
            return;
        }
        if (this.fleet.getBattle() != null) {
            return;
        }
        if (this.fleet.getAI() != null && (this.fleet.getAI().isFleeing() || this.fleet.getAI().isMaintainingContact())) {
            return;
        }
        if (this.fleet.getCurrentAssignment() != null && this.fleet.getCurrentAssignment().getAssignment() == FleetAssignment.ORBIT_PASSIVE) {
            return;
        }
        List<CampaignFleetAPI> targets = Misc.findNearbyFleets(this.fleet, 1000.0f, new Misc.FleetFilter(){

            public boolean accept(CampaignFleetAPI other) {
                return NPCHassler.this.isTargetAllowed(other);
            }
        });
        WeightedRandomPicker<CampaignFleetAPI> picker = new WeightedRandomPicker<CampaignFleetAPI>();
        picker.addAll(targets);
        CampaignFleetAPI target = (CampaignFleetAPI)picker.pick();
        if (target != null) {
            this.fleet.getContainingLocation().addScript(new HassleNPCScript(this.fleet, target));
            float globalTimeout = this.params.minGlobalTimeout + (this.params.maxGlobalTimeout - this.params.minGlobalTimeout) * (float)Math.random();
            Global.getSector().getMemoryWithoutUpdate().set(this.params.timeoutKey, true, globalTimeout);
            float targetTimeout = this.params.minTargetTimeout + (this.params.maxTargetTimeout - this.params.minTargetTimeout) * (float)Math.random();
            target.getMemoryWithoutUpdate().set(this.params.timeoutKey, true, targetTimeout);
        }
    }

    protected boolean isTargetAllowed(CampaignFleetAPI target) {
        if (target.isPlayerFleet() || target.getAI() == null) {
            return false;
        }
        if (target.isHostileTo(this.fleet)) {
            return false;
        }
        if (target.isStationMode()) {
            return false;
        }
        if (target.getBattle() != null) {
            return false;
        }
        if (target.getFaction() == this.fleet.getFaction()) {
            return false;
        }
        if (target.getMemoryWithoutUpdate().contains(this.params.timeoutKey)) {
            return false;
        }
        if (target.getAI() instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI ai = (ModularFleetAIAPI)target.getAI();
            if (ai.isFleeing() || ai.isMaintainingContact()) {
                return false;
            }
            if (this.fleet.getInteractionTarget() instanceof CampaignFleetAPI) {
                return false;
            }
        }
        if (!this.isTargetRightTypeOfFleet(target)) {
            return false;
        }
        SectorEntityToken.VisibilityLevel vis = target.getVisibilityLevelTo(this.fleet);
        return vis != SectorEntityToken.VisibilityLevel.NONE;
    }

    protected boolean isTargetRightTypeOfFleet(CampaignFleetAPI target) {
        if (Misc.isTrader(target)) {
            return true;
        }
        if (Misc.isPirate(target)) {
            return false;
        }
        if (Misc.isPatrol(target) && !target.getFaction().isPlayerFaction()) {
            return false;
        }
        if (Misc.isWarFleet(target)) {
            return false;
        }
        return target.getFaction().getCustomBoolean("decentralized");
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

