/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.BaseCampaignObjectivePlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class NavBuoyEntityPlugin
extends BaseCampaignObjectivePlugin {
    public static float NAV_BONUS = 3.0f;
    public static float NAV_BONUS_MAKESHIFT = 2.0f;

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        if (this.entity.getContainingLocation() == null || this.entity.isInHyperspace()) {
            return;
        }
        if (this.isReset().booleanValue()) {
            return;
        }
        String id = this.getModId();
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            MutableStat.StatMod curr;
            if (fleet.isInHyperspaceTransition() || fleet.getFaction() != this.entity.getFaction() && (!this.isHacked().booleanValue() || !fleet.getFaction().isPlayerFaction())) continue;
            String desc = "\u5bfc\u822a\u6d6e\u6807";
            float bonus = NAV_BONUS;
            if (this.isMakeshift()) {
                desc = "\u4e34\u65f6\u5bfc\u822a\u6d6e\u6807";
                bonus = NAV_BONUS_MAKESHIFT;
            }
            if ((curr = fleet.getStats().getFleetwideMaxBurnMod().getFlatBonus(id)) != null && !(curr.value <= bonus)) continue;
            fleet.getStats().addTemporaryModFlat(0.1f, id, desc, bonus, fleet.getStats().getFleetwideMaxBurnMod());
        }
    }

    protected boolean isMakeshift() {
        return this.entity.hasTag("makeshift");
    }

    public void printEffect(TooltipMakerAPI text, float pad) {
        int bonus = (int)NAV_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)NAV_BONUS_MAKESHIFT;
        }
        text.addPara("      %s \u6700\u5927\u5b87\u5b99\u822a\u901f\uff0c\u4f5c\u7528\u4e8e\u661f\u7cfb\u5185\u540c\u4e00\u52bf\u529b\u7684\u8230\u961f", pad, Misc.getHighlightColor(), "+" + bonus);
        if (this.isReset().booleanValue()) {
            text.addPara("      Auto-calibrating after factory reset; non-functional", 3.0f);
        }
    }

    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            text.addPara("\u7136\u800c\u8be5\u8bbe\u5907\u4f3c\u4e4e\u5e76\u672a\u53d1\u9001\u5bfc\u822a\u9065\u6d4b\u6570\u636e\uff0c\u5176\u529f\u80fd\u7f3a\u5931\u7684\u539f\u56e0\u4e5f\u5c1a\u4e0d\u660e\u786e\u3002");
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("\u4f60\u5df2\u7ecf\u6709\u4e00\u4e2a\u9ed1\u5ba2\u7a0b\u5e8f\u5728\u8be5\u8bbe\u5907\u4e0a\u8fd0\u884c\u3002");
        }
    }

    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        int bonus = (int)NAV_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)NAV_BONUS_MAKESHIFT;
        }
        text.addPara("%s \u661f\u7cfb\u5185\u8be5\u8bbe\u5907\u63a7\u5236\u65b9\u8230\u961f\u5b87\u5b99\u822a\u901f", pad, Misc.getHighlightColor(), "+" + bonus);
        super.addHackStatusToTooltip(text, pad);
    }

    protected String getModId() {
        return "nav_buoy";
    }
}

