/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.SkillData;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficerLevelupPluginImpl
implements OfficerLevelupPlugin {
    public static float XP_MULT = Global.getSettings().getFloat("officerXPRequiredMult");
    public static float EXPONENT_BEYOND_MAX_SPECIFIED_LEVEL = 1.1f;
    public static long[] XP_PER_LEVEL;
    public static long[] TOTAL_XP_PER_LEVEL;

    static {
        long[] lArray = new long[10];
        lArray[1] = 12000L;
        lArray[2] = 20000L;
        lArray[3] = 35000L;
        lArray[4] = 45000L;
        lArray[5] = 50000L;
        lArray[6] = 50000L;
        lArray[7] = 50000L;
        lArray[8] = 50000L;
        lArray[9] = 50000L;
        XP_PER_LEVEL = lArray;
        TOTAL_XP_PER_LEVEL = new long[XP_PER_LEVEL.length];
        long total = 0L;
        int i = 0;
        while (i < XP_PER_LEVEL.length) {
            OfficerLevelupPluginImpl.TOTAL_XP_PER_LEVEL[i] = total += XP_PER_LEVEL[i];
            ++i;
        }
    }

    @Override
    public long getXPForLevel(int level) {
        if (level <= 1) {
            return 0L;
        }
        if (level - 1 < TOTAL_XP_PER_LEVEL.length) {
            return (long)((float)TOTAL_XP_PER_LEVEL[level - 1] * XP_MULT);
        }
        int maxSpecified = TOTAL_XP_PER_LEVEL.length;
        long curr = TOTAL_XP_PER_LEVEL[maxSpecified - 1];
        long last = XP_PER_LEVEL[maxSpecified - 1];
        int i = maxSpecified;
        while (i < level) {
            last = (long)((float)last * EXPONENT_BEYOND_MAX_SPECIFIED_LEVEL);
            curr += last;
            ++i;
        }
        return (long)((float)curr * XP_MULT);
    }

    public static void main(String[] args) {
        int i = 1;
        while (i <= 6) {
            System.out.println("\u7b49\u7ea7 " + i + ": " + new OfficerLevelupPluginImpl().getXPForLevel(i));
            ++i;
        }
    }

    @Override
    public int getMaxLevel(PersonAPI person) {
        MutableCharacterStatsAPI stats;
        if (person != null && person.getMemoryWithoutUpdate().contains("$officerMaxLevel")) {
            return person.getMemoryWithoutUpdate().getInt("$officerMaxLevel");
        }
        int bonus = 0;
        if (person != null && (stats = person.getFleetCommanderStats()) != null) {
            bonus = (int)stats.getDynamic().getMod("officer_max_level_mod").computeEffective(0.0f);
        }
        return (int)Global.getSettings().getFloat("officerMaxLevel") + bonus;
    }

    @Override
    public int getMaxEliteSkills(PersonAPI person) {
        MutableCharacterStatsAPI stats;
        if (person != null && person.getMemoryWithoutUpdate().contains("$officerMaxEliteSkills")) {
            return person.getMemoryWithoutUpdate().getInt("$officerMaxEliteSkills");
        }
        int bonus = 0;
        if (person != null && (stats = person.getFleetCommanderStats()) != null) {
            bonus = (int)stats.getDynamic().getMod("officer_max_elite_skills_mod").computeEffective(0.0f);
        }
        return (int)Global.getSettings().getFloat("officerMaxEliteSkills") + bonus;
    }

    public List<String> pickLevelupSkillsV2(PersonAPI person, Random random) {
        WeightedRandomPicker<List<SkillSpecAPI>> picker;
        if (random == null) {
            random = new Random();
        }
        ArrayList leftovers = new ArrayList();
        ArrayList<List<SkillSpecAPI>> unknownTiers = new ArrayList<List<SkillSpecAPI>>();
        MutableCharacterStatsAPI stats = person.getStats();
        int level = stats.getLevel();
        for (String ap : SkillData.getAptitudes().keySet()) {
            SkillData.SkillsForAptitude skills = SkillData.getSkills(ap);
            int tier = 0;
            for (List<SkillSpecAPI> list : skills.tiers) {
                ++tier;
                ArrayList<SkillSpecAPI> unknown = new ArrayList<SkillSpecAPI>();
                for (SkillSpecAPI skill : list) {
                    if (!skill.isCombatOfficerSkill() || skill.hasTag("deprecated") || skill.hasTag("player_only") || !(stats.getSkillLevel(skill.getId()) <= 0.0f)) continue;
                    unknown.add(skill);
                }
                if (list.size() == unknown.size() && (tier < 4 || level >= 3)) {
                    unknownTiers.add(list);
                    continue;
                }
                leftovers.addAll(unknown);
            }
        }
        int max = 4;
        if (Misc.isMentored(person)) {
            max = 6;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!unknownTiers.isEmpty()) {
            picker = new WeightedRandomPicker<List<SkillSpecAPI>>(random);
            picker.addAll(unknownTiers);
            block3: while (!picker.isEmpty() && result.size() < max) {
                List pick = (List)picker.pickAndRemove();
                for (SkillSpecAPI s : pick) {
                    if (result.size() >= max) continue block3;
                    result.add(s.getId());
                }
            }
        }
        if (!leftovers.isEmpty()) {
            picker = new WeightedRandomPicker(random);
            picker.addAll(leftovers);
            while (!picker.isEmpty() && result.size() < max) {
                SkillSpecAPI pick = (SkillSpecAPI)picker.pickAndRemove();
                result.add(pick.getId());
            }
        }
        return result;
    }

    public List<String> pickLevelupSkillsV3(PersonAPI person, Random random) {
        SkillSpecAPI pick;
        WeightedRandomPicker<SkillSpecAPI> picker;
        if (random == null) {
            random = new Random();
        }
        ArrayList<SkillSpecAPI> top = new ArrayList<SkillSpecAPI>();
        ArrayList<SkillSpecAPI> leftovers = new ArrayList<SkillSpecAPI>();
        MutableCharacterStatsAPI stats = person.getStats();
        int level = stats.getLevel();
        for (String ap : SkillData.getAptitudes().keySet()) {
            SkillData.SkillsForAptitude skills = SkillData.getSkills(ap);
            for (List<SkillSpecAPI> list : skills.tiers) {
                boolean topTier = false;
                for (SkillSpecAPI skill : list) {
                    if (!skill.isCombatOfficerSkill() || skill.hasTag("deprecated") || skill.hasTag("player_only") || !(stats.getSkillLevel(skill.getId()) <= 0.0f)) continue;
                    if (skill.getTier() == 5) {
                        topTier = true;
                    }
                    if (topTier && level < 3) continue;
                    if (topTier) {
                        top.add(skill);
                        continue;
                    }
                    leftovers.add(skill);
                }
            }
        }
        int max = 4;
        if (Misc.isMentored(person)) {
            max = 6;
        }
        if (person.getMemoryWithoutUpdate().contains("$officerSkillPicksPerLevel")) {
            max = person.getMemoryWithoutUpdate().getInt("$officerSkillPicksPerLevel");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!top.isEmpty()) {
            picker = new WeightedRandomPicker<SkillSpecAPI>(random);
            picker.addAll(top);
            while (!picker.isEmpty() && result.size() < max) {
                pick = (SkillSpecAPI)picker.pickAndRemove();
                result.add(pick.getId());
            }
        }
        if (!leftovers.isEmpty()) {
            picker = new WeightedRandomPicker(random);
            picker.addAll(leftovers);
            while (!picker.isEmpty() && result.size() < max) {
                pick = (SkillSpecAPI)picker.pickAndRemove();
                result.add(pick.getId());
            }
        }
        return result;
    }

    @Override
    public List<String> pickLevelupSkills(PersonAPI person, Random random) {
        return this.pickLevelupSkillsV3(person, random);
    }

    private void addSkill(PersonAPI person, WeightedRandomPicker<String> picker, String skill) {
        if (person.getStats().getSkillLevel(skill) >= 3.0f) {
            return;
        }
        picker.add(skill);
    }
}

