/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTNonASBScanFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static int STABLE_FUEL_REQ = 500;
    public static int STABLE_MACHINERY_REQ = 200;
    public static String ADDED_KEY = "$core_starAddedStable";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private CampaignFleetAPI playerFleet;
    private PlanetAPI planet;
    private boolean unpauseOnExit = true;
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private OptionId lastOptionMousedOver = null;

    public boolean isUnpauseOnExit() {
        return this.unpauseOnExit;
    }

    public void setUnpauseOnExit(boolean unpauseOnExit) {
        this.unpauseOnExit = unpauseOnExit;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.planet = (PlanetAPI)dialog.getInteractionTarget();
        this.visual.setVisualFade(0.25f, 0.25f);
        if (this.planet.getCustomInteractionDialogImageVisual() != null) {
            this.visual.showImageVisual(this.planet.getCustomInteractionDialogImageVisual());
        } else if (!Global.getSettings().getBoolean("3dPlanetBGInInteractionDialog")) {
            this.visual.showPlanetInfo(this.planet);
        }
        dialog.setOptionOnEscape("\u79bb\u5f00", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        if (optionData == "DumpMemory.option_dump_memory") {
            HashMap<String, MemoryAPI> memoryMap = new HashMap<String, MemoryAPI>();
            MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
            memoryMap.put("local", memory);
            if (this.dialog.getInteractionTarget().getFaction() != null) {
                memoryMap.put("faction", this.dialog.getInteractionTarget().getFaction().getMemory());
            } else {
                memoryMap.put("faction", Global.getFactory().createMemory());
            }
            memoryMap.put("global", Global.getSector().getMemory());
            memoryMap.put("player", Global.getSector().getCharacterData().getMemory());
            if (this.dialog.getInteractionTarget().getMarket() != null) {
                memoryMap.put("market", this.dialog.getInteractionTarget().getMarket().getMemory());
            }
            new DumpMemory().execute(null, this.dialog, null, memoryMap);
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String type = "\u6052\u661f";
        String corona = "\u661f\u5195";
        String corona2 = "\u5904\u4e8e\u661f\u5195\u5185";
        if (this.planet.getSpec().isBlackHole()) {
            type = "\u9ed1\u6d1e";
            corona = "\u4e8b\u4ef6\u89c6\u754c";
            corona2 = "\u9760\u8fd1\u4e8b\u4ef6\u89c6\u754c";
        }
        switch (option) {
            case INIT: {
                Description desc;
                boolean didAlready = this.planet.getMemoryWithoutUpdate().getBoolean(ADDED_KEY);
                this.addText(this.getString("approach"));
                if (this.planet.getMemoryWithoutUpdate().getBoolean("$abyssalBlackHoleReadings")) {
                    this.planet.getMemoryWithoutUpdate().unset("$abyssalBlackHoleReadings");
                    this.planet.getMemoryWithoutUpdate().set("$abyssalBlackHoleReadingsRevisit", true);
                    this.addText("\u4f60\u7684\u4f20\u611f\u5668\u6280\u5e08\u72b9\u8c6b\u4e86\u4e00\u4e0b\uff0c\u7136\u540e\u62db\u547c\u4f60\u6ce8\u610f\u3002\"\u8230\u957f\uff0c\u9ed1\u6d1e\u4f20\u51fa\u7684\u6570\u636e\u6709\u7740\u67d0\u79cd...\u89c4\u5f8b\u3002\u6216\u8005\u8bf4... \" \u5176\u505c\u987f\u4e86\u4e00\u4e0b\uff0c\u9762\u9732\u96be\u8272\uff0c\"\u89c4\u5f8b\u7684\u6765\u6e90\u5177\u4f53\u662f\u5438\u79ef\u76d8\u8f90\u5c04\u51fa\u7684\u80fd\u91cf\u3002\"\n\n\u6574\u7406\u597d\u7684\u4f20\u611f\u5668\u8f93\u51fa\u56fe\u88ab\u4f20\u5230\u5927\u5c4f\u5e55\u3002\"\u8fd9\u597d\u50cf\u662f\u4e00\u79cd\u4fe1\u53f7\u3002\u770b\uff0c\u5982\u679c\u6211\u4eec\u628a\u80fd\u91cf\u8f93\u51fa\u7684\u6ce2\u52a8\u968f\u65f6\u95f4\u7684\u53d8\u5316\u7ed8\u5236\u6210\u56fe\u8868...\"\n\n\u4f60\u770b\u5230\u4e86\u5b83\uff0c\u90a3\u662f\u4e00\u4e2a\u6709\u5e8f\u7684\u6570\u5217\u3002\u4f60\u4e0d\u5dee\u7684\u6570\u5b66\u6c34\u51c6\u8ba9\u4f60\u610f\u8bc6\u5230\uff0c\u90a3\u50cf\u662f\u4e2a\u8d28\u6570\u6570\u5217\u4f46\u53c8\u4e0d\u5b8c\u5168\u662f\u3002\u4ece\u7edf\u8ba1\u5b66\u89d2\u5ea6\u770b\uff0c\u8fd9\u79cd\u5de7\u5408\u51e0\u4e4e\u662f\u4e0d\u53ef\u80fd\u7684\u3002\u4e00\u79cd\u53ef\u80fd\u4f46\u65e0\u6cd5\u786e\u5207\u7684\u89e3\u91ca\u662f\uff1a\u8fd9\u662f\u4e00\u7cfb\u5217\u661f\u7403\uff0c\u6216\u8005\u5927\u578b\u536b\u661f\uff0c\u4e4b\u95f4\u7684\u8d28\u91cf\u6bd4\u4f8b\u6240\u5f62\u6210\u7684\u6570\u5217\uff0c\u5b83\u4eec\u88ab\u6545\u610f\u4ee5\u8fd9\u6837\u7684\u987a\u5e8f\u4e00\u4e2a\u4e2a\u62c9\u5165\u4e86\u5438\u79ef\u76d8\u4e2d...\u6216\u8005\uff0c\u67d0\u4e9b\u5b58\u5728\u4ee5\u90a3\u8ba9 \u4eba\u4e4b\u9886 \u6700\u8840\u8165\u7684\u6218\u4e89\u8d29\u5b50\u90fd\u4e3a\u4e4b\u98a4\u6296\u7684\u9b44\u529b\uff0c\u6309\u7279\u5b9a\u987a\u5e8f\u6e6e\u706d\u6389\u4e86\u4e00\u6574\u4e2a\u884c\u661f\u7cfb\u7edf\u3002\n\n\u771f\u76f8\u5df2\u7ecf\u65e0\u6cd5\u5f97\u77e5\u3002\u90a3\u4e2a\u89c4\u5f8b\u4e00\u95ea\u800c\u901d\uff0c\u4eff\u4f5b\u4ece\u672a\u51fa\u73b0\u8fc7\u3002");
                    int points = HTPoints.ABYSSAL_BLACK_HOLE_UNUSUAL_READINGS;
                    if (points > 0) {
                        HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTNonASBScanFactor("\u8bc6\u522b\u5230\u6765\u81ea\u6df1\u6e0a\u9ed1\u6d1e\u7684\u4e0d\u5bfb\u5e38\u8bfb\u6570", points), this.dialog);
                    }
                } else if (this.planet.getMemoryWithoutUpdate().getBoolean("$abyssalBlackHoleReadingsRevisit")) {
                    this.addText("\u4f60\u7684\u4f20\u611f\u5668\u6280\u5e08\u4e0d\u518d\u4ece\u5438\u79ef\u76d8\u5185\u4fa7\u68c0\u6d4b\u5230\u5f02\u5e38\u7684\u80fd\u91cf\u5f62\u5f0f\uff0c\u53ea\u6709\u566a\u97f3\uff0c\u50cf\u5b87\u5b99\u80cc\u666f\u8f90\u5c04\u4e00\u6837\u65e0\u610f\u4e49\u7684\u566a\u97f3\u3002");
                }
                if (didAlready) {
                    this.addText("The " + corona + "\u53d1\u51fa\u7684\u6270\u52a8\u663e\u793a\u8fd9\u91cc\u8fd1\u671f\u8fdb\u884c\u8fc7\u53cd\u7269\u8d28\u55b7\u65bd\u4f5c\u4e1a\u3002");
                }
                if ((desc = Global.getSettings().getDescription(this.planet.getCustomDescriptionId(), Description.Type.CUSTOM)) != null && desc.hasText3()) {
                    this.addText(desc.getText3());
                }
                this.createInitialOptions();
                break;
            }
            case DUMP_PLANETKILLER: {
                this.addText("\u4f60\u7684\u519b\u5b98\u8fc5\u901f\u5bf9\u547d\u4ee4\u505a\u51fa\u53cd\u5e94\uff0c\u6709\u6761\u4e0d\u7d0a\u5730\u7ec4\u7ec7\u7740\u5404\u81ea\u7684\u4efb\u52a1\u3002\u7136\u800c\uff0c\u4ed6\u4eec\u4f20\u9001\u4fe1\u606f\u7684\u8bed\u6c14\u4e2d\u5374\u900f\u7740\u4e00\u4e1d\u7d27\u5f20\uff0c\u5c3d\u7ba1\u5c1d\u8bd5\u53bb\u514b\u5236\uff0c\u4f46\u6ca1\u4eba\u80fd\u771f\u6b63\u5ffd\u89c6\u8fd9\u6b21\u884c\u52a8\u7684\u4e25\u91cd\u6027\u3002\n\"\u5305\u88f9\u5df2\u51c6\u5907\u597d\u6295\u653e\uff0c\u8230\u957f\uff0c\" \u4f60\u7684\u884c\u52a8\u957f\u5b98\u8bf4\u3002\"\u7b49\u5f85\u4f60\u7684\u6307\u4ee4\u3002\"");
                this.options.clearOptions();
                this.options.addOption("\"\u9500\u6bc1\u5b83\uff01\"", (Object)OptionId.DUMP_PLANETKILLER_CONT_1, null);
                this.options.addOption("\"\u4e0d...\u8fd8\u662f\u7559\u7740\u5b83\u5427\u3002\"", (Object)OptionId.DUMP_PLANETKILLER_ON_SECOND_THOUGHT, null);
                break;
            }
            case DUMP_PLANETKILLER_ON_SECOND_THOUGHT: {
                this.createInitialOptions();
                break;
            }
            case DUMP_PLANETKILLER_CONT_1: {
                this.addText("\u968f\u7740\u4f60\u4e00\u58f0\u4ee4\u4e0b\uff0c\u56fa\u5b9a\u5728\u652f\u67b6\u91cc\u7684\u884c\u661f\u6740\u624b\u88ab\u63a8\u5411\u9ed1\u6d1e\u7684\u6b63\u4e2d\u5fc3\uff0c\u4e00\u76f4\u4e00\u76f4\u5411\u524d\uff0c\u7a7f\u8fc7\u4e86\u5438\u79ef\u76d8\u7684\u5e73\u9762\u3002\n\n\u5728\u4f20\u611f\u5668\u9065\u6d4b\u6570\u636e\u4e2d\uff0c\u5b83\u4ec5\u4ec5\u4ea7\u751f\u4e86\u6bd4\u5e95\u566a\u9ad8\u4e00\u70b9\u7684\u95ea\u5149\uff0c\u5c31\u6c38\u8fdc\u6d88\u5931\u4e86\u3002");
                AddRemoveCommodity.addItemLossText(new SpecialItemData("planetkiller", null), 1, this.dialog.getTextPanel());
                Global.getSector().getPlayerStats().addStoryPoints(1, this.dialog.getTextPanel(), false);
                this.removePK();
                this.options.clearOptions();
                this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                break;
            }
            case ADD_STABLE_CONFIRM: {
                StarSystemAPI system = this.planet.getStarSystem();
                if (system != null) {
                    CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
                    cargo.removeFuel(STABLE_FUEL_REQ);
                    AddRemoveCommodity.addCommodityLossText("fuel", STABLE_FUEL_REQ, this.dialog.getTextPanel());
                    StarSystemGenerator.addStableLocations(system, 1);
                    this.planet.getMemoryWithoutUpdate().set(ADDED_KEY, true);
                    this.addText("\u51c6\u5907\u5de5\u4f5c\u5b8c\u6210\u540e\uff0c\u4f60\u4e0b\u8fbe\u4e86\u884c\u52a8\u8bb8\u53ef\u3002\u7ecf\u8fc7\u4e86\u7d27\u5f20\u7684\u51e0\u5206\u949f\u540e\uff0c\u603b\u5de5\u7a0b\u5e08\u62a5\u544a\u6210\u529f\u3002\u7531\u6b64\u4ea7\u751f\u7684\u7a33\u5b9a\u70b9\u867d\u7136\u4e0d\u4f1a\u50cf\u81ea\u7136\u5b58\u5728\u7684\u4f4d\u7f6e\u90a3\u6837\u6301\u7eed\u6570\u5343\u5e74\uff0c\u4f46\u5b83\u5e94\u8be5\u8db3\u591f\u4f60\u7528\u4e86\u3002");
                }
                this.createInitialOptions();
                break;
            }
            case ADD_STABLE_DESCRIBE: {
                String reason;
                this.addText("\u8be5\u8fc7\u7a0b\u9700\u8981\u55b7\u6d12\u975e\u5e38\u5927\u91cf\u7684\u53cd\u7269\u8d28\u5230" + corona2 + ", " + "\u8ba1\u7b97\u7ed3\u679c\u8868\u660e\u4e16\u95f4\u8fdc\u6ca1\u6709\u4efb\u4f55\u4e8b\u7269\u6709\u80fd\u529b\u8fbe\u6210\u8fd9\u79cd\u58ee\u4e3e\uff0c" + "\u81f3\u5c11\u5728\u9075\u5b88\u7b2c\u4e8c\u6b21 AI \u6218\u4e89\u505c\u6218\u6761\u7ea6\u7684\u57fa\u7840\u4e0a\u3002");
                boolean canAfford = this.dialog.getTextPanel().addCostPanel("\u6240\u9700\u8d44\u6e90 (\u53ef\u7528) ", "alpha_core", 1, false, "heavy_machinery", STABLE_MACHINERY_REQ, false, "fuel", STABLE_FUEL_REQ, true);
                this.options.clearOptions();
                int num = Misc.getNumStableLocations(this.planet.getStarSystem());
                boolean alreadyCant = false;
                if (num <= 0) {
                    this.options.addOption("\u7ee7\u7eed\u8fdb\u884c\u64cd\u4f5c", (Object)OptionId.ADD_STABLE_CONFIRM, null);
                } else if (num < 2) {
                    this.addText("\u901a\u5e38\u60c5\u51b5\u4e0b\uff0c\u8be5\u65b9\u6848\u53ea\u80fd\u5728\u6ca1\u6709\u4efb\u4f55\u7a33\u5b9a\u70b9\u7684\u661f\u7cfb\u4e2d\u8fdb\u884c\u3002\u4f46\u4f60\u7684\u603b\u5de5\u7a0b\u5e08\u5374\u5efa\u8bae\u91c7\u7528\u4e00\u79cd\u975e\u4f20\u7edf\u7684\u7b56\u7565\u6765\u5f3a\u5236\u6267\u884c\u3002");
                    this.options.addOption("\u7ee7\u7eed\u8fdb\u884c\u64cd\u4f5c", (Object)OptionId.ADD_STABLE_CONFIRM, null);
                    SetStoryOption.set(this.dialog, Global.getSettings().getInt("createStableLocation"), (Object)OptionId.ADD_STABLE_CONFIRM, "createStableLocation", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "\u589e\u8bbe\u4e00\u5904\u7a33\u5b9a\u70b9 " + this.planet.getStarSystem().getNameWithLowercaseType());
                } else {
                    alreadyCant = true;
                    reason = "\u6b64\u5904\u661f\u7cfb\u5df2\u7ecf\u6709\u8bb8\u591a\u81ea\u7136\u5f62\u6210\u7684\u7a33\u5b9a\u70b9\uff0c\u56e0\u6b64\u65e0\u6cd5\u6267\u884c\u8be5\u65b9\u6848\u3002";
                    this.options.addOption("\u7ee7\u7eed\u8fdb\u884c\u64cd\u4f5c", (Object)OptionId.ADD_STABLE_CONFIRM, null);
                    this.options.setEnabled((Object)OptionId.ADD_STABLE_CONFIRM, false);
                    this.addText(reason);
                    this.options.setTooltip((Object)OptionId.ADD_STABLE_CONFIRM, reason);
                }
                if (!canAfford && !alreadyCant) {
                    reason = "\u6267\u884c\u8be5\u65b9\u6848\u7684\u5fc5\u8981\u8d44\u6e90\u4e0d\u8db3\u3002";
                    this.options.setEnabled((Object)OptionId.ADD_STABLE_CONFIRM, false);
                    this.addText(reason);
                    this.options.setTooltip((Object)OptionId.ADD_STABLE_CONFIRM, reason);
                }
                this.options.addOption("\u653e\u5f03", (Object)OptionId.ADD_STABLE_NEVER_MIND, null);
                break;
            }
            case ADD_STABLE_NEVER_MIND: {
                this.createInitialOptions();
                break;
            }
            case LEAVE: {
                if (this.unpauseOnExit) {
                    Global.getSector().setPaused(false);
                }
                this.dialog.dismiss();
            }
        }
    }

    protected void createInitialOptions() {
        this.options.clearOptions();
        MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
        String type = "\u6052\u661f";
        String corona = "\u661f\u5195";
        String corona2 = "\u5904\u4e8e\u661f\u5195\u5185";
        boolean blackHole = false;
        if (this.planet.getSpec().isBlackHole()) {
            blackHole = true;
            type = "\u9ed1\u6d1e";
            corona = "\u4e8b\u4ef6\u89c6\u754c";
            corona2 = "\u9760\u8fd1\u4e8b\u4ef6\u89c6\u754c";
        }
        StarSystemAPI system = this.planet.getStarSystem();
        boolean didAlready = this.planet.getMemoryWithoutUpdate().getBoolean(ADDED_KEY);
        boolean deepSpace = system.isDeepSpace();
        if (system != null && this.planet == system.getStar() && !didAlready && !deepSpace) {
            this.options.addOption("\u8003\u8651\u5728" + type + "\u7684\u8d85\u7a7a\u95f4\u573a\u4e2d\u8bf1\u5bfc\u8c10\u632f\u7ea7\u8054\u53cd\u5e94\uff0c\u521b\u9020\u4e00\u4e2a\u7a33\u5b9a\u70b9", (Object)OptionId.ADD_STABLE_DESCRIBE, null);
        }
        if (this.hasPK() && blackHole) {
            this.options.addOption("\u628a \u884c\u661f\u6740\u624b \u6254\u8fdb\u9ed1\u6d1e", (Object)OptionId.DUMP_PLANETKILLER, null);
        }
        this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    public void removePK() {
        Global.getSector().getPlayerFleet().getCargo().removeItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("planetkiller", null), 1.0f);
    }

    public boolean hasPK() {
        return Global.getSector().getPlayerFleet().getCargo().getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("planetkiller", null)) > 0.0f;
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    private String getString(String id) {
        String str = Global.getSettings().getString("planetInteractionDialog", id);
        String fleetOrShip = "fleet";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        str = str.replaceAll("\\$planetName", this.planet.getName());
        return str;
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        ADD_STABLE_CONFIRM,
        ADD_STABLE_DESCRIBE,
        DUMP_PLANETKILLER,
        DUMP_PLANETKILLER_ON_SECOND_THOUGHT,
        DUMP_PLANETKILLER_CONT_1,
        ADD_STABLE_NEVER_MIND,
        LEAVE;

    }
}

