/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class RepairGantry
extends BaseHullMod {
    private static Map mag = new HashMap();
    public static final float BATTLE_SALVAGE_MULT = 0.2f;
    public static final float MIN_CR = 0.1f;

    static {
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(10.0f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(25.0f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(30.0f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(40.0f));
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("salvage_value_bonus_ship").modifyFlat(id, ((Float)mag.get((Object)hullSize)).floatValue() * 0.01f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.FRIGATE)).intValue() + "%";
        }
        if (index == 1) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.DESTROYER)).intValue() + "%";
        }
        if (index == 2) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.CRUISER)).intValue() + "%";
        }
        if (index == 3) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.CAPITAL_SHIP)).intValue() + "%";
        }
        if (index == 4) {
            return Math.round(20.0f) + "%";
        }
        return null;
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("\u6536\u76ca\u5c06\u968f\u7740\u5b89\u88c5\u6709\u6253\u635e\u8d77\u91cd\u673a\u6570\u91cf\u589e\u591a\u800c\u4e0b\u964d\u3002\u8230\u961f\u4e2d\u5355\u4e00\u8230\u8239\u7684\u56de\u6536\u6700\u9ad8\u6536\u76ca\u8d8a\u9ad8\uff0c\u6536\u76ca\u4e0b\u964d\u7684\u5e45\u5ea6\u5c31\u8d8a\u4f4e\u3002", opad);
        if (isForModSpec || ship == null) {
            return;
        }
        if (Global.getSettings().getCurrentState() == GameState.TITLE) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        float fleetMod = RepairGantry.getAdjustedGantryModifier(fleet, null, 0.0f);
        float currShipMod = ((Float)mag.get((Object)hullSize)).floatValue() * 0.01f;
        float fleetModWithOneMore = RepairGantry.getAdjustedGantryModifier(fleet, null, currShipMod);
        float fleetModWithoutThisShip = RepairGantry.getAdjustedGantryModifier(fleet, ship.getFleetMemberId(), 0.0f);
        tooltip.addPara("\u5f53\u524d\u8230\u961f\u7684\u6253\u635e\u80fd\u529b\u4e3a %s}\u3002", opad, h, Math.round(fleetMod * 100.0f) + "%");
        float cr = ship.getCurrentCR();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!member.getId().equals(ship.getFleetMemberId())) continue;
            cr = member.getRepairTracker().getCR();
        }
        if (cr < 0.1f) {
            LabelAPI label = tooltip.addPara("\u5f53\u8be5\u8230\u6218\u5907\u503c (CR) \u4f4e\u4e8e %s \u65f6\uff0c\u6253\u635e\u8d77\u91cd\u673a\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002\u5f53\u8be5\u8230\u7684\u6218\u5907\u5145\u8db3\u65f6\uff0c\u5c06\u63d0\u9ad8 %s \u7684\u8230\u961f\u6253\u635e\u80fd\u529b\u3002", opad, h, Math.round(10.0f) + "%", Math.round(fleetModWithOneMore * 100.0f) + "%");
            label.setHighlightColors(bad, h);
            label.setHighlight(Math.round(10.0f) + "%", Math.round(fleetModWithOneMore * 100.0f) + "%");
        } else if (fleetMod > currShipMod) {
            tooltip.addPara("\u79fb\u9664\u8be5\u8230\u4f1a\u4f7f\u589e\u76ca\u964d\u81f3 %s}\u3002\u6dfb\u52a0\u540c\u7c7b\u8230\u8239\u4f1a\u4f7f\u589e\u76ca\u63d0\u9ad8\u81f3 %s}\u3002", opad, h, Math.round(fleetModWithoutThisShip * 100.0f) + "%", Math.round(fleetModWithOneMore * 100.0f) + "%");
        } else {
            tooltip.addPara("\u5982\u679c\u518d\u63d0\u9ad8\u4e00\u8258\u540c\u7c7b\u8230\u8239\uff0c\u5176\u589e\u76ca\u5c06\u63d0\u5347\u81f3 %s}\u3002", opad, h, Math.round(fleetModWithOneMore * 100.0f) + "%");
        }
        tooltip.addPara("\u5f53\u524d\u8230\u961f\u7684\u6218\u540e\u6253\u635e\u80fd\u529b\u4e3a %s}\u3002", opad, h, Math.round(RepairGantry.getAdjustedGantryModifierForPostCombatSalvage(fleet) * 100.0f) + "%");
    }

    public static float getAdjustedGantryModifierForPostCombatSalvage(CampaignFleetAPI fleet) {
        return RepairGantry.getAdjustedGantryModifier(fleet, null, 0.0f) * 0.2f;
    }

    public static float getAdjustedGantryModifier(CampaignFleetAPI fleet, String skipId, float add) {
        float max = 0.0f;
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float v;
            if (member.isMothballed() || member.getRepairTracker().getCR() < 0.1f || member.getId().equals(skipId) || (v = member.getStats().getDynamic().getMod("salvage_value_bonus_ship").computeEffective(0.0f)) <= 0.0f) continue;
            if (v > max) {
                max = v;
            }
            total += v;
        }
        if (add > max) {
            max = add;
        }
        total += add;
        if (max <= 0.0f) {
            return 0.0f;
        }
        float units = total / max;
        if (units <= 1.0f) {
            return max;
        }
        float mult = Misc.logOfBase(2.5f, units) + 1.0f;
        float result = total * mult / units;
        if (result <= 0.0f) {
            result = 0.0f;
        } else {
            result = (float)Math.round(result * 100.0f) / 100.0f;
            result = Math.max(result, 0.01f);
        }
        return result;
    }
}

