/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.RulesAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.DismissDialog;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedInteractionDialogPluginImpl
implements InteractionDialogPlugin,
RuleBasedDialog {
    public static final String FAILSAFE_LEAVE = "rbid_failsafe_leave";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private RulesAPI rules;
    private MemoryAPI memory;
    private CampaignFleetAPI playerFleet;
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private boolean embeddedMode = false;
    private final String initialTrigger;
    private String lastOptionMousedOver = null;
    private Map<String, MemoryAPI> memoryMap;

    public void setEmbeddedMode(boolean embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    public RuleBasedInteractionDialogPluginImpl() {
        this("OpenInteractionDialog");
    }

    public RuleBasedInteractionDialogPluginImpl(String initialTrigger) {
        this.initialTrigger = initialTrigger;
    }

    @Override
    public void reinit(boolean withContinueOnRuleFound) {
        this.init(this.dialog);
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        if (!this.embeddedMode) {
            this.visual.setVisualFade(0.25f, 0.25f);
        }
        this.rules = Global.getSector().getRules();
        this.updateMemory();
        if (!this.embeddedMode) {
            this.fireBest(this.initialTrigger);
            if (!this.options.hasOptions()) {
                this.options.clearOptions();
                this.options.addOption("\u79bb\u5f00", FAILSAFE_LEAVE);
                if (Global.getSettings().isDevMode()) {
                    DevMenuOptions.addOptions(dialog);
                }
            }
        }
    }

    @Override
    public void updateMemory() {
        if (this.memoryMap == null) {
            this.memoryMap = new HashMap<String, MemoryAPI>();
        } else {
            this.memoryMap.clear();
        }
        this.memory = this.dialog.getInteractionTarget().getMemory();
        this.memoryMap.put("local", this.memory);
        if (this.dialog.getInteractionTarget().getFaction() != null) {
            this.memoryMap.put("faction", this.dialog.getInteractionTarget().getFaction().getMemory());
        } else {
            this.memoryMap.put("faction", Global.getFactory().createMemory());
        }
        this.memoryMap.put("global", Global.getSector().getMemory());
        this.memoryMap.put("player", Global.getSector().getCharacterData().getMemory());
        if (this.dialog.getInteractionTarget().getMarket() != null) {
            this.memoryMap.put("market", this.dialog.getInteractionTarget().getMarket().getMemory());
        }
        if (this.memory.contains("$sourceMarket")) {
            String marketId = this.memory.getString("$sourceMarket");
            MarketAPI market = Global.getSector().getEconomy().getMarket(marketId);
            if (market != null) {
                this.memoryMap.put("sourceMarket", market.getMemory());
            }
        }
        this.updatePersonMemory();
    }

    private void updatePersonMemory() {
        PersonAPI person = this.dialog.getInteractionTarget().getActivePerson();
        if (person != null) {
            this.memory = person.getMemory();
            this.memoryMap.put("local", this.memory);
            this.memoryMap.put("personFaction", person.getFaction().getMemory());
            this.memoryMap.put("entity", this.dialog.getInteractionTarget().getMemory());
        } else {
            this.memory = this.dialog.getInteractionTarget().getMemory();
            this.memoryMap.put("local", this.memory);
            this.memoryMap.remove("entity");
            this.memoryMap.remove("personFaction");
        }
    }

    @Override
    public void notifyActivePersonChanged() {
        this.updatePersonMemory();
    }

    @Override
    public void setActiveMission(CampaignEventPlugin mission) {
        if (mission == null) {
            this.memoryMap.remove("mission");
        } else {
            MemoryAPI memory = mission.getMemory();
            if (memory != null) {
                this.memoryMap.put("mission", memory);
            } else {
                this.memoryMap.remove("mission");
            }
        }
    }

    public boolean fireAll(String trigger) {
        return FireAll.fire(null, this.dialog, this.memoryMap, trigger);
    }

    public boolean fireBest(String trigger) {
        return FireBest.fire(null, this.dialog, this.memoryMap, trigger);
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null || !(optionData instanceof String)) {
            return;
        }
        String optionId = (String)optionData;
        if (text != null) {
            this.dialog.addOptionSelectedText(optionData);
        }
        if (optionId == FAILSAFE_LEAVE) {
            new DismissDialog().execute(null, this.dialog, null, this.memoryMap);
            return;
        }
        if (optionId == "DumpMemory.option_dump_memory") {
            new DumpMemory().execute(null, this.dialog, null, this.memoryMap);
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        this.memory.set("$option", optionId);
        this.memory.expire("$option", 0.0f);
        boolean foundRule = this.fireBest("DialogOptionSelected");
        if (!foundRule && !this.dialog.isCurrentOptionHadAConfirm()) {
            this.textPanel.addPara("\u9519\u8bef\uff1a\u6ca1\u6709\u4e3a " + optionId + " \u9009\u9879\u627e\u5230\u89c4\u5219\uff0c\u4f60\u53ef\u70b9\u51fb\u751f\u6210\u7684\u6545\u969c\u4fdd\u62a4\u9009\u9879\u6765\u5b89\u5168\u9000\u51fa\u3002", Misc.getNegativeHighlightColor());
            this.textPanel.addPara("\u6ce8\u610f\uff1a\u8fd9\u53ef\u80fd\u4f1a\u7834\u574f\u5f53\u524d\u5bf9\u8bdd\u6846\u4e2d\u7684\u67d0\u4e9b\u4efb\u52a1\u4ea4\u4e92\uff0c\u5982\u679c\u4f60\u4f7f\u7528\u4e86\u8be5\u9009\u9879\uff0c\u5efa\u8bae\u4f60\u91cd\u65b0\u52a0\u8f7d\u4e4b\u524d\u7684\u4e00\u4e2a\u5b58\u6863\u3002");
            this.textPanel.highlightInLastPara(Misc.getNegativeHighlightColor(), "\u5efa\u8bae\u4f60\u91cd\u65b0\u52a0\u8f7d\u4e4b\u524d\u7684\u4e00\u4e2a\u5b58\u6863");
            this.options.addOption("\u9000\u51fa\u5bf9\u8bdd\u6846", FAILSAFE_LEAVE);
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.memoryMap;
    }
}

