/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.BaseCampaignObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoInDirection;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SensorArrayEntityPlugin
extends BaseCampaignObjectivePlugin {
    public static float SENSOR_BONUS = 700.0f;
    public static float SENSOR_BONUS_MAKESHIFT = 400.0f;
    public static String GHOST_RESPONSE = "ghost_response";

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        if (this.entity.getContainingLocation() == null || this.entity.isInHyperspace()) {
            return;
        }
        boolean reset = this.isReset();
        String id = this.getModId();
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            MutableStat.StatMod curr;
            if (fleet.isInHyperspaceTransition() || fleet.getFaction() != this.entity.getFaction() && (!this.isHacked().booleanValue() || !fleet.getFaction().isPlayerFaction())) continue;
            if (reset && !fleet.getFaction().isPlayerFaction()) {
                this.respondToFalseSensorReadings(fleet);
            } else if (reset && fleet.isPlayerFleet()) {
                this.spawnPlayerSensorReading(fleet);
            }
            String desc = "\u4f20\u611f\u5668\u9635\u5217";
            float bonus = SENSOR_BONUS;
            if (this.isMakeshift()) {
                desc = "\u4e34\u65f6\u4f20\u611f\u5668\u9635\u5217";
                bonus = SENSOR_BONUS_MAKESHIFT;
            }
            if ((curr = fleet.getStats().getSensorRangeMod().getFlatBonus(id)) != null && !(curr.value <= bonus)) continue;
            fleet.getStats().addTemporaryModFlat(0.1f, id, desc, bonus, fleet.getStats().getSensorRangeMod());
        }
    }

    protected boolean isMakeshift() {
        return this.entity.hasTag("makeshift");
    }

    public void printEffect(TooltipMakerAPI text, float pad) {
        int bonus = (int)SENSOR_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)SENSOR_BONUS_MAKESHIFT;
        }
        text.addPara("      %s \u4f20\u611f\u5668\u63a2\u6d4b\u8303\u56f4\uff0c\u7ed9\u661f\u7cfb\u5185\u540c\u4e00\u52bf\u529b\u7684\u8230\u961f", pad, Misc.getHighlightColor(), "+" + bonus);
        if (this.isReset().booleanValue()) {
            text.addPara("      \u4ea7\u751f\u5047\u4fe1\u53f7", 3.0f);
        }
    }

    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            text.addPara("\u7136\u800c\u8be5\u8bbe\u5907\u4f3c\u4e4e\u5e76\u672a\u53d1\u9001\u4f20\u611f\u5668\u9065\u6d4b\u6570\u636e\uff0c\u5176\u529f\u80fd\u7f3a\u5931\u7684\u539f\u56e0\u4e5f\u5c1a\u4e0d\u660e\u786e\u3002");
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("\u4f60\u5df2\u7ecf\u6709\u4e00\u4e2a\u9ed1\u5ba2\u7a0b\u5e8f\u5728\u8be5\u8bbe\u5907\u4e0a\u8fd0\u884c\u3002");
        }
    }

    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        int bonus = (int)SENSOR_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)SENSOR_BONUS_MAKESHIFT;
        }
        text.addPara("%s \u661f\u7cfb\u5185\u8be5\u8bbe\u5907\u63a7\u5236\u65b9\u8230\u961f\u7684\u4f20\u611f\u5668\u63a2\u6d4b\u8303\u56f4", pad, Misc.getHighlightColor(), "+" + bonus);
        super.addHackStatusToTooltip(text, pad);
    }

    protected String getModId() {
        return "sensor_array";
    }

    protected void spawnPlayerSensorReading(CampaignFleetAPI fleet) {
        int maxBurn;
        boolean spawnReading;
        Random random = Misc.random;
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean("$core_fleetNotChasingGhost")) {
            return;
        }
        if (mem.getBoolean("$core_fleetChasingGhost")) {
            return;
        }
        boolean bl = spawnReading = random.nextFloat() < 0.5f;
        if (!spawnReading) {
            mem.set("$core_fleetNotChasingGhost", true, 1.0f + 2.0f * random.nextFloat());
            return;
        }
        float dur = 6.0f + random.nextFloat();
        mem.set("$core_fleetNotChasingGhost", true, dur * 0.5f);
        BaseSensorGhost g = new BaseSensorGhost(null, 0);
        float r = random.nextFloat();
        if (r < 0.25f) {
            g.initEntity(g.genMediumSensorProfile(), g.genSmallRadius(), 0, fleet.getContainingLocation());
            maxBurn = 9 + random.nextInt(3);
        } else if (r < 0.6f) {
            g.initEntity(g.genLargeSensorProfile(), g.genMediumRadius(), 0, fleet.getContainingLocation());
            maxBurn = 8 + random.nextInt(3);
        } else {
            g.initEntity(g.genLargeSensorProfile(), g.genLargeRadius(), 0, fleet.getContainingLocation());
            maxBurn = 7 + random.nextInt(3);
        }
        if (!g.placeNearPlayer()) {
            return;
        }
        float speed = Misc.getSpeedForBurnLevel(maxBurn);
        float accelMult = speed / Misc.getSpeedForBurnLevel(20.0f);
        if (accelMult < 0.1f) {
            accelMult = 0.1f;
        }
        g.setAccelMult(1.0f / accelMult);
        float dir = Misc.getAngleInDegrees(g.getEntity().getLocation(), fleet.getLocation());
        float sign = Math.signum(random.nextFloat() - 0.5f);
        g.addBehavior(new GBGoInDirection(dur, dir += sign * (30.0f + random.nextFloat() * 60.0f), maxBurn));
        fleet.getContainingLocation().addScript(g);
    }

    protected void respondToFalseSensorReadings(CampaignFleetAPI fleet) {
        boolean willRespond;
        if (fleet.isStationMode()) {
            return;
        }
        if (fleet.getAI() == null) {
            return;
        }
        if (fleet.getAI().getAssignmentsCopy() == null) {
            return;
        }
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean("$core_fleetNotChasingGhost")) {
            return;
        }
        if (mem.getBoolean("$core_fleetChasingGhost")) {
            return;
        }
        if (mem.getBoolean("$core_fleetBusy")) {
            return;
        }
        boolean patrol = mem.getBoolean("$isPatrol");
        boolean warFleet = mem.getBoolean("$isWarFleet");
        boolean pirate = mem.getBoolean("$isPirate");
        if (!(patrol || warFleet || pirate)) {
            return;
        }
        Random random = (Random)mem.get("$core_fleetChasingGhostRandom");
        if (random == null) {
            random = Misc.getRandom(Misc.getSalvageSeed(fleet), 7);
            mem.set("$core_fleetChasingGhostRandom", random, 30.0f);
        }
        boolean bl = willRespond = random.nextFloat() < 0.75f;
        if (!willRespond) {
            mem.set("$core_fleetNotChasingGhost", true, 1.0f + 1.0f * random.nextFloat());
            Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetChasingGhost", GHOST_RESPONSE, false, 0.0f);
            for (FleetAssignmentDataAPI curr : fleet.getAI().getAssignmentsCopy()) {
                if (!GHOST_RESPONSE.equals(curr.getCustom())) continue;
                fleet.getAI().removeAssignment(curr);
            }
            return;
        }
        float chaseDur = (2.5f + (float)Math.random()) * 2.0f;
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetChasingGhost", GHOST_RESPONSE, true, chaseDur);
        mem.set("$core_fleetBusy", true, chaseDur);
        mem.set("$core_fleetNotChasingGhost", true, chaseDur + 8.0f + 4.0f * random.nextFloat());
        float angle = Misc.getAngleInDegrees(fleet.getLocation());
        float arc = 270.0f;
        float dist = 3000.0f + 3000.0f * random.nextFloat();
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle += arc / 2.0f - arc * random.nextFloat());
        loc.scale(dist);
        Vector2f.add((Vector2f)loc, (Vector2f)fleet.getLocation(), (Vector2f)loc);
        String actionText = "\u8c03\u67e5\u5f02\u5e38\u7684\u4f20\u611f\u5668\u4fe1\u53f7";
        SectorEntityToken target = fleet.getContainingLocation().createToken(loc);
        fleet.addAssignmentAtStart(FleetAssignment.PATROL_SYSTEM, target, 3.0f, actionText, null);
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(GHOST_RESPONSE);
        }
        if (dist > 2000.0f) {
            fleet.addAssignmentAtStart(FleetAssignment.GO_TO_LOCATION, target, 3.0f, actionText, null);
            curr = fleet.getCurrentAssignment();
            if (curr != null) {
                curr.setCustom(GHOST_RESPONSE);
            }
        }
    }
}

