/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class SmugglingFactionChangeScript
implements EveryFrameScript {
    private CampaignFleetAPI fleet;
    private String origFaction;
    private IntervalUtil tracker = new IntervalUtil(0.1f, 0.3f);

    public SmugglingFactionChangeScript(CampaignFleetAPI fleet) {
        this.fleet = fleet;
        this.origFaction = fleet.getFaction().getId();
    }

    public void advance(float amount) {
        SectorEntityToken target;
        FleetAssignmentDataAPI assignment;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed() && this.fleet.getAI() != null && (assignment = this.fleet.getAI().getCurrentAssignment()) != null && assignment.getAssignment() != FleetAssignment.STANDING_DOWN && (target = assignment.getTarget()) != null && target.getFaction() != null) {
            boolean targetHostile = target.getFaction().isHostileTo(this.origFaction);
            boolean mathchesTarget = this.fleet.getFaction().getId().equals(target.getFaction().getId());
            boolean mathchesOrig = this.fleet.getFaction().getId().equals(this.origFaction);
            float dist = Misc.getDistance(this.fleet.getLocation(), target.getLocation());
            if (dist < target.getRadius() + this.fleet.getRadius() + 1000.0f) {
                if (targetHostile && !mathchesTarget) {
                    this.fleet.setFaction(target.getFaction().getId(), true);
                }
            } else if (!mathchesOrig) {
                this.fleet.setFaction(this.origFaction, true);
            }
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

