/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.shared.PersonBountyEventData;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardRespawnDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showImagePortion("illustrations", "space_wreckage", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("\u4f60\u7684\u8230\u961f\u5df2\u7ecf\u88ab\u51fb\u8d25\uff01");
                this.textPanel.addParagraph("\u4e00\u822c\uff0c\u5982\u679c\u53d1\u751f\u8fd9\u79cd\u60c5\u51b5\uff0c\u4f60\u548c\u4f60\u5269\u4e0b\u7684\u8239\u5458\u5c06\u82b1\u4e00\u4e9b\u65f6\u95f4 \"\u5728\u5e55\u540e\" \u7ec4\u88c5\u4e00\u4e2a\u8f83\u5c0f\u7684\u8239\u961f\u56de\u6536\u8230\u8239\u3002");
                this.textPanel.addParagraph("\u5728\u672c\u6559\u7a0b\u4e2d\uff0c\u552f\u4e00\u53ef\u7528\u7684\u9009\u9879\u662f\u91cd\u65b0\u52a0\u8f7d\u6700\u540e\u7684\u4fdd\u5b58\u3002");
                this.options.clearOptions();
                this.options.addOption("\u7ee7\u7eed", (Object)OptionId.RESPAWN, null);
                break;
            }
            case RESPAWN: {
                this.createPlayerFleet();
                this.dialog.dismiss();
                Global.getSector().getCampaignUI().quickLoad();
            }
        }
    }

    protected void createPlayerFleet() {
        float fp = 10.0f;
        float crew = 50.0f;
        float daysSince = Global.getSector().getClock().getElapsedDaysSince(SharedData.getData().getPlayerLosingBattleTimestamp());
        if (daysSince < 2.0f) {
            fp = SharedData.getData().getPlayerPreLosingBattleFP();
            crew = SharedData.getData().getPlayerPreLosingBattleCrew();
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        for (CampaignFleetAPI other : Global.getSector().getCurrentLocation().getFleets()) {
            MemoryAPI mem = other.getMemoryWithoutUpdate();
            if (mem.getBoolean("$cfai_makeHostileWhileTOff")) {
                mem.removeAllRequired("$cfai_makeHostileWhileTOff");
            }
            mem.unset("$sawPlayerTransponderOff");
            if (Misc.isPermaKnowsWhoPlayerIs(other)) continue;
            mem.unset("$sawPlayerTransponderOn");
        }
        CampaignFleetAPI fleet = FleetFactoryV3.createEmptyFleet("player", null, null);
        fleet.setName("\u8230\u961f");
        Global.getSector().setCurrentLocation(Global.getSector().getHyperspace());
        fleet.setLocation(1.0E9f, 1.0E9f);
        for (OfficerDataAPI officer : playerFleet.getFleetData().getOfficersCopy()) {
            fleet.getFleetData().addOfficer(officer);
        }
        Global.getSector().setPlayerFleet(fleet);
        Global.getSector().setLastPlayerBattleTimestamp(Long.MIN_VALUE);
        Global.getSector().setLastPlayerBattleWon(false);
        fleet.getFleetData().setSyncNeeded();
        fleet.getFleetData().syncIfNeeded();
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float max = member.getRepairTracker().getMaxCR();
            member.getRepairTracker().setCR(max);
        }
        for (String id : Global.getSector().getCharacterData().getAbilities()) {
            fleet.addAbility(id);
        }
        if (fleet.getAbility("transponder") != null) {
            fleet.getAbility("transponder").activate();
        }
        Global.getSector().setPaused(true);
        Global.getSector().getCampaignUI().resetViewOffset();
        Misc.clearAreaAroundPlayer(2000.0f);
        PersonBountyEventData data = SharedData.getData().getPersonBountyEventData();
        data.setLevel(Math.max(0, data.getLevel() - 1));
        data.setSuccessesThisLevel(0);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        RESPAWN;

    }
}

