/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.abilities.BaseAbilityPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public abstract class BaseDurationAbility
extends BaseAbilityPlugin {
    public static final float LOOP_FADE_TIME_DAYS = 0.1f;
    protected boolean turnedOn = false;
    protected float activeDaysLeft = 0.0f;
    protected float cooldownLeft = 0.0f;
    protected float level = 0.0f;
    protected float loopFadeLeft = 0.0f;
    protected boolean fadingOut = false;

    public float getLoopSoundUIVolume() {
        if (this.loopFadeLeft > 0.0f) {
            return this.loopFadeLeft / 0.1f;
        }
        if (this.level > 0.0f) {
            if (this.fadingOut) {
                return 1.0f;
            }
            return this.level;
        }
        return 0.0f;
    }

    public float getLoopSoundUIPitch() {
        return 1.0f;
    }

    public float getLoopSoundWorldVolume() {
        return this.getLoopSoundUIVolume();
    }

    public float getLoopSoundWorldPitch() {
        return 1.0f;
    }

    public float getCooldownDays() {
        return this.spec.getDeactivationCooldown();
    }

    public float getDurationDays() {
        return this.spec.getDurationDays();
    }

    public float getTotalDurationDays() {
        return this.spec.getDurationDays() + this.spec.getActivationDays() + this.spec.getDeactivationDays();
    }

    public float getActivationDays() {
        return this.spec.getActivationDays();
    }

    public float getDeactivationDays() {
        return this.spec.getDeactivationDays();
    }

    protected abstract void activateImpl();

    protected abstract void applyEffect(float var1, float var2);

    protected abstract void deactivateImpl();

    protected abstract void cleanupImpl();

    public void advance(float amount) {
        String soundId;
        super.advance(amount);
        if (this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet() && this.getLoopSoundWorldVolume() > 0.0f && !Global.getSector().isPaused() && (soundId = this.getLoopSoundWorld()) != null) {
            Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * this.getLoopSoundWorldVolume());
            Global.getSoundPlayer().playLoop(soundId, this.entity, this.getLoopSoundWorldPitch(), this.getLoopSoundWorldVolume(), this.entity.getLocation(), this.entity.getVelocity());
        }
        if (this.entity.isPlayerFleet() && this.getLoopSoundUIVolume() > 0.0f && !Global.getSector().isPaused() && (soundId = this.getLoopSoundUI()) != null) {
            Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * this.getLoopSoundUIVolume());
            Global.getSoundPlayer().playLoop(soundId, this.entity, this.getLoopSoundUIPitch(), this.getLoopSoundUIVolume(), this.entity.getLocation(), this.entity.getVelocity());
        }
        if (this.activeDaysLeft > 0.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.activeDaysLeft -= days;
            if (this.activeDaysLeft <= 0.0f) {
                this.level = 1.0f;
                this.applyEffect(amount, this.level);
                this.activeDaysLeft = 0.0f;
                this.deactivate();
            }
        } else if (this.cooldownLeft > 0.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.cooldownLeft -= days;
            if (this.cooldownLeft < 0.0f) {
                this.cooldownLeft = 0.0f;
            }
        }
        if (this.loopFadeLeft > 0.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.loopFadeLeft -= days;
            if (this.loopFadeLeft < 0.0f) {
                this.loopFadeLeft = 0.0f;
            }
        }
        float prevLevel = this.level;
        if (this.activeDaysLeft > 0.0f) {
            float a = this.getActivationDays();
            float d = this.getDeactivationDays();
            float t = this.getTotalDurationDays();
            if (this.activeDaysLeft > t - a) {
                this.level = a <= 0.0f ? 1.0f : 1.0f - (this.activeDaysLeft - (t - a)) / a;
            } else if (this.activeDaysLeft < d) {
                this.fadingOut = true;
                this.level = d <= 0.0f ? 0.0f : this.activeDaysLeft / d;
            } else {
                this.level = 1.0f;
            }
        } else {
            this.level = 0.0f;
        }
        if (prevLevel != this.level || this.level > 0.0f) {
            this.applyEffect(amount, this.level);
            this.disableIncompatible();
        }
    }

    protected void addIncompatibleToTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        this.addIncompatibleToTooltip(tooltip, "\u6fc0\u6d3b\u65f6\u5c06\u4f1a\u7981\u7528\u4ee5\u4e0b\u80fd\u529b\uff1a", "\u5c55\u5f00\u4fe1\u606f\u67e5\u770b\u51b2\u7a81\u7684\u80fd\u529b", expanded);
    }

    public float getCooldownFraction() {
        if (this.cooldownLeft <= 0.0f) {
            return 1.0f;
        }
        return 1.0f - this.cooldownLeft / this.getCooldownDays();
    }

    public float getProgressFraction() {
        if (this.getTotalDurationDays() <= 0.0f || !this.turnedOn) {
            return 0.0f;
        }
        return 1.0f - this.activeDaysLeft / this.getTotalDurationDays();
    }

    public boolean showProgressIndicator() {
        return this.turnedOn;
    }

    public boolean showActiveIndicator() {
        return false;
    }

    public boolean isUsable() {
        return !this.isOnCooldown() && !this.isInProgress() && !this.turnedOn && this.disableFrames <= 0;
    }

    public void pressButton() {
        if (this.isUsable() && !this.turnedOn) {
            String soundId;
            this.activate();
            if (this.entity.isPlayerFleet() && (soundId = this.getOnSoundUI()) != null) {
                if (PLAY_UI_SOUNDS_IN_WORLD_SOURCES) {
                    Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
                } else {
                    Global.getSoundPlayer().playUISound(soundId, 1.0f, 1.0f);
                }
            }
        }
    }

    public void activate() {
        if (this.isUsable() && !this.turnedOn) {
            String soundId;
            this.turnedOn = true;
            this.loopFadeLeft = 0.0f;
            this.fadingOut = false;
            this.activeDaysLeft = this.getTotalDurationDays();
            if (this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet() && !this.entity.isPlayerFleet() && (soundId = this.getOnSoundWorld()) != null) {
                Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, this.entity.getLocation(), this.entity.getVelocity());
            }
            if (this.getActivationDays() <= 0.0f) {
                this.level = 1.0f;
            }
            if (this.entity.isInCurrentLocation() && this.getActivationText() != null && this.entity.isVisibleToPlayerFleet()) {
                this.entity.addFloatingText(this.getActivationText(), Misc.setAlpha(this.entity.getIndicatorColor(), 255), 0.5f);
            }
            this.activateImpl();
            this.applyEffect(0.0f, this.level);
            this.interruptIncompatible();
            this.disableIncompatible();
            if (this.getTotalDurationDays() <= 0.0f) {
                this.deactivate();
            }
            super.activate();
        }
    }

    public void deactivate() {
        if (this.turnedOn) {
            String soundId;
            this.turnedOn = false;
            this.activeDaysLeft = 0.0f;
            this.loopFadeLeft = 0.1f;
            if (this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet() && !this.entity.isPlayerFleet() && (soundId = this.getOffSoundWorld()) != null) {
                Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, this.entity.getLocation(), this.entity.getVelocity());
            }
            if (this.entity.isPlayerFleet() && (soundId = this.getOffSoundUI()) != null) {
                if (PLAY_UI_SOUNDS_IN_WORLD_SOURCES) {
                    Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
                } else {
                    Global.getSoundPlayer().playUISound(soundId, 1.0f, 1.0f);
                }
            }
            this.cooldownLeft = this.getCooldownDays();
            this.level = 0.0f;
            this.applyEffect(0.0f, this.level);
            if (this.entity.isInCurrentLocation() && this.getDeactivationText() != null && this.entity.isVisibleToPlayerFleet()) {
                this.entity.addFloatingText(this.getDeactivationText(), Misc.setAlpha(this.entity.getIndicatorColor(), 255), 0.5f);
            }
            this.deactivateImpl();
            super.deactivate();
        }
    }

    public void cleanup() {
        super.cleanup();
        this.applyEffect(0.0f, 0.0f);
        this.cleanupImpl();
    }

    public boolean isActive() {
        return false;
    }

    public boolean isInProgress() {
        return super.isInProgress();
    }

    public boolean hasCustomButtonPressSounds() {
        return this.getOnSoundUI() != null;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public float getActiveDaysLeft() {
        return this.activeDaysLeft;
    }

    public void setActiveDaysLeft(float activeDaysLeft) {
        this.activeDaysLeft = activeDaysLeft;
    }

    public float getCooldownLeft() {
        return this.cooldownLeft;
    }

    public void setCooldownLeft(float cooldownLeft) {
        this.cooldownLeft = cooldownLeft;
    }

    public boolean isFadingOut() {
        return this.fadingOut;
    }

    public float getLevel() {
        return this.level;
    }
}

