/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.abilities.BaseAbilityPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public abstract class BaseToggleAbility
extends BaseAbilityPlugin {
    protected boolean turnedOn = false;
    protected float cooldownLeft = 0.0f;
    protected boolean isActivateCooldown = false;
    protected float level = 0.0f;

    public float getLoopSoundUIVolume() {
        return this.level;
    }

    public float getLoopSoundUIPitch() {
        return 1.0f;
    }

    public float getLoopSoundWorldVolume() {
        return this.level;
    }

    public float getLoopSoundWorldPitch() {
        return 1.0f;
    }

    public float getActivateCooldownDays() {
        return this.spec.getActivationCooldown();
    }

    public float getDeactivateCooldownDays() {
        return this.spec.getDeactivationCooldown();
    }

    public float getActivationDays() {
        return this.spec.getActivationDays();
    }

    public float getDeactivationDays() {
        return this.spec.getDeactivationDays();
    }

    protected abstract void activateImpl();

    protected abstract void applyEffect(float var1, float var2);

    protected abstract void deactivateImpl();

    protected abstract void cleanupImpl();

    public float getCooldownLeft() {
        return this.cooldownLeft;
    }

    public void setCooldownLeft(float cooldownLeft) {
        this.cooldownLeft = cooldownLeft;
    }

    public void advance(float amount) {
        String soundId;
        super.advance(amount);
        if (this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet() && this.getLoopSoundWorldVolume() > 0.0f && !Global.getSector().isPaused() && (soundId = this.getLoopSoundWorld()) != null) {
            Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * this.getLoopSoundWorldVolume());
            Global.getSoundPlayer().playLoop(soundId, this.entity, this.getLoopSoundWorldPitch(), this.getLoopSoundWorldVolume(), this.entity.getLocation(), this.entity.getVelocity());
        }
        if (this.entity.isPlayerFleet() && this.getLoopSoundUIVolume() > 0.0f && !Global.getSector().isPaused() && (soundId = this.getLoopSoundUI()) != null) {
            Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * this.getLoopSoundUIVolume());
            Global.getSoundPlayer().playLoop(soundId, this.entity, this.getLoopSoundUIPitch(), this.getLoopSoundUIVolume(), this.entity.getLocation(), this.entity.getVelocity());
        }
        if (this.cooldownLeft > 0.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.cooldownLeft -= days;
            if (this.cooldownLeft < 0.0f) {
                this.cooldownLeft = 0.0f;
            }
        }
        float prevLevel = this.level;
        if (this.turnedOn && this.level < 1.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.level += days / this.getActivationDays();
            if (this.level > 1.0f) {
                this.level = 1.0f;
            }
        } else if (!this.turnedOn && this.level > 0.0f) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.level -= days / this.getDeactivationDays();
            if (this.level < 0.0f) {
                this.level = 0.0f;
            }
        }
        if (prevLevel != this.level || this.level > 0.0f) {
            this.applyEffect(amount, this.level);
        }
    }

    protected void addIncompatibleToTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        this.addIncompatibleToTooltip(tooltip, "\u6fc0\u6d3b\u65f6\u5c06\u4f1a\u4e2d\u65ad\u4ee5\u4e0b\u80fd\u529b\uff1a", "\u5c55\u5f00\u4fe1\u606f\u67e5\u770b\u51b2\u7a81\u7684\u80fd\u529b", expanded);
    }

    public boolean isUsable() {
        if (!this.isActivateCooldown && this.getProgressFraction() > 0.0f && this.getProgressFraction() < 1.0f && this.getDeactivationDays() > 0.0f) {
            return false;
        }
        return super.isUsable();
    }

    public float getCooldownFraction() {
        if (this.cooldownLeft <= 0.0f) {
            return 1.0f;
        }
        if (this.isActivateCooldown) {
            float max = this.getActivateCooldownDays();
            if (max <= 0.0f) {
                return 1.0f - this.cooldownLeft / 1.0f;
            }
            return 1.0f - this.cooldownLeft / max;
        }
        float max = this.getDeactivateCooldownDays();
        if (max <= 0.0f) {
            return 1.0f - this.cooldownLeft / 1.0f;
        }
        return 1.0f - this.cooldownLeft / max;
    }

    public float getProgressFraction() {
        return this.level;
    }

    public boolean showProgressIndicator() {
        return this.level > 0.0f && (!this.turnedOn || this.level < 1.0f);
    }

    public boolean showActiveIndicator() {
        return this.isActive() && this.level >= 1.0f;
    }

    public void pressButton() {
        if (this.isActive()) {
            this.deactivate();
        } else {
            this.activate();
        }
        if (this.entity.isPlayerFleet()) {
            if (this.isActive()) {
                String soundId = this.getOnSoundUI();
                if (soundId != null) {
                    if (PLAY_UI_SOUNDS_IN_WORLD_SOURCES) {
                        Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
                    } else {
                        Global.getSoundPlayer().playUISound(soundId, 1.0f, 1.0f);
                    }
                }
            } else {
                String soundId = this.getOffSoundUI();
                if (soundId != null) {
                    if (PLAY_UI_SOUNDS_IN_WORLD_SOURCES) {
                        Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
                    } else {
                        Global.getSoundPlayer().playUISound(soundId, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public void activate() {
        if (!this.isActive() && this.isUsable()) {
            String soundId;
            this.turnedOn = true;
            if (this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet() && !this.entity.isPlayerFleet() && (soundId = this.getOnSoundWorld()) != null) {
                Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, this.entity.getLocation(), this.entity.getVelocity());
            }
            if (this.getActivationDays() <= 0.0f) {
                this.level = 1.0f;
            }
            this.cooldownLeft = this.getActivateCooldownDays();
            this.isActivateCooldown = true;
            if (this.entity.isInCurrentLocation() && this.getActivationText() != null && this.entity.isVisibleToPlayerFleet()) {
                this.entity.addFloatingText(this.getActivationText(), Misc.setAlpha(this.entity.getIndicatorColor(), 255), 0.5f);
            }
            this.activateImpl();
            this.applyEffect(0.0f, this.level);
            this.interruptIncompatible();
            super.activate();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            String soundId;
            this.turnedOn = false;
            if (this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet() && !this.entity.isPlayerFleet() && (soundId = this.getOffSoundWorld()) != null) {
                Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, this.entity.getLocation(), this.entity.getVelocity());
            }
            if (this.getDeactivationDays() <= 0.0f) {
                this.level = 0.0f;
            }
            this.cooldownLeft = this.getDeactivateCooldownDays();
            this.isActivateCooldown = false;
            this.applyEffect(0.0f, this.level);
            if (this.entity.isInCurrentLocation() && this.getDeactivationText() != null && this.entity.isVisibleToPlayerFleet()) {
                this.entity.addFloatingText(this.getDeactivationText(), Misc.setAlpha(this.entity.getIndicatorColor(), 255), 0.5f);
            }
            this.deactivateImpl();
            super.deactivate();
        }
    }

    public void cleanup() {
        super.cleanup();
        this.applyEffect(0.0f, 0.0f);
        this.cleanupImpl();
    }

    public boolean isActive() {
        return this.turnedOn;
    }

    public boolean hasCustomButtonPressSounds() {
        return this.getOnSoundUI() != null;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public float getLevel() {
        return this.level;
    }
}

