/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.abilities.DistressCallResponseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.abilities.DistressCallResponsePirateAssignmentAI;
import com.fs.starfarer.api.impl.campaign.econ.impl.MilitaryBase;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.PirateFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RuinsFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.DelayedActionScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistressCallAbility
extends BaseDurationAbility
implements RouteManager.RouteFleetSpawner {
    public static final float NEARBY_USE_TIMEOUT_DAYS = 20.0f;
    public static final float NEARBY_USE_RADIUS_LY = 5.0f;
    public static final float DAYS_TO_TRACK_USAGE = 365.0f;
    protected boolean performed = false;
    protected int numTimesUsed = 0;
    protected long lastUsed = 0L;
    protected TimeoutTracker<AbilityUseData> uses = new TimeoutTracker();

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.uses == null) {
            this.uses = new TimeoutTracker();
        }
        return this;
    }

    @Override
    protected void activateImpl() {
        if (this.entity.isInCurrentLocation()) {
            SectorEntityToken.VisibilityLevel level = this.entity.getVisibilityLevelToPlayerFleet();
            if (level != SectorEntityToken.VisibilityLevel.NONE) {
                Global.getSector().addPing(this.entity, "distress_call");
            }
            this.performed = false;
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (!this.performed) {
            DistressCallOutcome outcome;
            if (this.wasUsedNearby(20.0f, fleet.getLocationInHyperspace(), 5.0f)) {
                this.performed = true;
                return;
            }
            WeightedRandomPicker<DistressCallOutcome> picker = new WeightedRandomPicker<DistressCallOutcome>();
            picker.add(DistressCallOutcome.HELP, 10.0f);
            if (this.numTimesUsed > 2) {
                float uses = this.getNumUsesInLastPeriod();
                float pirates = 10.0f + uses * 2.0f;
                picker.add(DistressCallOutcome.PIRATES, pirates);
                float nothing = 10.0f + uses * 2.0f;
                picker.add(DistressCallOutcome.NOTHING, nothing);
            }
            if ((outcome = (DistressCallOutcome)((Object)picker.pick())) != DistressCallOutcome.NOTHING) {
                float delay = 10.0f + 10.0f * (float)Math.random();
                if (this.numTimesUsed == 0) {
                    delay = 1.0f + 2.0f * (float)Math.random();
                }
                this.addResponseScript(delay, outcome);
            }
            ++this.numTimesUsed;
            this.lastUsed = Global.getSector().getClock().getTimestamp();
            this.performed = true;
            AbilityUseData data = new AbilityUseData(this.lastUsed, fleet.getLocationInHyperspace());
            this.uses.add(data, 365.0f);
        }
    }

    public boolean wasUsedNearby(float withinDays, Vector2f locInHyper, float withinRangeLY) {
        for (AbilityUseData data : this.uses.getItems()) {
            float range;
            float daysSinceUse = Global.getSector().getClock().getElapsedDaysSince(data.timestamp);
            if (!(daysSinceUse <= withinDays) || !((range = Misc.getDistanceLY(locInHyper, data.location)) <= withinRangeLY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.uses.advance(days);
    }

    public TimeoutTracker<AbilityUseData> getUses() {
        return this.uses;
    }

    public int getNumUsesInLastPeriod() {
        return this.uses.getItems().size();
    }

    protected void addResponseScript(float delayDays, DistressCallOutcome outcome) {
        JumpPointAPI outer;
        SectorEntityToken test;
        CampaignFleetAPI player = this.getFleet();
        if (player == null) {
            return;
        }
        if (!(player.getContainingLocation() instanceof StarSystemAPI)) {
            return;
        }
        StarSystemAPI system = (StarSystemAPI)player.getContainingLocation();
        JumpPointAPI inner = Misc.getDistressJumpPoint(system);
        if (inner == null) {
            return;
        }
        JumpPointAPI outerTemp = null;
        if (inner.getDestinations().size() >= 1 && (test = inner.getDestinations().get(0).getDestination()) instanceof JumpPointAPI) {
            outerTemp = (JumpPointAPI)test;
        }
        if ((outer = outerTemp) == null) {
            return;
        }
        if (outcome == DistressCallOutcome.HELP) {
            this.addHelpScript(delayDays, system, inner, outer);
        } else if (outcome == DistressCallOutcome.PIRATES) {
            this.addPiratesScript(delayDays, system, inner, outer);
        }
    }

    protected void addPiratesScript(float delayDays, StarSystemAPI system, final JumpPointAPI inner, final JumpPointAPI outer) {
        Global.getSector().addScript(new DelayedActionScript(delayDays){

            public void doAction() {
                CampaignFleetAPI player = Global.getSector().getPlayerFleet();
                if (player == null) {
                    return;
                }
                int numPirates = new Random().nextInt(3) + 1;
                int i = 0;
                while (i < numPirates) {
                    DistressResponseData data = new DistressResponseData();
                    data.outcome = DistressCallOutcome.PIRATES;
                    data.inner = inner;
                    data.outer = outer;
                    RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData();
                    extra.factionId = "pirates";
                    RouteManager.RouteData route = RouteManager.getInstance().addRoute("dca_" + DistressCallAbility.this.getId(), null, Misc.genRandomSeed(), extra, DistressCallAbility.this, data);
                    float waitDays = 15.0f + (float)Math.random() * 10.0f;
                    route.addSegment(new RouteManager.RouteSegment(waitDays, inner));
                    ++i;
                }
            }
        });
    }

    protected void addHelpScript(float delayDays, StarSystemAPI system, final JumpPointAPI inner, final JumpPointAPI outer) {
        Global.getSector().addScript(new DelayedActionScript(delayDays){

            public void doAction() {
                DistressResponseData data = new DistressResponseData();
                data.outcome = DistressCallOutcome.HELP;
                data.inner = inner;
                data.outer = outer;
                RouteManager.RouteData route = RouteManager.getInstance().addRoute("dca_" + DistressCallAbility.this.getId(), null, Misc.genRandomSeed(), null, DistressCallAbility.this, data);
                float waitDays = 15.0f + (float)Math.random() * 10.0f;
                route.addSegment(new RouteManager.RouteSegment(waitDays, inner));
            }
        });
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet.isInHyperspace() || fleet.isInHyperspaceTransition()) {
            return false;
        }
        return fleet.getContainingLocation() == null || !fleet.getContainingLocation().hasTag("system_abyssal");
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle(this.spec.getName());
        float pad = 10.0f;
        tooltip.addPara("\u53ef\u88ab\u53d7\u56f0\u8230\u961f\u7528\u4e8e\u5411\u8d85\u7a7a\u95f4\u53d1\u51fa\u5f3a\u529b\u6c42\u6551\u4fe1\u53f7\uff0c\u901a\u77e5\u5468\u56f4\u7684\u8230\u961f\u63d0\u4f9b\u71c3\u6599\u548c\u8865\u7ed9\u65b9\u9762\u7684\u63f4\u52a9\u3002\u6551\u63f4\u53ef\u80fd\u9700\u8981\u591a\u5929\u4e4b\u540e\u624d\u4f1a\u5230\u8fbe\u3002\u5982\u679c\u53cd\u590d\u4f7f\u7528\u8be5\u80fd\u529b\u547c\u53eb\u63f4\u52a9\u8230\u961f\u5360\u4fbf\u5b9c\u7684\u8bdd\uff0c\u5c06\u4f1a\u53d7\u5230\u6765\u81ea\u54cd\u5e94\u65b9\u8d8a\u6765\u8d8a\u9ad8\u7684\u58f0\u671b\u60e9\u7f5a\u3002", pad);
        tooltip.addPara("\u6839\u636e\u60ef\u4f8b\uff0c\u9047\u9669\u8230\u961f\u4e00\u822c\u5728\u661f\u7cfb \u6700\u5185\u5c42\u7684\u8df3\u8dc3\u70b9 \u65c1\u7b49\u5f85\u6551\u63f4\u3002", pad, highlight, "\u6700\u5185\u5c42\u7684\u8df3\u8dc3\u70b9");
        tooltip.addPara("\u8be5\u4fe1\u53f7\u5e76\u975e\u5b9a\u5411\uff0c\u4e14\u672a\u643a\u5e26\u6570\u636e\uff0c\u56e0\u6b64\u65e0\u6cd5\u4f5c\u4e3a\u6218\u672f\u4f7f\u7528\u3002", pad);
        if (fleet.isInHyperspace()) {
            tooltip.addPara("\u65e0\u6cd5\u5728\u8d85\u7a7a\u95f4\u5185\u4f7f\u7528\u3002", bad, pad);
        }
        if (fleet.getContainingLocation() != null && fleet.getContainingLocation().hasTag("system_abyssal")) {
            tooltip.addPara("\u65e0\u6cd5\u5728\u6df1\u6e0a\u8d85\u7a7a\u95f4\u5185\u7684\u661f\u7cfb\u4e2d\u4f7f\u7528\u3002", bad, pad);
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        DistressResponseData data = (DistressResponseData)route.getCustom();
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        if (data.outcome == DistressCallOutcome.HELP) {
            Object type;
            WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(null, data.inner, 10.0f, 10.0f, 0.0f);
            String faction = factions.pick();
            if (faction == null) {
                return null;
            }
            CampaignFleetAPI fleet = null;
            if ("independent".equals(faction)) {
                WeightedRandomPicker<String> typePicker = new WeightedRandomPicker<String>();
                typePicker.add("scavengerSmall", 5.0f);
                typePicker.add("scavengerMedium", 10.0f);
                typePicker.add("scavengerLarge", 5.0f);
                type = (String)typePicker.pick();
                fleet = RuinsFleetRouteManager.createScavenger(type, data.inner.getLocationInHyperspace(), route, null, false, null);
            } else {
                WeightedRandomPicker<FleetFactory.PatrolType> picker = new WeightedRandomPicker<FleetFactory.PatrolType>();
                picker.add(FleetFactory.PatrolType.FAST, 5.0f);
                picker.add(FleetFactory.PatrolType.COMBAT, 10.0f);
                picker.add(FleetFactory.PatrolType.HEAVY, 5.0f);
                type = (FleetFactory.PatrolType)((Object)picker.pick());
                fleet = MilitaryBase.createPatrol((FleetFactory.PatrolType)((Object)type), faction, route, null, data.inner.getLocationInHyperspace(), route.getRandom());
            }
            if (fleet == null) {
                return null;
            }
            if (Misc.getSourceMarket(fleet) == null) {
                return null;
            }
            if (this.numTimesUsed == 1) {
                FullName name = new FullName("Mel", "Greenish", fleet.getCommander().getGender());
                fleet.getCommander().setName(name);
                fleet.getFlagship().setShipName("\u5728\u4efb\u4f55\u60c5\u51b5\u4e0b\u90fd\u662f\u5982\u6b64");
            }
            Misc.makeImportant(fleet, "distressResponse", 30.0f);
            fleet.getMemoryWithoutUpdate().set("$distressResponse", true);
            Global.getSector().getHyperspace().addEntity(fleet);
            if (!player.isInHyperspace() && (Global.getSector().getHyperspace().getDaysSinceLastPlayerVisit() > 5.0f || player.getCargo().getFuel() <= 0.0f)) {
                Vector2f loc = data.outer.getLocation();
                fleet.setLocation(loc.x, loc.y + fleet.getRadius() + 100.0f);
            } else {
                float dir = (float)Math.random() * 360.0f;
                if (player.isInHyperspace()) {
                    dir = Misc.getAngleInDegrees(player.getLocation(), data.inner.getLocationInHyperspace());
                    dir += (float)Math.random() * 120.0f - 60.0f;
                }
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(dir);
                loc.scale(3000.0f + 1000.0f * (float)Math.random());
                Vector2f.add((Vector2f)data.inner.getLocationInHyperspace(), (Vector2f)loc, (Vector2f)loc);
                fleet.setLocation(loc.x, loc.y + fleet.getRadius() + 100.0f);
            }
            fleet.addScript(new DistressCallResponseAssignmentAI(fleet, data.inner.getStarSystem(), data.inner, data.outer));
            return fleet;
        }
        if (data.outcome == DistressCallOutcome.PIRATES) {
            int points = 5 + new Random().nextInt(15);
            CampaignFleetAPI fleet = PirateFleetManager.createPirateFleet(points, route, data.inner.getLocationInHyperspace());
            if (fleet == null) {
                return null;
            }
            if (Misc.getSourceMarket(fleet) == null) {
                return null;
            }
            Global.getSector().getHyperspace().addEntity(fleet);
            if (!player.isInHyperspace() && (Global.getSector().getHyperspace().getDaysSinceLastPlayerVisit() > 5.0f || player.getCargo().getFuel() <= 0.0f)) {
                Vector2f loc = data.outer.getLocation();
                fleet.setLocation(loc.x, loc.y + fleet.getRadius() + 100.0f);
            } else {
                float dir = (float)Math.random() * 360.0f;
                if (player.isInHyperspace()) {
                    dir = Misc.getAngleInDegrees(player.getLocation(), data.inner.getLocationInHyperspace());
                    dir += (float)Math.random() * 120.0f - 60.0f;
                }
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(dir);
                loc.scale(3000.0f + 1000.0f * (float)Math.random());
                Vector2f.add((Vector2f)data.inner.getLocationInHyperspace(), (Vector2f)loc, (Vector2f)loc);
                fleet.setLocation(loc.x, loc.y + fleet.getRadius() + 100.0f);
            }
            fleet.addScript(new DistressCallResponsePirateAssignmentAI(fleet, data.inner.getStarSystem(), data.inner, data.outer));
            return fleet;
        }
        return null;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
        route.expire();
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    public static class AbilityUseData {
        public long timestamp;
        public Vector2f location;

        public AbilityUseData(long timestamp, Vector2f location) {
            this.timestamp = timestamp;
            this.location = location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistressCallOutcome {
        NOTHING,
        HELP,
        PIRATES;

    }

    public static class DistressResponseData {
        public DistressCallOutcome outcome;
        public JumpPointAPI inner;
        public JumpPointAPI outer;
    }
}

