/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.terrain.CRRecoveryBuff;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurationAbilityWithCost2
extends BaseDurationAbility {
    public float getFuelCostMult() {
        return 1.0f;
    }

    public float getCRCostMult() {
        return 0.25f;
    }

    public float getActivationAtLowCRShipDamageProbability() {
        return 0.33f;
    }

    public Misc.FleetMemberDamageLevel getActivationDamageLevel() {
        return Misc.FleetMemberDamageLevel.LOW;
    }

    public boolean canRecoverCRWhileActive() {
        return false;
    }

    protected void deductCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        float crCostMult = this.getCRCostMult();
        if (crCostMult > 0.0f) {
            for (FleetMemberAPI member : this.getNonReadyShips()) {
                if (!((float)Math.random() < this.getActivationAtLowCRShipDamageProbability())) continue;
                Misc.applyDamage(member, null, this.getActivationDamageLevel(), false, null, null, true, null, String.valueOf(member.getShipName()) + " \u4e0d\u614e\u56e0\u6fc0\u6d3b " + this.spec.getName() + " \u800c\u53d7\u5230\u4e86\u635f\u4f24");
            }
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                float crLoss = this.getCRCost(member);
                member.getRepairTracker().applyCREvent(-crLoss, Misc.ucFirst(this.spec.getName().toLowerCase()));
            }
        }
        float cost = this.computeFuelCost();
        fleet.getCargo().removeFuel(cost);
    }

    protected void applyStatsEffect(float amount, float level) {
    }

    protected void unapplyStatsEffect() {
    }

    protected void applyFleetVisual(float amount, float level) {
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        this.applyStatsEffect(amount, level);
        this.applyFleetVisual(amount, level);
        if (!this.canRecoverCRWhileActive()) {
            String buffId = this.getModId();
            float buffDur = 0.1f;
            boolean needsSync = false;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                if (level <= 0.0f) {
                    member.getBuffManager().removeBuff(buffId);
                    needsSync = true;
                    continue;
                }
                BuffManagerAPI.Buff test = member.getBuffManager().getBuff(buffId);
                if (test instanceof CRRecoveryBuff) {
                    CRRecoveryBuff buff = (CRRecoveryBuff)test;
                    buff.setDur(buffDur);
                    continue;
                }
                member.getBuffManager().addBuff(new CRRecoveryBuff(buffId, 0.0f, buffDur));
                needsSync = true;
            }
            if (needsSync) {
                fleet.forceSync();
            }
        }
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        this.unapplyStatsEffect();
    }

    protected List<FleetMemberAPI> getNonReadyShips() {
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        if (this.getCRCostMult() <= 0.0f) {
            return result;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float crLoss = this.getCRCost(member);
            if (Math.round(member.getRepairTracker().getCR() * 100.0f) >= Math.round(crLoss * 100.0f)) continue;
            result.add(member);
        }
        return result;
    }

    public float getCRCost(FleetMemberAPI member) {
        float crCostMult = this.getCRCostMult();
        float crLoss = member.getDeployCost() * crCostMult;
        return (float)Math.round(crLoss * 100.0f) / 100.0f;
    }

    protected float computeFuelCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float cost = fleet.getLogistics().getFuelCostPerLightYear() * this.getFuelCostMult();
        return cost;
    }

    protected float computeSupplyCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float crCostMult = this.getCRCostMult();
        float cost = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            cost += member.getDeploymentCostSupplies() * crCostMult;
        }
        return cost;
    }

    public void addInitialDescription(TooltipMakerAPI tooltip, boolean expanded) {
    }

    public boolean addNotUsableReasonBeforeFuelCost(TooltipMakerAPI tooltip, boolean expanded) {
        return false;
    }

    public void addNotUsableReasonAfterFuelCost(TooltipMakerAPI tooltip, boolean expanded) {
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle(this.spec.getName());
        this.addInitialDescription(tooltip, expanded);
        float pad = 10.0f;
        float fuelCost = this.computeFuelCost();
        float supplyCost = this.computeSupplyCost();
        String preventsRecovery = "";
        if (!this.canRecoverCRWhileActive()) {
            preventsRecovery = " \u6fc0\u6d3b\u65f6\u65e0\u6cd5\u6062\u590d\u6218\u5907\u503c\u3002";
        }
        if (supplyCost > 0.0f && fuelCost > 0.0f) {
            tooltip.addPara("\u6d88\u8017 %s \u71c3\u6599\uff0c\u5e76\u5bfc\u81f4\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c\u4e0b\u964d\uff0c\u9700\u8981\u6d88\u8017 %s \u8865\u7ed9\u8fdb\u884c\u6062\u590d\u3002" + preventsRecovery, pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost), Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else if (supplyCost > 0.0f) {
            tooltip.addPara("\u5bfc\u81f4\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c\u4e0b\u964d\uff0c\u9700\u8981\u6d88\u8017 %s \u8865\u7ed9\u8fdb\u884c\u6062\u590d\u3002" + preventsRecovery, pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else if (fuelCost > 0.0f) {
            tooltip.addPara("\u6d88\u8017 %s \u71c3\u6599\u3002" + preventsRecovery, pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost));
        }
        boolean addedReason = this.addNotUsableReasonBeforeFuelCost(tooltip, expanded);
        if (!addedReason && fuelCost > 0.0f && fuelCost > fleet.getCargo().getFuel()) {
            tooltip.addPara("\u71c3\u6599\u4e0d\u8db3\u3002", bad, pad);
        } else {
            this.addNotUsableReasonAfterFuelCost(tooltip, expanded);
        }
        List<FleetMemberAPI> nonReady = this.getNonReadyShips();
        if (!nonReady.isEmpty()) {
            tooltip.addPara("\u4ee5\u4e0b\u8230\u8239\u7684\u6218\u5907\u503c\u4e0d\u8db3\uff0c\u5982\u679c\u5f3a\u884c\u6fc0\u6d3b\u5c06\u6709\u53ef\u80fd\u906d\u53d7\u635f\u4f24\uff1a", pad, Misc.getNegativeHighlightColor(), "\u6709\u53ef\u80fd\u906d\u53d7\u635f\u4f24");
            int j = 0;
            int max = 4;
            float initPad = 5.0f;
            for (FleetMemberAPI member : nonReady) {
                if (j >= max && nonReady.size() > max + 1) {
                    tooltip.addPara("     ... \u4ee5\u53ca\u5176\u4ed6\u51e0\u8258\u8230\u8239", initPad);
                    break;
                }
                String str = "";
                if (!member.isFighterWing()) {
                    str = String.valueOf(str) + member.getShipName() + "\uff0c";
                    str = String.valueOf(str) + member.getHullSpec().getHullNameWithDashClass();
                } else {
                    str = String.valueOf(str) + member.getVariant().getFullDesignationWithHullName();
                }
                tooltip.addPara("      " + str, initPad);
                initPad = 0.0f;
                ++j;
            }
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
        if (engagedInHostilities) {
            this.deactivate();
        }
    }

    @Override
    public void fleetOpenedMarket(MarketAPI market) {
        this.deactivate();
    }

    protected boolean showAlarm() {
        return !this.getNonReadyShips().isEmpty() && !this.isOnCooldown() && !this.isActiveOrInProgress() && this.isUsable();
    }

    @Override
    public boolean isOnCooldown() {
        return super.getCooldownFraction() < 1.0f;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && this.getFleet() != null && (this.getFleet().isAIMode() || this.computeFuelCost() <= this.getFleet().getCargo().getFuel());
    }

    @Override
    public float getCooldownFraction() {
        if (this.showAlarm()) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return this.showAlarm();
    }

    @Override
    protected void activateImpl() {
    }
}

