/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.terrain.CRRecoveryBuff;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmergencyBurnAbility
extends BaseDurationAbility {
    public static float SENSOR_RANGE_MULT = 0.5f;
    public static float DETECTABILITY_PERCENT = 50.0f;
    public static float MAX_BURN_MOD = 8.0f;
    public static float CR_COST_MULT = 0.25f;
    public static float FUEL_USE_MULT = 1.0f;
    public static float ACCELERATION_MULT = 4.0f;
    public static float ACTIVATION_DAMAGE_PROB = 0.33f;

    @Override
    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("emergency_burn_mult");
        if (crCostFleetMult > 0.0f) {
            for (FleetMemberAPI member : this.getNonReadyShips()) {
                if (!((float)Math.random() < ACTIVATION_DAMAGE_PROB)) continue;
                Misc.applyDamage(member, null, Misc.FleetMemberDamageLevel.LOW, false, null, null, true, null, String.valueOf(member.getShipName()) + " \u5728\u7d27\u6025\u52a0\u901f\u65f6\u4e0d\u614e\u53d7\u5230\u4e86\u635f\u4f24");
            }
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                float crLoss = member.getDeployCost() * CR_COST_MULT * crCostFleetMult;
                member.getRepairTracker().applyCREvent(-crLoss, "\u7d27\u6025\u52a0\u901f");
            }
        }
        float cost = this.computeFuelCost();
        fleet.getCargo().removeFuel(cost);
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getSensorRangeMod().modifyMult(this.getModId(), 1.0f + (SENSOR_RANGE_MULT - 1.0f) * level, "\u7d27\u6025\u52a0\u901f");
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), DETECTABILITY_PERCENT * level, "\u7d27\u6025\u52a0\u901f");
        fleet.getStats().getFleetwideMaxBurnMod().modifyFlat(this.getModId(), (int)(MAX_BURN_MOD * level), "\u7d27\u6025\u52a0\u901f");
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f + (ACCELERATION_MULT - 1.0f) * level);
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), new Color(250, 150, 100, 255), 1.0f, 1.0f, 0.75f);
            view.getEngineGlowSizeMult().shift(this.getModId(), 2.0f, 1.0f, 1.0f, 1.0f);
            view.getEngineHeightMult().shift(this.getModId(), 5.0f, 1.0f, 1.0f, 1.0f);
            view.getEngineWidthMult().shift(this.getModId(), 3.0f, 1.0f, 1.0f, 1.0f);
        }
        String buffId = this.getModId();
        float buffDur = 0.1f;
        boolean needsSync = false;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (level <= 0.0f) {
                member.getBuffManager().removeBuff(buffId);
                needsSync = true;
                continue;
            }
            BuffManagerAPI.Buff test = member.getBuffManager().getBuff(buffId);
            if (test instanceof CRRecoveryBuff) {
                CRRecoveryBuff buff = (CRRecoveryBuff)test;
                buff.setDur(buffDur);
                continue;
            }
            member.getBuffManager().addBuff(new CRRecoveryBuff(buffId, 0.0f, buffDur));
            needsSync = true;
        }
        if (needsSync) {
            fleet.forceSync();
        }
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getSensorRangeMod().unmodify(this.getModId());
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    protected List<FleetMemberAPI> getNonReadyShips() {
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float crLoss = EmergencyBurnAbility.getCRCost(member, fleet);
            if (Math.round(member.getRepairTracker().getCR() * 100.0f) >= Math.round(crLoss * 100.0f)) continue;
            result.add(member);
        }
        return result;
    }

    public static float getCRCost(FleetMemberAPI member, CampaignFleetAPI fleet) {
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("emergency_burn_mult");
        float crLoss = member.getDeployCost() * CR_COST_MULT * crCostFleetMult;
        return (float)Math.round(crLoss * 100.0f) / 100.0f;
    }

    protected float computeFuelCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float cost = fleet.getLogistics().getFuelCostPerLightYear() * FUEL_USE_MULT;
        return cost;
    }

    protected float computeSupplyCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("emergency_burn_mult");
        float cost = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            cost += member.getDeploymentCostSupplies() * CR_COST_MULT * crCostFleetMult;
        }
        return cost;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        List<FleetMemberAPI> nonReady;
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle("\u7d27\u6025\u52a0\u901f");
        float pad = 10.0f;
        float fuelCost = this.computeFuelCost();
        float supplyCost = this.computeSupplyCost();
        tooltip.addPara("\u63d0\u9ad8 %s \u70b9\u6700\u5927\u5b87\u5b99\u822a\u884c\u901f\u5ea6\u3002\u4f46\u964d\u4f4e %s \u4f20\u611f\u5668\u63a2\u6d4b\u8303\u56f4\uff0c\u4e14\u63d0\u9ad8 %s \u8230\u961f\u88ab\u4fa6\u6d4b\u8303\u56f4\u3002", pad, highlight, "" + (int)MAX_BURN_MOD, (int)((1.0f - SENSOR_RANGE_MULT) * 100.0f) + "%", (int)DETECTABILITY_PERCENT + "%");
        if (supplyCost > 0.0f) {
            tooltip.addPara("\u6d88\u8017 %s \u71c3\u6599\uff0c\u5e76\u5bfc\u81f4\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c\u4e0b\u964d\uff0c\u9700\u8981\u6d88\u8017 %s \u8865\u7ed9\u8fdb\u884c\u6062\u590d\u3002\u4e14\u6fc0\u6d3b\u65f6\u65e0\u6cd5\u6062\u590d\u6218\u5907\u503c\u3002", pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost), Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else {
            tooltip.addPara("\u6d88\u8017 %s \u5355\u4f4d\u7684\u71c3\u6599\uff0c\u4e14\u542f\u52a8\u65f6\u5c06\u505c\u6b62\u6218\u5907\u503c (CR) \u7684\u6062\u590d\u3002", pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost));
        }
        if (fuelCost > fleet.getCargo().getFuel()) {
            tooltip.addPara("\u6ca1\u6709\u8db3\u591f\u7684\u71c3\u6599\u3002", bad, pad);
        }
        if (!(nonReady = this.getNonReadyShips()).isEmpty()) {
            tooltip.addPara("\u5f53\u67d0\u4e9b\u8230\u8239\u6218\u5907\u503c (CR) \u4e0d\u8db3\u65f6\uff0c\u5c06\u65e0\u6cd5\u5b89\u5168\u5730\u542f\u52a8\u7d27\u6025\u52a0\u901f\uff0c\u56e0\u6b64\u5f53\u8be5\u80fd\u529b\u6fc0\u6d3b\u65f6\uff0c\u4ee5\u4e0b\u8230\u8239\u5c06\u53ef\u80fd\u906d\u53d7\u635f\u5bb3\uff1a", pad, Misc.getNegativeHighlightColor(), "\u6709\u53ef\u80fd\u906d\u53d7\u635f\u4f24");
            int j = 0;
            int max = 4;
            float initPad = 5.0f;
            for (FleetMemberAPI member : nonReady) {
                if (j >= max && nonReady.size() > max + 1) {
                    tooltip.addPara("     ... \u4ee5\u53ca\u5176\u4ed6\u51e0\u8258\u8230\u8239", initPad);
                    break;
                }
                String str = "";
                if (!member.isFighterWing()) {
                    str = String.valueOf(str) + member.getShipName() + ", ";
                    str = String.valueOf(str) + member.getHullSpec().getHullNameWithDashClass();
                } else {
                    str = String.valueOf(str) + member.getVariant().getFullDesignationWithHullName();
                }
                tooltip.addPara("      " + str, initPad);
                initPad = 0.0f;
                ++j;
            }
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
        if (engagedInHostilities) {
            this.deactivate();
        }
    }

    @Override
    public void fleetOpenedMarket(MarketAPI market) {
        this.deactivate();
    }

    protected boolean showAlarm() {
        return !this.getNonReadyShips().isEmpty() && !this.isOnCooldown() && !this.isActiveOrInProgress() && this.isUsable();
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && this.getFleet() != null && (this.getFleet().isAIMode() || this.computeFuelCost() <= this.getFleet().getCargo().getFuel());
    }

    @Override
    public float getCooldownFraction() {
        if (this.showAlarm()) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public boolean showCooldownIndicator() {
        return super.showCooldownIndicator();
    }

    @Override
    public boolean isOnCooldown() {
        return super.getCooldownFraction() < 1.0f;
    }

    @Override
    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return this.showAlarm();
    }
}

