/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.abilities.EmergencyBurnAbility;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractureJumpAbility
extends BaseDurationAbility {
    public static float CR_COST_MULT = 0.1f;
    public static float FUEL_USE_MULT = 1.0f;
    public static float NASCENT_JUMP_DIST = 50.0f;
    protected Boolean primed = null;
    protected NascentGravityWellAPI well = null;
    protected EveryFrameScript ping = null;

    protected boolean canUseToJumpToHyper() {
        return true;
    }

    protected boolean canUseToJumpToSystem() {
        return true;
    }

    @Override
    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (fleet.isInHyperspaceTransition()) {
            return;
        }
        if (fleet.isInHyperspace() && this.canUseToJumpToSystem()) {
            NascentGravityWellAPI well = this.getNearestWell(NASCENT_JUMP_DIST);
            if (well == null || well.getTarget() == null) {
                return;
            }
            this.well = well;
            this.ping = Global.getSector().addPing((SectorEntityToken)fleet, "transverse_jump");
            this.primed = true;
        } else if (!fleet.isInHyperspace() && this.canUseToJumpToHyper() && fleet.getContainingLocation() instanceof StarSystemAPI) {
            this.ping = Global.getSector().addPing((SectorEntityToken)fleet, "transverse_jump");
            this.primed = true;
        } else {
            this.deactivate();
        }
    }

    @Override
    public void deactivate() {
        if (this.ping != null) {
            Global.getSector().removeScript(this.ping);
            this.ping = null;
        }
        super.deactivate();
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level > 0.0f && level < 1.0f && amount > 0.0f) {
            float activateSeconds = this.getActivationDays() * Global.getSector().getClock().getSecondsPerDay();
            float speed = fleet.getVelocity().length();
            float acc = Math.max(speed, 200.0f) / activateSeconds + fleet.getAcceleration();
            float ds = acc * amount;
            if (ds > speed) {
                ds = speed;
            }
            Vector2f dv = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(fleet.getVelocity()));
            dv.scale(ds);
            fleet.setVelocity(fleet.getVelocity().x - dv.x, fleet.getVelocity().y - dv.y);
            return;
        }
        if (level == 1.0f && this.primed != null) {
            float dist = Float.MAX_VALUE;
            if (this.well != null) {
                dist = Misc.getDistance(fleet, this.well) - this.well.getRadius() - fleet.getRadius();
            }
            if (this.well != null && fleet.isInHyperspace() && this.canUseToJumpToSystem() && dist < 500.0f) {
                SectorEntityToken planet = this.well.getTarget();
                Vector2f loc = Misc.getPointAtRadius(planet.getLocation(), planet.getRadius() + 200.0f + fleet.getRadius());
                SectorEntityToken token = planet.getContainingLocation().createToken(loc.x, loc.y);
                JumpPointAPI.JumpDestination dest = new JumpPointAPI.JumpDestination(token, null);
                Global.getSector().doHyperspaceTransition(fleet, fleet, dest);
            } else if (!fleet.isInHyperspace() && this.canUseToJumpToHyper() && fleet.getContainingLocation() instanceof StarSystemAPI) {
                float crCostFleetMult = this.getCRCostMult(fleet);
                if (crCostFleetMult > 0.0f) {
                    for (FleetMemberAPI member : this.getNonReadyShips()) {
                        if (!((float)Math.random() < EmergencyBurnAbility.ACTIVATION_DAMAGE_PROB)) continue;
                        Misc.applyDamage(member, null, Misc.FleetMemberDamageLevel.LOW, false, null, null, true, null, String.valueOf(member.getShipName()) + " \u5728\u6a2a\u8f74\u8df3\u8dc3\u65f6\u4e0d\u614e\u53d7\u5230\u4e86\u635f\u4f24");
                    }
                    for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                        float crLoss = member.getDeployCost() * CR_COST_MULT * crCostFleetMult;
                        member.getRepairTracker().applyCREvent(-crLoss, "\u6a2a\u8f74\u8df3\u8dc3");
                    }
                    String key = "$makeTranverseJumpCostMoreCROnce";
                    fleet.getMemoryWithoutUpdate().unset(key);
                }
                float cost = this.computeFuelCost();
                fleet.getCargo().removeFuel(cost);
                StarSystemAPI system = (StarSystemAPI)fleet.getContainingLocation();
                Vector2f offset = Vector2f.sub((Vector2f)fleet.getLocation(), (Vector2f)system.getCenter().getLocation(), (Vector2f)new Vector2f());
                float maxInSystem = 20000.0f;
                float maxInHyper = 2000.0f;
                float f = offset.length() / maxInSystem;
                if (f > 0.5f) {
                    f = 0.5f;
                }
                float angle = Misc.getAngleInDegreesStrict(offset);
                Vector2f destOffset = Misc.getUnitVectorAtDegreeAngle(angle);
                destOffset.scale(f * maxInHyper);
                Vector2f.add((Vector2f)system.getLocation(), (Vector2f)destOffset, (Vector2f)destOffset);
                SectorEntityToken token = Global.getSector().getHyperspace().createToken(destOffset.x, destOffset.y);
                JumpPointAPI.JumpDestination dest = new JumpPointAPI.JumpDestination(token, null);
                Global.getSector().doHyperspaceTransition(fleet, fleet, dest);
            }
            this.primed = null;
            this.well = null;
        }
    }

    @Override
    protected String getActivationText() {
        return super.getActivationText();
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet.isInHyperspaceTransition()) {
            return false;
        }
        if (TutorialMissionIntel.isTutorialInProgress()) {
            return false;
        }
        if (this.canUseToJumpToSystem() && fleet.isInHyperspace() && this.getNearestWell(NASCENT_JUMP_DIST) != null) {
            return true;
        }
        return this.canUseToJumpToHyper() && !fleet.isInHyperspace() && (this.getFleet().isAIMode() || this.computeFuelCost() <= this.getFleet().getCargo().getFuel());
    }

    public NascentGravityWellAPI getNearestWell(float maxDist) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return null;
        }
        if (!fleet.isInHyperspace()) {
            return null;
        }
        float minDist = Float.MAX_VALUE;
        NascentGravityWellAPI closest = null;
        List wells = fleet.getContainingLocation().getEntities(NascentGravityWellAPI.class);
        for (Object o : wells) {
            NascentGravityWellAPI well = (NascentGravityWellAPI)o;
            float dist = Misc.getDistance(well.getLocation(), fleet.getLocation());
            if ((dist -= well.getRadius() + fleet.getRadius()) > maxDist || !(dist < minDist)) continue;
            minDist = dist;
            closest = well;
        }
        return closest;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle("\u6a2a\u8f74\u8df3\u8dc3");
        float pad = 10.0f;
        NascentGravityWellAPI well = this.getNearestWell(NASCENT_JUMP_DIST);
        tooltip.addPara("\u4e0d\u4f7f\u7528\u8df3\u8dc3\u70b9\u76f4\u63a5\u8df3\u5165\u8d85\u7a7a\u95f4\u3002\u4e5f\u53ef\u4ee5\u4ece\u4e9a\u4e34\u754c\u91cd\u529b\u4e95\u9644\u8fd1\u7a81\u7834\u8d85\u7a7a\u95f4\u754c\u9762\u8df3\u5165\u6052\u661f\u7cfb\uff0c\u5c06\u51fa\u73b0\u5728\u91cd\u529b\u4e95\u5bf9\u5e94\u7684\u7269\u4f53\u65c1\u8fb9\u3002", pad);
        float fuelCost = this.computeFuelCost();
        float supplyCost = this.computeSupplyCost();
        if (supplyCost > 0.0f) {
            tooltip.addPara("\u8df3\u5165\u8d85\u7a7a\u95f4\u5c06\u8017\u8d39 %s \u71c3\u6599\uff0c\u5e76\u5bfc\u81f4\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c\u8f7b\u5fae\u4e0b\u964d\uff0c\u9700\u8981\u6d88\u8017 %s \u8865\u7ed9\u8fdb\u884c\u6062\u590d\u3002\u8df3\u5165\u661f\u7cfb\u65f6\u65e0\u9700\u8017\u8d39\u3002", pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost), Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else {
            tooltip.addPara("\u8df3\u5165\u8d85\u7a7a\u95f4\u5c06\u6d88\u8017 %s \u71c3\u6599\u3002\u8df3\u5165\u661f\u7cfb\u5219\u6ca1\u6709\u6d88\u8017\u3002", pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost));
        }
        if (TutorialMissionIntel.isTutorialInProgress()) {
            tooltip.addPara("\u73b0\u5728\u65e0\u6cd5\u4f7f\u7528\u3002", bad, pad);
        }
        if (!fleet.isInHyperspace()) {
            List<FleetMemberAPI> nonReady;
            if (fuelCost > fleet.getCargo().getFuel()) {
                tooltip.addPara("\u6ca1\u6709\u8db3\u591f\u7684\u71c3\u6599\u3002", bad, pad);
            }
            if (!(nonReady = this.getNonReadyShips()).isEmpty()) {
                tooltip.addPara("\u5f53\u67d0\u4e9b\u8230\u8239\u6218\u5907\u503c (CR) \u4e0d\u8db3\u65f6\uff0c\u5c06\u65e0\u6cd5\u5b89\u5168\u5730\u542f\u52a8\u6a2a\u8f74\u8df3\u8dc3\uff0c\u56e0\u6b64\u5f53\u8be5\u80fd\u529b\u6fc0\u6d3b\u65f6\uff0c\u4ee5\u4e0b\u8230\u8239\u5c06\u53ef\u80fd\u906d\u53d7\u635f\u5bb3\uff1a", pad, Misc.getNegativeHighlightColor(), "may suffer damage");
                int j = 0;
                int max = 4;
                float initPad = 5.0f;
                for (FleetMemberAPI member : nonReady) {
                    if (j >= max && nonReady.size() > max + 1) {
                        tooltip.addPara("     ... \u4ee5\u53ca\u5176\u4ed6\u51e0\u8258\u8230\u8239", initPad);
                        break;
                    }
                    String str = "";
                    if (!member.isFighterWing()) {
                        str = String.valueOf(str) + member.getShipName() + ", ";
                        str = String.valueOf(str) + member.getHullSpec().getHullNameWithDashClass();
                    } else {
                        str = String.valueOf(str) + member.getVariant().getFullDesignationWithHullName();
                    }
                    tooltip.addPara("      " + str, initPad);
                    initPad = 0.0f;
                    ++j;
                }
            }
        }
        if (fleet.isInHyperspace() && well == null) {
            tooltip.addPara("\u5fc5\u987b\u9760\u8fd1\u4e00\u5904\u4e9a\u4e34\u754c\u91cd\u529b\u4e95\u3002", bad, pad);
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
        if (engagedInHostilities) {
            this.deactivate();
        }
    }

    @Override
    public void fleetOpenedMarket(MarketAPI market) {
        this.deactivate();
    }

    protected List<FleetMemberAPI> getNonReadyShips() {
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        float crCostFleetMult = this.getCRCostMult(fleet);
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float crLoss = member.getDeployCost() * CR_COST_MULT * crCostFleetMult;
            if (Math.round(member.getRepairTracker().getCR() * 100.0f) >= Math.round(crLoss * 100.0f)) continue;
            result.add(member);
        }
        return result;
    }

    protected float computeFuelCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float cost = fleet.getLogistics().getFuelCostPerLightYear() * FUEL_USE_MULT;
        return cost;
    }

    protected float getCRCostMult(CampaignFleetAPI fleet) {
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("direct_jump_cr_mult");
        String key = "$makeTranverseJumpCostMoreCROnce";
        if (fleet.getMemoryWithoutUpdate().contains(key)) {
            crCostFleetMult = 20.0f;
        }
        return crCostFleetMult;
    }

    protected float computeSupplyCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float crCostFleetMult = this.getCRCostMult(fleet);
        float cost = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            cost += member.getDeploymentCostSupplies() * CR_COST_MULT * crCostFleetMult;
        }
        return cost;
    }

    protected boolean showAlarm() {
        if (this.getFleet() != null && this.getFleet().isInHyperspace()) {
            return false;
        }
        return !this.getNonReadyShips().isEmpty() && !this.isOnCooldown() && !this.isActiveOrInProgress() && this.isUsable();
    }

    @Override
    public float getCooldownFraction() {
        if (this.showAlarm()) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public boolean showCooldownIndicator() {
        return super.showCooldownIndicator();
    }

    @Override
    public boolean isOnCooldown() {
        return super.getCooldownFraction() < 1.0f;
    }

    @Override
    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return this.showAlarm();
    }
}

